/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.db2;

import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.db2.Db2Check;
import com.intellij.database.model.db2.Db2ModConstraint;
import com.intellij.database.model.db2.Db2ModSchema;
import com.intellij.database.model.db2.Db2ModTable;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Db2ModCheck
extends Db2Check,
Db2ModConstraint {
    @Override
    @NotNull
    public Db2ModTable getTable();

    @Override
    @NotNull
    default public Db2ModTable getDbParent() {
        Db2ModTable db2ModTable = this.getTable();
        if (db2ModTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/db2/Db2ModCheck", "getDbParent"));
        }
        return db2ModTable;
    }

    @Override
    @NotNull
    public ModNamingFamily<? extends Db2ModCheck> getParentFamily();

    @Override
    @NotNull
    default public Db2ModSchema getSchema() {
        Db2ModSchema db2ModSchema = this.getTable().getSchema();
        if (db2ModSchema == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/db2/Db2ModCheck", "getSchema"));
        }
        return db2ModSchema;
    }

    @Override
    @NotNull
    default public List<? extends ModFamily<? extends BasicModElement>> getFamilies() {
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/db2/Db2ModCheck", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public JBIterable<? extends BasicModElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.empty();
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/db2/Db2ModCheck", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    public void setName(@NotNull String var1);

    @Override
    public void setNameSurrogate(boolean var1);

    @Override
    public void setComment(@Nullable String var1);

    @Override
    public void setColNames(@NotNull List<String> var1);

    @Override
    default public void setColNames(String ... colNames) {
        this.setColNames(Arrays.asList(colNames));
    }

    public void setPredicate(@Nullable String var1);

    @Override
    default public void importProperties(@NotNull Map<String, String> properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/database/model/db2/Db2ModCheck", "importProperties"));
        }
        String name = properties.get("Name");
        String nameSurrogate = properties.get("NameSurrogate");
        String comment = properties.get("Comment");
        String colNames = properties.get("ColNames");
        String predicate = properties.get("Predicate");
        if (name != null) {
            this.setName(PropertyConverter.importString(name));
        }
        if (nameSurrogate != null) {
            this.setNameSurrogate(PropertyConverter.importBoolean(nameSurrogate));
        }
        if (comment != null) {
            this.setComment(PropertyConverter.importString(comment));
        }
        if (colNames != null) {
            this.setColNames(PropertyConverter.importListOfString(colNames));
        }
        if (predicate != null) {
            this.setPredicate(PropertyConverter.importString(predicate));
        }
    }
}

