/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.derby;

import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.NameValueConsumer;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.derby.DerbyRoot;
import com.intellij.database.model.derby.DerbyRoutine;
import com.intellij.database.model.derby.DerbySequence;
import com.intellij.database.model.derby.DerbySynonym;
import com.intellij.database.model.derby.DerbyTable;
import com.intellij.database.model.derby.DerbyView;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.database.model.families.NamingIdentifyingFamily;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface DerbySchema
extends BasicSchema,
BasicNamedElement {
    @Override
    @NotNull
    default public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.SCHEMA;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/derby/DerbySchema", "getKind"));
        }
        return objectKind;
    }

    @Nullable
    public DerbyRoot getRoot();

    @Override
    @Nullable
    default public DerbyRoot getDbParent() {
        return this.getRoot();
    }

    @Override
    default public @Nullable NamingFamily<@NotNull ? extends DerbySchema> getParentFamily() {
        return null;
    }

    @NotNull
    public @NotNull NamingIdentifyingFamily<@NotNull ? extends DerbySequence> getSequences();

    @NotNull
    public @NotNull NamingFamily<@NotNull ? extends DerbyTable> getTables();

    @NotNull
    public @NotNull NamingFamily<@NotNull ? extends DerbyView> getViews();

    @NotNull
    public @NotNull NamingFamily<@NotNull ? extends DerbyRoutine> getRoutines();

    @NotNull
    public @NotNull NamingIdentifyingFamily<@NotNull ? extends DerbySynonym> getSynonyms();

    @Override
    @NotNull
    default public List<ObjectKind> getFamilyKinds() {
        List<ObjectKind> list = Arrays.asList(ObjectKind.SEQUENCE, ObjectKind.TABLE, ObjectKind.VIEW, ObjectKind.ROUTINE, ObjectKind.SYNONYM);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/derby/DerbySchema", "getFamilyKinds"));
        }
        return list;
    }

    @Override
    @NotNull
    default public @NotNull List<@NotNull ? extends Family<@NotNull ? extends BasicElement>> getFamilies() {
        List<Family> list = Arrays.asList(this.getSequences(), this.getTables(), this.getViews(), this.getRoutines(), this.getSynonyms());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/derby/DerbySchema", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public @NotNull JBIterable<@NotNull ? extends BasicElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.empty().append(this.getSequences()).append(this.getTables()).append(this.getViews()).append(this.getRoutines()).append(this.getSynonyms());
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/derby/DerbySchema", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    @NotNull
    default public String getName() {
        String string = ModelConsts.NO_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/derby/DerbySchema", "getName"));
        }
        return string;
    }

    @Override
    default public boolean isNameSurrogate() {
        return false;
    }

    @Override
    @Nullable
    default public String getComment() {
        return null;
    }

    @Override
    @Nullable
    default public Date getIntrospectionTimestamp() {
        return null;
    }

    @Override
    default public boolean isCurrent() {
        return false;
    }

    @Override
    default public boolean isVisible() {
        return false;
    }

    @Override
    default public void exportProperties(@NotNull NameValueConsumer<String> consumer) {
        boolean visible;
        boolean current;
        Date introspectionTimestamp;
        String comment;
        boolean nameSurrogate;
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/model/derby/DerbySchema", "exportProperties"));
        }
        String name = this.getName();
        if (name != null && name != ModelConsts.NO_NAME) {
            consumer.accept("Name", PropertyConverter.export(name));
        }
        if (nameSurrogate = this.isNameSurrogate()) {
            consumer.accept("NameSurrogate", PropertyConverter.export(nameSurrogate));
        }
        if ((comment = this.getComment()) != null) {
            consumer.accept("Comment", PropertyConverter.export(comment));
        }
        if ((introspectionTimestamp = this.getIntrospectionTimestamp()) != null) {
            consumer.accept("IntrospectionTimestamp", PropertyConverter.export(introspectionTimestamp));
        }
        if (current = this.isCurrent()) {
            consumer.accept("Current", PropertyConverter.export(current));
        }
        if (visible = this.isVisible()) {
            consumer.accept("Visible", PropertyConverter.export(visible));
        }
    }

    @Override
    @NotNull
    default public List<String> getPropertyNames() {
        List<String> list = Arrays.asList("Name", "NameSurrogate", "Comment", "IntrospectionTimestamp", "Current", "Visible");
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/derby/DerbySchema", "getPropertyNames"));
        }
        return list;
    }
}

