/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.hsql;

import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.NameValueConsumer;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicLeaf;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicTrigger;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.database.model.hsql.HsqlSchema;
import com.intellij.database.model.hsql.HsqlSourceAware;
import com.intellij.database.model.hsql.HsqlTable;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.database.model.properties.TrigEvent;
import com.intellij.database.model.properties.TrigTurn;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface HsqlTrigger
extends BasicTrigger,
HsqlSourceAware,
BasicNamedElement,
BasicLeaf {
    @Override
    @NotNull
    default public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.TRIGGER;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/hsql/HsqlTrigger", "getKind"));
        }
        return objectKind;
    }

    @Override
    @Nullable
    public HsqlTable getTable();

    @Override
    @Nullable
    default public HsqlTable getDbParent() {
        return this.getTable();
    }

    @Override
    @Nullable
    default public HsqlTable getMajorObject() {
        return this.getTable();
    }

    default public @Nullable NamingFamily<@NotNull ? extends HsqlTrigger> getParentFamily() {
        return null;
    }

    @Nullable
    default public HsqlSchema getSchema() {
        HsqlTable table = this.getTable();
        return table != null ? table.getSchema() : null;
    }

    @Override
    @NotNull
    default public List<ObjectKind> getFamilyKinds() {
        List<ObjectKind> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/hsql/HsqlTrigger", "getFamilyKinds"));
        }
        return list;
    }

    @Override
    @NotNull
    default public @NotNull List<@NotNull ? extends Family<@NotNull ? extends BasicElement>> getFamilies() {
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/hsql/HsqlTrigger", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public @NotNull JBIterable<@NotNull ? extends BasicElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.empty();
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/hsql/HsqlTrigger", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    @NotNull
    default public String getName() {
        String string = ModelConsts.NO_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/hsql/HsqlTrigger", "getName"));
        }
        return string;
    }

    @Override
    default public boolean isNameSurrogate() {
        return false;
    }

    @Override
    @Nullable
    default public String getComment() {
        return null;
    }

    @Override
    @Nullable
    default public TrigTurn getTurn() {
        return null;
    }

    @NotNull
    default public Set<TrigEvent> getEvent() {
        Set<TrigEvent> set = Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/hsql/HsqlTrigger", "getEvent"));
        }
        return set;
    }

    @Override
    default public void exportProperties(@NotNull NameValueConsumer<String> consumer) {
        Set<TrigEvent> event;
        TrigTurn turn;
        String comment;
        boolean nameSurrogate;
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/model/hsql/HsqlTrigger", "exportProperties"));
        }
        String name = this.getName();
        if (name != null && name != ModelConsts.NO_NAME) {
            consumer.accept("Name", PropertyConverter.export(name));
        }
        if (nameSurrogate = this.isNameSurrogate()) {
            consumer.accept("NameSurrogate", PropertyConverter.export(nameSurrogate));
        }
        if ((comment = this.getComment()) != null) {
            consumer.accept("Comment", PropertyConverter.export(comment));
        }
        if ((turn = this.getTurn()) != null) {
            consumer.accept("Turn", PropertyConverter.export(turn));
        }
        if (!(event = this.getEvent()).isEmpty()) {
            consumer.accept("Event", PropertyConverter.exportSetOfTrigEvent(event));
        }
    }

    @Override
    @NotNull
    default public List<String> getPropertyNames() {
        List<String> list = Arrays.asList("Name", "NameSurrogate", "Comment", "Turn", "Event");
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/hsql/HsqlTrigger", "getPropertyNames"));
        }
        return list;
    }
}

