/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.db2.Db2ModArgument;
import com.intellij.database.model.db2.Db2ModCheck;
import com.intellij.database.model.db2.Db2ModForeignKey;
import com.intellij.database.model.db2.Db2ModIndex;
import com.intellij.database.model.db2.Db2ModKey;
import com.intellij.database.model.db2.Db2ModModel;
import com.intellij.database.model.db2.Db2ModRoot;
import com.intellij.database.model.db2.Db2ModRoutine;
import com.intellij.database.model.db2.Db2ModSchema;
import com.intellij.database.model.db2.Db2ModSynonym;
import com.intellij.database.model.db2.Db2ModTable;
import com.intellij.database.model.db2.Db2ModTableColumn;
import com.intellij.database.model.db2.Db2ModTrigger;
import com.intellij.database.model.db2.Db2ModView;
import com.intellij.database.model.db2.Db2ModViewColumn;
import com.intellij.database.model.db2.Db2Root;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.impl.BaseModel;
import com.intellij.database.model.properties.TrigEvent;
import com.intellij.database.model.properties.TrigTurn;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class Db2ImplModel
extends BaseModel
implements Db2ModModel {
    private final Root myRoot = new Root();

    Db2ImplModel() {
    }

    @Override
    @NotNull
    public Db2Root getRoot() {
        Root root2 = this.myRoot;
        if (root2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/Db2ImplModel", "getRoot"));
        }
        return root2;
    }

    final class Synonym
    extends BaseModel.BaseRegularElement
    implements Db2ModSynonym {
        private long myObjectId;
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;
        @Nullable
        private String myTargetSchemaName;
        @NotNull
        private ObjectKind myTargetObjectKind;
        @Nullable
        private String myTargetObjectName;

        private Synonym(BaseModel.BaseFamily<? extends Synonym> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/Db2ImplModel$Synonym", "<init>"));
            }
            super(parentFamily);
            this.myObjectId = Long.MIN_VALUE;
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
            this.myTargetSchemaName = null;
            this.myTargetObjectKind = ObjectKind.NONE;
            this.myTargetObjectName = null;
        }

        @Override
        @NotNull
        public Schema getSchema() {
            Schema schema = (Schema)this.myParentFamily.owner;
            if (schema == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/Db2ImplModel$Synonym", "getSchema"));
            }
            return schema;
        }

        @Override
        @NotNull
        public ModNamingIdentifyingFamily<Synonym> getParentFamily() {
            ModNamingIdentifyingFamily modNamingIdentifyingFamily = (ModNamingIdentifyingFamily)((Object)this.myParentFamily);
            if (modNamingIdentifyingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/Db2ImplModel$Synonym", "getParentFamily"));
            }
            return modNamingIdentifyingFamily;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/Db2ImplModel$Synonym", "familyOf"));
            }
            return null;
        }

        @Override
        public long getObjectId() {
            return this.myObjectId;
        }

        @Override
        public void setObjectId(long objectId) {
            if (this.myObjectId == objectId) {
                return;
            }
            this.modifying();
            this.myObjectId = objectId;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/Db2ImplModel$Synonym", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/Db2ImplModel$Synonym", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = BaseModel.deduplicate(name);
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        @Nullable
        public String getTargetSchemaName() {
            return this.myTargetSchemaName;
        }

        @Override
        public void setTargetSchemaName(@Nullable String targetSchemaName) {
            if (BaseModel.eq(this.myTargetSchemaName, targetSchemaName)) {
                return;
            }
            this.modifying();
            this.myTargetSchemaName = targetSchemaName;
        }

        @Override
        @NotNull
        public ObjectKind getTargetObjectKind() {
            ObjectKind objectKind = this.myTargetObjectKind;
            if (objectKind == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/Db2ImplModel$Synonym", "getTargetObjectKind"));
            }
            return objectKind;
        }

        @Override
        public void setTargetObjectKind(@NotNull ObjectKind targetObjectKind) {
            if (targetObjectKind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetObjectKind", "com/intellij/database/model/impl/Db2ImplModel$Synonym", "setTargetObjectKind"));
            }
            if (this.myTargetObjectKind.equals(targetObjectKind)) {
                return;
            }
            this.modifying();
            this.myTargetObjectKind = targetObjectKind;
        }

        @Override
        @Nullable
        public String getTargetObjectName() {
            return this.myTargetObjectName;
        }

        @Override
        public void setTargetObjectName(@Nullable String targetObjectName) {
            if (BaseModel.eq(this.myTargetObjectName, targetObjectName)) {
                return;
            }
            this.modifying();
            this.myTargetObjectName = targetObjectName;
        }
    }

    final class Trigger
    extends BaseModel.BaseRegularElement
    implements Db2ModTrigger {
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;
        @Nullable
        private TrigTurn myTurn;
        @NotNull
        private Set<TrigEvent> myEvent;

        private Trigger(BaseModel.BaseFamily<? extends Trigger> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/Db2ImplModel$Trigger", "<init>"));
            }
            super(parentFamily);
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
            this.myTurn = null;
            this.myEvent = Collections.emptySet();
        }

        @Override
        @NotNull
        public Table getTable() {
            Table table = (Table)this.myParentFamily.owner;
            if (table == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/Db2ImplModel$Trigger", "getTable"));
            }
            return table;
        }

        @Override
        @NotNull
        public ModNamingFamily<Trigger> getParentFamily() {
            ModNamingFamily modNamingFamily = (ModNamingFamily)((Object)this.myParentFamily);
            if (modNamingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/Db2ImplModel$Trigger", "getParentFamily"));
            }
            return modNamingFamily;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/Db2ImplModel$Trigger", "familyOf"));
            }
            return null;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/Db2ImplModel$Trigger", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/Db2ImplModel$Trigger", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = BaseModel.deduplicate(name);
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        @Nullable
        public TrigTurn getTurn() {
            return this.myTurn;
        }

        @Override
        public void setTurn(@Nullable TrigTurn turn) {
            if (BaseModel.eq((Object)this.myTurn, (Object)turn)) {
                return;
            }
            this.modifying();
            this.myTurn = turn;
        }

        @Override
        @NotNull
        public Set<TrigEvent> getEvent() {
            Set<TrigEvent> set = this.myEvent;
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/Db2ImplModel$Trigger", "getEvent"));
            }
            return set;
        }

        @Override
        public void setEvent(@Nullable Set<TrigEvent> event) {
            ImmutableSet x;
            ImmutableSet immutableSet = x = event != null ? ImmutableSet.copyOf(event) : Collections.emptySet();
            if (x.isEmpty() && this.myEvent.isEmpty()) {
                return;
            }
            this.modifying();
            this.myEvent = x;
        }
    }

    final class Argument
    extends BaseModel.BaseRegularElement
    implements Db2ModArgument {
        private short myPosition;
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;
        @NotNull
        private DasArgument.Direction myArgumentDirection;
        @NotNull
        private DataType myDataType;
        @Nullable
        private String myDefaultExpression;

        private Argument(BaseModel.BaseFamily<? extends Argument> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/Db2ImplModel$Argument", "<init>"));
            }
            super(parentFamily);
            this.myPosition = 0;
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
            this.myArgumentDirection = DasArgument.Direction.IN;
            this.myDataType = ModelConsts.NO_DATA_TYPE;
            this.myDefaultExpression = null;
        }

        @Override
        @NotNull
        public Routine getRoutine() {
            Routine routine2 = (Routine)this.myParentFamily.owner;
            if (routine2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/Db2ImplModel$Argument", "getRoutine"));
            }
            return routine2;
        }

        @Override
        @NotNull
        public ModPositioningNamingFamily<Argument> getParentFamily() {
            ModPositioningNamingFamily modPositioningNamingFamily = (ModPositioningNamingFamily)((Object)this.myParentFamily);
            if (modPositioningNamingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/Db2ImplModel$Argument", "getParentFamily"));
            }
            return modPositioningNamingFamily;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/Db2ImplModel$Argument", "familyOf"));
            }
            return null;
        }

        @Override
        public short getPosition() {
            return this.myPosition;
        }

        @Override
        public void setPosition(short position) {
            if (this.myPosition == position) {
                return;
            }
            this.modifying();
            this.myPosition = position;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/Db2ImplModel$Argument", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/Db2ImplModel$Argument", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = BaseModel.deduplicate(name);
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        @NotNull
        public DasArgument.Direction getArgumentDirection() {
            DasArgument.Direction direction = this.myArgumentDirection;
            if (direction == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/Db2ImplModel$Argument", "getArgumentDirection"));
            }
            return direction;
        }

        @Override
        public void setArgumentDirection(@NotNull DasArgument.Direction argumentDirection) {
            if (argumentDirection == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentDirection", "com/intellij/database/model/impl/Db2ImplModel$Argument", "setArgumentDirection"));
            }
            if (this.myArgumentDirection.equals((Object)argumentDirection)) {
                return;
            }
            this.modifying();
            this.myArgumentDirection = argumentDirection;
        }

        @Override
        @NotNull
        public DataType getDataType() {
            DataType dataType = this.myDataType;
            if (dataType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/Db2ImplModel$Argument", "getDataType"));
            }
            return dataType;
        }

        @Override
        public void setDataType(@NotNull DataType dataType) {
            if (dataType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataType", "com/intellij/database/model/impl/Db2ImplModel$Argument", "setDataType"));
            }
            if (this.myDataType.equals(dataType)) {
                return;
            }
            this.modifying();
            this.myDataType = dataType;
        }

        @Override
        @Nullable
        public String getDefaultExpression() {
            return this.myDefaultExpression;
        }

        @Override
        public void setDefaultExpression(@Nullable String defaultExpression) {
            if (BaseModel.eq(this.myDefaultExpression, defaultExpression)) {
                return;
            }
            this.modifying();
            this.myDefaultExpression = defaultExpression;
        }
    }

    final class Routine
    extends BaseModel.BaseRegularElement
    implements Db2ModRoutine {
        private final Arguments myArguments;
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;
        @NotNull
        private DasRoutine.Kind myRoutineKind;

        private Routine(BaseModel.BaseFamily<? extends Routine> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/Db2ImplModel$Routine", "<init>"));
            }
            super(parentFamily);
            this.myArguments = new Arguments(this);
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
            this.myRoutineKind = DasRoutine.Kind.NONE;
        }

        @Override
        @NotNull
        public Schema getSchema() {
            Schema schema = (Schema)this.myParentFamily.owner;
            if (schema == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/Db2ImplModel$Routine", "getSchema"));
            }
            return schema;
        }

        @Override
        @NotNull
        public ModNamingFamily<Routine> getParentFamily() {
            ModNamingFamily modNamingFamily = (ModNamingFamily)((Object)this.myParentFamily);
            if (modNamingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/Db2ImplModel$Routine", "getParentFamily"));
            }
            return modNamingFamily;
        }

        @Override
        @NotNull
        public Arguments getArguments() {
            Arguments arguments = this.myArguments;
            if (arguments == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/Db2ImplModel$Routine", "getArguments"));
            }
            return arguments;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/Db2ImplModel$Routine", "familyOf"));
            }
            if (kind == ObjectKind.ARGUMENT) {
                return this.myArguments;
            }
            return null;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/Db2ImplModel$Routine", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/Db2ImplModel$Routine", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = BaseModel.deduplicate(name);
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        @NotNull
        public DasRoutine.Kind getRoutineKind() {
            DasRoutine.Kind kind = this.myRoutineKind;
            if (kind == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/Db2ImplModel$Routine", "getRoutineKind"));
            }
            return kind;
        }

        @Override
        public void setRoutineKind(@NotNull DasRoutine.Kind routineKind) {
            if (routineKind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "routineKind", "com/intellij/database/model/impl/Db2ImplModel$Routine", "setRoutineKind"));
            }
            if (this.myRoutineKind.equals((Object)routineKind)) {
                return;
            }
            this.modifying();
            this.myRoutineKind = routineKind;
        }

        private final class Arguments
        extends BaseModel.BasePositioningNamingFamily<Argument> {
            private Arguments(Routine owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/Db2ImplModel$Routine$Arguments", "<init>"));
                }
                super(owner);
            }

            @Override
            protected Argument instantiate() {
                return new Argument(this);
            }
        }
    }

    final class Check
    extends BaseModel.BaseRegularElement
    implements Db2ModCheck {
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;
        @NotNull
        private List<String> myColNames;
        @Nullable
        private String myPredicate;

        private Check(BaseModel.BaseFamily<? extends Check> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/Db2ImplModel$Check", "<init>"));
            }
            super(parentFamily);
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
            this.myColNames = Collections.emptyList();
            this.myPredicate = null;
        }

        @Override
        @NotNull
        public Table getTable() {
            Table table = (Table)this.myParentFamily.owner;
            if (table == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/Db2ImplModel$Check", "getTable"));
            }
            return table;
        }

        @Override
        @NotNull
        public ModNamingFamily<Check> getParentFamily() {
            ModNamingFamily modNamingFamily = (ModNamingFamily)((Object)this.myParentFamily);
            if (modNamingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/Db2ImplModel$Check", "getParentFamily"));
            }
            return modNamingFamily;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/Db2ImplModel$Check", "familyOf"));
            }
            return null;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/Db2ImplModel$Check", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/Db2ImplModel$Check", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = BaseModel.deduplicate(name);
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        @NotNull
        public List<String> getColNames() {
            List<String> list = this.myColNames;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/Db2ImplModel$Check", "getColNames"));
            }
            return list;
        }

        @Override
        public void setColNames(@Nullable List<String> colNames) {
            ImmutableList x;
            ImmutableList immutableList = x = colNames != null ? ImmutableList.copyOf(colNames) : Collections.emptyList();
            if (x.isEmpty() && this.myColNames.isEmpty()) {
                return;
            }
            this.modifying();
            this.myColNames = x;
        }

        @Override
        @Nullable
        public String getPredicate() {
            return this.myPredicate;
        }

        @Override
        public void setPredicate(@Nullable String predicate) {
            if (BaseModel.eq(this.myPredicate, predicate)) {
                return;
            }
            this.modifying();
            this.myPredicate = predicate;
        }
    }

    final class ForeignKey
    extends BaseModel.BaseRegularElement
    implements Db2ModForeignKey {
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;
        @NotNull
        private List<String> myColNames;
        @Nullable
        private String myRefSchemaName;
        @Nullable
        private String myRefTableName;
        @Nullable
        private String myRefKeyName;
        @NotNull
        private List<String> myRefColNames;

        private ForeignKey(BaseModel.BaseFamily<? extends ForeignKey> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/Db2ImplModel$ForeignKey", "<init>"));
            }
            super(parentFamily);
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
            this.myColNames = Collections.emptyList();
            this.myRefSchemaName = null;
            this.myRefTableName = null;
            this.myRefKeyName = null;
            this.myRefColNames = Collections.emptyList();
        }

        @Override
        @NotNull
        public Table getTable() {
            Table table = (Table)this.myParentFamily.owner;
            if (table == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/Db2ImplModel$ForeignKey", "getTable"));
            }
            return table;
        }

        @Override
        @NotNull
        public ModNamingFamily<ForeignKey> getParentFamily() {
            ModNamingFamily modNamingFamily = (ModNamingFamily)((Object)this.myParentFamily);
            if (modNamingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/Db2ImplModel$ForeignKey", "getParentFamily"));
            }
            return modNamingFamily;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/Db2ImplModel$ForeignKey", "familyOf"));
            }
            return null;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/Db2ImplModel$ForeignKey", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/Db2ImplModel$ForeignKey", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = BaseModel.deduplicate(name);
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        @NotNull
        public List<String> getColNames() {
            List<String> list = this.myColNames;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/Db2ImplModel$ForeignKey", "getColNames"));
            }
            return list;
        }

        @Override
        public void setColNames(@Nullable List<String> colNames) {
            ImmutableList x;
            ImmutableList immutableList = x = colNames != null ? ImmutableList.copyOf(colNames) : Collections.emptyList();
            if (x.isEmpty() && this.myColNames.isEmpty()) {
                return;
            }
            this.modifying();
            this.myColNames = x;
        }

        @Override
        @Nullable
        public String getRefSchemaName() {
            return this.myRefSchemaName;
        }

        @Override
        public void setRefSchemaName(@Nullable String refSchemaName) {
            if (BaseModel.eq(this.myRefSchemaName, refSchemaName)) {
                return;
            }
            this.modifying();
            this.myRefSchemaName = refSchemaName;
        }

        @Override
        @Nullable
        public String getRefTableName() {
            return this.myRefTableName;
        }

        @Override
        public void setRefTableName(@Nullable String refTableName) {
            if (BaseModel.eq(this.myRefTableName, refTableName)) {
                return;
            }
            this.modifying();
            this.myRefTableName = refTableName;
        }

        @Override
        @Nullable
        public String getRefKeyName() {
            return this.myRefKeyName;
        }

        @Override
        public void setRefKeyName(@Nullable String refKeyName) {
            if (BaseModel.eq(this.myRefKeyName, refKeyName)) {
                return;
            }
            this.modifying();
            this.myRefKeyName = refKeyName;
        }

        @Override
        @NotNull
        public List<String> getRefColNames() {
            List<String> list = this.myRefColNames;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/Db2ImplModel$ForeignKey", "getRefColNames"));
            }
            return list;
        }

        @Override
        public void setRefColNames(@Nullable List<String> refColNames) {
            ImmutableList x;
            ImmutableList immutableList = x = refColNames != null ? ImmutableList.copyOf(refColNames) : Collections.emptyList();
            if (x.isEmpty() && this.myRefColNames.isEmpty()) {
                return;
            }
            this.modifying();
            this.myRefColNames = x;
        }
    }

    final class Key
    extends BaseModel.BaseRegularElement
    implements Db2ModKey {
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;
        @NotNull
        private List<String> myColNames;
        private boolean myPrimary;

        private Key(BaseModel.BaseFamily<? extends Key> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/Db2ImplModel$Key", "<init>"));
            }
            super(parentFamily);
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
            this.myColNames = Collections.emptyList();
            this.myPrimary = false;
        }

        @Override
        @NotNull
        public Table getTable() {
            Table table = (Table)this.myParentFamily.owner;
            if (table == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/Db2ImplModel$Key", "getTable"));
            }
            return table;
        }

        @Override
        @NotNull
        public ModNamingFamily<Key> getParentFamily() {
            ModNamingFamily modNamingFamily = (ModNamingFamily)((Object)this.myParentFamily);
            if (modNamingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/Db2ImplModel$Key", "getParentFamily"));
            }
            return modNamingFamily;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/Db2ImplModel$Key", "familyOf"));
            }
            return null;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/Db2ImplModel$Key", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/Db2ImplModel$Key", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = BaseModel.deduplicate(name);
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        @NotNull
        public List<String> getColNames() {
            List<String> list = this.myColNames;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/Db2ImplModel$Key", "getColNames"));
            }
            return list;
        }

        @Override
        public void setColNames(@Nullable List<String> colNames) {
            ImmutableList x;
            ImmutableList immutableList = x = colNames != null ? ImmutableList.copyOf(colNames) : Collections.emptyList();
            if (x.isEmpty() && this.myColNames.isEmpty()) {
                return;
            }
            this.modifying();
            this.myColNames = x;
        }

        @Override
        public boolean isPrimary() {
            return this.myPrimary;
        }

        @Override
        public void setPrimary(boolean primary) {
            if (this.myPrimary == primary) {
                return;
            }
            this.modifying();
            this.myPrimary = primary;
        }
    }

    final class Index
    extends BaseModel.BaseRegularElement
    implements Db2ModIndex {
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;
        @NotNull
        private List<String> myColNames;
        @NotNull
        private Set<String> myReverseColNames;
        private boolean myUnique;

        private Index(BaseModel.BaseFamily<? extends Index> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/Db2ImplModel$Index", "<init>"));
            }
            super(parentFamily);
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
            this.myColNames = Collections.emptyList();
            this.myReverseColNames = Collections.emptySet();
            this.myUnique = false;
        }

        @Override
        @NotNull
        public Table getTable() {
            Table table = (Table)this.myParentFamily.owner;
            if (table == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/Db2ImplModel$Index", "getTable"));
            }
            return table;
        }

        @Override
        @NotNull
        public ModNamingFamily<Index> getParentFamily() {
            ModNamingFamily modNamingFamily = (ModNamingFamily)((Object)this.myParentFamily);
            if (modNamingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/Db2ImplModel$Index", "getParentFamily"));
            }
            return modNamingFamily;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/Db2ImplModel$Index", "familyOf"));
            }
            return null;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/Db2ImplModel$Index", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/Db2ImplModel$Index", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = BaseModel.deduplicate(name);
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        @NotNull
        public List<String> getColNames() {
            List<String> list = this.myColNames;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/Db2ImplModel$Index", "getColNames"));
            }
            return list;
        }

        @Override
        public void setColNames(@Nullable List<String> colNames) {
            ImmutableList x;
            ImmutableList immutableList = x = colNames != null ? ImmutableList.copyOf(colNames) : Collections.emptyList();
            if (x.isEmpty() && this.myColNames.isEmpty()) {
                return;
            }
            this.modifying();
            this.myColNames = x;
        }

        @Override
        @NotNull
        public Set<String> getReverseColNames() {
            Set<String> set = this.myReverseColNames;
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/Db2ImplModel$Index", "getReverseColNames"));
            }
            return set;
        }

        @Override
        public void setReverseColNames(@Nullable Set<String> reverseColNames) {
            ImmutableSet x;
            ImmutableSet immutableSet = x = reverseColNames != null ? ImmutableSet.copyOf(reverseColNames) : Collections.emptySet();
            if (x.isEmpty() && this.myReverseColNames.isEmpty()) {
                return;
            }
            this.modifying();
            this.myReverseColNames = x;
        }

        @Override
        public boolean isUnique() {
            return this.myUnique;
        }

        @Override
        public void setUnique(boolean unique) {
            if (this.myUnique == unique) {
                return;
            }
            this.modifying();
            this.myUnique = unique;
        }
    }

    final class ViewColumn
    extends BaseModel.BaseRegularElement
    implements Db2ModViewColumn {
        private short myPosition;
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;
        @NotNull
        private DataType myDataType;
        private boolean myNotNull;

        private ViewColumn(BaseModel.BaseFamily<? extends ViewColumn> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/Db2ImplModel$ViewColumn", "<init>"));
            }
            super(parentFamily);
            this.myPosition = 0;
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
            this.myDataType = ModelConsts.NO_DATA_TYPE;
            this.myNotNull = false;
        }

        @Override
        @NotNull
        public View getView() {
            View view2 = (View)this.myParentFamily.owner;
            if (view2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/Db2ImplModel$ViewColumn", "getView"));
            }
            return view2;
        }

        @Override
        @NotNull
        public ModPositioningNamingFamily<ViewColumn> getParentFamily() {
            ModPositioningNamingFamily modPositioningNamingFamily = (ModPositioningNamingFamily)((Object)this.myParentFamily);
            if (modPositioningNamingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/Db2ImplModel$ViewColumn", "getParentFamily"));
            }
            return modPositioningNamingFamily;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/Db2ImplModel$ViewColumn", "familyOf"));
            }
            return null;
        }

        @Override
        public short getPosition() {
            return this.myPosition;
        }

        @Override
        public void setPosition(short position) {
            if (this.myPosition == position) {
                return;
            }
            this.modifying();
            this.myPosition = position;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/Db2ImplModel$ViewColumn", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/Db2ImplModel$ViewColumn", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = BaseModel.deduplicate(name);
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        @NotNull
        public DataType getDataType() {
            DataType dataType = this.myDataType;
            if (dataType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/Db2ImplModel$ViewColumn", "getDataType"));
            }
            return dataType;
        }

        @Override
        public void setDataType(@NotNull DataType dataType) {
            if (dataType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataType", "com/intellij/database/model/impl/Db2ImplModel$ViewColumn", "setDataType"));
            }
            if (this.myDataType.equals(dataType)) {
                return;
            }
            this.modifying();
            this.myDataType = dataType;
        }

        @Override
        public boolean isNotNull() {
            return this.myNotNull;
        }

        @Override
        public void setNotNull(boolean notNull) {
            if (this.myNotNull == notNull) {
                return;
            }
            this.modifying();
            this.myNotNull = notNull;
        }
    }

    final class View
    extends BaseModel.BaseRegularElement
    implements Db2ModView {
        private final Columns myColumns;
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;
        private boolean mySystem;

        private View(BaseModel.BaseFamily<? extends View> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/Db2ImplModel$View", "<init>"));
            }
            super(parentFamily);
            this.myColumns = new Columns(this);
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
            this.mySystem = false;
        }

        @Override
        @NotNull
        public Schema getSchema() {
            Schema schema = (Schema)this.myParentFamily.owner;
            if (schema == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/Db2ImplModel$View", "getSchema"));
            }
            return schema;
        }

        @Override
        @NotNull
        public ModNamingFamily<View> getParentFamily() {
            ModNamingFamily modNamingFamily = (ModNamingFamily)((Object)this.myParentFamily);
            if (modNamingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/Db2ImplModel$View", "getParentFamily"));
            }
            return modNamingFamily;
        }

        @Override
        @NotNull
        public Columns getColumns() {
            Columns columns = this.myColumns;
            if (columns == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/Db2ImplModel$View", "getColumns"));
            }
            return columns;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/Db2ImplModel$View", "familyOf"));
            }
            if (kind == ObjectKind.COLUMN) {
                return this.myColumns;
            }
            return null;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/Db2ImplModel$View", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/Db2ImplModel$View", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = BaseModel.deduplicate(name);
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        public boolean isSystem() {
            return this.mySystem;
        }

        @Override
        public void setSystem(boolean system) {
            if (this.mySystem == system) {
                return;
            }
            this.modifying();
            this.mySystem = system;
        }

        private final class Columns
        extends BaseModel.BasePositioningNamingFamily<ViewColumn> {
            private Columns(View owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/Db2ImplModel$View$Columns", "<init>"));
                }
                super(owner);
            }

            @Override
            protected ViewColumn instantiate() {
                return new ViewColumn(this);
            }
        }
    }

    final class TableColumn
    extends BaseModel.BaseRegularElement
    implements Db2ModTableColumn {
        private short myPosition;
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;
        @NotNull
        private DataType myDataType;
        private boolean myNotNull;
        @Nullable
        private SequenceIdentity mySequenceIdentity;
        @Nullable
        private String myDefaultExpression;

        private TableColumn(BaseModel.BaseFamily<? extends TableColumn> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/Db2ImplModel$TableColumn", "<init>"));
            }
            super(parentFamily);
            this.myPosition = 0;
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
            this.myDataType = ModelConsts.NO_DATA_TYPE;
            this.myNotNull = false;
            this.mySequenceIdentity = null;
            this.myDefaultExpression = null;
        }

        @Override
        @NotNull
        public Table getTable() {
            Table table = (Table)this.myParentFamily.owner;
            if (table == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/Db2ImplModel$TableColumn", "getTable"));
            }
            return table;
        }

        @Override
        @NotNull
        public ModPositioningNamingFamily<TableColumn> getParentFamily() {
            ModPositioningNamingFamily modPositioningNamingFamily = (ModPositioningNamingFamily)((Object)this.myParentFamily);
            if (modPositioningNamingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/Db2ImplModel$TableColumn", "getParentFamily"));
            }
            return modPositioningNamingFamily;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/Db2ImplModel$TableColumn", "familyOf"));
            }
            return null;
        }

        @Override
        public short getPosition() {
            return this.myPosition;
        }

        @Override
        public void setPosition(short position) {
            if (this.myPosition == position) {
                return;
            }
            this.modifying();
            this.myPosition = position;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/Db2ImplModel$TableColumn", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/Db2ImplModel$TableColumn", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = BaseModel.deduplicate(name);
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        @NotNull
        public DataType getDataType() {
            DataType dataType = this.myDataType;
            if (dataType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/Db2ImplModel$TableColumn", "getDataType"));
            }
            return dataType;
        }

        @Override
        public void setDataType(@NotNull DataType dataType) {
            if (dataType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataType", "com/intellij/database/model/impl/Db2ImplModel$TableColumn", "setDataType"));
            }
            if (this.myDataType.equals(dataType)) {
                return;
            }
            this.modifying();
            this.myDataType = dataType;
        }

        @Override
        public boolean isNotNull() {
            return this.myNotNull;
        }

        @Override
        public void setNotNull(boolean notNull) {
            if (this.myNotNull == notNull) {
                return;
            }
            this.modifying();
            this.myNotNull = notNull;
        }

        @Override
        @Nullable
        public SequenceIdentity getSequenceIdentity() {
            return this.mySequenceIdentity;
        }

        @Override
        public void setSequenceIdentity(@Nullable SequenceIdentity sequenceIdentity) {
            if (BaseModel.eq(this.mySequenceIdentity, sequenceIdentity)) {
                return;
            }
            this.modifying();
            this.mySequenceIdentity = sequenceIdentity;
        }

        @Override
        @Nullable
        public String getDefaultExpression() {
            return this.myDefaultExpression;
        }

        @Override
        public void setDefaultExpression(@Nullable String defaultExpression) {
            if (BaseModel.eq(this.myDefaultExpression, defaultExpression)) {
                return;
            }
            this.modifying();
            this.myDefaultExpression = defaultExpression;
        }
    }

    final class Table
    extends BaseModel.BaseRegularElement
    implements Db2ModTable {
        private final Columns myColumns;
        private final Indices myIndices;
        private final Keys myKeys;
        private final ForeignKeys myForeignKeys;
        private final Checks myChecks;
        private final Triggers myTriggers;
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;
        private boolean mySystem;
        private boolean myTemporary;

        private Table(BaseModel.BaseFamily<? extends Table> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/Db2ImplModel$Table", "<init>"));
            }
            super(parentFamily);
            this.myColumns = new Columns(this);
            this.myIndices = new Indices(this);
            this.myKeys = new Keys(this);
            this.myForeignKeys = new ForeignKeys(this);
            this.myChecks = new Checks(this);
            this.myTriggers = new Triggers(this);
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
            this.mySystem = false;
            this.myTemporary = false;
        }

        @Override
        @NotNull
        public Schema getSchema() {
            Schema schema = (Schema)this.myParentFamily.owner;
            if (schema == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/Db2ImplModel$Table", "getSchema"));
            }
            return schema;
        }

        @Override
        @NotNull
        public ModNamingFamily<Table> getParentFamily() {
            ModNamingFamily modNamingFamily = (ModNamingFamily)((Object)this.myParentFamily);
            if (modNamingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/Db2ImplModel$Table", "getParentFamily"));
            }
            return modNamingFamily;
        }

        @Override
        @NotNull
        public Columns getColumns() {
            Columns columns = this.myColumns;
            if (columns == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/Db2ImplModel$Table", "getColumns"));
            }
            return columns;
        }

        @Override
        @NotNull
        public Indices getIndices() {
            Indices indices = this.myIndices;
            if (indices == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/Db2ImplModel$Table", "getIndices"));
            }
            return indices;
        }

        @Override
        @NotNull
        public Keys getKeys() {
            Keys keys = this.myKeys;
            if (keys == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/Db2ImplModel$Table", "getKeys"));
            }
            return keys;
        }

        @Override
        @NotNull
        public ForeignKeys getForeignKeys() {
            ForeignKeys foreignKeys = this.myForeignKeys;
            if (foreignKeys == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/Db2ImplModel$Table", "getForeignKeys"));
            }
            return foreignKeys;
        }

        @Override
        @NotNull
        public Checks getChecks() {
            Checks checks = this.myChecks;
            if (checks == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/Db2ImplModel$Table", "getChecks"));
            }
            return checks;
        }

        @Override
        @NotNull
        public Triggers getTriggers() {
            Triggers triggers = this.myTriggers;
            if (triggers == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/Db2ImplModel$Table", "getTriggers"));
            }
            return triggers;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/Db2ImplModel$Table", "familyOf"));
            }
            if (kind == ObjectKind.COLUMN) {
                return this.myColumns;
            }
            if (kind == ObjectKind.INDEX) {
                return this.myIndices;
            }
            if (kind == ObjectKind.KEY) {
                return this.myKeys;
            }
            if (kind == ObjectKind.FOREIGN_KEY) {
                return this.myForeignKeys;
            }
            if (kind == ObjectKind.CHECK) {
                return this.myChecks;
            }
            if (kind == ObjectKind.TRIGGER) {
                return this.myTriggers;
            }
            return null;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/Db2ImplModel$Table", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/Db2ImplModel$Table", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = BaseModel.deduplicate(name);
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        public boolean isSystem() {
            return this.mySystem;
        }

        @Override
        public void setSystem(boolean system) {
            if (this.mySystem == system) {
                return;
            }
            this.modifying();
            this.mySystem = system;
        }

        @Override
        public boolean isTemporary() {
            return this.myTemporary;
        }

        @Override
        public void setTemporary(boolean temporary) {
            if (this.myTemporary == temporary) {
                return;
            }
            this.modifying();
            this.myTemporary = temporary;
        }

        private final class Triggers
        extends BaseModel.BaseNamingFamily<Trigger> {
            private Triggers(Table owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/Db2ImplModel$Table$Triggers", "<init>"));
                }
                super(owner);
            }

            @Override
            protected Trigger instantiate() {
                return new Trigger(this);
            }
        }

        private final class Checks
        extends BaseModel.BaseNamingFamily<Check> {
            private Checks(Table owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/Db2ImplModel$Table$Checks", "<init>"));
                }
                super(owner);
            }

            @Override
            protected Check instantiate() {
                return new Check(this);
            }
        }

        private final class ForeignKeys
        extends BaseModel.BaseNamingFamily<ForeignKey> {
            private ForeignKeys(Table owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/Db2ImplModel$Table$ForeignKeys", "<init>"));
                }
                super(owner);
            }

            @Override
            protected ForeignKey instantiate() {
                return new ForeignKey(this);
            }
        }

        private final class Keys
        extends BaseModel.BaseNamingFamily<Key> {
            private Keys(Table owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/Db2ImplModel$Table$Keys", "<init>"));
                }
                super(owner);
            }

            @Override
            protected Key instantiate() {
                return new Key(this);
            }
        }

        private final class Indices
        extends BaseModel.BaseNamingFamily<Index> {
            private Indices(Table owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/Db2ImplModel$Table$Indices", "<init>"));
                }
                super(owner);
            }

            @Override
            protected Index instantiate() {
                return new Index(this);
            }
        }

        private final class Columns
        extends BaseModel.BasePositioningNamingFamily<TableColumn> {
            private Columns(Table owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/Db2ImplModel$Table$Columns", "<init>"));
                }
                super(owner);
            }

            @Override
            protected TableColumn instantiate() {
                return new TableColumn(this);
            }
        }
    }

    final class Schema
    extends BaseModel.BaseRegularElement
    implements Db2ModSchema {
        private final Tables myTables;
        private final Views myViews;
        private final Routines myRoutines;
        private final Synonyms mySynonyms;
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;
        @Nullable
        private Date myIntrospectionTimestamp;
        private boolean myCurrent;
        private boolean myVisible;

        private Schema(BaseModel.BaseFamily<? extends Schema> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/Db2ImplModel$Schema", "<init>"));
            }
            super(parentFamily);
            this.myTables = new Tables(this);
            this.myViews = new Views(this);
            this.myRoutines = new Routines(this);
            this.mySynonyms = new Synonyms(this);
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
            this.myIntrospectionTimestamp = null;
            this.myCurrent = false;
            this.myVisible = false;
        }

        @Override
        @NotNull
        public Root getRoot() {
            Root root2 = (Root)this.myParentFamily.owner;
            if (root2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/Db2ImplModel$Schema", "getRoot"));
            }
            return root2;
        }

        @Override
        @NotNull
        public ModNamingFamily<Schema> getParentFamily() {
            ModNamingFamily modNamingFamily = (ModNamingFamily)((Object)this.myParentFamily);
            if (modNamingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/Db2ImplModel$Schema", "getParentFamily"));
            }
            return modNamingFamily;
        }

        @Override
        @NotNull
        public Tables getTables() {
            Tables tables = this.myTables;
            if (tables == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/Db2ImplModel$Schema", "getTables"));
            }
            return tables;
        }

        @Override
        @NotNull
        public Views getViews() {
            Views views = this.myViews;
            if (views == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/Db2ImplModel$Schema", "getViews"));
            }
            return views;
        }

        @Override
        @NotNull
        public Routines getRoutines() {
            Routines routines = this.myRoutines;
            if (routines == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/Db2ImplModel$Schema", "getRoutines"));
            }
            return routines;
        }

        @Override
        @NotNull
        public Synonyms getSynonyms() {
            Synonyms synonyms = this.mySynonyms;
            if (synonyms == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/Db2ImplModel$Schema", "getSynonyms"));
            }
            return synonyms;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/Db2ImplModel$Schema", "familyOf"));
            }
            if (kind == ObjectKind.TABLE) {
                return this.myTables;
            }
            if (kind == ObjectKind.VIEW) {
                return this.myViews;
            }
            if (kind == ObjectKind.ROUTINE) {
                return this.myRoutines;
            }
            if (kind == ObjectKind.SYNONYM) {
                return this.mySynonyms;
            }
            return null;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/Db2ImplModel$Schema", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/Db2ImplModel$Schema", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = BaseModel.deduplicate(name);
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        @Nullable
        public Date getIntrospectionTimestamp() {
            return this.myIntrospectionTimestamp;
        }

        @Override
        public void setIntrospectionTimestamp(@Nullable Date introspectionTimestamp) {
            if (BaseModel.eq(this.myIntrospectionTimestamp, introspectionTimestamp)) {
                return;
            }
            this.modifying();
            this.myIntrospectionTimestamp = introspectionTimestamp;
        }

        @Override
        public boolean isCurrent() {
            return this.myCurrent;
        }

        @Override
        public void setCurrent(boolean current) {
            if (this.myCurrent == current) {
                return;
            }
            this.modifying();
            this.myCurrent = current;
        }

        @Override
        public boolean isVisible() {
            return this.myVisible;
        }

        @Override
        public void setVisible(boolean visible) {
            if (this.myVisible == visible) {
                return;
            }
            this.modifying();
            this.myVisible = visible;
        }

        private final class Synonyms
        extends BaseModel.BaseNamingIdentifyingFamily<Synonym> {
            private Synonyms(Schema owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/Db2ImplModel$Schema$Synonyms", "<init>"));
                }
                super(owner);
            }

            @Override
            protected Synonym instantiate() {
                return new Synonym(this);
            }
        }

        private final class Routines
        extends BaseModel.BaseNamingFamily<Routine> {
            private Routines(Schema owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/Db2ImplModel$Schema$Routines", "<init>"));
                }
                super(owner);
            }

            @Override
            protected Routine instantiate() {
                return new Routine(this);
            }
        }

        private final class Views
        extends BaseModel.BaseNamingFamily<View> {
            private Views(Schema owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/Db2ImplModel$Schema$Views", "<init>"));
                }
                super(owner);
            }

            @Override
            protected View instantiate() {
                return new View(this);
            }
        }

        private final class Tables
        extends BaseModel.BaseNamingFamily<Table> {
            private Tables(Schema owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/Db2ImplModel$Schema$Tables", "<init>"));
                }
                super(owner);
            }

            @Override
            protected Table instantiate() {
                return new Table(this);
            }
        }
    }

    final class Root
    extends BaseModel.BaseRoot
    implements Db2ModRoot {
        private final Schemas mySchemas = new Schemas(this);

        private Root() {
        }

        @Override
        @NotNull
        public Schemas getSchemas() {
            Schemas schemas = this.mySchemas;
            if (schemas == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/Db2ImplModel$Root", "getSchemas"));
            }
            return schemas;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/Db2ImplModel$Root", "familyOf"));
            }
            if (kind == ObjectKind.SCHEMA) {
                return this.mySchemas;
            }
            return null;
        }

        private final class Schemas
        extends BaseModel.BaseNamingFamily<Schema> {
            private Schemas(Root owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/Db2ImplModel$Root$Schemas", "<init>"));
                }
                super(owner);
            }

            @Override
            protected Schema instantiate() {
                return new Schema(this);
            }
        }
    }
}

