/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.mssql;

import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.NameValueConsumer;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicCheck;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicLeaf;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.NamingIdentifyingFamily;
import com.intellij.database.model.mssql.MsConstraint;
import com.intellij.database.model.mssql.MsLikeTable;
import com.intellij.database.model.mssql.MsSchema;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface MsCheck
extends MsConstraint,
BasicCheck,
BasicLeaf {
    @Override
    @NotNull
    default public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.CHECK;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/mssql/MsCheck", "getKind"));
        }
        return objectKind;
    }

    @Nullable
    public MsLikeTable getLikeTable();

    @Override
    @Nullable
    default public MsLikeTable getDbParent() {
        return this.getLikeTable();
    }

    @Override
    @Nullable
    default public MsLikeTable getMajorObject() {
        return this.getLikeTable();
    }

    default public @Nullable NamingIdentifyingFamily<@NotNull ? extends MsCheck> getParentFamily() {
        return null;
    }

    @Override
    @Nullable
    default public MsSchema getSchema() {
        MsLikeTable likeTable = this.getLikeTable();
        return likeTable != null ? likeTable.getSchema() : null;
    }

    @Override
    @NotNull
    default public List<ObjectKind> getFamilyKinds() {
        List<ObjectKind> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/mssql/MsCheck", "getFamilyKinds"));
        }
        return list;
    }

    @Override
    @NotNull
    default public @NotNull List<@NotNull ? extends Family<@NotNull ? extends BasicElement>> getFamilies() {
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/mssql/MsCheck", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public @NotNull JBIterable<@NotNull ? extends BasicElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.empty();
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/mssql/MsCheck", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    default public long getObjectId() {
        return Long.MIN_VALUE;
    }

    @Override
    @NotNull
    default public String getName() {
        String string = ModelConsts.NO_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/mssql/MsCheck", "getName"));
        }
        return string;
    }

    @Override
    default public boolean isNameSurrogate() {
        return false;
    }

    @Override
    @Nullable
    default public String getComment() {
        return null;
    }

    @Override
    @Nullable
    default public Date getCreatedTimestamp() {
        return null;
    }

    @Override
    @Nullable
    default public Date getModifiedTimestamp() {
        return null;
    }

    @Override
    @NotNull
    default public List<String> getColNames() {
        List<String> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/mssql/MsCheck", "getColNames"));
        }
        return list;
    }

    @Override
    default public boolean isDeferrable() {
        return false;
    }

    @Override
    default public boolean isInitiallyDeferred() {
        return false;
    }

    @Override
    @Nullable
    default public String getPredicate() {
        return null;
    }

    @Override
    default public void exportProperties(@NotNull NameValueConsumer<String> consumer) {
        String predicate;
        boolean initiallyDeferred;
        boolean deferrable;
        List<String> colNames;
        Date modifiedTimestamp;
        Date createdTimestamp;
        String comment;
        boolean nameSurrogate;
        String name;
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/model/mssql/MsCheck", "exportProperties"));
        }
        long objectId = this.getObjectId();
        if (objectId != Long.MIN_VALUE) {
            consumer.accept("ObjectId", PropertyConverter.export(objectId));
        }
        if ((name = this.getName()) != null && name != ModelConsts.NO_NAME) {
            consumer.accept("Name", PropertyConverter.export(name));
        }
        if (nameSurrogate = this.isNameSurrogate()) {
            consumer.accept("NameSurrogate", PropertyConverter.export(nameSurrogate));
        }
        if ((comment = this.getComment()) != null) {
            consumer.accept("Comment", PropertyConverter.export(comment));
        }
        if ((createdTimestamp = this.getCreatedTimestamp()) != null) {
            consumer.accept("CreatedTimestamp", PropertyConverter.export(createdTimestamp));
        }
        if ((modifiedTimestamp = this.getModifiedTimestamp()) != null) {
            consumer.accept("ModifiedTimestamp", PropertyConverter.export(modifiedTimestamp));
        }
        if (!(colNames = this.getColNames()).isEmpty()) {
            consumer.accept("ColNames", PropertyConverter.exportListOfString(colNames));
        }
        if (deferrable = this.isDeferrable()) {
            consumer.accept("Deferrable", PropertyConverter.export(deferrable));
        }
        if (initiallyDeferred = this.isInitiallyDeferred()) {
            consumer.accept("InitiallyDeferred", PropertyConverter.export(initiallyDeferred));
        }
        if ((predicate = this.getPredicate()) != null) {
            consumer.accept("Predicate", PropertyConverter.export(predicate));
        }
    }

    @Override
    @NotNull
    default public List<String> getPropertyNames() {
        List<String> list = Arrays.asList("ObjectId", "Name", "NameSurrogate", "Comment", "CreatedTimestamp", "ModifiedTimestamp", "ColNames", "Deferrable", "InitiallyDeferred", "Predicate");
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/mssql/MsCheck", "getPropertyNames"));
        }
        return list;
    }
}

