/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.oracle;

import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.NameValueConsumer;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicUserDefinedType;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.database.model.families.NamingIdentifyingFamily;
import com.intellij.database.model.families.PositioningNamingFamily;
import com.intellij.database.model.families.SingletonFamily;
import com.intellij.database.model.oracle.OraModule;
import com.intellij.database.model.oracle.OraObjectTypeAttribute;
import com.intellij.database.model.oracle.OraObjectTypeBody;
import com.intellij.database.model.oracle.OraObjectTypeRoutine;
import com.intellij.database.model.oracle.OraSchema;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.database.model.properties.SourceError;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface OraObjectType
extends OraModule,
BasicUserDefinedType {
    @Override
    @NotNull
    default public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.OBJECT_TYPE;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/oracle/OraObjectType", "getKind"));
        }
        return objectKind;
    }

    @Override
    @Nullable
    public OraSchema getSchema();

    @Override
    @Nullable
    default public OraSchema getDbParent() {
        return this.getSchema();
    }

    default public @Nullable NamingIdentifyingFamily<@NotNull ? extends OraObjectType> getParentFamily() {
        return null;
    }

    @NotNull
    public @NotNull SingletonFamily<@NotNull ? extends OraObjectTypeBody> getBodies();

    @NotNull
    public @NotNull PositioningNamingFamily<@NotNull ? extends OraObjectTypeAttribute> getAttributes();

    @NotNull
    public @NotNull NamingFamily<@NotNull ? extends OraObjectTypeRoutine> getRoutines();

    @Override
    @NotNull
    default public List<ObjectKind> getFamilyKinds() {
        List<ObjectKind> list = Arrays.asList(ObjectKind.BODY, ObjectKind.OBJECT_ATTRIBUTE, ObjectKind.ROUTINE);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/oracle/OraObjectType", "getFamilyKinds"));
        }
        return list;
    }

    @Override
    @NotNull
    default public @NotNull List<@NotNull ? extends Family<@NotNull ? extends BasicElement>> getFamilies() {
        List<Family> list = Arrays.asList(this.getBodies(), this.getAttributes(), this.getRoutines());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/oracle/OraObjectType", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public @NotNull JBIterable<@NotNull ? extends BasicElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.empty().append(this.getBodies()).append(this.getAttributes()).append(this.getRoutines());
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/oracle/OraObjectType", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    default public long getObjectId() {
        return Long.MIN_VALUE;
    }

    @Override
    @NotNull
    default public String getName() {
        String string = ModelConsts.NO_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/oracle/OraObjectType", "getName"));
        }
        return string;
    }

    @Override
    default public boolean isNameSurrogate() {
        return false;
    }

    @Override
    @Nullable
    default public String getComment() {
        return null;
    }

    @Override
    @NotNull
    default public List<SourceError> getErrors() {
        List<SourceError> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/oracle/OraObjectType", "getErrors"));
        }
        return list;
    }

    @Override
    default public boolean isInvalid() {
        return false;
    }

    @Override
    @Nullable
    default public Date getCreatedTimestamp() {
        return null;
    }

    @Override
    @Nullable
    default public Date getModifiedTimestamp() {
        return null;
    }

    @Nullable
    default public String getSuperSchemaName() {
        return null;
    }

    @Nullable
    default public String getSuperObjectName() {
        return null;
    }

    default public boolean isIncomplete() {
        return false;
    }

    default public boolean isFinal() {
        return false;
    }

    default public boolean isInstantiable() {
        return false;
    }

    @Override
    default public void exportProperties(@NotNull NameValueConsumer<String> consumer) {
        boolean instantiable;
        boolean finnal;
        boolean incomplete;
        String superObjectName;
        String superSchemaName;
        Date modifiedTimestamp;
        Date createdTimestamp;
        boolean invalid;
        String comment;
        boolean nameSurrogate;
        String name;
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/model/oracle/OraObjectType", "exportProperties"));
        }
        long objectId = this.getObjectId();
        if (objectId != Long.MIN_VALUE) {
            consumer.accept("ObjectId", PropertyConverter.export(objectId));
        }
        if ((name = this.getName()) != null && name != ModelConsts.NO_NAME) {
            consumer.accept("Name", PropertyConverter.export(name));
        }
        if (nameSurrogate = this.isNameSurrogate()) {
            consumer.accept("NameSurrogate", PropertyConverter.export(nameSurrogate));
        }
        if ((comment = this.getComment()) != null) {
            consumer.accept("Comment", PropertyConverter.export(comment));
        }
        if (invalid = this.isInvalid()) {
            consumer.accept("Invalid", PropertyConverter.export(invalid));
        }
        if ((createdTimestamp = this.getCreatedTimestamp()) != null) {
            consumer.accept("CreatedTimestamp", PropertyConverter.export(createdTimestamp));
        }
        if ((modifiedTimestamp = this.getModifiedTimestamp()) != null) {
            consumer.accept("ModifiedTimestamp", PropertyConverter.export(modifiedTimestamp));
        }
        if ((superSchemaName = this.getSuperSchemaName()) != null) {
            consumer.accept("SuperSchemaName", PropertyConverter.export(superSchemaName));
        }
        if ((superObjectName = this.getSuperObjectName()) != null) {
            consumer.accept("SuperObjectName", PropertyConverter.export(superObjectName));
        }
        if (incomplete = this.isIncomplete()) {
            consumer.accept("Incomplete", PropertyConverter.export(incomplete));
        }
        if (finnal = this.isFinal()) {
            consumer.accept("Final", PropertyConverter.export(finnal));
        }
        if (instantiable = this.isInstantiable()) {
            consumer.accept("Instantiable", PropertyConverter.export(instantiable));
        }
    }

    @Override
    @NotNull
    default public List<String> getPropertyNames() {
        List<String> list = Arrays.asList("ObjectId", "Name", "NameSurrogate", "Comment", "Errors", "Invalid", "CreatedTimestamp", "ModifiedTimestamp", "SuperSchemaName", "SuperObjectName", "Incomplete", "Final", "Instantiable");
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/oracle/OraObjectType", "getPropertyNames"));
        }
        return list;
    }
}

