/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.properties;

import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public final class SourceError {
    public final int line;
    public final int pos;
    @NotNull
    public final String message;

    private SourceError(int line, int pos, @NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/database/model/properties/SourceError", "<init>"));
        }
        this.line = line;
        this.pos = pos;
        this.message = StringUtil.notNullize((String)message);
    }

    public static SourceError of(int line, int pos, @NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/database/model/properties/SourceError", "of"));
        }
        return new SourceError(line, pos, message);
    }

    public String toString() {
        return this.line + "." + this.pos + ": " + this.message;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SourceError error = (SourceError)o;
        if (this.line != error.line) {
            return false;
        }
        if (this.pos != error.pos) {
            return false;
        }
        return this.message.equals(error.message);
    }

    public int hashCode() {
        return this.line * 101 + this.pos;
    }
}

