/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.sybase;

import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModIdentifiedElement;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.database.model.properties.TrigEvent;
import com.intellij.database.model.properties.TrigTurn;
import com.intellij.database.model.sybase.SybaseModLikeTable;
import com.intellij.database.model.sybase.SybaseModSourceAware;
import com.intellij.database.model.sybase.SybaseTrigger;
import com.intellij.util.containers.JBIterable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface SybaseModTrigger
extends SybaseTrigger,
SybaseModSourceAware,
BasicModIdentifiedElement,
BasicModNamedElement {
    @Override
    @NotNull
    public SybaseModLikeTable getLikeTable();

    @Override
    @NotNull
    default public SybaseModLikeTable getDbParent() {
        SybaseModLikeTable sybaseModLikeTable = this.getLikeTable();
        if (sybaseModLikeTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/sybase/SybaseModTrigger", "getDbParent"));
        }
        return sybaseModLikeTable;
    }

    @Override
    @NotNull
    public ModNamingIdentifyingFamily<? extends SybaseModTrigger> getParentFamily();

    @Override
    @NotNull
    default public List<? extends ModFamily<? extends BasicModElement>> getFamilies() {
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/sybase/SybaseModTrigger", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public JBIterable<? extends BasicModElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.empty();
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/sybase/SybaseModTrigger", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    public void setObjectId(long var1);

    @Override
    public void setName(@NotNull String var1);

    @Override
    public void setNameSurrogate(boolean var1);

    @Override
    public void setComment(@Nullable String var1);

    public void setTurn(@Nullable TrigTurn var1);

    public void setEvents(@NotNull Set<TrigEvent> var1);

    @Override
    default public void importProperties(@NotNull Map<String, String> properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/database/model/sybase/SybaseModTrigger", "importProperties"));
        }
        String objectId = properties.get("ObjectId");
        String name = properties.get("Name");
        String nameSurrogate = properties.get("NameSurrogate");
        String comment = properties.get("Comment");
        String turn = properties.get("Turn");
        String events = properties.get("Events");
        if (objectId != null) {
            this.setObjectId(PropertyConverter.importLong(objectId));
        }
        if (name != null) {
            this.setName(PropertyConverter.importString(name));
        }
        if (nameSurrogate != null) {
            this.setNameSurrogate(PropertyConverter.importBoolean(nameSurrogate));
        }
        if (comment != null) {
            this.setComment(PropertyConverter.importString(comment));
        }
        if (turn != null) {
            this.setTurn(PropertyConverter.importTrigTurn(turn));
        }
        if (events != null) {
            this.setEvents(PropertyConverter.importSetOfTrigEvent(events));
        }
    }
}

