/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.generation;

import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasObject;
import com.intellij.database.schemaEditor.generation.DdlGraphBuilder;
import com.intellij.database.schemaEditor.generation.DdlOperation;
import com.intellij.database.schemaEditor.generation.DdlOperationKey;
import com.intellij.database.schemaEditor.generation.ImplicitDepProvider;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.schemaEditor.operations.DasDdlOperations;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImplicitRenameOrder
extends ImplicitDepProvider {
    @Override
    public void addImplicitDeps(@NotNull DdlGraphBuilder builder, @NotNull MultiMap<DdlOperationKey, DdlOperationKey> deps) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/schemaEditor/generation/ImplicitRenameOrder", "addImplicitDeps"));
        }
        if (deps == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deps", "com/intellij/database/schemaEditor/generation/ImplicitRenameOrder", "addImplicitDeps"));
        }
        ArrayList operations = ContainerUtil.newArrayList((Iterable)builder.getOperations().filter(key -> ImplicitRenameOrder.isRename(key)));
        MultiMap sense = MultiMap.create((TObjectHashingStrategy)ContainerUtil.canonicalStrategy());
        MultiMap insense = MultiMap.create((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
        for (DdlOperationKey key2 : operations) {
            DeObject from = DasDdlOperations.getAlterFrom(key2, builder);
            Casing casing = builder.getDialect().getCasing(from.getKind(), from);
            (DasUtil.isCaseSensitive((Casing)casing) ? sense : insense).putValue((Object)from.getName(), (Object)key2);
        }
        for (DdlOperationKey key2 : operations) {
            UserDataHolder data = builder.getData(key2);
            DeObject to = DasDdlOperations.getAlterTo(key2.target, data);
            boolean temp1 = DasDdlOperations.TemporaryRenameOperation.TEMPORARY.get(data) == Boolean.TRUE;
            Casing casing = builder.getDialect().getCasing(to.getKind(), to);
            for (DdlOperationKey mayConflict : (DasUtil.isCaseSensitive((Casing)casing) ? sense : insense).get((Object)to.getName())) {
                if (mayConflict.equals(key2) || !ImplicitRenameOrder.conflicts(to, temp1, mayConflict, builder)) continue;
                deps.putValue((Object)key2, (Object)mayConflict);
            }
        }
    }

    public static boolean conflicts(@NotNull DdlOperationKey key1, @NotNull DdlOperationKey key2, @NotNull DdlGraphBuilder builder) {
        if (key1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key1", "com/intellij/database/schemaEditor/generation/ImplicitRenameOrder", "conflicts"));
        }
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key2", "com/intellij/database/schemaEditor/generation/ImplicitRenameOrder", "conflicts"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/schemaEditor/generation/ImplicitRenameOrder", "conflicts"));
        }
        UserDataHolder data = builder.getData(key1);
        boolean temp1 = DasDdlOperations.TemporaryRenameOperation.TEMPORARY.get(data) == Boolean.TRUE;
        DeObject obj1 = DasDdlOperations.getAlterTo(key1.target, data);
        return ImplicitRenameOrder.conflicts(obj1, temp1, key2, builder);
    }

    private static boolean conflicts(@NotNull DeObject obj1, boolean temp1, @NotNull DdlOperationKey key2, @NotNull DdlGraphBuilder builder) {
        if (obj1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "obj1", "com/intellij/database/schemaEditor/generation/ImplicitRenameOrder", "conflicts"));
        }
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key2", "com/intellij/database/schemaEditor/generation/ImplicitRenameOrder", "conflicts"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/schemaEditor/generation/ImplicitRenameOrder", "conflicts"));
        }
        UserDataHolder data = builder.getData(key2);
        boolean temp2 = DasDdlOperations.TemporaryRenameOperation.TEMPORARY.get(data) == Boolean.TRUE;
        DeObject obj2 = DasDdlOperations.getAlterFrom(key2.target, data);
        return ImplicitRenameOrder.conflicts(obj1, temp1, obj2, temp2, builder);
    }

    private static boolean conflicts(@NotNull DeObject obj1, boolean temp1, @NotNull DeObject obj2, boolean temp2, @NotNull DdlGraphBuilder builder) {
        if (obj1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "obj1", "com/intellij/database/schemaEditor/generation/ImplicitRenameOrder", "conflicts"));
        }
        if (obj2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "obj2", "com/intellij/database/schemaEditor/generation/ImplicitRenameOrder", "conflicts"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/schemaEditor/generation/ImplicitRenameOrder", "conflicts"));
        }
        if (obj1 == obj2) {
            return !temp1 || !temp2;
        }
        if (obj1.getKind() != obj2.getKind()) {
            return false;
        }
        if (!DasUtil.nameEqual((DasObject)obj1, (String)obj2.getName(), (CasingProvider)builder.getDialect())) {
            return false;
        }
        return ImplicitRenameOrder.isSameOrRenamed(obj1.getParent(), obj2.getParent(), builder);
    }

    private static boolean isSameOrRenamed(@Nullable DeObject o1, @Nullable DeObject o2, @NotNull DdlGraphBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/schemaEditor/generation/ImplicitRenameOrder", "isSameOrRenamed"));
        }
        if (o1 == o2 || o1 == null || o2 == null) {
            return o1 == o2;
        }
        if (o1.getKind() != o2.getKind()) {
            return false;
        }
        return ImplicitRenameOrder.getObjectEquivalence(o1, builder).contains(o2) || DasUtil.nameEqual((DasObject)o1, (String)o2.getName(), (CasingProvider)builder.getDialect()) && ImplicitRenameOrder.isSameOrRenamed(o1.getParent(), o2.getParent(), builder);
    }

    @NotNull
    private static Set<DeObject> getObjectEquivalence(@Nullable DeObject o, @NotNull DdlGraphBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/schemaEditor/generation/ImplicitRenameOrder", "getObjectEquivalence"));
        }
        if (o == null) {
            Set<DeObject> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/generation/ImplicitRenameOrder", "getObjectEquivalence"));
            }
            return set;
        }
        LinkedList toProcess = ContainerUtil.newLinkedList();
        HashSet visited = ContainerUtil.newHashSet();
        visited.add(o);
        toProcess.addAll(builder.getNodes(new DdlOperationKey(o, DdlOperation.RENAME)));
        toProcess.addAll(builder.getNodes(new DdlOperationKey(o, DdlOperation.POST_RENAME)));
        while (!toProcess.isEmpty()) {
            DdlOperationKey key = (DdlOperationKey)toProcess.remove(0);
            DeObject from = DasDdlOperations.getAlterFrom(key, builder);
            DeObject to = DasDdlOperations.getAlterFrom(key, builder);
            if (!visited.contains(from)) {
                visited.add(from);
                toProcess.addAll(builder.getNodes(new DdlOperationKey(from, DdlOperation.POST_RENAME)));
            }
            if (visited.contains(to)) continue;
            visited.add(to);
            toProcess.addAll(builder.getNodes(new DdlOperationKey(to, DdlOperation.RENAME)));
        }
        HashSet hashSet = visited;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/generation/ImplicitRenameOrder", "getObjectEquivalence"));
        }
        return hashSet;
    }

    public static boolean isRename(@NotNull DdlOperationKey key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/database/schemaEditor/generation/ImplicitRenameOrder", "isRename"));
        }
        return ArrayUtil.contains((Object)DdlOperation.RENAME, (Object[])key.operation.getInterfaces());
    }
}

