/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.model;

import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.schemaEditor.model.DeColumn;
import com.intellij.database.schemaEditor.model.DeColumnListBase;
import com.intellij.database.schemaEditor.model.DeModel;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DeIndex
extends DeColumnListBase
implements DasIndex {
    public boolean unique;
    public final List<Item> items;

    protected DeIndex(@NotNull DeModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/schemaEditor/model/DeIndex", "<init>"));
        }
        super(model);
        this.items = ContainerUtil.newArrayList();
    }

    public DeIndex(@NotNull String name, @NotNull DeTable table, @NotNull DeModel model) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/schemaEditor/model/DeIndex", "<init>"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/schemaEditor/model/DeIndex", "<init>"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/schemaEditor/model/DeIndex", "<init>"));
        }
        super(name, table, model);
        this.items = ContainerUtil.newArrayList();
    }

    @Override
    @NotNull
    public Iterable<DeColumn> getColumns() {
        JBIterable jBIterable = JBIterable.from(this.items).transform(item -> item.column);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/model/DeIndex", "getColumns"));
        }
        return jBIterable;
    }

    @Override
    @NotNull
    public DeObject copyFrom(@NotNull DeObject obj, boolean withChildren, @NotNull DeObject.DeCopier copier) {
        if (obj == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "obj", "com/intellij/database/schemaEditor/model/DeIndex", "copyFrom"));
        }
        if (copier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "copier", "com/intellij/database/schemaEditor/model/DeIndex", "copyFrom"));
        }
        super.copyFrom(obj, withChildren, copier);
        DeIndex idx = (DeIndex)obj;
        this.unique = idx.unique;
        this.items.clear();
        for (Item item : idx.items) {
            this.items.add(new Item(copier.copy(item.column, false), item.sorting));
        }
        DeIndex deIndex = this;
        if (deIndex == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/model/DeIndex", "copyFrom"));
        }
        return deIndex;
    }

    @Override
    @NotNull
    public DeObject emptyClone(@NotNull DeModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/schemaEditor/model/DeIndex", "emptyClone"));
        }
        DeIndex deIndex = new DeIndex(model);
        if (deIndex == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/model/DeIndex", "emptyClone"));
        }
        return deIndex;
    }

    public boolean isUnique() {
        return this.unique;
    }

    @NotNull
    public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.INDEX;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/model/DeIndex", "getKind"));
        }
        return objectKind;
    }

    @Override
    public boolean isAlteredIgnoringChild(@NotNull DeObject other, @NotNull Collection<? extends DeObject> children, @NotNull Collection<? extends DasObject> otherChildren) {
        if (other == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "com/intellij/database/schemaEditor/model/DeIndex", "isAlteredIgnoringChild"));
        }
        if (children == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "children", "com/intellij/database/schemaEditor/model/DeIndex", "isAlteredIgnoringChild"));
        }
        if (otherChildren == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "otherChildren", "com/intellij/database/schemaEditor/model/DeIndex", "isAlteredIgnoringChild"));
        }
        return this.unique != ((DeIndex)other).unique || DeIndex.isSortingAltered(this, (DeIndex)other) || super.isAlteredIgnoringChild(other, children, otherChildren);
    }

    @NotNull
    public DasIndex.Sorting getColumnSorting(@NotNull DasTypedObject column) {
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/schemaEditor/model/DeIndex", "getColumnSorting"));
        }
        for (Item item : this.items) {
            if (item.column != column) continue;
            DasIndex.Sorting sorting = item.sorting;
            if (sorting == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/model/DeIndex", "getColumnSorting"));
            }
            return sorting;
        }
        DasIndex.Sorting sorting = DasIndex.Sorting.NONE;
        if (sorting == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/model/DeIndex", "getColumnSorting"));
        }
        return sorting;
    }

    protected static boolean isSortingAltered(@NotNull DeIndex a, @NotNull DeIndex b) {
        if (a == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a", "com/intellij/database/schemaEditor/model/DeIndex", "isSortingAltered"));
        }
        if (b == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "com/intellij/database/schemaEditor/model/DeIndex", "isSortingAltered"));
        }
        if (a.items.size() != b.items.size()) {
            return true;
        }
        for (int i2 = 0; i2 < a.items.size(); ++i2) {
            if (a.items.get((int)i2).sorting == b.items.get((int)i2).sorting) continue;
            return true;
        }
        return false;
    }

    public static class Item {
        public final DeColumn column;
        public final DasIndex.Sorting sorting;

        public Item(DeColumn column, DasIndex.Sorting sorting) {
            this.column = column;
            this.sorting = sorting;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Item item = (Item)o;
            if (!Comparing.equal((Object)this.column, (Object)item.column)) {
                return false;
            }
            return this.sorting == item.sorting;
        }

        public int hashCode() {
            int result = Comparing.hashcode((Object)this.column);
            result = 31 * result + this.sorting.hashCode();
            return result;
        }
    }
}

