/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.operations;

import com.intellij.database.schemaEditor.generation.DdlOperation;
import com.intellij.database.schemaEditor.generation.DdlOperationGenerator;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.openapi.util.Key;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ConfigurableDdlGenerator<T extends DeObject>
extends DdlOperationGenerator<T> {
    public static final Key<Iterable<OptionValue<?>>> OPTION_VALUES = Key.create((String)"OPTION_VALUES");
    private final Option<?>[] myOptions;

    public ConfigurableDdlGenerator(@NotNull DdlOperation operation, Option<?> ... options) {
        if (operation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operation", "com/intellij/database/schemaEditor/operations/ConfigurableDdlGenerator", "<init>"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/database/schemaEditor/operations/ConfigurableDdlGenerator", "<init>"));
        }
        super(operation);
        this.myOptions = options;
    }

    @NotNull
    public Option<?>[] getOptions() {
        if (this.myOptions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/ConfigurableDdlGenerator", "getOptions"));
        }
        return this.myOptions;
    }

    @Nullable
    protected static <T> T findOption(@NotNull Iterable<OptionValue<?>> values, @NotNull Option<T> option) {
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/database/schemaEditor/operations/ConfigurableDdlGenerator", "findOption"));
        }
        if (option == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "option", "com/intellij/database/schemaEditor/operations/ConfigurableDdlGenerator", "findOption"));
        }
        for (OptionValue<?> value : values) {
            if (value.option != option) continue;
            return value.value;
        }
        return null;
    }

    public static class OptionValue<T> {
        public final Option<T> option;
        public T value;

        public OptionValue(@NotNull Option<T> option, @Nullable T value) {
            if (option == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "option", "com/intellij/database/schemaEditor/operations/ConfigurableDdlGenerator$OptionValue", "<init>"));
            }
            this.option = option;
            this.value = value;
        }

        @NotNull
        public <U> OptionValue<U> cast() {
            OptionValue optionValue = this;
            if (optionValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/ConfigurableDdlGenerator$OptionValue", "cast"));
            }
            return optionValue;
        }

        @NotNull
        public static <T> OptionValue<T> defaultOf(@NotNull Option<T> option) {
            if (option == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "option", "com/intellij/database/schemaEditor/operations/ConfigurableDdlGenerator$OptionValue", "defaultOf"));
            }
            OptionValue<T> optionValue = new OptionValue<T>(option, option.defValue);
            if (optionValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/ConfigurableDdlGenerator$OptionValue", "defaultOf"));
            }
            return optionValue;
        }
    }

    public static abstract class OptionVisitor {
        public abstract void visit(OptionValue<Boolean> var1, Boolean var2);

        public static void visit(OptionValue<?> opt, OptionVisitor vis) {
            if (opt.option.valueClass.isAssignableFrom(Boolean.class)) {
                vis.visit(opt.cast(), (Boolean)opt.cast().value);
            }
        }
    }

    public static class Option<T> {
        public final String name;
        public final Class<? extends T> valueClass;
        public final T defValue;

        public Option(@NotNull String name, @NotNull Class<? extends T> valueClass, @Nullable T defValue) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/schemaEditor/operations/ConfigurableDdlGenerator$Option", "<init>"));
            }
            if (valueClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueClass", "com/intellij/database/schemaEditor/operations/ConfigurableDdlGenerator$Option", "<init>"));
            }
            this.name = name;
            this.valueClass = valueClass;
            this.defValue = defValue;
        }

        @NotNull
        public static <T> Option<T> create(@NotNull String name, @NotNull T defValue) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/schemaEditor/operations/ConfigurableDdlGenerator$Option", "create"));
            }
            if (defValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defValue", "com/intellij/database/schemaEditor/operations/ConfigurableDdlGenerator$Option", "create"));
            }
            Option option = new Option(name, defValue.getClass(), defValue);
            if (option == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/ConfigurableDdlGenerator$Option", "create"));
            }
            return option;
        }
    }
}

