/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.google.common.collect.Iterables;
import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.access.ConnectionProvider;
import com.intellij.database.console.DbConsoleRootType;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcConsoleProvider;
import com.intellij.database.console.JdbcDriverManager;
import com.intellij.database.console.JdbcEngine;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbSrcFileSystem;
import com.intellij.database.dataSource.srcStorage.DbSrcPath;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.datagrid.mutating.ColumnUpdateData;
import com.intellij.database.dbimport.DataImporter;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.DatabaseDialects;
import com.intellij.database.dialects.GenericDialect;
import com.intellij.database.extractors.DataExtractor;
import com.intellij.database.extractors.ExtractorsUtil;
import com.intellij.database.extractors.HtmlValuesExtractor;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.extractors.tz.TimeZonedTime;
import com.intellij.database.extractors.tz.TimeZonedValue;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DataType;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbDataSourceImpl;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPackage;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.psi.DbRoutine;
import com.intellij.database.psi.DbTable;
import com.intellij.database.remote.jdbc.LobInfo;
import com.intellij.database.remote.jdbc.RemotePreparedStatement;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.database.remote.jdbc.impl.FileBlob;
import com.intellij.database.remote.jdbc.impl.FileClob;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.Case;
import com.intellij.database.util.CharOut;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.JdbcUtil;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.database.vfs.ObjectPath;
import com.intellij.database.vfs.SearchPath;
import com.intellij.database.view.DatabaseDialogsHelper;
import com.intellij.database.view.DbNodeDescriptor;
import com.intellij.execution.rmi.RemoteUtil;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.openapi.vfs.newvfs.persistent.VfsDependentEnum;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlCreateViewStatement;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlResultSetExpression;
import com.intellij.sql.psi.SqlSelectClause;
import com.intellij.sql.psi.SqlSelectOption;
import com.intellij.sql.psi.SqlTableExpression;
import com.intellij.sql.psi.SqlWithQueryExpression;
import com.intellij.sql.psi.impl.SqlTokenType;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.ThrowableConvertor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import gnu.trove.TIntArrayList;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.function.BiConsumer;
import javax.swing.JComboBox;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;

public class DbImplUtil {
    public static final String PG_TIMESTAMP_TZ_NAME = "timestamptz";
    private static final int UNLIMITED_PAGE_SIZE = -1;
    private static final String PG_TIME_TZ_NAME = "timetz";
    public static final Condition<DbElement> CAN_CONNECT_TO = DbImplUtil::canConnectTo;
    private static final char ESCAPE_CHAR = '#';
    public static final ThrowableConvertor<ResultSet, List<String>, SQLException> RS_AS_STRING_LIST = rs -> {
        ArrayList res = ContainerUtil.newArrayList();
        while (rs.next()) {
            res.add(rs.getString(1));
        }
        return res;
    };
    private static final String COMPUTED_COLUMN = "COMPUTED_COLUMN";
    private static final VfsDependentEnum<String> myDialectAndDataSourcesEnumerator = new VfsDependentEnum("sql_dialects_and_data_sources", (KeyDescriptor)EnumeratorStringDescriptor.INSTANCE, 1);

    private DbImplUtil() {
    }

    public static boolean valuesEqual(Object v1, Object v2) {
        ThreeState result;
        if (v1 == ReservedCellValue.NULL) {
            v1 = null;
        }
        if (v2 == ReservedCellValue.NULL) {
            v2 = null;
        }
        if ((result = DbImplUtil.simpleEquals(v1, v2)) == ThreeState.UNSURE) {
            result = DbImplUtil.numberEquals(v1, v2);
        }
        if (result == ThreeState.UNSURE) {
            result = DbImplUtil.arrayEquals(v1, v2);
        }
        if (result == ThreeState.UNSURE) {
            result = DbImplUtil.clobEquals(v1, v2);
        }
        if (result == ThreeState.UNSURE) {
            result = ThreeState.NO;
        }
        return result.toBoolean();
    }

    public static int valueHashCode(Object v) {
        if (v == ReservedCellValue.NULL) {
            v = null;
        }
        if (v instanceof Number) {
            Number n = (Number)v;
            return Long.valueOf(n.longValue()).hashCode() * 31 + Double.valueOf(n.doubleValue()).hashCode();
        }
        if (v instanceof byte[]) {
            return Arrays.hashCode((byte[])v);
        }
        if (v instanceof char[]) {
            return Arrays.hashCode((char[])v);
        }
        if (v instanceof LobInfo.ClobInfo) {
            return Comparing.hashcode((Object)((LobInfo.ClobInfo)v).data);
        }
        return Comparing.hashcode((Object)v);
    }

    private static ThreeState simpleEquals(Object v1, Object v2) {
        return Comparing.equal((Object)v1, (Object)v2) ? ThreeState.YES : ThreeState.UNSURE;
    }

    private static ThreeState numberEquals(Object v1, Object v2) {
        Number n1 = (Number)ObjectUtils.tryCast((Object)v1, Number.class);
        Number n2 = (Number)ObjectUtils.tryCast((Object)v2, Number.class);
        if (n1 != null && n2 != null) {
            long l1 = n1.longValue();
            long l2 = n2.longValue();
            double d1 = n1.doubleValue();
            double d2 = n2.doubleValue();
            return ThreeState.fromBoolean((l1 == l2 && (d1 == d2 || Double.isNaN(d1) && Double.isNaN(d2)) ? 1 : 0) != 0);
        }
        return ThreeState.UNSURE;
    }

    private static ThreeState arrayEquals(Object v1, Object v2) {
        if (v1 != null && v2 != null && v1.getClass() == v2.getClass() && v1.getClass().isArray()) {
            if (v1 instanceof byte[]) {
                return ThreeState.fromBoolean((boolean)Arrays.equals((byte[])v1, (byte[])v2));
            }
            if (v1 instanceof char[]) {
                return ThreeState.fromBoolean((boolean)Arrays.equals((char[])v1, (char[])v2));
            }
        }
        return ThreeState.UNSURE;
    }

    private static ThreeState clobEquals(Object v1, Object v2) {
        LobInfo.ClobInfo info1 = (LobInfo.ClobInfo)ObjectUtils.tryCast((Object)v1, LobInfo.ClobInfo.class);
        LobInfo.ClobInfo info2 = (LobInfo.ClobInfo)ObjectUtils.tryCast((Object)v2, LobInfo.ClobInfo.class);
        if (info1 != null && info2 != null) {
            return ThreeState.fromBoolean((!info2.isTruncated() && DbImplUtil.clobStringEquals(info1, info2.data) ? 1 : 0) != 0);
        }
        if (info1 != null && v2 instanceof String) {
            return ThreeState.fromBoolean((boolean)DbImplUtil.clobStringEquals(info1, (String)v2));
        }
        if (info2 != null && v1 instanceof String) {
            return ThreeState.fromBoolean((boolean)DbImplUtil.clobStringEquals(info2, (String)v1));
        }
        return ThreeState.UNSURE;
    }

    private static boolean clobStringEquals(@NotNull LobInfo.ClobInfo lob, @Nullable String s) {
        if (lob == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lob", "com/intellij/database/util/DbImplUtil", "clobStringEquals"));
        }
        return !lob.isTruncated() && Comparing.equal((String)lob.data, (String)s);
    }

    public static DdlBuilder createBuilderForExec(@NotNull DatabaseDialectEx dialect) {
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/util/DbImplUtil", "createBuilderForExec"));
        }
        return new DdlBuilder().withDialect(dialect).qualifyReferences(true).quoteIdentifiers(true);
    }

    public static DdlBuilder createBuilderForUIExec(@NotNull DatabaseDialectEx dialect, @Nullable DasObject object) {
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/util/DbImplUtil", "createBuilderForUIExec"));
        }
        DdlBuilder builder = DbImplUtil.createBuilderForExec(dialect).quoteIdentifiers(false);
        DbElement element = DbImplUtil.getDbElement(object);
        return element != null ? builder.withCasingFor(element) : builder;
    }

    public static DdlBuilder createSelectAllQuery(@NotNull DasTable databaseTable, @NotNull DatabaseDialectEx dialect, @Nullable DatabaseSystem system) {
        if (databaseTable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "databaseTable", "com/intellij/database/util/DbImplUtil", "createSelectAllQuery"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/util/DbImplUtil", "createSelectAllQuery"));
        }
        return DbImplUtil.createSelectAllQuery(databaseTable, dialect, system, false, -1);
    }

    public static DdlBuilder createSelectAllQuery(@NotNull DasTable databaseTable, @NotNull DatabaseDialectEx dialect, @Nullable DatabaseSystem system, int rows) {
        if (databaseTable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "databaseTable", "com/intellij/database/util/DbImplUtil", "createSelectAllQuery"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/util/DbImplUtil", "createSelectAllQuery"));
        }
        return DbImplUtil.createSelectAllQuery(databaseTable, dialect, system, false, rows);
    }

    public static DdlBuilder createSelectAllQuery(@NotNull DasTable databaseTable, @NotNull DatabaseDialectEx dialect, @Nullable DatabaseSystem system, boolean appendRowId, int rows) {
        if (databaseTable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "databaseTable", "com/intellij/database/util/DbImplUtil", "createSelectAllQuery"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/util/DbImplUtil", "createSelectAllQuery"));
        }
        return DbImplUtil.createSelectAllQuery(databaseTable, dialect, system, appendRowId, rows, Collections.emptyList(), Collections.emptyList());
    }

    public static DdlBuilder createSelectAllQuery(@NotNull DasTable databaseTable, @NotNull DatabaseDialectEx dialect, @Nullable DatabaseSystem system, int rows, @NotNull Iterable<String> columnNames, @NotNull Iterable<?> values) {
        if (databaseTable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "databaseTable", "com/intellij/database/util/DbImplUtil", "createSelectAllQuery"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/util/DbImplUtil", "createSelectAllQuery"));
        }
        if (columnNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnNames", "com/intellij/database/util/DbImplUtil", "createSelectAllQuery"));
        }
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/database/util/DbImplUtil", "createSelectAllQuery"));
        }
        return DbImplUtil.createSelectAllQuery(databaseTable, dialect, system, false, rows, columnNames, values);
    }

    private static DdlBuilder createSelectAllQuery(@NotNull DasTable databaseTable, @NotNull DatabaseDialectEx dialect, @Nullable DatabaseSystem system, boolean appendRowId, int rows, @NotNull Iterable<String> columnNames, @NotNull Iterable<?> values) {
        if (databaseTable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "databaseTable", "com/intellij/database/util/DbImplUtil", "createSelectAllQuery"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/util/DbImplUtil", "createSelectAllQuery"));
        }
        if (columnNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnNames", "com/intellij/database/util/DbImplUtil", "createSelectAllQuery"));
        }
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/database/util/DbImplUtil", "createSelectAllQuery"));
        }
        DdlBuilder builder = DbImplUtil.createBuilderForUIExec(dialect, (DasObject)databaseTable);
        BiConsumer<String, DdlBuilder> appendWhereClause = Iterables.isEmpty(columnNames) ? null : (tableNameAlias, ddlBuilder) -> {
            if (columnNames == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnNames", "com/intellij/database/util/DbImplUtil", "lambda$createSelectAllQuery$1"));
            }
            if (values == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/database/util/DbImplUtil", "lambda$createSelectAllQuery$1"));
            }
            if (dialect == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/util/DbImplUtil", "lambda$createSelectAllQuery$1"));
            }
            ddlBuilder.space().keyword("WHERE").space();
            DbImplUtil.composeWhereCondition(ddlBuilder, columnNames, values, tableNameAlias, dialect);
        };
        return DbImplUtil.createSelectAllQuery(builder, databaseTable, dialect, system, appendWhereClause, appendRowId, rows);
    }

    @Nullable
    private static DbElement getDbElement(@Nullable DasObject object) {
        return (DbElement)DasUtil.getParentOfClass((DasObject)object, DbDataSource.class, (boolean)false);
    }

    @NotNull
    public static List<ColumnUpdateData> createSelectAllQueryWithParameters(@NotNull DdlBuilder builder, @NotNull DasTable table, @NotNull DatabaseDialectEx dialect, @Nullable DatabaseSystem system, @NotNull List<ColumnUpdateData> datas, int rows) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/util/DbImplUtil", "createSelectAllQueryWithParameters"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/util/DbImplUtil", "createSelectAllQueryWithParameters"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/util/DbImplUtil", "createSelectAllQueryWithParameters"));
        }
        if (datas == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "datas", "com/intellij/database/util/DbImplUtil", "createSelectAllQueryWithParameters"));
        }
        if (datas.isEmpty()) {
            DbImplUtil.createSelectAllQuery(table, dialect, system, rows);
            ImmutableList immutableList = ContainerUtil.immutableList((Object[])new ColumnUpdateData[0]);
            if (immutableList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DbImplUtil", "createSelectAllQueryWithParameters"));
            }
            return immutableList;
        }
        ArrayList newData = ContainerUtil.newArrayList();
        BiConsumer<String, DdlBuilder> appendWhereClauseFunction = (tableNameAlias, ddlBuilder) -> {
            if (datas == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "datas", "com/intellij/database/util/DbImplUtil", "lambda$createSelectAllQueryWithParameters$2"));
            }
            if (dialect == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/util/DbImplUtil", "lambda$createSelectAllQueryWithParameters$2"));
            }
            ddlBuilder.space().keyword("WHERE").space();
            newData.addAll(DbImplUtil.composeWhereConditionWithParameters(ddlBuilder, datas, tableNameAlias, dialect));
        };
        DbImplUtil.createSelectAllQuery(builder, table, dialect, system, appendWhereClauseFunction, false, rows);
        ArrayList arrayList = newData;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DbImplUtil", "createSelectAllQueryWithParameters"));
        }
        return arrayList;
    }

    @NotNull
    private static DdlBuilder createSelectAllQuery(@NotNull DdlBuilder builder, @NotNull DasTable dasTable, @NotNull DatabaseDialectEx dialect, @Nullable DatabaseSystem system, @Nullable BiConsumer<String, DdlBuilder> appendWhereClause, boolean appendRowId, int rows) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/util/DbImplUtil", "createSelectAllQuery"));
        }
        if (dasTable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dasTable", "com/intellij/database/util/DbImplUtil", "createSelectAllQuery"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/util/DbImplUtil", "createSelectAllQuery"));
        }
        DdlBuilder ddlBuilder = dialect.sqlSelectAll(builder, dasTable, system, appendWhereClause, null, appendRowId, rows);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DbImplUtil", "createSelectAllQuery"));
        }
        return ddlBuilder;
    }

    @Nullable
    public static String createSelectCountQuery(@NotNull Project project, @NotNull DatabaseDialectEx dialect, @Nullable String queryText, @Nullable DbDataSource dataSource) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/util/DbImplUtil", "createSelectCountQuery"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/util/DbImplUtil", "createSelectCountQuery"));
        }
        queryText = queryText != null ? StringUtil.trimEnd((String)queryText, (String)";") : "";
        SqlResultSetExpression e = DbSqlUtil.parseQuery(project, DbSqlUtil.getSqlDialect(dialect), queryText, null);
        if (e == null) {
            return null;
        }
        SqlQueryExpression query = e instanceof SqlWithQueryExpression ? (SqlQueryExpression)ObjectUtils.tryCast((Object)((SqlWithQueryExpression)e).getExpression(), SqlQueryExpression.class) : (e instanceof SqlQueryExpression ? (SqlQueryExpression)e : null);
        DdlBuilder builder = DbImplUtil.createBuilderForUIExec(dialect, (DasObject)dataSource);
        if (query == null || !DbImplUtil.buildOptimizedCountQuery(builder, query, queryText)) {
            DbImplUtil.buildCountQuery(builder, e, queryText);
        }
        return builder.getStatement();
    }

    private static DdlBuilder buildCountQuery(@NotNull DdlBuilder builder, @NotNull SqlResultSetExpression e, @NotNull String query) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/util/DbImplUtil", "buildCountQuery"));
        }
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/util/DbImplUtil", "buildCountQuery"));
        }
        if (query == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "query", "com/intellij/database/util/DbImplUtil", "buildCountQuery"));
        }
        builder.keyword("SELECT").space().keyword("COUNT").symbol("(").symbol("*").symbol(")").space().keyword("FROM").space().symbol("(");
        boolean subqueryIsBuilt = false;
        boolean needSelectTargetAliases = builder.getDialect().getFamilyId().isMicrosoft();
        if (needSelectTargetAliases) {
            TIntArrayList endOffsets = new TIntArrayList();
            for (SqlSelectClause selectClause : SyntaxTraverser.psiTraverser((PsiElement)e).filter(SqlSelectClause.class)) {
                for (SqlExpression expression : selectClause.getExpressions()) {
                    if (expression instanceof SqlAsExpression || expression instanceof SqlReferenceExpression) continue;
                    endOffsets.add(expression.getTextRange().getEndOffset());
                }
            }
            endOffsets.sort();
            int prevIdx = 0;
            int count = 0;
            int len = endOffsets.size();
            for (int i2 = 0; i2 < len; ++i2) {
                int offset = endOffsets.get(i2);
                builder.plain(query.substring(prevIdx, offset));
                builder.space().columnRef("_" + ++count);
                prevIdx = offset;
            }
            builder.plain(e.getText().substring(prevIdx));
            subqueryIsBuilt = true;
        }
        if (!subqueryIsBuilt) {
            builder.plain(query);
        }
        return builder.symbol(")").space().identifier("t");
    }

    private static boolean buildOptimizedCountQuery(@NotNull DdlBuilder builder, @NotNull SqlQueryExpression query, @NotNull String queryText) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/util/DbImplUtil", "buildOptimizedCountQuery"));
        }
        if (query == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "query", "com/intellij/database/util/DbImplUtil", "buildOptimizedCountQuery"));
        }
        if (queryText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryText", "com/intellij/database/util/DbImplUtil", "buildOptimizedCountQuery"));
        }
        SqlSelectClause selectClause = query.getSelectClause();
        if (selectClause == null) {
            return false;
        }
        for (SqlSelectOption option : selectClause.getOptions()) {
            if (!option.getOptionName().startsWith("DISTINCT") && option.getClause() == null) continue;
            return false;
        }
        SqlTableExpression tableExp = query.getTableExpression();
        if (tableExp == null || tableExp.getHavingClause() != null || tableExp.getGroupByClause() != null) {
            return false;
        }
        List expressions = selectClause.getExpressions();
        for (SqlExpression e : expressions) {
            if (((SyntaxTraverser)SyntaxTraverser.psiTraverser().withRoot((Object)e)).preOrderDfsTraversal().filter(SqlFunctionCallExpression.class).isEmpty()) continue;
            return false;
        }
        SqlExpression firstExpression = (SqlExpression)ContainerUtil.getFirstItem((List)expressions);
        SqlExpression lastExpression = (SqlExpression)ContainerUtil.getLastItem((List)expressions);
        if (firstExpression == null || lastExpression == null) {
            return false;
        }
        int expressionsStartOffset = firstExpression.getTextRange().getStartOffset();
        int expressionsEndOffset = lastExpression.getTextRange().getEndOffset();
        builder.clear().plain(queryText.substring(0, expressionsStartOffset)).keyword("COUNT").symbol("(").symbol("*").symbol(")").plain(queryText.substring(expressionsEndOffset));
        return true;
    }

    @NotNull
    public static String resultSetToString(ResultSet rs, DatabaseDialectEx dialect, DataExtractor extractor) throws Exception {
        String string = DbImplUtil.resultSetToString("", rs, Integer.MAX_VALUE, dialect, extractor, CharOut.Util.newSink()).toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DbImplUtil", "resultSetToString"));
        }
        return string;
    }

    public static CharOut resultSetToString(String title, ResultSet rs, int size, DatabaseDialectEx dialect, DataExtractor extractor, CharOut out) throws Exception {
        DataConsumer.Column[] columns = JdbcEngine.getColumnDescriptors(rs, dialect);
        RemoteResultSet remoteResultSet = (RemoteResultSet)ObjectUtils.assertNotNull((Object)RemoteUtil.castToRemote((Object)rs, RemoteResultSet.class));
        List objects = remoteResultSet.getObjects(size, dialect.getClass().getSimpleName(), DatabaseSettings.getSettings().getMaxLobLength());
        List data = (List)RemoteUtil.handleRemoteResult((Object)objects, List.class, (Object)extractor);
        ArrayList<DataConsumer.Row> rows = new ArrayList<DataConsumer.Row>(data.size());
        if (data.isEmpty()) {
            return out;
        }
        for (int i2 = 0; i2 < data.size(); ++i2) {
            rows.add(DataConsumer.Row.create(i2 + 1, (Object[])data.get(i2)));
        }
        out.append(String.format(title, data.size()));
        ExtractorsUtil.extract(out, dialect, false, Arrays.asList(columns), extractor, rows, new int[0]);
        return out;
    }

    @Nullable
    public static DbDataSource getDbDataSource(@NotNull Project project, @NotNull LocalDataSource localDataSource) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/util/DbImplUtil", "getDbDataSource"));
        }
        if (localDataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localDataSource", "com/intellij/database/util/DbImplUtil", "getDbDataSource"));
        }
        return DbPsiFacade.getInstance((Project)project).findDataSource(localDataSource.getUniqueId());
    }

    public static boolean isConnected(@NotNull DbElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/util/DbImplUtil", "isConnected"));
        }
        return element.getDelegate() instanceof LocalDataSource && !JdbcDriverManager.getDriverManager(element.getProject()).getActiveConfigurations((LocalDataSource)((Object)element.getDelegate())).isEmpty();
    }

    public static boolean canConnectTo(@Nullable DbElement element) {
        DatabaseSystem ds = element == null ? null : element.getDataSource().getDelegate();
        return ds instanceof LocalDataSource && DbImplUtil.canConnectTo((LocalDataSource)ds);
    }

    public static boolean hasDriverFiles(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/util/DbImplUtil", "hasDriverFiles"));
        }
        return !dataSource.getClasspathElements().isEmpty();
    }

    public static boolean canConnectTo(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/util/DbImplUtil", "canConnectTo"));
        }
        if (StringUtil.isEmptyOrSpaces((String)dataSource.getUrl())) {
            return false;
        }
        if (!DbImplUtil.hasDriverFiles(dataSource)) {
            return false;
        }
        String driverClass = dataSource.getDriverClass();
        return !StringUtil.isEmptyOrSpaces((String)driverClass);
    }

    public static boolean canConnectToAndModify(@Nullable DbElement element) {
        return element != null && element.isWritable() && DbImplUtil.canConnectTo(element) && !DataImporter.isBusy(element);
    }

    @Nullable
    public static Connection getConnection(@NotNull DbElement element) throws Exception {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/util/DbImplUtil", "getConnection"));
        }
        DatabaseSystem ds = element.getDataSource().getDelegate();
        if (!(ds instanceof LocalDataSource)) {
            return null;
        }
        Connection connection = ((LocalDataSource)ds).getConnection(element.getProject());
        if (connection != null) {
            JdbcUtil.setCatalogSafe((Connection)connection, (String)DasUtil.getCatalog((DasObject)element));
        }
        return connection;
    }

    public static void setStatementParameter(@NotNull PreparedStatement statement, @NotNull ColumnDescriptor column, @Nullable Object value, @NotNull DatabaseDialect dialect, boolean needsEscaping, int idx) throws Exception {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/database/util/DbImplUtil", "setStatementParameter"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/util/DbImplUtil", "setStatementParameter"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/util/DbImplUtil", "setStatementParameter"));
        }
        int type = column.getType();
        String typeName = column.getTypeName();
        if (value == null || value == ReservedCellValue.NULL) {
            statement.setNull(idx, DbImplUtil.isPgUuidColumn(column, dialect) ? 1111 : type);
        } else if (value instanceof LobInfo.FileBlobInfo) {
            LobInfo.FileBlobInfo info = (LobInfo.FileBlobInfo)value;
            statement.setBlob(idx, (Blob)new FileBlob(info.file));
        } else if (value instanceof LobInfo.FileClobInfo) {
            LobInfo.FileClobInfo info = (LobInfo.FileClobInfo)value;
            statement.setClob(idx, (Clob)new FileClob(info.file, info.charset));
        } else if (value instanceof LobInfo.BlobInfo) {
            statement.setBytes(idx, ((LobInfo.BlobInfo)value).data);
        } else if (value instanceof LobInfo.ClobInfo) {
            statement.setString(idx, DbImplUtil.escapeSql(((LobInfo.ClobInfo)value).data, needsEscaping, dialect));
        } else if (value instanceof ObjectFormatter.ImageInfo) {
            statement.setBytes(idx, ((ObjectFormatter.ImageInfo)value).bytes);
        } else if (value instanceof ObjectFormatter.TextInfo) {
            statement.setBytes(idx, ((ObjectFormatter.TextInfo)value).bytes);
        } else if (dialect.getFamilyId().isPostgres() && type == 2003 && value instanceof Object[]) {
            RemotePreparedStatement remoteStatement = (RemotePreparedStatement)RemoteUtil.castToRemote((Object)statement, RemotePreparedStatement.class);
            ((RemotePreparedStatement)ObjectUtils.assertNotNull((Object)remoteStatement)).setArray(idx, StringUtil.replace((String)typeName, (String)"_", (String)""), (Object[])value);
        } else if (dialect.getFamilyId().isPostgres() && (Arrays.asList("bit", "varbit", "tid", "uuid", "money", "interval").contains(typeName) || type == 2003 || type == 2002 || type == 1111 || Object.class.getName().equals(column.getJavaClassName()))) {
            statement.setObject(idx, value, 1111);
        } else if (dialect.getFamilyId().isPostgres() && type == 2009) {
            statement.setObject(idx, DbImplUtil.escapeSql(value, needsEscaping, dialect), 2009);
        } else if (value instanceof Date) {
            long millis = ((Date)value).getTime();
            if (type == 93) {
                statement.setTimestamp(idx, value instanceof Timestamp ? (Timestamp)value : new Timestamp(millis));
            } else if (type == 92) {
                statement.setTime(idx, value instanceof Time ? (Time)value : new Time(millis));
            } else {
                statement.setDate(idx, value instanceof java.sql.Date ? (java.sql.Date)value : new java.sql.Date(millis));
            }
        } else if (dialect.getFamilyId().isPostgres() && DbImplUtil.isZonedColumn(column, dialect)) {
            if (DbImplUtil.isZonedTimestampColumn(column, dialect)) {
                TimeZonedValue zonedValue = (TimeZonedValue)value;
                statement.setObject(idx, (Object)DbImplUtil.escapeSql(zonedValue.getStringRepresentation(), needsEscaping, dialect), zonedValue.getType());
            } else {
                TimeZonedTime zonedTime = (TimeZonedTime)value;
                Time time = (Time)zonedTime.getValue();
                ZoneOffset offset = zonedTime.getZoneOffset() == null ? OffsetTime.now().getOffset() : zonedTime.getZoneOffset();
                statement.setTime(idx, time, Calendar.getInstance(TimeZone.getTimeZone(offset)));
            }
        } else {
            statement.setObject(idx, DbImplUtil.escapeSql(value, needsEscaping, dialect));
        }
    }

    public static boolean canInsertBlob(@NotNull DataConsumer.Column column) {
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/util/DbImplUtil", "canInsertBlob"));
        }
        int type = ExtractorsUtil.guessJdbcType(column);
        return type == -2 || type == 2004 || type == -4 || type == -3;
    }

    public static boolean canInsertClob(@NotNull DataConsumer.Column column) {
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/util/DbImplUtil", "canInsertClob"));
        }
        int type = ExtractorsUtil.guessJdbcType(column);
        return type == 2005 || type == 2011 || type == -1 || type == -16 || type == -15 || type == 1 || type == 12 || type == -9 || type == 2009;
    }

    @Nullable
    public static LobInfo.FileClobInfo clobFromFile(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/database/util/DbImplUtil", "clobFromFile"));
        }
        Charset encoding = EncodingManager.getInstance().getEncoding(virtualFile, true);
        String charset = encoding != null ? encoding.name() : null;
        File file = VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile);
        return new LobInfo.FileClobInfo(file, charset);
    }

    @NotNull
    public static LobInfo.FileBlobInfo blobFromFile(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/database/util/DbImplUtil", "blobFromFile"));
        }
        LobInfo.FileBlobInfo fileBlobInfo = new LobInfo.FileBlobInfo(VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile));
        if (fileBlobInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DbImplUtil", "blobFromFile"));
        }
        return fileBlobInfo;
    }

    public static void tryLoadFirstNRows(Connection connection, String query, StringBuilder sb, int rows) {
        try {
            DbImplUtil.tryLoadFirstNRows("", connection, query, CharOut.Util.newSink(sb), rows);
        }
        catch (Exception e) {
            DbImplUtil.exceptionToHtml(e, "Unable to load table data", sb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tryLoadFirstNRows(String title, Connection connection, String query, CharOut sb, int rows) throws Exception {
        if (connection == null) {
            return;
        }
        Statement statement = null;
        try {
            statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(query);
            ObjectFormatter converter = new ObjectFormatter(){

                @Override
                @Nullable
                public String objectToString(@Nullable Object o, DataConsumer.Column column, DatabaseDialect dialect, boolean forDisplay) {
                    Object o1 = 1.objectToObject(o, column);
                    if (o1 instanceof ObjectFormatter.ImageInfo) {
                        ObjectFormatter.ImageInfo info = (ObjectFormatter.ImageInfo)o1;
                        o1 = new ObjectFormatter.ImageInfo(info.format, info.width, info.height, info.size, null);
                    }
                    return super.objectToString(o1, column, dialect, forDisplay);
                }
            };
            HtmlValuesExtractor extractor = new HtmlValuesExtractor(converter){

                @Override
                protected String getValueAsString(@NotNull DataConsumer.Row row, @NotNull DataConsumer.Column column, @NotNull DatabaseDialect dialect, boolean forDisplay) {
                    if (row == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/util/DbImplUtil$2", "getValueAsString"));
                    }
                    if (column == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/util/DbImplUtil$2", "getValueAsString"));
                    }
                    if (dialect == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/util/DbImplUtil$2", "getValueAsString"));
                    }
                    String unescaped = super.getValueAsString(2.getOriginalRow(row, column), 2.getOriginalColumn(row, column), dialect, forDisplay, false);
                    return this.escapeChars(unescaped != null && unescaped.length() > 50 ? unescaped.substring(0, 50) + "..." : unescaped);
                }
            };
            extractor.setDisplayMode(true);
            extractor.setIncludeColumnNames(true);
            DbImplUtil.resultSetToString(title, resultSet, rows, GenericDialect.INSTANCE, extractor, sb);
        }
        finally {
            JdbcUtil.closeStatementSafe((Statement)statement);
        }
    }

    public static StringBuilder exceptionToHtml(Exception e, String str, StringBuilder sb) {
        sb.append(str).append(":<br>");
        sb.append("<code>").append(e).append("</code><br>");
        return sb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tryLoadViewDefinition(ConnectionProvider provider, @NotNull DbTable element, StringBuilder sb) throws Exception {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/util/DbImplUtil", "tryLoadViewDefinition"));
        }
        DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect((DbElement)element);
        if (!dialect.supportsViewDefinition()) {
            return;
        }
        try {
            if (!provider.acquire()) {
                return;
            }
            DatabaseFamilyId familyId = dialect.getFamilyId();
            Pair<String, ConcatenationProps> query = dialect.sqlViewDefinition((DasObject)element);
            int initialLength = sb.length();
            DbImplUtil.concatStringResults(provider.getConnection(), dialect, 0, (String)query.first, sb, (ConcatenationProps)query.second);
            if (sb.length() > initialLength) {
                if (familyId.isMysql() || familyId.isPostgres()) {
                    DdlBuilder builder = DatabaseDialogsHelper.createDdlBuilder((DbElement)element, false);
                    String fullDefinition = dialect.sqlCreateView(builder, (DasTable)element, sb.substring(initialLength), "").getStatement();
                    sb.setLength(initialLength);
                    sb.append(fullDefinition);
                } else if (familyId.isDerby()) {
                    DdlBuilder builder = DatabaseDialogsHelper.createDdlBuilder((DbElement)element, false);
                    sb.insert(initialLength, dialect.sqlDropView(builder, (DasTable)element, true).getStatement() + ";\n");
                } else if (familyId.isMicrosoft()) {
                    DbImplUtil.replaceTokenInDefinition((DbElement)element, sb, dialect, SqlCreateViewStatement.class, SqlCommonKeywords.SQL_CREATE, SqlCommonKeywords.SQL_ALTER);
                } else if (familyId.isSybase()) {
                    DdlBuilder builder = DatabaseDialogsHelper.createDdlBuilder((DbElement)element, false);
                    sb.insert(initialLength, dialect.sqlDropView(builder, (DasTable)element, true).newLine().keyword("GO").getStatement() + "\n");
                } else if (familyId.isH2()) {
                    sb.insert(initialLength + "CREATE ".length(), "OR REPLACE ");
                }
            }
        }
        finally {
            provider.release();
        }
    }

    @Nullable
    public static DasObject getSearchPathObject(@NotNull DatabaseDialectEx dialect, @Nullable DasObject dasObject) {
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/util/DbImplUtil", "getSearchPathObject"));
        }
        return (DasObject)DasUtil.dasParents((DasObject)dasObject).filter(object -> {
            if (dialect == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/util/DbImplUtil", "lambda$getSearchPathObject$3"));
            }
            return dialect.sqlSetSearchPath(SearchPath.of(ObjectPath.of(object))) != null;
        }).first();
    }

    public static DdlBuilder endStatement(@NotNull DdlBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/util/DbImplUtil", "endStatement"));
        }
        if (builder.getDialect().getFamilyId().isTransactSql()) {
            builder.newLine().keyword("go").newStatement();
        } else {
            builder.newStatement();
        }
        return builder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void tryLoadProcedureDefinition(@NotNull ConnectionProvider provider, @NotNull DbRoutine element, @NotNull StringBuilder sb) throws Exception {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/database/util/DbImplUtil", "tryLoadProcedureDefinition"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/util/DbImplUtil", "tryLoadProcedureDefinition"));
        }
        if (sb == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sb", "com/intellij/database/util/DbImplUtil", "tryLoadProcedureDefinition"));
        }
        DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect((DbElement)element);
        if (!provider.acquire()) {
            provider.release();
            return;
        }
        String fromDialect = dialect.tryToLoadProcedureDefinition((DasRoutine)element, provider.getConnection());
        if (StringUtil.isNotEmpty((String)fromDialect)) {
            sb.append(fromDialect);
            provider.release();
            return;
        }
        if (!dialect.supportsProcedureDefinition()) {
            return;
        }
        DatabaseFamilyId familyId = dialect.getFamilyId();
        Pair<String, ConcatenationProps> query = dialect.sqlProcedureDefinition((DasRoutine)element);
        StringBuilder definition = DbImplUtil.concatStringResults(provider.getConnection(), dialect, (String)query.first, 0, new StringBuilder(), (ConcatenationProps)query.second);
        if (StringUtil.isEmptyOrSpaces((String)definition.toString())) return;
        DdlBuilder builder = DatabaseDialogsHelper.createDdlBuilder((DbElement)element, false);
        if (familyId.isOracle()) {
            definition.insert(0, builder.keywords("create", "or", "replace").space().getStatement());
        } else if (familyId.isDb2()) {
            definition.insert(0, dialect.sqlDropProcedure(builder, (DasRoutine)element).getStatement() + ";\n");
        } else if (familyId.isMicrosoft()) {
            DbImplUtil.replaceTokenInDefinition((DbElement)element, definition, dialect, SqlCreateStatement.class, SqlCommonKeywords.SQL_CREATE, SqlCommonKeywords.SQL_ALTER);
        } else if (familyId.isSybase()) {
            builder.keyword("drop").space().keyword(StringUtil.startsWithIgnoreCase((String)definition.toString().trim(), (String)"create function") ? "function" : "procedure").space();
            dialect.qualifiedIdentifier(builder, element.getName(), (DasObject)element, (DasObject)element);
            builder.newLine();
            builder.keyword("go").newLine();
            definition.insert(0, builder.getStatement());
        }
        String trim = definition.toString().trim();
        sb.append(trim);
        if (familyId.isTransactSql()) {
            sb.append(DatabaseDialogsHelper.createDdlBuilder((DbElement)element, false).clear().newLine().keyword("go").getStatement());
            return;
        }
        if (trim.endsWith(";")) return;
        sb.append(";");
        return;
    }

    private static void replaceTokenInDefinition(@NotNull DbElement element, @NotNull StringBuilder sb, @NotNull DatabaseDialectEx dialect, @NotNull Class<? extends SqlDefinition> defClazz, @NotNull SqlTokenType fromToken, @NotNull SqlTokenType toToken) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/util/DbImplUtil", "replaceTokenInDefinition"));
        }
        if (sb == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sb", "com/intellij/database/util/DbImplUtil", "replaceTokenInDefinition"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/util/DbImplUtil", "replaceTokenInDefinition"));
        }
        if (defClazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defClazz", "com/intellij/database/util/DbImplUtil", "replaceTokenInDefinition"));
        }
        if (fromToken == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromToken", "com/intellij/database/util/DbImplUtil", "replaceTokenInDefinition"));
        }
        if (toToken == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toToken", "com/intellij/database/util/DbImplUtil", "replaceTokenInDefinition"));
        }
        SqlFile psi = SqlPsiFacade.getInstance((Project)element.getProject()).createSqlReader().getReadOnlyPsi(DbImplUtil.getSqlDialect(dialect), (CharSequence)sb);
        SyntaxTraverser st = SyntaxTraverser.psiTraverser((PsiElement)psi);
        PsiElement keyword = (PsiElement)st.traverse().skipWhile(Conditions.notInstanceOf(defClazz)).filter(Conditions.compose((Function)st.api.TO_TYPE, (Condition)Conditions.equalTo((Object)fromToken))).first();
        if (keyword != null) {
            TextRange r = st.api.rangeOf((Object)keyword);
            int i0 = r.getStartOffset();
            int i1 = r.getEndOffset();
            String replacement = ((Case)ObjectUtils.notNull((Object)Case.forString((String)sb.substring(i0, i1)), (Object)Case.EXACT)).apply(toToken.toString());
            sb.replace(i0, i1, replacement);
        }
    }

    public static boolean isDataTable(@Nullable DasTable info) {
        if (info == null) {
            return false;
        }
        return DbImplUtil.isDataTable(info.getKind());
    }

    public static boolean isDataTable(@Nullable ObjectKind kind) {
        return kind == ObjectKind.TABLE || kind == ObjectKind.VIEW || kind == ObjectKind.MAT_VIEW;
    }

    @NotNull
    public static DatabaseDialectEx getDatabaseDialect(@NotNull DbElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/util/DbImplUtil", "getDatabaseDialect"));
        }
        DbDataSource dataSource = element.getDataSource();
        DatabaseDialectEx databaseDialectEx = dataSource instanceof DbDataSourceImpl ? ((DbDataSourceImpl)dataSource).getDatabaseDialect() : GenericDialect.INSTANCE;
        if (databaseDialectEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DbImplUtil", "getDatabaseDialect"));
        }
        return databaseDialectEx;
    }

    @NotNull
    public static DatabaseDialectEx getDatabaseDialect(@NotNull JdbcConsole console) {
        if (console == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "com/intellij/database/util/DbImplUtil", "getDatabaseDialect"));
        }
        DatabaseDialectEx databaseDialectEx = DbImplUtil.getDatabaseDialect(console.getDataSource());
        if (databaseDialectEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DbImplUtil", "getDatabaseDialect"));
        }
        return databaseDialectEx;
    }

    @NotNull
    public static DatabaseDialectEx getDatabaseDialect(@NotNull RawConnectionConfig connectionInfo) {
        if (connectionInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connectionInfo", "com/intellij/database/util/DbImplUtil", "getDatabaseDialect"));
        }
        DatabaseDialectEx databaseDialectEx = (DatabaseDialectEx)ObjectUtils.notNull((Object)DbImplUtil.guessDatabaseDialect(connectionInfo), (Object)GenericDialect.INSTANCE);
        if (databaseDialectEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DbImplUtil", "getDatabaseDialect"));
        }
        return databaseDialectEx;
    }

    @Nullable
    public static DatabaseDialectEx guessDatabaseDialect(@Nullable RawConnectionConfig connectionInfo) {
        DatabaseFamilyId familyId;
        DatabaseFamilyId databaseFamilyId = familyId = connectionInfo instanceof DatabaseSystem ? DatabaseFamilyId.forDataSource((DatabaseSystem)((DatabaseSystem)connectionInfo)) : DatabaseFamilyId.forConnection((RawConnectionConfig)connectionInfo);
        if (familyId == DatabaseFamilyId.UNKNOWN) {
            return null;
        }
        for (DatabaseDialectEx dialect : DatabaseDialects.getSupportedDialects()) {
            if (dialect.getFamilyId() != familyId) continue;
            return dialect;
        }
        return null;
    }

    public static boolean supportsDynamicSchemaSwitching(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/util/DbImplUtil", "supportsDynamicSchemaSwitching"));
        }
        DatabaseDialectEx dialect = DbImplUtil.guessDatabaseDialect(dataSource);
        return dialect == null || !dialect.getFamilyId().isMysql() || !dataSource.isReadOnly();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tryLoadPackageDefinition(ConnectionProvider provider, @NotNull DbPackage element, boolean spec, StringBuilder sb) throws Exception {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/util/DbImplUtil", "tryLoadPackageDefinition"));
        }
        DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect((DbElement)element);
        if (!dialect.supportsPackageDefinition()) {
            return;
        }
        try {
            if (!provider.acquire()) {
                return;
            }
            Pair<String, ConcatenationProps> query = spec ? dialect.sqlPackageDefinition((DasObject)element) : dialect.sqlPackageBodyDefinition((DasObject)element);
            StringBuilder def = DbImplUtil.concatStringResults(provider.getConnection(), dialect, (String)query.first, 0, new StringBuilder(), (ConcatenationProps)query.second);
            Case caseMode = (Case)ObjectUtils.notNull((Object)Case.forString((String)def.substring(0, Math.min(sb.length(), 7))), (Object)Case.EXACT);
            if (StringUtil.startsWith((CharSequence)def, (CharSequence)"package") || StringUtil.startsWith((CharSequence)def, (CharSequence)"PACKAGE")) {
                def.insert(0, caseMode.apply("CREATE OR REPLACE "));
            }
            sb.append((CharSequence)def);
        }
        finally {
            provider.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tryLoadSequenceDefinition(ConnectionProvider provider, DbTable element, StringBuilder sb) throws Exception {
        DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect((DbElement)element);
        if (!dialect.supportsSequenceDefinition()) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        String drop = dialect.sqlDropSequence(DatabaseDialogsHelper.createDdlBuilder((DbElement)element, false), (DasObject)element, false).getStatement() + ";\n";
        builder.append(drop);
        try {
            if (!provider.acquire()) {
                return;
            }
            Pair<String, ConcatenationProps> query = dialect.sqlSequenceDefinition((DasObject)element);
            DbImplUtil.concatStringResults(provider.getConnection(), dialect, (String)query.first, 0, builder, (ConcatenationProps)query.second);
            sb.append((CharSequence)builder);
        }
        finally {
            provider.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tryLoadTableDefinition(ConnectionProvider provider, DbTable element, StringBuilder sb) throws Exception {
        DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect((DbElement)element);
        if (!dialect.supportsTableDefinition()) {
            return;
        }
        try {
            if (!provider.acquire()) {
                return;
            }
            String sql = dialect.tryToLoadTableDefinition((DasTable)element, provider.getConnection());
            if (!StringUtil.isEmptyOrSpaces((String)sql)) {
                sb.append(sql);
            }
        }
        finally {
            provider.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> tryLoadTableInfo(ConnectionProvider provider, DbTable element) throws Exception {
        DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect((DbElement)element);
        if (!dialect.supportsTableInfo()) {
            return Collections.emptyMap();
        }
        try {
            if (!provider.acquire()) {
                Map<String, Object> map = Collections.emptyMap();
                return map;
            }
            Map<String, Object> map = dialect.tryToLoadTableInfo(element, provider.getConnection());
            return map;
        }
        finally {
            provider.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tryLoadSynonymDefinition(ConnectionProvider provider, DbTable element, StringBuilder sb) throws Exception {
        DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect((DbElement)element);
        if (!dialect.supportsTableDefinition()) {
            return;
        }
        try {
            if (!provider.acquire()) {
                return;
            }
            String sql = dialect.tryToLoadSynonymDefinition((DasTable)element, provider.getConnection());
            if (!StringUtil.isEmpty((String)sql)) {
                sb.append(sql);
            }
        }
        finally {
            provider.release();
        }
    }

    @Nullable
    public static String getCustomTypeShortDescription(@Nullable Object delegate) {
        JBIterable names;
        if (delegate instanceof DasTypedObject) {
            DataType type = ((DasTypedObject)delegate).getDataType();
            if (type != DataType.UNKNOWN) {
                return DbNodeDescriptor.arrow() + " " + type.toString();
            }
        } else if (delegate instanceof DasTable && !(names = DasUtil.getColumns((DasObject)((DasTable)delegate)).transform(DasUtil.TO_NAME)).isEmpty()) {
            return "(" + StringUtil.join((Iterable)names, (String)", ") + ')';
        }
        return null;
    }

    public static boolean isDatabaseVirtualFile(@Nullable VirtualFile file) {
        if (file == null) {
            return false;
        }
        return file.getFileSystem() instanceof DbSrcFileSystem || file instanceof DatabaseElementVirtualFileImpl;
    }

    @Nullable
    public static DbDataSource findDataSource(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/util/DbImplUtil", "findDataSource"));
        }
        if (file != null && file.getFileSystem() instanceof DbSrcFileSystem) {
            return DbPsiFacade.getInstance((Project)project).findDataSource(DbSrcUtils.getDataSource(file));
        }
        if (file instanceof DatabaseElementVirtualFileImpl) {
            DatabaseElementVirtualFileImpl dbFile = (DatabaseElementVirtualFileImpl)file;
            return dbFile.findDataSource();
        }
        return null;
    }

    @Nullable
    public static DbElement findElement(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/util/DbImplUtil", "findElement"));
        }
        if (file != null && file.getFileSystem() instanceof DbSrcFileSystem) {
            return DbSrcUtils.findDbElement(project, file, DbElement.class, true);
        }
        if (file instanceof DatabaseElementVirtualFileImpl) {
            return ((DatabaseElementVirtualFileImpl)file).findElement();
        }
        return null;
    }

    @Nullable
    public static ObjectKind getKind(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/util/DbImplUtil", "getKind"));
        }
        if (file.getFileSystem() instanceof DbSrcFileSystem) {
            DbSrcPath path = DbSrcUtils.getFullPath(file.getPath());
            String code = path == null ? null : path.getKind();
            return (ObjectKind)ObjectKind.ourKinds.get(code);
        }
        if (file instanceof DatabaseElementVirtualFileImpl) {
            return ((DatabaseElementVirtualFileImpl)file).getObjectKind();
        }
        return null;
    }

    @Nullable
    public static VirtualFile findVirtualFile(@NotNull DbElement o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/database/util/DbImplUtil", "findVirtualFile"));
        }
        VirtualFile vf = DbImplUtil.findVirtualFileInSourceStorage(o, false);
        return vf != null ? vf : DatabaseElementVirtualFileImpl.findFile(o);
    }

    @Nullable
    public static VirtualFile findVirtualFileInSourceStorage(@Nullable DbElement o, boolean original) {
        Object delegate;
        Object object = delegate = o != null ? o.getDelegate() : null;
        if (delegate instanceof BasicSourceAware) {
            DbSrcPath srcPath = DbSrcPath.of((DasObject)o);
            VirtualFile vf = DbSrcUtils.findDbSrcFile(o.getDataSource(), srcPath, false);
            if (vf != null) {
                return original ? DbSrcFileSystem.getInstance().getBaseFile(vf, false) : vf;
            }
        }
        return null;
    }

    @Nullable
    public static String loadDefinitionFromStorage(@Nullable DbElement o) {
        VirtualFile file = DbImplUtil.findVirtualFileInSourceStorage(o, true);
        if (file == null) {
            return null;
        }
        try {
            return VfsUtilCore.loadText((VirtualFile)file);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static String concatStringResults(Connection connection, DatabaseDialectEx dialect, String query, int forcedColumn, ConcatenationProps props) throws SQLException {
        return DbImplUtil.concatStringResults(connection, dialect, query, forcedColumn, new StringBuilder(), props).toString().trim();
    }

    public static StringBuilder concatStringResults(Connection connection, DatabaseDialectEx dialect, int forcedColumn, String query, StringBuilder sb, ConcatenationProps props) throws SQLException {
        return DbImplUtil.concatStringResults(connection, dialect, query, forcedColumn, sb, props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StringBuilder concatStringResults(Connection connection, DatabaseDialectEx dialect, String query, int forcedColumn, StringBuilder sb, ConcatenationProps props) throws SQLException {
        Statement statement = connection.createStatement();
        try {
            int updateCount;
            ResultSet rs = statement.executeQuery(query);
            boolean resultSetHere = rs != null;
            int n = updateCount = resultSetHere ? -1 : JdbcEngine.getUpdateCountSafe(statement);
            while (resultSetHere || updateCount != -1) {
                if (resultSetHere && rs == null) {
                    rs = statement.getResultSet();
                }
                if (rs != null) {
                    try {
                        DbImplUtil.concatStringResults(rs, (DatabaseDialect)dialect, forcedColumn, sb, props);
                    }
                    finally {
                        JdbcUtil.closeResultSetSafe((ResultSet)rs);
                    }
                }
                rs = null;
                resultSetHere = statement.getMoreResults();
                updateCount = JdbcEngine.getUpdateCountSafe(statement);
            }
        }
        finally {
            JdbcUtil.closeStatementSafe((Statement)statement);
        }
        return sb;
    }

    protected static void concatStringResults(ResultSet rs, DatabaseDialect dialect, int forcedColumn, StringBuilder sb, ConcatenationProps props) throws SQLException {
        int trimmedLen;
        DataConsumer.Column[] columns = JdbcEngine.getColumnDescriptors(rs, dialect);
        int columnCount = columns.length;
        int start = sb.length();
        while (rs.next()) {
            if (start != sb.length()) {
                sb.append(props.rowSep);
            }
            int rowStart = sb.length();
            for (int i2 = forcedColumn > 0 ? forcedColumn : 1; i2 <= (forcedColumn > 0 ? forcedColumn : columnCount); ++i2) {
                CharSequence s = DbImplUtil.extractString(rs.getObject(i2));
                if (s == null) continue;
                if (props.lTrim) {
                    s = StringUtil.trimLeading((CharSequence)s);
                }
                if (props.rTrim) {
                    s = StringUtil.trimTrailing((CharSequence)s);
                }
                if (rowStart != sb.length()) {
                    sb.append(props.colSep);
                }
                sb.append(s);
            }
        }
        for (trimmedLen = sb.length(); trimmedLen != 0 && sb.charAt(trimmedLen - 1) == ' '; --trimmedLen) {
        }
        sb.setLength(trimmedLen);
    }

    @Nullable
    private static CharSequence extractString(@Nullable Object object) throws SQLException {
        if (object instanceof CharSequence) {
            return (CharSequence)object;
        }
        if (object instanceof Clob) {
            Clob clob = (Clob)object;
            return clob.getSubString(1L, (int)clob.length());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T executeAndGetResult(Connection connection, String query, ThrowableConvertor<ResultSet, T, SQLException> result) throws SQLException {
        Object object;
        Statement statement = null;
        ResultSet rs = null;
        try {
            statement = connection.createStatement();
            rs = statement.executeQuery(query);
            object = result.convert((Object)rs);
        }
        catch (Throwable throwable) {
            JdbcUtil.closeResultSetSafe(rs);
            JdbcUtil.closeStatementSafe((Statement)statement);
            throw throwable;
        }
        JdbcUtil.closeResultSetSafe((ResultSet)rs);
        JdbcUtil.closeStatementSafe((Statement)statement);
        return (T)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int executeUpdate(@NotNull Connection connection, @NotNull String sql) throws SQLException {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/util/DbImplUtil", "executeUpdate"));
        }
        if (sql == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sql", "com/intellij/database/util/DbImplUtil", "executeUpdate"));
        }
        Statement statement = connection.createStatement();
        try {
            int n = statement.executeUpdate(sql);
            return n;
        }
        finally {
            JdbcUtil.closeStatementSafe((Statement)statement);
        }
    }

    public static Map<String, Object> resultRowAsMap(Connection connection, String query, String ... columnSelection) throws SQLException {
        Map result = Collections.emptyMap();
        Statement statement = connection.createStatement();
        ResultSet rs = statement.executeQuery(query);
        if (rs.next()) {
            result = JdbcUtil.resultSetRowToMapSafe((ResultSet)rs);
            if (columnSelection.length > 0 && !result.isEmpty()) {
                assert (columnSelection.length % 2 == 0);
                LinkedHashMap map = ContainerUtil.newLinkedHashMap();
                for (int i2 = 0; i2 < columnSelection.length; i2 += 2) {
                    Object o = result.get(columnSelection[i2]);
                    if (o == null) continue;
                    map.put(columnSelection[i2 + 1], o);
                }
                result = map;
            }
        }
        JdbcUtil.closeResultSetSafe((ResultSet)rs);
        JdbcUtil.closeStatementSafe((Statement)statement);
        return result;
    }

    @Nullable
    public static DbDataSource getForcedDataSource(@Nullable PsiFile psiFile) {
        DbDataSource element;
        VirtualFileSystem fileSystem;
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)psiFile);
        if (virtualFile instanceof VirtualFileWindow) {
            virtualFile = PsiUtilCore.getVirtualFile((PsiElement)InjectedLanguageUtil.getTopLevelFile((PsiElement)psiFile));
        }
        VirtualFileSystem virtualFileSystem = fileSystem = virtualFile == null ? null : virtualFile.getFileSystem();
        if (virtualFile instanceof DatabaseElementVirtualFileImpl) {
            element = ((DatabaseElementVirtualFileImpl)virtualFile).findDataSource();
        } else if (DbConsoleRootType.isConsoleFile(virtualFile)) {
            element = DbConsoleRootType.getDataSource(psiFile.getProject(), virtualFile);
        } else if (fileSystem instanceof DbSrcFileSystem) {
            String dataSourceId = DbSrcUtils.getDataSource(virtualFile);
            element = dataSourceId == null ? null : DbPsiFacade.getInstance((Project)psiFile.getProject()).findDataSource(dataSourceId);
        } else {
            JdbcConsole console = JdbcConsoleProvider.getAttachedConsole(psiFile);
            DbDataSource dbDataSource = element = console == null ? (DbDataSource)DatabaseDataKeys.DATA_SOURCE_KEY.get((UserDataHolder)psiFile) : DbImplUtil.getDbDataSource(console.getProject(), console.getDataSource());
            if (element == null && ApplicationManager.getApplication().isUnitTestMode()) {
                return (DbDataSource)DatabaseDataKeys.DATA_SOURCE_KEY.get((UserDataHolder)virtualFile);
            }
        }
        return element != null && element.isValid() ? element : null;
    }

    @NotNull
    public static JBIterable<DbDataSource> getDataSourcesForExec(@NotNull PsiFile file, boolean ignoreForced, boolean matchingOnly) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/util/DbImplUtil", "getDataSourcesForExec"));
        }
        DbDataSource forced = ignoreForced ? null : DbImplUtil.getForcedDataSource(file);
        JBIterable<DbDataSource> result = forced != null ? JBIterable.of((Object)forced) : DbSqlUtil.getAppropriateDataSources(file, false, matchingOnly);
        JBIterable jBIterable = result.filter(CAN_CONNECT_TO);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DbImplUtil", "getDataSourcesForExec"));
        }
        return jBIterable;
    }

    public static DdlBuilder composeWhereCondition(@NotNull DdlBuilder builder, @NotNull List<DataConsumer.Column> columns, @NotNull List<Object> values, @NotNull DatabaseDialect dialect, @Nullable String tableAlias) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/util/DbImplUtil", "composeWhereCondition"));
        }
        if (columns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/util/DbImplUtil", "composeWhereCondition"));
        }
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/database/util/DbImplUtil", "composeWhereCondition"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/util/DbImplUtil", "composeWhereCondition"));
        }
        for (int i2 = 0; i2 < columns.size(); ++i2) {
            if (i2 > 0) {
                builder.space().keyword("AND").space();
            }
            DataConsumer.Column column = columns.get(i2);
            boolean useLike = "java.lang.String".equals(column.clazz);
            DbImplUtil.composeWhereItem(builder, column.name, values.get(i2), useLike, tableAlias, dialect);
        }
        return builder;
    }

    public static DdlBuilder composeWhereCondition(DdlBuilder builder, Iterable<String> names, Iterable<?> values, String alias, DatabaseDialect dialect) {
        boolean first = true;
        Iterator<String> it1 = names.iterator();
        Iterator<?> it2 = values.iterator();
        while (it1.hasNext() && it2.hasNext()) {
            if (first) {
                first = false;
            } else {
                builder.space().keyword("AND").space();
            }
            DbImplUtil.composeWhereItem(builder, it1.next(), it2.next(), true, alias, dialect);
        }
        return builder;
    }

    public static DdlBuilder composeWhereItem(@NotNull DdlBuilder builder, String columnName, Object value, boolean useLike, String alias, @NotNull DatabaseDialect dialect) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/util/DbImplUtil", "composeWhereItem"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/util/DbImplUtil", "composeWhereItem"));
        }
        if (alias != null) {
            builder.alias(alias).symbol(".");
        }
        builder.identifier(columnName).space();
        if (value == null) {
            builder.keywords("IS", "NULL");
        } else {
            boolean isString = value instanceof String;
            boolean bl = useLike = useLike && isString && !dialect.getFamilyId().isSqlite();
            if (useLike) {
                builder.keyword("LIKE");
            } else {
                builder.symbol("=");
            }
            String literal = isString ? DbImplUtil.escapeSql((String)value, useLike, dialect) : value.toString();
            builder.space().literal(isString ? "'" + literal.replace("'", "''") + "'" : literal);
            if (useLike && literal.indexOf(35) > -1) {
                builder.space().keyword("ESCAPE").space().plain("'#'");
            }
        }
        return builder;
    }

    @NotNull
    public static List<ColumnUpdateData> composeWhereConditionWithParameters(@NotNull DdlBuilder builder, @NotNull List<ColumnUpdateData> datas, @Nullable String alias, @NotNull DatabaseDialect dialect) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/util/DbImplUtil", "composeWhereConditionWithParameters"));
        }
        if (datas == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "datas", "com/intellij/database/util/DbImplUtil", "composeWhereConditionWithParameters"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/util/DbImplUtil", "composeWhereConditionWithParameters"));
        }
        ArrayList parameters = ContainerUtil.newArrayList();
        boolean first = true;
        for (ColumnUpdateData data : datas) {
            if (first) {
                first = false;
            } else {
                builder.space().keyword("AND").space();
            }
            ThreeState nullability = data.getObject() == null ? ThreeState.YES : ThreeState.NO;
            int placeholdersAdded = DbImplUtil.composeWhereItemWithParameters(builder, data.getColumn(), nullability, alias, dialect);
            parameters.addAll(Collections.nCopies(placeholdersAdded, data));
        }
        ArrayList arrayList = parameters;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DbImplUtil", "composeWhereConditionWithParameters"));
        }
        return arrayList;
    }

    public static int composeWhereItemWithParameters(@NotNull DdlBuilder builder, @NotNull DataConsumer.Column column, @NotNull ThreeState nullability, @Nullable String alias, @NotNull DatabaseDialect dialect) {
        boolean useLike;
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/util/DbImplUtil", "composeWhereItemWithParameters"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/util/DbImplUtil", "composeWhereItemWithParameters"));
        }
        if (nullability == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nullability", "com/intellij/database/util/DbImplUtil", "composeWhereItemWithParameters"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/util/DbImplUtil", "composeWhereItemWithParameters"));
        }
        if (nullability == ThreeState.UNSURE) {
            builder.symbol("(");
        }
        if (DbImplUtil.isComputedColumn(column)) {
            builder.plain(column.name);
        } else {
            if (alias != null) {
                builder.alias(alias).symbol(".");
            }
            builder.identifier(column.name);
        }
        builder.space();
        if (nullability == ThreeState.YES) {
            builder.keywords("IS", "NULL");
            return 0;
        }
        boolean bl = useLike = !dialect.getFamilyId().isSqlite() && "java.lang.String".equals(column.clazz);
        if (useLike) {
            builder.keyword("LIKE");
        } else {
            builder.symbol("=");
        }
        builder.space().symbol("?");
        if (useLike) {
            builder.space().keyword("ESCAPE").space().plain("'#'");
        }
        if (nullability == ThreeState.UNSURE) {
            builder.space().keyword("OR").space().symbol("(");
            if (alias != null) {
                builder.alias(alias).symbol(".");
            }
            builder.identifier(column.name).space().keywords("IS", "NULL", "AND").space().symbol("?").space().keywords("IS", "NULL");
            builder.symbol(")");
            builder.symbol(")");
            return 2;
        }
        return 1;
    }

    public static String escapeStr(String value) {
        return StringUtil.notNullize((String)value).replace("'", "''");
    }

    public static <T> T escapeSql(T value, boolean needsEscaping, @NotNull DatabaseDialect dialect) {
        Object[] objectArray;
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/util/DbImplUtil", "escapeSql"));
        }
        if (!needsEscaping) {
            return value;
        }
        DatabaseFamilyId familyId = dialect.getFamilyId();
        if (familyId.isSqlite()) {
            return value;
        }
        if (!(value instanceof String)) {
            return value;
        }
        String s = (String)value;
        if (familyId.isMysql()) {
            String[] stringArray = new String[4];
            stringArray[0] = "%";
            stringArray[1] = "_";
            stringArray[2] = "\\";
            objectArray = stringArray;
            stringArray[3] = String.valueOf('#');
        } else {
            Object[] objectArray2 = new String[3];
            objectArray2[0] = "%";
            objectArray2[1] = "_";
            objectArray = objectArray2;
            objectArray2[2] = String.valueOf('#');
        }
        Object[] unescapedChars = objectArray;
        String[] escapedChars = (String[])ContainerUtil.map2Array((Object[])unescapedChars, String.class, s1 -> '#' + s1);
        return (T)StringUtil.replace((String)s, (String[])unescapedChars, (String[])escapedChars);
    }

    public static boolean isComputedColumn(DataConsumer.Column column) {
        return COMPUTED_COLUMN == column.table;
    }

    public static DataConsumer.Column makeComputedColumn(DataConsumer.Column column) {
        return new DataConsumer.Column(column.columnNum, column.name, column.type, column.typeName, column.clazz, -1, -1, COMPUTED_COLUMN, COMPUTED_COLUMN, COMPUTED_COLUMN);
    }

    public static boolean isSqlFileType(FileType fileType) {
        return fileType instanceof LanguageFileType && "sql".equals(fileType.getDefaultExtension());
    }

    @NotNull
    public static SqlLanguageDialect getSqlDialect(@NotNull DatabaseDialect dialect) {
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/util/DbImplUtil", "getSqlDialect"));
        }
        for (SqlLanguageDialect language : DbSqlUtil.getSqlDialects()) {
            if (language.getDatabaseDialect() != dialect) continue;
            SqlLanguageDialect sqlLanguageDialect = language;
            if (sqlLanguageDialect == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DbImplUtil", "getSqlDialect"));
            }
            return sqlLanguageDialect;
        }
        throw new AssertionError((Object)("SQL dialect not found for: " + dialect.getDisplayName()));
    }

    public static boolean isPageSizeUnlimited(int pageSize) {
        return pageSize < 1;
    }

    @NotNull
    public static SqlLanguageDialect getSqlDialect(@NotNull Project project, @Nullable DatabaseSystem dataSource) {
        DatabaseSystem delegateInfo;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/util/DbImplUtil", "getSqlDialect"));
        }
        DatabaseSystem databaseSystem = delegateInfo = dataSource instanceof DbElement ? (DatabaseSystem)((DbElement)dataSource).getDelegate() : dataSource;
        if (delegateInfo instanceof LocalDataSource) {
            Language result;
            String defaultDialect = ((LocalDataSource)delegateInfo).getDefaultDialect();
            Language language = result = StringUtil.isEmpty((String)defaultDialect) ? null : Language.findLanguageByID((String)defaultDialect);
            if (result instanceof SqlLanguageDialect) {
                SqlLanguageDialect sqlLanguageDialect = (SqlLanguageDialect)result;
                if (sqlLanguageDialect == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DbImplUtil", "getSqlDialect"));
                }
                return sqlLanguageDialect;
            }
        }
        if (delegateInfo instanceof RawConnectionConfig) {
            SqlLanguageDialect sqlLanguageDialect = DbSqlUtil.getSqlDialect(project, (RawConnectionConfig)delegateInfo);
            if (sqlLanguageDialect == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DbImplUtil", "getSqlDialect"));
            }
            return sqlLanguageDialect;
        }
        SqlLanguageDialect sqlLanguageDialect = SqlPsiFacade.getInstance((Project)project).getDefaultDialect();
        if (sqlLanguageDialect == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DbImplUtil", "getSqlDialect"));
        }
        return sqlLanguageDialect;
    }

    public static boolean writeVFSAttributeSafe(@NotNull VirtualFile file, @NotNull FileAttribute attribute, @Nullable String value) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/util/DbImplUtil", "writeVFSAttributeSafe"));
        }
        if (attribute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "com/intellij/database/util/DbImplUtil", "writeVFSAttributeSafe"));
        }
        if (!(file instanceof VirtualFileWithId)) {
            return false;
        }
        try {
            return DbImplUtil.writeVFSAttribute(file, attribute, value);
        }
        catch (IOException ex) {
            DataSourceUiUtil.LOG.warn((Throwable)ex);
            return false;
        }
    }

    @Nullable
    public static String readVFSAttributeSafe(@NotNull VirtualFile file, @NotNull FileAttribute attribute) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/util/DbImplUtil", "readVFSAttributeSafe"));
        }
        if (attribute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "com/intellij/database/util/DbImplUtil", "readVFSAttributeSafe"));
        }
        if (!(file instanceof VirtualFileWithId)) {
            return null;
        }
        try {
            return DbImplUtil.readVFSAttribute(file, attribute);
        }
        catch (IOException ex) {
            return null;
        }
    }

    public static boolean writeVFSAttribute(@NotNull VirtualFile fileOrDir, @NotNull FileAttribute attribute, @Nullable String value) throws IOException {
        if (fileOrDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileOrDir", "com/intellij/database/util/DbImplUtil", "writeVFSAttribute"));
        }
        if (attribute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "com/intellij/database/util/DbImplUtil", "writeVFSAttribute"));
        }
        String oldValue = DbImplUtil.readVFSAttribute(fileOrDir, attribute);
        if (Comparing.equal((String)oldValue, (String)value)) {
            return false;
        }
        DataOutputStream oStream = attribute.writeAttribute(fileOrDir);
        DataInputOutputUtil.writeINT((DataOutput)oStream, (int)myDialectAndDataSourcesEnumerator.getId((Object)StringUtil.notNullize((String)value)));
        oStream.close();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static String readVFSAttribute(VirtualFile fileOrDir, FileAttribute attribute) throws IOException {
        DataInputStream iStream = attribute.readAttribute(fileOrDir);
        if (iStream != null) {
            try {
                String string = StringUtil.nullize((String)((String)myDialectAndDataSourcesEnumerator.getById(DataInputOutputUtil.readINT((DataInput)iStream))));
                return string;
            }
            finally {
                iStream.close();
            }
        }
        return null;
    }

    public static boolean isAuthRequired(@NotNull LocalDataSource info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/util/DbImplUtil", "isAuthRequired"));
        }
        return info.isAuthRequired();
    }

    public static void initLanguageComboBox(JComboBox comboBox, boolean allowNull) {
        ArrayList<SqlLanguageDialect> langs = new ArrayList<SqlLanguageDialect>();
        if (allowNull) {
            langs.add(null);
        }
        langs.addAll(DbSqlUtil.getTopLevelSqlDialects());
        comboBox.setModel(new CollectionComboBoxModel(langs));
        comboBox.setEditable(false);
        comboBox.setRenderer(new ListCellRendererWrapper<Language>(){

            public void customize(JList list, Language language, int index, boolean selected, boolean hasFocus) {
                if (language == null) {
                    this.setText("<default>");
                    this.setIcon(null);
                } else {
                    if (language instanceof SqlLanguageDialect) {
                        this.setIcon(((SqlLanguageDialect)language).getDatabaseDialect().getIcon());
                    } else {
                        LanguageFileType fileType = language.getAssociatedFileType();
                        this.setIcon(fileType == null ? null : fileType.getIcon());
                    }
                    this.setText(language.getDisplayName());
                }
            }
        });
    }

    @Nullable
    public static DatabaseDriver guessDatabaseDriver(@NotNull RawConnectionConfig info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/util/DbImplUtil", "guessDatabaseDriver"));
        }
        Collection<? extends DatabaseDriver> allDrivers = DatabaseDriverManager.getInstance().getDrivers();
        List matchedDrivers = ContainerUtil.newSmartList();
        for (DatabaseDriver databaseDriver : allDrivers) {
            if (!Comparing.equal((String)info.getDriverClass(), (String)databaseDriver.getDriverClass())) continue;
            matchedDrivers.add(databaseDriver);
        }
        if (matchedDrivers.isEmpty()) {
            return null;
        }
        if (matchedDrivers.size() == 1) {
            return (DatabaseDriver)matchedDrivers.get(0);
        }
        for (DatabaseDriver databaseDriver : matchedDrivers) {
            if (!databaseDriver.matchesUrl(StringUtil.notNullize((String)info.getUrl()))) continue;
            return databaseDriver;
        }
        return (DatabaseDriver)matchedDrivers.get(0);
    }

    @NotNull
    public static DatabaseSystem getBaseDataSource(@Nullable DatabaseSystem info) {
        if (info instanceof LocalDataSource || info instanceof SqlDataSource) {
            DatabaseSystem databaseSystem = info;
            if (databaseSystem == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DbImplUtil", "getBaseDataSource"));
            }
            return databaseSystem;
        }
        if (info instanceof DbElement) {
            DatabaseSystem databaseSystem = DbImplUtil.getBaseDataSource((DatabaseSystem)((DbElement)info).getDelegate());
            if (databaseSystem == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DbImplUtil", "getBaseDataSource"));
            }
            return databaseSystem;
        }
        throw new AssertionError(info);
    }

    @NotNull
    public static LocalDataSource getLocalDataSource(@Nullable DatabaseSystem info) {
        DatabaseSystem dataSource = DbImplUtil.getBaseDataSource(info);
        if (dataSource instanceof LocalDataSource) {
            LocalDataSource localDataSource = (LocalDataSource)dataSource;
            if (localDataSource == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DbImplUtil", "getLocalDataSource"));
            }
            return localDataSource;
        }
        throw new AssertionError(info);
    }

    public static void setActionCallbackDone(@Nullable AsyncPromise<Void> callback, boolean done, @Nullable String reason) {
        if (callback == null) {
            return;
        }
        GuiUtils.invokeLaterIfNeeded(() -> {
            if (done) {
                callback.setResult(null);
            } else {
                callback.setError(StringUtil.isEmptyOrSpaces((String)reason) ? "not done" : reason);
            }
        }, (ModalityState)ModalityState.defaultModalityState());
    }

    public static void setActionCallbackDone(@Nullable AsyncPromise<Void> callback, boolean done) {
        DbImplUtil.setActionCallbackDone(callback, done, null);
    }

    @NotNull
    public static EnumSet<ReservedCellValue> getSpecialValues(@Nullable DasColumn databaseColumn) {
        if (databaseColumn == null) {
            EnumSet<ReservedCellValue> enumSet = EnumSet.of(ReservedCellValue.NULL);
            if (enumSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DbImplUtil", "getSpecialValues"));
            }
            return enumSet;
        }
        EnumSet<ReservedCellValue> result = EnumSet.noneOf(ReservedCellValue.class);
        if (DasUtil.isAutoVal((DasColumn)databaseColumn)) {
            result.add(ReservedCellValue.GENERATED);
        }
        if (!databaseColumn.isNotNull()) {
            result.add(ReservedCellValue.NULL);
        }
        if (databaseColumn.getDefault() != null) {
            result.add(ReservedCellValue.DEFAULT);
        }
        EnumSet<ReservedCellValue> enumSet = result;
        if (enumSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DbImplUtil", "getSpecialValues"));
        }
        return enumSet;
    }

    @NotNull
    public static DasModel getModelNoCancel(@NotNull DbDataSource source) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/util/DbImplUtil", "getModelNoCancel"));
        }
        for (int i2 = 0; i2 < 3; ++i2) {
            DasModel dasModel;
            try {
                dasModel = source.getModel();
            }
            catch (ProcessCanceledException processCanceledException) {
                continue;
            }
            if (dasModel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DbImplUtil", "getModelNoCancel"));
            }
            return dasModel;
        }
        DasModel dasModel = DasUtil.loadingModel();
        if (dasModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DbImplUtil", "getModelNoCancel"));
        }
        return dasModel;
    }

    public static boolean isZonedColumn(@NotNull ColumnDescriptor column, @NotNull DatabaseDialect dialect) {
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/util/DbImplUtil", "isZonedColumn"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/util/DbImplUtil", "isZonedColumn"));
        }
        return DbImplUtil.isZonedTimeColumn(column, dialect) || DbImplUtil.isZonedTimestampColumn(column, dialect);
    }

    public static boolean isZonedTimestampColumn(@NotNull ColumnDescriptor column, @NotNull DatabaseDialect dialect) {
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/util/DbImplUtil", "isZonedTimestampColumn"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/util/DbImplUtil", "isZonedTimestampColumn"));
        }
        return dialect.getFamilyId().isPostgres() && PG_TIMESTAMP_TZ_NAME.equals(column.getTypeName());
    }

    public static boolean isZonedTimeColumn(@NotNull ColumnDescriptor column, @NotNull DatabaseDialect dialect) {
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/util/DbImplUtil", "isZonedTimeColumn"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/util/DbImplUtil", "isZonedTimeColumn"));
        }
        return dialect.getFamilyId().isPostgres() && PG_TIME_TZ_NAME.equals(column.getTypeName());
    }

    private static boolean isPgUuidColumn(@NotNull ColumnDescriptor column, @NotNull DatabaseDialect dialect) {
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/util/DbImplUtil", "isPgUuidColumn"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/util/DbImplUtil", "isPgUuidColumn"));
        }
        return dialect.getFamilyId().isPostgres() && StringUtil.equalsIgnoreCase((CharSequence)column.getTypeName(), (CharSequence)"uuid");
    }

    @NotNull
    public static Object unwrap(@NotNull DasObject object) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/util/DbImplUtil", "unwrap"));
        }
        Object tmp = object;
        while (tmp != null) {
            if (!(tmp instanceof DbElement)) {
                DasObject dasObject = tmp;
                if (dasObject == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DbImplUtil", "unwrap"));
                }
                return dasObject;
            }
            tmp = ((DbElement)tmp).getDelegate();
        }
        DasObject dasObject = object;
        if (dasObject == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DbImplUtil", "unwrap"));
        }
        return dasObject;
    }

    public static class ConcatenationProps {
        public String rowSep;
        public String colSep;
        public boolean lTrim;
        public boolean rTrim;
        public static final ConcatenationProps LINES = new ConcatenationProps("\n", " ", false, false);
        public static final ConcatenationProps TIGHT = new ConcatenationProps("", "", false, false);
        public static final ConcatenationProps NO_CONCAT = LINES;

        public ConcatenationProps(String rowSep, String colSep, boolean lTrim, boolean rTrim) {
            this.rowSep = rowSep;
            this.colSep = colSep;
            this.lTrim = lTrim;
            this.rTrim = rTrim;
        }

        public String toString() {
            return "ConcatenationProps{rowSep='" + this.rowSep + '\'' + ", colSep='" + this.colSep + '\'' + ", lTrim=" + this.lTrim + ", rTrim=" + this.rTrim + '}';
        }
    }
}

