/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.vfs;

import com.intellij.openapi.fileTypes.UserBinaryFileType;
import icons.DatabaseIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public abstract class DbStorageFileType
extends UserBinaryFileType {
    @NotNull
    public String getName() {
        String string = this.getDatabaseName() + " Database";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/vfs/DbStorageFileType", "getName"));
        }
        return string;
    }

    @NotNull
    public String getDescription() {
        String string = this.getDatabaseName() + " Database File";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/vfs/DbStorageFileType", "getDescription"));
        }
        return string;
    }

    public Icon getIcon() {
        return DatabaseIcons.Dbms;
    }

    @NotNull
    public abstract String getDatabaseName();

    public boolean isReadOnly() {
        return true;
    }

    @NotNull
    abstract String getFilePrefix();

    public static class H2Storage
    extends DbStorageFileType {
        public static final H2Storage INSTANCE = new H2Storage();

        @NotNull
        public String getDefaultExtension() {
            if ("h2.db" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/vfs/DbStorageFileType$H2Storage", "getDefaultExtension"));
            }
            return "h2.db";
        }

        @Override
        @NotNull
        public String getDatabaseName() {
            if ("H2" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/vfs/DbStorageFileType$H2Storage", "getDatabaseName"));
            }
            return "H2";
        }

        @Override
        @NotNull
        String getFilePrefix() {
            if ("-- H2 0.5/B --" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/vfs/DbStorageFileType$H2Storage", "getFilePrefix"));
            }
            return "-- H2 0.5/B --";
        }
    }

    public static class SqliteStorage
    extends DbStorageFileType {
        public static final SqliteStorage INSTANCE = new SqliteStorage();

        @Override
        @NotNull
        public String getDatabaseName() {
            if ("SQLite" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/vfs/DbStorageFileType$SqliteStorage", "getDatabaseName"));
            }
            return "SQLite";
        }

        @Override
        @NotNull
        String getFilePrefix() {
            if ("SQLite format " == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/vfs/DbStorageFileType$SqliteStorage", "getFilePrefix"));
            }
            return "SQLite format ";
        }
    }
}

