/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasSchemaChild;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.ErrorHandler;
import com.intellij.database.util.LoaderContext;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.database.vfs.ObjectPath;
import com.intellij.database.vfs.SearchPath;
import com.intellij.database.view.DatabaseView;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import java.sql.Connection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public abstract class AbstractDatabaseModifier {
    @NotNull
    protected DbDataSource myDataSource;
    @NotNull
    private LoaderContext myContext;
    @NotNull
    private final String myTitle;
    @Nullable
    private final DasNamespace myDefaultNs;
    private Set<Object> mySelectionBeforeUpdate;

    protected AbstractDatabaseModifier(@NotNull DbDataSource dataSource, @Nullable DasNamespace defaultNs, @NotNull String title) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/view/AbstractDatabaseModifier", "<init>"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/database/view/AbstractDatabaseModifier", "<init>"));
        }
        this.mySelectionBeforeUpdate = Collections.emptySet();
        this.myDataSource = dataSource;
        this.myDefaultNs = defaultNs;
        this.myTitle = title;
        DatabaseSystem delegate = dataSource.getDelegate();
        this.myContext = new LoaderContext(delegate instanceof LocalDataSource ? (LocalDataSource)delegate : null);
    }

    @NotNull
    public DbDataSource getDataSource() {
        DbDataSource dbDataSource = this.myDataSource;
        if (dbDataSource == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/AbstractDatabaseModifier", "getDataSource"));
        }
        return dbDataSource;
    }

    @NotNull
    public LoaderContext getContext() {
        LoaderContext loaderContext = this.myContext;
        if (loaderContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/AbstractDatabaseModifier", "getContext"));
        }
        return loaderContext;
    }

    @Nullable
    private String getDefaultPathQuery(@NotNull DatabaseDialectEx dialect) {
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/view/AbstractDatabaseModifier", "getDefaultPathQuery"));
        }
        DasObject object = DbImplUtil.getSearchPathObject(dialect, (DasObject)this.myDefaultNs);
        return object == null ? null : dialect.sqlSetSearchPath(SearchPath.of(ObjectPath.of(object)));
    }

    @NotNull
    public Promise<Void> runStatements(final boolean nonModalSync) {
        final Project project = this.myDataSource.getProject();
        final LocalDataSource dataSource = this.myContext.getDataSource();
        if (dataSource == null) {
            Promise promise = Promises.rejectedPromise();
            if (promise == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/AbstractDatabaseModifier", "runStatements"));
            }
            return promise;
        }
        this.mySelectionBeforeUpdate = DatabaseView.getDatabaseView(project).getTreeBuilder().getSelectedElements();
        final AsyncPromise callback = new AsyncPromise();
        final ErrorHandler errorHandler = new ErrorHandler();
        callback.rejected(throwable -> {
            if (!errorHandler.getSummary().isEmpty()) {
                DataSourceUiUtil.showNotification(project, "", errorHandler.getSummary(), true);
            }
        });
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, this.myTitle){

            /*
             * Exception decompiling
             */
            public void run(@NotNull ProgressIndicator indicator) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 14[SIMPLE_IF_TAKEN]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            private /* synthetic */ void lambda$run$0() {
                AbstractDatabaseModifier.this.runSync();
            }
        });
        AsyncPromise asyncPromise = callback;
        if (asyncPromise == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/AbstractDatabaseModifier", "runStatements"));
        }
        return asyncPromise;
    }

    public void runSync() {
        Project project = this.myDataSource.getProject();
        DataSourceUiUtil.performManualSyncTask(project, this.myContext).doWhenProcessed(() -> {
            DatabaseView view2 = DatabaseView.getDatabaseView(project);
            view2.getTreeBuilder().queueUpdate().doWhenProcessed(() -> {
                DbElement element = this.getElement(project);
                if (AbstractDatabaseModifier.needSelect(this.mySelectionBeforeUpdate, view2, element)) {
                    AbstractDatabaseModifier.selectElement(element);
                }
            });
        });
    }

    private static void selectElement(@Nullable DbElement element) {
        if (element == null) {
            return;
        }
        DatabaseView.select(element, false);
    }

    private static boolean needSelect(@NotNull Set<Object> oldSelection, @NotNull DatabaseView view2, @Nullable DbElement element) {
        if (oldSelection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldSelection", "com/intellij/database/view/AbstractDatabaseModifier", "needSelect"));
        }
        if (view2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/database/view/AbstractDatabaseModifier", "needSelect"));
        }
        Set<Object> currentlySelected = AbstractDatabaseModifier.getSelectedElements(view2);
        return element != null && oldSelection.equals(currentlySelected) && !currentlySelected.contains(element);
    }

    @NotNull
    private static Set<Object> getSelectedElements(@NotNull DatabaseView view2) {
        if (view2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/database/view/AbstractDatabaseModifier", "getSelectedElements"));
        }
        AbstractTreeBuilder builder = view2.getTreeBuilder();
        Set set = builder.getSelectedElements();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/AbstractDatabaseModifier", "getSelectedElements"));
        }
        return set;
    }

    @Nullable
    private DbElement getElement(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/view/AbstractDatabaseModifier", "getElement"));
        }
        DasObject info = AbstractDatabaseModifier.getDasObject(this.myContext.getElementToFocus());
        if (info == null) {
            return null;
        }
        DatabaseElementVirtualFileImpl file = DatabaseElementVirtualFileImpl.findFile(project, (DatabaseSystem)this.myDataSource, ObjectPath.of(info));
        return file == null ? null : file.findElement();
    }

    @Nullable
    private static DasObject getDasObject(@Nullable Object object) {
        return object instanceof DasSchemaChild ? (DasObject)object : (object instanceof DasColumn ? ((DasColumn)object).getTable() : (object instanceof DasTableKey ? ((DasTableKey)object).getTable() : null));
    }

    @NotNull
    protected abstract QueryExecutor getExecutor();

    static /* synthetic */ String access$000(AbstractDatabaseModifier x0, DatabaseDialectEx x1) {
        return x0.getDefaultPathQuery(x1);
    }

    static /* synthetic */ LoaderContext access$100(AbstractDatabaseModifier x0) {
        return x0.myContext;
    }

    protected static interface QueryExecutor {
        public boolean execute(ProgressIndicator var1, Connection var2, Project var3, ErrorHandler var4) throws Exception;
    }
}

