/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.editors;

import com.intellij.database.model.DasObject;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.view.editors.DatabaseEditorBase;
import com.intellij.database.view.editors.DatabaseEditorBaseEx;
import com.intellij.database.view.editors.ShutSplitter;
import com.intellij.database.view.models.ObjectEditorModel;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbarPosition;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.ui.AnActionButtonUpdater;
import com.intellij.ui.EditorTextFieldCellRenderer;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.JBTable;
import com.intellij.ui.table.TableView;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.table.EditorTextFieldJBTableRowRenderer;
import com.intellij.util.ui.table.JBListTable;
import com.intellij.util.ui.table.JBTableRow;
import com.intellij.util.ui.table.JBTableRowEditor;
import com.intellij.util.ui.table.JBTableRowRenderer;
import gnu.trove.TIntArrayList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.event.TableModelEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DatabaseEditorUtil {
    public static JComponent labeledDecorator(@NotNull JComponent label, @NotNull JBTable table) {
        if (label == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "label", "com/intellij/database/view/editors/DatabaseEditorUtil", "labeledDecorator"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/view/editors/DatabaseEditorUtil", "labeledDecorator"));
        }
        return DatabaseEditorUtil.labeledDecorator(label, ToolbarDecorator.createDecorator((JTable)table));
    }

    @NotNull
    public static JComponent labeledDecorator(@NotNull JComponent label, ToolbarDecorator decorator) {
        if (label == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "label", "com/intellij/database/view/editors/DatabaseEditorUtil", "labeledDecorator"));
        }
        decorator.setToolbarPosition(ActionToolbarPosition.TOP);
        JPanel p = decorator.createPanel();
        p.setBorder(IdeBorderFactory.createEmptyBorder());
        decorator.getActionsPanel().setToolbarLabel(label, ActionToolbarPosition.LEFT);
        decorator.getActionsPanel().getToolbar().setReservePlaceAutoPopupIcon(false);
        JPanel jPanel = p;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseEditorUtil", "labeledDecorator"));
        }
        return jPanel;
    }

    public static int computeLength(@NotNull Iterable<Pair<String, TextAttributesKey>> iterable) {
        if (iterable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterable", "com/intellij/database/view/editors/DatabaseEditorUtil", "computeLength"));
        }
        int length = 0;
        for (Pair<String, TextAttributesKey> pair : iterable) {
            length += ((String)pair.first).length();
        }
        return length;
    }

    public static void padText(@NotNull ColoredFragmentsBuilder builder, int maxLength, int length) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/view/editors/DatabaseEditorUtil", "padText"));
        }
        for (int i2 = 0; i2 < maxLength - length + 1; ++i2) {
            builder.append(" ");
        }
    }

    public static <T> ListTableModel<T> createTableModel(final @NotNull ObjectEditorModel model, final @NotNull EditorModelHelper<T> helper, final boolean canExchange) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/view/editors/DatabaseEditorUtil", "createTableModel"));
        }
        if (helper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helper", "com/intellij/database/view/editors/DatabaseEditorUtil", "createTableModel"));
        }
        return new ListTableModel<T>(new ColumnInfo[0]){

            public void addRow() {
                Object row = helper.createRow();
                if (row == null) {
                    return;
                }
                this.addRow(row);
                model.commit();
            }

            public void removeRow(int idx) {
                if (!helper.removeRow(this.getItem(idx), idx)) {
                    return;
                }
                super.removeRow(idx);
                model.commit();
            }

            public boolean canExchangeRows(int oldIndex, int newIndex) {
                return canExchange;
            }

            public void exchangeRows(int idx1, int idx2) {
                if (idx1 == idx2) {
                    return;
                }
                if (!helper.exchangeRows(this.getItem(idx1), idx1, this.getItem(idx2), idx2)) {
                    return;
                }
                super.exchangeRows(idx1, idx2);
                model.commit();
            }
        };
    }

    public static <Ed extends DatabaseEditorBaseEx, Das extends DasObject> void cleanupEditors(@NotNull ListTableModel<Ed> model, @NotNull Iterable<? extends Das> objects, @NotNull Function<Das, Ed> fac) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/view/editors/DatabaseEditorUtil", "cleanupEditors"));
        }
        if (objects == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objects", "com/intellij/database/view/editors/DatabaseEditorUtil", "cleanupEditors"));
        }
        if (fac == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fac", "com/intellij/database/view/editors/DatabaseEditorUtil", "cleanupEditors"));
        }
        HashMap editors = ContainerUtil.newHashMap();
        ArrayList newItems = ContainerUtil.newArrayList();
        for (DatabaseEditorBaseEx editor : model.getItems()) {
            editors.put(editor.getKeyObject(), editor);
        }
        for (DasObject column : objects) {
            DatabaseEditorBaseEx editor = (DatabaseEditorBaseEx)editors.get(column);
            if (editor == null) {
                editor = (DatabaseEditorBaseEx)fac.fun((Object)column);
            }
            editors.remove(column);
            newItems.add(editor);
        }
        for (DatabaseEditorBaseEx editor : editors.values()) {
            Disposer.dispose((Disposable)editor);
        }
        if (model.getItems().equals(newItems)) {
            return;
        }
        model.setItems((List)newItems);
    }

    public static void setTableDecoratorMinSize(@NotNull JComponent component, @NotNull JTable table) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/database/view/editors/DatabaseEditorUtil", "setTableDecoratorMinSize"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/view/editors/DatabaseEditorUtil", "setTableDecoratorMinSize"));
        }
    }

    @NotNull
    public static <T extends EmbeddableEditor> DbListTableWithEditor createTableWithEditor(@NotNull ListTableModel<T> model, @NotNull DatabaseEditorBase editor, int rows, int width, @Nullable ActionGroup contextMenu) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/view/editors/DatabaseEditorUtil", "createTableWithEditor"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/database/view/editors/DatabaseEditorUtil", "createTableWithEditor"));
        }
        DbListTableWithEditor<T> dbListTableWithEditor = new DbListTableWithEditor<T>(model, editor, rows, width, contextMenu);
        if (dbListTableWithEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseEditorUtil", "createTableWithEditor"));
        }
        return dbListTableWithEditor;
    }

    @NotNull
    public static ShutSplitter createHideableSplitter(@NotNull String separatorText, @NotNull JComponent first, @NotNull JComponent second, @Nullable String key) {
        if (separatorText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "separatorText", "com/intellij/database/view/editors/DatabaseEditorUtil", "createHideableSplitter"));
        }
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "com/intellij/database/view/editors/DatabaseEditorUtil", "createHideableSplitter"));
        }
        if (second == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "second", "com/intellij/database/view/editors/DatabaseEditorUtil", "createHideableSplitter"));
        }
        ShutSplitter splitter = new ShutSplitter(separatorText, key);
        splitter.setFirstComponent(first);
        splitter.setSecondComponent(second);
        ShutSplitter shutSplitter = splitter;
        if (shutSplitter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseEditorUtil", "createHideableSplitter"));
        }
        return shutSplitter;
    }

    @Nullable
    public static <T extends DatabaseEditorBaseEx> T startItemEditing(@Nullable DeObject object, JBListTable table, ListTableModel<T> model) {
        int index = DatabaseEditorUtil.findObjectIndex(object, model);
        if (index == -1) {
            return null;
        }
        TableUtil.selectRows((JTable)table.getTable(), (int[])new int[]{index});
        TableUtil.editCellAt((JTable)table.getTable(), (int)index, (int)0);
        return (T)((DatabaseEditorBaseEx)model.getItem(index));
    }

    @Nullable
    public static <T extends DatabaseEditorBaseEx> T getEditedItem(JBListTable table, ListTableModel<T> model) {
        int index = table.getTable().getEditingRow();
        if (index == -1) {
            return null;
        }
        return (T)((DatabaseEditorBaseEx)model.getItem(index));
    }

    public static <T extends DatabaseEditorBaseEx> int findObjectIndex(@Nullable DeObject object, ListTableModel<T> model) {
        int index = 0;
        for (DatabaseEditorBaseEx ed : model.getItems()) {
            if (ed.getKeyObject() == object) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public static void setSmallFontRecursive(@Nullable JComponent component) {
        for (Component c : UIUtil.uiTraverser((Component)component)) {
            if (!(c instanceof JLabel) && !(c instanceof AbstractButton)) continue;
            UIUtil.applyStyle((UIUtil.ComponentStyle)UIUtil.ComponentStyle.SMALL, (Component)c);
        }
    }

    public static abstract class JBTableRowEditorWrapper<T extends EmbeddableEditor>
    extends JBTableRowEditor {
        protected final T myComponent;

        protected JBTableRowEditorWrapper(T component) {
            this.myComponent = component;
        }

        public void prepareEditor(JTable table, int row) {
            this.setLayout(new BorderLayout());
            this.setBorder((Border)JBUI.Borders.empty((int)4, (int)8));
            JComponent component = this.myComponent.getComponent();
            DatabaseEditorUtil.setSmallFontRecursive(component);
            this.add(component, "Center");
        }

        public JComponent getPreferredFocusedComponent() {
            return this.myComponent.getPreferredFocusedComponent();
        }

        public JComponent[] getFocusableComponents() {
            return this.myComponent.getFocusableComponents();
        }
    }

    public static class FlagUpdater
    implements AnActionButtonUpdater {
        private boolean myEnabled = true;

        public FlagUpdater(boolean enabled) {
            this.myEnabled = enabled;
        }

        public boolean isEnabled(AnActionEvent e) {
            return this.myEnabled;
        }

        public void setEnabled(boolean enabled) {
            this.myEnabled = enabled;
        }
    }

    public static class DbListTableWithEditor<T extends EmbeddableEditor>
    extends DbListTable<T> {
        private boolean myEditable = true;

        public DbListTableWithEditor(ListTableModel<T> model, DatabaseEditorBase editor, int rows, int width, @Nullable ActionGroup contextMenu) {
            super(model, editor, rows, width, contextMenu);
        }

        private boolean isSelecting() {
            return this.myMouseEvent != null && ((this.myMouseEvent.getModifiers() & 2) != 0 || (this.myMouseEvent.getModifiers() & 1) != 0 || (this.myMouseEvent.getModifiers() & 8) != 0 || (this.myMouseEvent.getModifiers() & 4) != 0);
        }

        @Override
        protected JBTableRowEditor getRowEditor(final int row) {
            if (this.isSelecting()) {
                return null;
            }
            EmbeddableEditor editor = (EmbeddableEditor)this.getEditor(row);
            if (!this.myEditable || !editor.canDoAnything()) {
                return null;
            }
            return new JBTableRowEditorWrapper<T>(editor){

                public JBTableRow getValue() {
                    return new JBTableRow(){

                        public Object getValueAt(int column) {
                            return myInternalTable.getValueAt(row, column);
                        }
                    };
                }

                @Override
                public JComponent[] getFocusableComponents() {
                    return (JComponent[])Arrays.stream(super.getFocusableComponents()).filter(Component::isEnabled).toArray(JComponent[]::new);
                }
            };
        }

        public void setEditable(boolean editable) {
            this.myEditable = editable;
        }
    }

    public static class DbListTable<T extends RowStringProvider>
    extends JBListTable {
        private final EditorTextFieldJBTableRowRenderer myRowRenderer;

        public DbListTable(@NotNull ListTableModel<T> model, final @NotNull DatabaseEditorBase editor, int rows, int width, @Nullable ActionGroup contextMenu) {
            if (model == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/view/editors/DatabaseEditorUtil$DbListTable", "<init>"));
            }
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/database/view/editors/DatabaseEditorUtil$DbListTable", "<init>"));
            }
            super((JTable)new TableView<T>(model){

                public void tableChanged(TableModelEvent e) {
                    super.tableChanged(e);
                }
            }, (Disposable)editor);
            this.myRowRenderer = new EditorTextFieldJBTableRowRenderer(editor.getContext().getProject(), (FileType)DbSqlUtil.getSqlDialect(editor.getContext().getDialect()).getAssociatedFileType(), editor){

                protected String getText(JTable table, int row) {
                    return "";
                }

                private Iterable<Pair<String, TextAttributesKey>> getText(int row) {
                    return this.getEditor(row).getRowText();
                }

                @Nullable
                protected TextAttributes getTextAttributes(JTable table, int row) {
                    return this.getEditor(row).isObjectValid() ? null : this.getColorScheme(table).getAttributes(HighlighterColors.BAD_CHARACTER);
                }

                protected void customizeEditor(@NotNull EditorEx textEditor, JTable table, Object value, boolean selected, int row, int column) {
                    if (textEditor == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textEditor", "com/intellij/database/view/editors/DatabaseEditorUtil$DbListTable$2", "customizeEditor"));
                    }
                    VirtualFile file = FileDocumentManager.getInstance().getFile((Document)textEditor.getDocument());
                    SqlLanguageDialect dialect = DbSqlUtil.getSqlDialect(editor.getContext().getDialect());
                    SyntaxHighlighter highlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)dialect, (Project)editor.getContext().getProject(), (VirtualFile)file);
                    EditorColorsScheme scheme = textEditor.getColorsScheme();
                    textEditor.setHighlighter((EditorHighlighter)new LexerEditorHighlighter(highlighter, scheme));
                    textEditor.getMarkupModel().removeAllHighlighters();
                    StringBuilder text = new StringBuilder(" ");
                    Iterable<Pair<String, TextAttributesKey>> fragments = this.getText(row);
                    TIntArrayList ranges = new TIntArrayList();
                    ranges.add(text.length());
                    for (Pair<String, TextAttributesKey> pair : fragments) {
                        text.append((String)pair.first);
                        ranges.add(text.length());
                    }
                    textEditor.getDocument().setText((CharSequence)text);
                    ((EditorImpl)textEditor).resetSizes();
                    textEditor.getHighlighter().setText((CharSequence)text);
                    int i2 = 0;
                    for (Pair<String, TextAttributesKey> pair : fragments) {
                        if (pair.second != null) {
                            textEditor.getMarkupModel().addRangeHighlighter(ranges.get(i2), ranges.get(i2 + 1), 4000, scheme.getAttributes((TextAttributesKey)pair.second), HighlighterTargetArea.EXACT_RANGE);
                        }
                        ++i2;
                    }
                    textEditor.getMarkupModel().addRangeHighlighter(0, textEditor.getDocument().getTextLength(), 4000, this.getTextAttributes(table, row), HighlighterTargetArea.EXACT_RANGE);
                    ((EditorImpl)textEditor).setPaintSelection(selected);
                    SelectionModel selectionModel = textEditor.getSelectionModel();
                    selectionModel.setSelection(0, selected ? textEditor.getDocument().getTextLength() : 0);
                }

                @NotNull
                protected EditorTextFieldCellRenderer.RendererComponent createRendererComponent(@Nullable Project project, @Nullable FileType fileType, boolean inheritFontFromLaF) {
                    EditorTextFieldCellRenderer.SimpleRendererComponent simpleRendererComponent = new EditorTextFieldCellRenderer.SimpleRendererComponent(project, fileType, inheritFontFromLaF);
                    if (simpleRendererComponent == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseEditorUtil$DbListTable$2", "createRendererComponent"));
                    }
                    return simpleRendererComponent;
                }
            };
            JBTable table = this.getTable();
            table.setCellSelectionEnabled(true);
            table.getSelectionModel().setSelectionMode(2);
            if (contextMenu != null) {
                PopupHandler.installUnknownPopupHandler((JComponent)table, (ActionGroup)contextMenu, (ActionManager)ActionManager.getInstance());
            }
            table.setSurrendersFocusOnKeystroke(true);
            table.setStriped(true);
            table.getSelectionModel().setSelectionInterval(0, 0);
            table.getColumnModel().getSelectionModel().setSelectionInterval(0, 0);
            int height = table.getRowHeight();
            table.setPreferredScrollableViewportSize(new Dimension(width, height * Math.max(4, rows)));
        }

        protected JBTableRowRenderer getRowRenderer(int row) {
            return this.myRowRenderer;
        }

        protected T getEditor(int row) {
            return (T)((RowStringProvider)((TableView)this.myInternalTable).getTableViewModel().getItems().get(row));
        }

        protected JBTableRowEditor getRowEditor(int row) {
            return null;
        }
    }

    public static abstract class EmbeddableEditorAdapter
    implements EmbeddableEditor {
        @Override
        public boolean canDoAnything() {
            return true;
        }

        @Override
        public boolean isObjectValid() {
            return true;
        }

        @Override
        @NotNull
        public Iterable<Pair<String, TextAttributesKey>> getRowText() {
            List<Pair<String, TextAttributesKey>> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseEditorUtil$EmbeddableEditorAdapter", "getRowText"));
            }
            return list;
        }
    }

    public static interface EmbeddableEditor
    extends RowStringProvider {
        public boolean canDoAnything();

        @NotNull
        public JComponent getComponent();

        @NotNull
        public JComponent getPreferredFocusedComponent();

        @NotNull
        public JComponent[] getFocusableComponents();
    }

    public static interface RowStringProvider {
        @NotNull
        public Iterable<Pair<String, TextAttributesKey>> getRowText();

        public boolean isObjectValid();
    }

    public static class ColoredFragmentsBuilder {
        private JBIterable<Pair<String, TextAttributesKey>> myResult = JBIterable.empty();
        private StringBuilder myBuffer = new StringBuilder();

        public ColoredFragmentsBuilder append(@NotNull String frag) {
            if (frag == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frag", "com/intellij/database/view/editors/DatabaseEditorUtil$ColoredFragmentsBuilder", "append"));
            }
            return this.append(frag, null);
        }

        public ColoredFragmentsBuilder appendRef(@NotNull String frag, boolean good) {
            if (frag == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frag", "com/intellij/database/view/editors/DatabaseEditorUtil$ColoredFragmentsBuilder", "appendRef"));
            }
            return this.append(frag, good ? null : CodeInsightColors.WARNINGS_ATTRIBUTES);
        }

        public ColoredFragmentsBuilder append(@NotNull String frag, @Nullable TextAttributesKey attrs) {
            if (frag == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frag", "com/intellij/database/view/editors/DatabaseEditorUtil$ColoredFragmentsBuilder", "append"));
            }
            if (attrs == null) {
                this.myBuffer.append(frag);
            } else {
                this.finish();
                this.myResult = this.myResult.append((Object)Pair.create((Object)frag, (Object)attrs));
            }
            return this;
        }

        @NotNull
        public Iterable<Pair<String, TextAttributesKey>> build() {
            this.finish();
            JBIterable<Pair<String, TextAttributesKey>> jBIterable = this.myResult;
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseEditorUtil$ColoredFragmentsBuilder", "build"));
            }
            return jBIterable;
        }

        private void finish() {
            if (this.myBuffer.length() == 0) {
                return;
            }
            this.myResult = this.myResult.append((Object)Pair.create((Object)this.myBuffer.toString(), null));
            this.myBuffer.setLength(0);
        }
    }

    public static abstract class EditorModelHelper<T> {
        @Nullable
        public T createRow() {
            return null;
        }

        public boolean removeRow(T item, int idx) {
            return false;
        }

        public boolean exchangeRows(T item0, int idx0, T item1, int idx1) {
            return false;
        }
    }
}

