/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.models;

import com.intellij.database.model.DasObject;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.view.models.ObjectEditorModel;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.WeakValueHashMap;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class EditorModelsCache {
    public final SqlCodeStyleSettings settings;
    private Map<DasObject, ObjectEditorModel<?>> myModels;

    public EditorModelsCache(@NotNull SqlCodeStyleSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/database/view/models/EditorModelsCache", "<init>"));
        }
        this.myModels = new WeakValueHashMap();
        this.settings = settings;
    }

    @NotNull
    private <M extends ObjectEditorModel> M create(@NotNull DeObject obj, @NotNull Class<? extends M> clazz) {
        ObjectEditorModel objectEditorModel;
        if (obj == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "obj", "com/intellij/database/view/models/EditorModelsCache", "create"));
        }
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/database/view/models/EditorModelsCache", "create"));
        }
        try {
            Constructor<?>[] constructors = clazz.getConstructors();
            assert (constructors.length == 1);
            objectEditorModel = (ObjectEditorModel)clazz.cast(constructors[0].newInstance(obj, this));
        }
        catch (InvocationTargetException e) {
            ExceptionUtil.rethrowUnchecked((Throwable)e);
            throw new AssertionError((Object)"Unreachable");
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Error instantiating editor " + clazz.getCanonicalName() + " for " + obj.getClass().getCanonicalName(), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Error instantiating editor " + clazz.getCanonicalName() + " for " + obj.getClass().getCanonicalName(), e);
        }
        if (objectEditorModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/models/EditorModelsCache", "create"));
        }
        return (M)objectEditorModel;
    }

    public <M extends ObjectEditorModel> M get(@NotNull DeObject obj, @NotNull Class<? extends M> clazz) {
        if (obj == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "obj", "com/intellij/database/view/models/EditorModelsCache", "get"));
        }
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/database/view/models/EditorModelsCache", "get"));
        }
        ObjectEditorModel<?> model = this.myModels.get(obj);
        if (model != null) {
            return (M)((ObjectEditorModel)clazz.cast(model));
        }
        M res = this.create(obj, clazz);
        this.myModels.put(obj, (ObjectEditorModel<?>)res);
        return res;
    }

    @NotNull
    public Iterable<ObjectEditorModel<?>> getModels() {
        ArrayList arrayList = ContainerUtil.newArrayList(this.myModels.values());
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/models/EditorModelsCache", "getModels"));
        }
        return arrayList;
    }
}

