/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.models;

import com.intellij.database.schemaEditor.model.DeColumn;
import com.intellij.database.schemaEditor.model.DeConstraint;
import com.intellij.database.schemaEditor.model.DeForeignKey;
import com.intellij.database.schemaEditor.model.DeIndex;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.schemaEditor.model.DeTableKey;
import com.intellij.database.schemaEditor.model.ListSet;
import com.intellij.database.view.models.EditorModelsCache;
import com.intellij.database.view.models.ObjectEditorModel;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TableEditorModel
extends ObjectEditorModel<DeTable> {
    public TableEditorModel(@NotNull DeTable object, @NotNull EditorModelsCache models) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/view/models/TableEditorModel", "<init>"));
        }
        if (models == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "models", "com/intellij/database/view/models/TableEditorModel", "<init>"));
        }
        super(object, models);
    }

    public void setTemporary(boolean temporary) {
        if (((DeTable)this.myObject).temporary == temporary) {
            return;
        }
        ((DeTable)this.myObject).temporary = temporary;
        this.modify();
    }

    public boolean isTemporary() {
        return ((DeTable)this.myObject).temporary;
    }

    public void insertColumn(@NotNull DeColumn column, int index) {
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/view/models/TableEditorModel", "insertColumn"));
        }
        ((DeTable)this.myObject).columns.add(index, column);
        this.modify();
    }

    public void removeColumn(@NotNull DeColumn column) {
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/view/models/TableEditorModel", "removeColumn"));
        }
        ((DeTable)this.myObject).columns.remove(column);
        this.modify();
    }

    @NotNull
    public List<DeColumn> getColumns() {
        List<DeColumn> list = Collections.unmodifiableList(((DeTable)this.myObject).columns);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/models/TableEditorModel", "getColumns"));
        }
        return list;
    }

    public void setPrimaryKey(@Nullable DeTableKey key) {
        if (((DeTable)this.myObject).keys.getPrimaryKey() == key) {
            return;
        }
        ((DeTable)this.myObject).keys.setPrimaryKey(key);
        this.modify();
    }

    @Nullable
    public DeTableKey getPrimaryKey() {
        return ((DeTable)this.myObject).keys.getPrimaryKey();
    }

    public void addConstraint(@NotNull DeConstraint constraint) {
        if (constraint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constraint", "com/intellij/database/view/models/TableEditorModel", "addConstraint"));
        }
        if (((DeTable)this.myObject).constraints.contains(constraint)) {
            return;
        }
        ((DeTable)this.myObject).constraints.add(constraint);
        this.modify();
    }

    public void removeConstraint(@NotNull DeConstraint constraint) {
        if (constraint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constraint", "com/intellij/database/view/models/TableEditorModel", "removeConstraint"));
        }
        if (!((DeTable)this.myObject).constraints.contains(constraint)) {
            return;
        }
        ((DeTable)this.myObject).constraints.remove(constraint);
        this.modify();
    }

    public void addIndex(@NotNull DeIndex constraint) {
        if (constraint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constraint", "com/intellij/database/view/models/TableEditorModel", "addIndex"));
        }
        if (((DeTable)this.myObject).indices.contains(constraint)) {
            return;
        }
        ((DeTable)this.myObject).indices.add(constraint);
        this.modify();
    }

    public void removeIndex(@NotNull DeIndex constraint) {
        if (constraint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constraint", "com/intellij/database/view/models/TableEditorModel", "removeIndex"));
        }
        if (!((DeTable)this.myObject).indices.contains(constraint)) {
            return;
        }
        ((DeTable)this.myObject).indices.remove(constraint);
        this.modify();
    }

    public Iterable<DeConstraint> getConstraints() {
        return ((DeTable)this.myObject).constraints;
    }

    @NotNull
    public DeColumn createColumn(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/view/models/TableEditorModel", "createColumn"));
        }
        DeColumn deColumn = new DeColumn(name, (DeTable)this.myObject, ((DeTable)this.myObject).model);
        if (deColumn == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/models/TableEditorModel", "createColumn"));
        }
        return deColumn;
    }

    @NotNull
    public DeConstraint createConstraint(@NotNull String name, DeColumn ... columns) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/view/models/TableEditorModel", "createConstraint"));
        }
        if (columns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/view/models/TableEditorModel", "createConstraint"));
        }
        DeConstraint constraint = new DeConstraint(name, (DeTable)this.myObject, ((DeTable)this.myObject).model);
        Collections.addAll(constraint.columns, columns);
        DeConstraint deConstraint = constraint;
        if (deConstraint == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/models/TableEditorModel", "createConstraint"));
        }
        return deConstraint;
    }

    @NotNull
    public DeTableKey createTableKey(DeColumn ... columns) {
        if (columns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/view/models/TableEditorModel", "createTableKey"));
        }
        DeTableKey key = new DeTableKey("", (DeTable)this.myObject, ((DeTable)this.myObject).model);
        Collections.addAll(key.columns, columns);
        DeTableKey deTableKey = key;
        if (deTableKey == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/models/TableEditorModel", "createTableKey"));
        }
        return deTableKey;
    }

    @NotNull
    public DeIndex createIndex(DeIndex.Item ... items) {
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/intellij/database/view/models/TableEditorModel", "createIndex"));
        }
        DeIndex deIndex = this.createIndex(Arrays.asList(items));
        if (deIndex == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/models/TableEditorModel", "createIndex"));
        }
        return deIndex;
    }

    @NotNull
    public DeIndex createIndex(@NotNull List<DeIndex.Item> items) {
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/intellij/database/view/models/TableEditorModel", "createIndex"));
        }
        DeIndex index = new DeIndex("", (DeTable)this.myObject, ((DeTable)this.myObject).model);
        for (DeIndex.Item item : items) {
            index.items.add(item);
        }
        DeIndex deIndex = index;
        if (deIndex == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/models/TableEditorModel", "createIndex"));
        }
        return deIndex;
    }

    @NotNull
    public DeForeignKey createForeignKey(DeForeignKey.Ref ... refs) {
        if (refs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refs", "com/intellij/database/view/models/TableEditorModel", "createForeignKey"));
        }
        DeForeignKey deForeignKey = this.createForeignKey(Arrays.asList(refs));
        if (deForeignKey == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/models/TableEditorModel", "createForeignKey"));
        }
        return deForeignKey;
    }

    @NotNull
    public DeForeignKey createForeignKey(@NotNull List<DeForeignKey.Ref> refs) {
        if (refs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refs", "com/intellij/database/view/models/TableEditorModel", "createForeignKey"));
        }
        DeForeignKey foreignKey = new DeForeignKey("", (DeTable)this.myObject, ((DeTable)this.myObject).model);
        foreignKey.refs.addAll(refs);
        foreignKey.target = null;
        DeForeignKey deForeignKey = foreignKey;
        if (deForeignKey == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/models/TableEditorModel", "createForeignKey"));
        }
        return deForeignKey;
    }

    public int getColumnsCount() {
        return ((DeTable)this.myObject).columns.size();
    }

    @NotNull
    public Iterable<DeIndex> getIndices() {
        ListSet<DeIndex> listSet = ((DeTable)this.myObject).indices;
        if (listSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/models/TableEditorModel", "getIndices"));
        }
        return listSet;
    }

    public int getIndicesCount() {
        return ((DeTable)this.myObject).indices.size();
    }

    public void addForeignKey(@NotNull DeForeignKey fk) {
        if (fk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fk", "com/intellij/database/view/models/TableEditorModel", "addForeignKey"));
        }
        if (((DeTable)this.myObject).foreignKeys.contains(fk)) {
            return;
        }
        ((DeTable)this.myObject).foreignKeys.add(fk);
        this.modify();
    }

    public void removeForeignKey(@NotNull DeForeignKey fk) {
        if (fk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fk", "com/intellij/database/view/models/TableEditorModel", "removeForeignKey"));
        }
        if (!((DeTable)this.myObject).foreignKeys.contains(fk)) {
            return;
        }
        ((DeTable)this.myObject).foreignKeys.remove(fk);
        this.modify();
    }

    public int getForeignKeysCount() {
        return ((DeTable)this.myObject).foreignKeys.size();
    }

    @NotNull
    public Iterable<DeForeignKey> getForeignKeys() {
        ListSet<DeForeignKey> listSet = ((DeTable)this.myObject).foreignKeys;
        if (listSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/models/TableEditorModel", "getForeignKeys"));
        }
        return listSet;
    }

    public void removeTableKey(@NotNull DeTableKey key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/database/view/models/TableEditorModel", "removeTableKey"));
        }
        if (!((DeTable)this.myObject).keys.contains(key)) {
            return;
        }
        ((DeTable)this.myObject).keys.remove(key);
        this.modify();
    }

    public Iterable<DeTableKey> getTableKeys() {
        return ((DeTable)this.myObject).keys;
    }

    public void addTableKey(@NotNull DeTableKey key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/database/view/models/TableEditorModel", "addTableKey"));
        }
        if (((DeTable)this.myObject).keys.contains(key)) {
            return;
        }
        ((DeTable)this.myObject).keys.add(key);
        this.modify();
    }

    public int getTableKeysCount() {
        return ((DeTable)this.myObject).keys.size();
    }
}

