/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlFromClause;
import com.intellij.sql.psi.SqlInsertStatement;
import com.intellij.sql.psi.SqlJoinConditionClause;
import com.intellij.sql.psi.SqlJoinExpression;
import com.intellij.sql.psi.SqlReferenceList;
import com.intellij.sql.psi.SqlTableColumnsList;
import com.intellij.sql.psi.SqlWhereClause;
import com.intellij.sql.psi.impl.SqlImplUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlTypedHandler
extends TypedHandlerDelegate {
    public TypedHandlerDelegate.Result checkAutoPopup(char c, Project project, @NotNull Editor editor, PsiFile file) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/sql/SqlTypedHandler", "checkAutoPopup"));
        }
        if (!(file instanceof SqlFile)) {
            return super.checkAutoPopup(c, project, editor, file);
        }
        if (c == ' ' || c == '(') {
            PsiElement at;
            int offset = editor.getCaretModel().getOffset();
            PsiElement psiElement = at = offset > 0 ? file.findElementAt(offset - 1) : null;
            if (SqlTypedHandler.goodFor(at, c)) {
                AutoPopupController.getInstance((Project)project).autoPopupMemberLookup(editor, null);
                return TypedHandlerDelegate.Result.STOP;
            }
        }
        return super.checkAutoPopup(c, project, editor, file);
    }

    public TypedHandlerDelegate.Result beforeCharTyped(char c, Project project, Editor editor, PsiFile file, FileType fileType) {
        if (!(file instanceof SqlFile)) {
            return super.beforeCharTyped(c, project, editor, file, fileType);
        }
        if (c == ']') {
            SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)file);
            boolean transactFamily = dialect.getFamilyId().isTransactSql();
            int offset = editor.getCaretModel().getOffset();
            String text = editor.getDocument().getText();
            if (transactFamily && offset < text.length() && c == text.charAt(offset)) {
                EditorModificationUtil.moveCaretRelatively((Editor)editor, (int)1);
                return TypedHandlerDelegate.Result.STOP;
            }
        }
        return super.beforeCharTyped(c, project, editor, file, fileType);
    }

    private static boolean goodFor(@Nullable PsiElement element, char c) {
        PsiElement prev;
        if (!(element instanceof LeafPsiElement)) {
            return false;
        }
        IElementType type = ((LeafPsiElement)element).getElementType();
        PsiElement parent = element.getParent();
        if (c == ' ') {
            if (type == SqlCommonKeywords.SQL_WHERE && parent instanceof SqlWhereClause) {
                return true;
            }
            if (type == SqlCommonKeywords.SQL_FROM && parent instanceof SqlFromClause) {
                return true;
            }
            if (type == SqlCommonKeywords.SQL_ON && parent instanceof SqlJoinConditionClause) {
                return true;
            }
            if (type == SqlCommonKeywords.SQL_JOIN && parent instanceof SqlJoinExpression) {
                return true;
            }
        }
        return c == '(' && PsiTreeUtil.getParentOfType((PsiElement)(prev = PsiTreeUtil.prevVisibleLeaf((PsiElement)element)), SqlTableColumnsList.class) != null && PsiTreeUtil.getParentOfType((PsiElement)prev, SqlInsertStatement.class) != null && PsiTreeUtil.getParentOfType((PsiElement)prev, SqlReferenceList.class) == null && PsiTreeUtil.getParentOfType((PsiElement)element, SqlReferenceList.class) == null;
    }
}

