/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects;

import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.psi.DbDataSource;
import com.intellij.psi.PsiElement;
import com.intellij.sql.dialects.SqlDialectImplUtil;
import com.intellij.sql.dialects.SqlImportUtil;
import com.intellij.sql.dialects.TreePattern;
import com.intellij.sql.dialects.TreePatternNode;
import com.intellij.sql.psi.SqlFile;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TIntArrayList;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlImportState {
    public final SqlImportState prevState;
    public final Shared shared;
    public final PsiElement element;
    public final TreePattern state;
    private static final TreePatternNode FAKE_NODE = new TreePatternNode<TreePatternNode.PositiveNaming>(new TreePatternNode.PositiveNaming(new ObjectName("FAKEFAKEFAKEFAKEFAKEFAKE", true)), TreePatternNode.NO_GROUPS);

    public SqlImportState(@Nullable PsiElement element, @NotNull Shared shared, @NotNull TreePattern state, @Nullable SqlImportState prevState) {
        if (shared == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shared", "com/intellij/sql/dialects/SqlImportState", "<init>"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/sql/dialects/SqlImportState", "<init>"));
        }
        this.element = element;
        this.shared = shared;
        this.state = state;
        this.prevState = prevState;
    }

    public boolean isImported(@Nullable DbDataSource dataSource, @Nullable SqlDialectImplUtil.ObjectTracer<?> tracer) {
        List kinds = ContainerUtil.newSmartList();
        List names = ContainerUtil.newSmartList();
        SqlImportState.getTrace(dataSource, tracer, kinds, names);
        DasModel casingProvider = dataSource != null ? dataSource.getModel() : this.shared.file;
        return this.shared.overlay != null && SqlImportState.isImported(this.shared.overlay, kinds, names, (CasingProvider)casingProvider) || SqlImportState.isImported(this.state, kinds, names, (CasingProvider)casingProvider);
    }

    private static boolean isImported(@NotNull TreePattern state, @NotNull List<ObjectKind> kinds, @NotNull List<ObjectName> names, @NotNull CasingProvider casingProvider) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/sql/dialects/SqlImportState", "isImported"));
        }
        if (kinds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kinds", "com/intellij/sql/dialects/SqlImportState", "isImported"));
        }
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/intellij/sql/dialects/SqlImportState", "isImported"));
        }
        if (casingProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "casingProvider", "com/intellij/sql/dialects/SqlImportState", "isImported"));
        }
        TIntArrayList depth = new TIntArrayList();
        ArrayList nodes2 = ContainerUtil.newArrayList();
        nodes2.add(state.root);
        depth.add(kinds.size() - 1);
        while (!nodes2.isEmpty()) {
            TreePatternNode node = (TreePatternNode)nodes2.remove(nodes2.size() - 1);
            int d = depth.remove(depth.size() - 1);
            ObjectName name = names.get(d);
            ObjectKind kind = kinds.get(d);
            boolean found = node.matchedChildren(name == null || name.name.length() == 0 ? null : name, casingProvider.getCasing(kind, null), kind, nodes2);
            if (name != null && name.name.length() == 0 || name == null && kind == SqlImportUtil.DATA_SOURCE) {
                found = true;
                nodes2.add(FAKE_NODE);
            }
            if (d == 0) {
                nodes2.subList(depth.size(), nodes2.size()).clear();
                if (!found) continue;
                return true;
            }
            while (depth.size() < nodes2.size()) {
                depth.add(d - 1);
            }
        }
        return false;
    }

    public static void getTrace(@Nullable DbDataSource dataSource, @Nullable SqlDialectImplUtil.ObjectTracer<?> tracer, @NotNull List<ObjectKind> kinds, @NotNull List<ObjectName> names) {
        if (kinds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kinds", "com/intellij/sql/dialects/SqlImportState", "getTrace"));
        }
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/intellij/sql/dialects/SqlImportState", "getTrace"));
        }
        if (tracer != null) {
            SqlDialectImplUtil.ObjectTracer.ObjectTraceIt<?> it = tracer.trace();
            while (it.hasNext()) {
                it.next();
                kinds.add(it.getKind());
                names.add(new ObjectName(it.getName(), it.isQuoted()));
            }
        }
        kinds.add(SqlImportUtil.DATA_SOURCE);
        names.add(ObjectName.quoted((String)(dataSource == null ? null : dataSource.getName())));
    }

    public static class Shared {
        public final SqlFile file;
        public final TreePattern overlay;

        public Shared(@NotNull SqlFile file, @Nullable TreePattern overlay) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/sql/dialects/SqlImportState$Shared", "<init>"));
            }
            this.file = file;
            this.overlay = overlay;
        }
    }
}

