/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects;

import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.MetaModel;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.psi.DbDataSource;
import com.intellij.dbm.common.IntrospectionScope;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Couple;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.TreePattern;
import com.intellij.sql.dialects.TreePatternNode;
import com.intellij.sql.dialects.TreePatternUtils;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SqlImportUtil {
    public static final ObjectKind DATA_SOURCE = new ObjectKind("data-source");
    public static final ObjectName NON_MATCHING_NAME = ObjectName.quoted((String)"SOME NON MATCHING NAME");

    @NotNull
    public static TreePattern createPattern(@NotNull List<ObjectName> names, @NotNull List<ObjectKind> kinds, @Nullable TreePatternNode.Group[] tail) {
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/intellij/sql/dialects/SqlImportUtil", "createPattern"));
        }
        if (kinds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kinds", "com/intellij/sql/dialects/SqlImportUtil", "createPattern"));
        }
        TreePatternNode.Group[] children = (TreePatternNode.Group[])ObjectUtils.chooseNotNull((Object)tail, (Object)TreePatternNode.NO_GROUPS);
        for (int i2 = 0; i2 < names.size(); ++i2) {
            TreePatternNode[] treePatternNodeArray;
            ObjectName name = names.get(i2);
            ObjectKind kind = kinds.get(i2);
            TreePatternNode<TreePatternNode.PositiveNaming> p = null;
            TreePatternNode<TreePatternNode.NegativeNaming> n = null;
            if (name == null) {
                n = new TreePatternNode<TreePatternNode.NegativeNaming>(TreePatternNode.NegativeNaming.WILDCARD, children);
            } else {
                p = new TreePatternNode<TreePatternNode.PositiveNaming>(new TreePatternNode.PositiveNaming(name), children);
            }
            TreePatternNode.Group[] groupArray = new TreePatternNode.Group[1];
            if (p == null) {
                treePatternNodeArray = null;
            } else {
                TreePatternNode[] treePatternNodeArray2 = new TreePatternNode[1];
                treePatternNodeArray = treePatternNodeArray2;
                treePatternNodeArray2[0] = p;
            }
            groupArray[0] = new TreePatternNode.Group(kind, treePatternNodeArray, n);
            children = groupArray;
        }
        TreePattern treePattern = new TreePattern(children);
        if (treePattern == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/SqlImportUtil", "createPattern"));
        }
        return treePattern;
    }

    @Nullable
    public static List<ObjectKind> getSingleRootPath(@NotNull ObjectKind kind, @NotNull DatabaseDialectEx dialect) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/sql/dialects/SqlImportUtil", "getSingleRootPath"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/sql/dialects/SqlImportUtil", "getSingleRootPath"));
        }
        JBIterable roots = dialect.getMetaModel().getPathsToRoot(kind);
        List root2 = (List)roots.first();
        if (root2 == null || root2.isEmpty() || !roots.skip(1).isEmpty()) {
            Logger.getInstance(dialect.getClass()).warn("To many roots from " + kind);
            return null;
        }
        root2 = ContainerUtil.newArrayList((Iterable)root2);
        assert (!root2.isEmpty());
        assert (root2.get(root2.size() - 1) == ObjectKind.ROOT);
        root2.set(root2.size() - 1, DATA_SOURCE);
        return root2;
    }

    @Nullable
    public static TreePattern createRefPattern(@NotNull SqlReferenceExpression ref, @NotNull DatabaseDialectEx dialect) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/sql/dialects/SqlImportUtil", "createRefPattern"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/sql/dialects/SqlImportUtil", "createRefPattern"));
        }
        ObjectKind refKind = ref.getReferenceElementType().getTargetKind();
        List<ObjectKind> kinds = SqlImportUtil.getSingleRootPath(refKind, dialect);
        if (kinds == null) {
            return null;
        }
        List names = ContainerUtil.newSmartList();
        names.add(new ObjectName(ref.getName(), !ref.isPlainIdentifier()));
        SqlReferenceExpression qual = (SqlReferenceExpression)ObjectUtils.tryCast((Object)ref.getQualifierExpression(), SqlReferenceExpression.class);
        while (names.size() < kinds.size()) {
            names.add(qual == null ? null : new ObjectName(qual.getName(), !qual.isPlainIdentifier()));
            qual = qual == null ? null : (SqlReferenceExpression)ObjectUtils.tryCast((Object)qual.getQualifierExpression(), SqlReferenceExpression.class);
        }
        return SqlImportUtil.createPattern(names, kinds, null);
    }

    static TreePattern createDefaultScopePattern(@Nullable DbDataSource ds, @NotNull SqlLanguageDialectEx language) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/sql/dialects/SqlImportUtil", "createDefaultScopePattern"));
        }
        return language.getDefaultImports(ds);
    }

    @NotNull
    public static TreePatternNode.Group[] notNullArray(@Nullable TreePatternNode.Group g) {
        TreePatternNode.Group[] groupArray;
        if (g == null) {
            groupArray = TreePatternNode.NO_GROUPS;
        } else {
            TreePatternNode.Group[] groupArray2 = new TreePatternNode.Group[1];
            groupArray = groupArray2;
            groupArray2[0] = g;
        }
        if (groupArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/SqlImportUtil", "notNullArray"));
        }
        return groupArray;
    }

    @Nullable
    static TreePattern createResolveScopePattern(@NotNull DbDataSource dataSource, @NotNull SqlLanguageDialectEx language) {
        TreePatternNode.Group group2;
        IntrospectionScope scope;
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/sql/dialects/SqlImportUtil", "createResolveScopePattern"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/sql/dialects/SqlImportUtil", "createResolveScopePattern"));
        }
        LocalDataSource source = (LocalDataSource)((Object)ObjectUtils.tryCast((Object)dataSource.getDelegate(), LocalDataSource.class));
        IntrospectionScope introspectionScope = scope = source == null ? null : source.getResolveScope();
        if (scope == null) {
            return null;
        }
        MetaModel metaModel = language.getDatabaseDialect().getMetaModel();
        if (metaModel.getKindCouples().contains(Couple.of((Object)ObjectKind.DATABASE, (Object)ObjectKind.SCHEMA))) {
            group2 = SqlImportUtil.processDbNames(scope.databases(), ObjectKind.DATABASE, (Function<String, TreePatternNode.Group[]>)((Function)db -> SqlImportUtil.notNullArray(SqlImportUtil.processDbNames(scope.schemas((String)db), ObjectKind.SCHEMA, (Function<String, TreePatternNode.Group[]>)((Function)s -> TreePatternNode.NO_GROUPS)))));
        } else if (metaModel.getRootNamespaceKinds().contains((Object)ObjectKind.SCHEMA)) {
            group2 = SqlImportUtil.processDbNames(scope.allSchemas(), ObjectKind.SCHEMA, (Function<String, TreePatternNode.Group[]>)((Function)s -> TreePatternNode.NO_GROUPS));
        } else {
            throw new AssertionError((Object)"Meta model does not start from database-schema or schema");
        }
        return language.applyImplicitImports(dataSource, new TreePattern(TreePatternUtils.create(ObjectName.quoted((String)dataSource.getName()), DATA_SOURCE, group2)));
    }

    @Nullable
    private static TreePatternNode.Group processDbNames(@NotNull Iterable<String> names, @NotNull ObjectKind kind, @NotNull Function<String, TreePatternNode.Group[]> childFactory) {
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/intellij/sql/dialects/SqlImportUtil", "processDbNames"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/sql/dialects/SqlImportUtil", "processDbNames"));
        }
        if (childFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childFactory", "com/intellij/sql/dialects/SqlImportUtil", "processDbNames"));
        }
        List p = ContainerUtil.newSmartList();
        TreePatternNode<TreePatternNode.NegativeNaming> n = null;
        boolean needNegative = false;
        LinkedHashSet pNames = ContainerUtil.newLinkedHashSet();
        for (String name : names) {
            if ("*".equals(name)) {
                needNegative = true;
                continue;
            }
            p.add(new TreePatternNode<TreePatternNode.PositiveNaming>(new TreePatternNode.PositiveNaming(ObjectName.quoted((String)name)), (TreePatternNode.Group[])childFactory.fun((Object)name)));
            pNames.add(name);
        }
        if (needNegative) {
            n = new TreePatternNode<TreePatternNode.NegativeNaming>(new TreePatternNode.NegativeNaming(ObjectName.toArray((Iterable)JBIterable.from((Iterable)pNames).transform(ObjectName::quoted))), (TreePatternNode.Group[])childFactory.fun((Object)"*"));
        }
        return new TreePatternNode.Group(kind, p.isEmpty() ? null : p.toArray(new TreePatternNode[p.size()]), n);
    }

    @NotNull
    public static TreePattern addObjectsByPath(@NotNull SqlLanguageDialectEx language, @NotNull TreePattern pattern, @Nullable DbDataSource dataSource, @NotNull List<ObjectName> names, boolean atBegin, ObjectKind ... path) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/sql/dialects/SqlImportUtil", "addObjectsByPath"));
        }
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/sql/dialects/SqlImportUtil", "addObjectsByPath"));
        }
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/intellij/sql/dialects/SqlImportUtil", "addObjectsByPath"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/sql/dialects/SqlImportUtil", "addObjectsByPath"));
        }
        PatternItemsFactory f = new PatternItemsFactory(language);
        ObjectKind targetKind = path[path.length - 1];
        ObjectName[] namesPath = new ObjectName[path.length];
        namesPath[0] = dataSource == null ? null : ObjectName.quoted((String)dataSource.getName());
        TreePattern treePattern = TreePatternUtils.patternProcessor(pattern, f.createSimplePattern(namesPath, path), (g, parent, parentKind) -> {
            if (names == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/intellij/sql/dialects/SqlImportUtil", "lambda$addObjectsByPath$3"));
            }
            if (parent instanceof TreePatternNode.NegativeNaming) {
                return TreePatternUtils.SKIP_PROCESSING;
            }
            if (g.kind != targetKind) {
                return g;
            }
            List notFound = ContainerUtil.newSmartList();
            for (ObjectName name : names) {
                if (g.matchedChildren(name, null, null)) continue;
                notFound.add(name);
            }
            if (notFound.isEmpty()) {
                return g;
            }
            TreePatternNode.PositiveNaming naming = new TreePatternNode.PositiveNaming(ObjectName.toArray((Iterable)notFound));
            TreePatternUtils.GroupBuilder builder = TreePatternUtils.GroupBuilder.from(g);
            builder.positives.add(atBegin ? 0 : builder.positives.size(), new TreePatternNode<TreePatternNode.PositiveNaming>(naming, TreePatternNode.NO_GROUPS));
            return builder.build(g.kind);
        });
        if (treePattern == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/SqlImportUtil", "addObjectsByPath"));
        }
        return treePattern;
    }

    @Nullable
    public static RawConnectionConfig getConnectionConfig(@Nullable DbDataSource ds) {
        return ds == null ? null : ds.getConnectionConfig();
    }

    public static class PatternItemsFactory {
        private final SqlLanguageDialectEx myLanguage;

        public PatternItemsFactory(@NotNull SqlLanguageDialectEx language) {
            if (language == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/sql/dialects/SqlImportUtil$PatternItemsFactory", "<init>"));
            }
            this.myLanguage = language;
        }

        @NotNull
        public TreePatternNode.Group createNode(@Nullable List<ObjectName> name, @NotNull ObjectKind kind, TreePatternNode.Group ... groups) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/sql/dialects/SqlImportUtil$PatternItemsFactory", "createNode"));
            }
            TreePatternNode.Group group2 = TreePatternUtils.create(name, kind, groups);
            if (group2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/SqlImportUtil$PatternItemsFactory", "createNode"));
            }
            return group2;
        }

        @NotNull
        public TreePatternNode.Group createNode(@Nullable ObjectName name, @NotNull ObjectKind kind, TreePatternNode.Group ... groups) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/sql/dialects/SqlImportUtil$PatternItemsFactory", "createNode"));
            }
            TreePatternNode.Group group2 = this.createNode(name == null ? null : Collections.singletonList(name), kind, groups);
            if (group2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/SqlImportUtil$PatternItemsFactory", "createNode"));
            }
            return group2;
        }

        @Nullable
        public TreePatternNode.Group createNodeIfNotNull(@Nullable ObjectName name, @NotNull ObjectKind kind, TreePatternNode.Group ... groups) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/sql/dialects/SqlImportUtil$PatternItemsFactory", "createNodeIfNotNull"));
            }
            return name == null ? null : this.createNode(name, kind, groups);
        }

        @NotNull
        public TreePatternNode.Group createPositiveDatabase(@Nullable ObjectName name, TreePatternNode.Group ... groups) {
            TreePatternNode.Group group2 = this.createNode((ObjectName)ObjectUtils.chooseNotNull((Object)name, (Object)NON_MATCHING_NAME), ObjectKind.DATABASE, groups);
            if (group2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/SqlImportUtil$PatternItemsFactory", "createPositiveDatabase"));
            }
            return group2;
        }

        @NotNull
        public TreePatternNode.Group createDataSources(@Nullable DbDataSource dataSource, TreePatternNode.Group ... groups) {
            TreePatternNode.Group group2 = this.createNode(this.getDataSources(dataSource), DATA_SOURCE, groups);
            if (group2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/SqlImportUtil$PatternItemsFactory", "createDataSources"));
            }
            return group2;
        }

        @NotNull
        protected List<ObjectName> getDataSources(@Nullable DbDataSource ds) {
            List<ObjectName> list = ds == null ? Collections.singletonList(NON_MATCHING_NAME) : Arrays.asList(ObjectName.quoted((String)ds.getName()), NON_MATCHING_NAME);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/SqlImportUtil$PatternItemsFactory", "getDataSources"));
            }
            return list;
        }

        @NotNull
        public TreePattern createSimplePattern(@NotNull ObjectName[] names, @NotNull ObjectKind[] kinds) {
            if (names == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/intellij/sql/dialects/SqlImportUtil$PatternItemsFactory", "createSimplePattern"));
            }
            if (kinds == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kinds", "com/intellij/sql/dialects/SqlImportUtil$PatternItemsFactory", "createSimplePattern"));
            }
            assert (names.length == kinds.length);
            TreePatternNode.Group[] children = TreePatternNode.NO_GROUPS;
            for (int i2 = names.length - 1; i2 >= 0; --i2) {
                children = new TreePatternNode.Group[]{this.createNode(names[i2], kinds[i2], children)};
            }
            TreePattern treePattern = new TreePattern(children);
            if (treePattern == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/SqlImportUtil$PatternItemsFactory", "createSimplePattern"));
            }
            return treePattern;
        }
    }
}

