/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.functions;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.database.dialects.GenericDialect;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.sql.dialects.SqlDialectImplUtil;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.dialects.functions.SqlFunctionDefinitionParser;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlDmlInstruction;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlExpressionList;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlInfoElementType;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.impl.SqlCompletionUtil;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlScopeProcessor;
import com.intellij.sql.util.SqlTokenRegistry;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairConsumer;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlFunctionsUtil {
    private static final Key<SqlFunctionDefinition.Prototype> EXPLICIT_FUNCTION_PROTOTYPE = Key.create((String)"EXPLICIT_FUNCTION_PROTOTYPE");

    public static Map<String, SqlFunctionDefinition> loadFunctionDefinition(@NotNull SqlLanguageDialectEx dialect) {
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/sql/dialects/functions/SqlFunctionsUtil", "loadFunctionDefinition"));
        }
        THashMap map = ContainerUtil.newTroveMap((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
        try {
            Class<?> dialectClass = ((Object)((Object)dialect)).getClass();
            SqlFunctionDefinitionParser parser = new SqlFunctionDefinitionParser(dialect);
            for (SqlFunctionDefinition definition : parser.parse(SqlFunctionsUtil.getDialectFunctionDefinitions(dialectClass))) {
                SqlFunctionDefinition def = map.put(StringUtil.toUpperCase((String)definition.getName()), definition);
                assert (def == null) : definition.getName() + " already exists";
            }
        }
        catch (IOException e) {
            SqlDialectImplUtil.LOG.error((Throwable)e);
        }
        return map;
    }

    @NotNull
    public static String getDialectFunctionDefinitions(Class dialectClass) throws IOException {
        String string = SqlDialectImplUtil.loadDialectResource(dialectClass, "functions.xml");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/functions/SqlFunctionsUtil", "getDialectFunctionDefinitions"));
        }
        return string;
    }

    @Nullable
    public static SqlReferenceElementType getReferenceType(SqlFunctionDefinition.ReferenceParameter parameter) {
        return (SqlReferenceElementType)SqlTokenRegistry.findCompositeType((String)("SQL_" + parameter.getRefTypeName() + "_REFERENCE"));
    }

    public static boolean isAssignable(SqlFunctionDefinition.Parameter parameter, SqlExpression expression) {
        if (parameter instanceof SqlFunctionDefinition.ReferenceParameter) {
            SqlReferenceElementType refType = SqlFunctionsUtil.getReferenceType((SqlFunctionDefinition.ReferenceParameter)parameter);
            return refType == null || SqlScopeProcessor.acceptsElement(expression, SqlImplUtil.getSqlDialectSafe((PsiElement)expression), Collections.singleton(refType.getTargetKind()), false, false);
        }
        if (parameter instanceof SqlFunctionDefinition.SimpleParameter) {
            SqlFunctionDefinition.Type type = ((SqlFunctionDefinition.SimpleParameter)parameter).getType();
            SqlType exprType = expression.getSqlType();
            if (type == SqlFunctionDefinition.TABLE && exprType instanceof SqlTableType) {
                return true;
            }
            SqlType sqlType = type.getSqlType();
            return sqlType == null || SqlImplUtil.isAssignable(sqlType, exprType);
        }
        return false;
    }

    public static void setExplicitPrototype(@Nullable SqlExpression expr, SqlFunctionDefinition.Prototype prototype) {
        if (expr != null) {
            expr.putUserData(EXPLICIT_FUNCTION_PROTOTYPE, (Object)prototype);
        }
    }

    @Nullable
    public static SqlFunctionDefinition.Prototype chooseTheBestPrototype(SqlFunctionCallExpression expression, boolean returnTypeOnly) {
        SqlFunctionDefinition.Prototype explicitPrototype = (SqlFunctionDefinition.Prototype)expression.getUserData(EXPLICIT_FUNCTION_PROTOTYPE);
        if (explicitPrototype != null) {
            return explicitPrototype;
        }
        SqlFunctionDefinition definition = (SqlFunctionDefinition)((Object)ObjectUtils.tryCast((Object)expression.getFunctionDefinition(), SqlFunctionDefinition.class));
        if (definition == null) {
            return null;
        }
        if (returnTypeOnly) {
            SqlFunctionDefinition.Prototype cur = null;
            for (SqlFunctionDefinition.Prototype p : definition.getPrototypes()) {
                if (cur == null) {
                    cur = p;
                    continue;
                }
                if (Comparing.equal((Object)cur.getReturnType(), (Object)p.getReturnType())) continue;
                cur = null;
                break;
            }
            if (cur != null) {
                return cur;
            }
        }
        Map<SqlFunctionDefinition.Prototype, Map<PsiElement, SqlFunctionDefinition.Parameter>> map = SqlFunctionsUtil.getAcceptedPrototypes(definition, expression.getParameterList());
        SqlFunctionDefinition.Prototype maxMatched = null;
        int maxMatchedCount = -1;
        for (SqlFunctionDefinition.Prototype prototype : map.keySet()) {
            Map<PsiElement, SqlFunctionDefinition.Parameter> mapping = map.get(prototype);
            int count = 0;
            for (PsiElement element : mapping.keySet()) {
                if (!(element instanceof SqlExpression) || !SqlFunctionsUtil.isAssignable(mapping.get(element), (SqlExpression)element)) continue;
                ++count;
            }
            if (maxMatchedCount >= count) continue;
            maxMatchedCount = count;
            maxMatched = prototype;
        }
        return maxMatched;
    }

    @NotNull
    private static Map<SqlFunctionDefinition.Prototype, Map<PsiElement, SqlFunctionDefinition.Parameter>> getAcceptedPrototypes(@NotNull SqlFunctionDefinition definition, @Nullable SqlExpressionList parameterList) {
        if (definition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "definition", "com/intellij/sql/dialects/functions/SqlFunctionsUtil", "getAcceptedPrototypes"));
        }
        ASTNode[] nodes2 = SqlFunctionsUtil.getArgNodes(parameterList);
        LinkedHashMap result = ContainerUtil.newLinkedHashMap();
        for (SqlFunctionDefinition.Prototype prototype : definition.getPrototypes()) {
            LinkedHashMap map = ContainerUtil.newLinkedHashMap();
            SqlFunctionsUtil.mapArguments(prototype, nodes2, (PairProcessor<PsiElement, SqlFunctionDefinition.Parameter>)((PairProcessor)(psi, param) -> {
                map.put(psi, param);
                return true;
            }));
            if (map.isEmpty() && prototype.getParams().length != 0) continue;
            result.put(prototype, map);
        }
        LinkedHashMap linkedHashMap = result;
        if (linkedHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/functions/SqlFunctionsUtil", "getAcceptedPrototypes"));
        }
        return linkedHashMap;
    }

    public static boolean mapArguments(@NotNull SqlFunctionDefinition.Prototype prototype, @Nullable SqlExpressionList parameterList, @NotNull PairProcessor<PsiElement, SqlFunctionDefinition.Parameter> processor) {
        if (prototype == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prototype", "com/intellij/sql/dialects/functions/SqlFunctionsUtil", "mapArguments"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/sql/dialects/functions/SqlFunctionsUtil", "mapArguments"));
        }
        return SqlFunctionsUtil.mapArguments(prototype, SqlFunctionsUtil.getArgNodes(parameterList), processor);
    }

    private static ASTNode[] getArgNodes(@Nullable SqlExpressionList parameterList) {
        ASTNode astNode = parameterList == null ? null : parameterList.getNode();
        return astNode == null ? ASTNode.EMPTY_ARRAY : astNode.getChildren(null);
    }

    private static boolean mapArguments(@NotNull SqlFunctionDefinition.Prototype prototype, @NotNull ASTNode[] paramNodes, @NotNull PairProcessor<PsiElement, SqlFunctionDefinition.Parameter> processor) {
        if (prototype == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prototype", "com/intellij/sql/dialects/functions/SqlFunctionsUtil", "mapArguments"));
        }
        if (paramNodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paramNodes", "com/intellij/sql/dialects/functions/SqlFunctionsUtil", "mapArguments"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/sql/dialects/functions/SqlFunctionsUtil", "mapArguments"));
        }
        if (paramNodes.length == 0) {
            return true;
        }
        PsiElement prev = null;
        for (ASTNode node : paramNodes) {
            Object value = SqlInfoElementType.getValue(node);
            if (!(value instanceof SqlFunctionDefinition.Parameter)) {
                PsiElement psi = node.getPsi();
                if (psi instanceof PsiWhiteSpace || psi instanceof PsiComment) continue;
                prev = psi;
                continue;
            }
            int prototypeId = ((SqlFunctionDefinition.Parameter)value).getPrototypeId();
            if (prev == null || prototypeId != prototype.getPrototypeId() && prototypeId != -1 || processor.process((Object)prev, (Object)((SqlFunctionDefinition.Parameter)value))) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static Number getSignatureNumber(@NotNull SqlFunctionCallExpression o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/sql/dialects/functions/SqlFunctionsUtil", "getSignatureNumber"));
        }
        SyntaxTraverser.ApiEx api = SyntaxTraverser.psiApiReversed();
        SqlExpressionList params2 = o.getParameterList();
        return params2 == null ? (Number)null : (Number)((Number)api.children((Object)params2).transform(SqlInfoElementType::getValue).filter(Number.class).first());
    }

    @NotNull
    public static List<DasRoutine> getNonPredefSignatures(@NotNull SqlFunctionCallExpression o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/sql/dialects/functions/SqlFunctionsUtil", "getNonPredefSignatures"));
        }
        List nonPredefSigs = ContainerUtil.newSmartList();
        SqlReferenceExpression nameElement = o.getNameElement();
        if (nameElement != null) {
            for (ResolveResult resolve : nameElement.multiResolve(false)) {
                if (resolve.getElement() == o) continue;
                ContainerUtil.addIfNotNull((Collection)nonPredefSigs, (Object)ObjectUtils.tryCast((Object)resolve.getElement(), DasRoutine.class));
            }
        }
        List list = nonPredefSigs;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/functions/SqlFunctionsUtil", "getNonPredefSignatures"));
        }
        return list;
    }

    @Nullable
    public static SqlFunctionDefinition.Prototype findExactPredefinedFunction(@NotNull SqlFunctionCallExpression o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/sql/dialects/functions/SqlFunctionsUtil", "findExactPredefinedFunction"));
        }
        SqlReferenceExpression nameElement = o.getNameElement();
        SqlFunctionDefinition def = (SqlFunctionDefinition)((Object)ObjectUtils.tryCast((Object)o.getFunctionDefinition(), SqlFunctionDefinition.class));
        if (nameElement == null || nameElement.getQualifierExpression() != null || def == null) {
            return null;
        }
        Number sigNum = SqlFunctionsUtil.getSignatureNumber(o);
        if (sigNum == null) {
            return null;
        }
        int idx = sigNum.intValue();
        SqlFunctionDefinition.Prototype[] prototypes = def.getPrototypes();
        return idx >= 0 && idx < prototypes.length ? prototypes[idx] : null;
    }

    @Nullable
    public static DasRoutine findSignature(@Nullable SqlExpressionList args, @NotNull List<DasRoutine> protos) {
        if (protos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "protos", "com/intellij/sql/dialects/functions/SqlFunctionsUtil", "findSignature"));
        }
        return (DasRoutine)ContainerUtil.getFirstItem(protos);
    }

    @NotNull
    public static ExpressionList[] getOverloads(@NotNull SqlFunctionCallExpression call) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/intellij/sql/dialects/functions/SqlFunctionsUtil", "getOverloads"));
        }
        SqlReferenceExpression element = call.getNameElement();
        boolean notBuiltin = element != null && element.getQualifierExpression() != null;
        ArrayList prototypes = ContainerUtil.newArrayList();
        SqlFunctionDefinition def = notBuiltin ? null : (SqlFunctionDefinition)((Object)ObjectUtils.tryCast((Object)call.getFunctionDefinition(), SqlFunctionDefinition.class));
        boolean anyMatched = false;
        if (def != null) {
            Number number = SqlFunctionsUtil.getSignatureNumber(call);
            for (SqlFunctionDefinition.Prototype proto : def.getPrototypes()) {
                boolean matched = number != null && number.intValue() == proto.getPrototypeId();
                anyMatched |= matched;
                prototypes.add(new BuiltinPrototypeWrapper(call, proto, matched));
            }
        }
        for (DasRoutine routine2 : SqlFunctionsUtil.getNonPredefSignatures(call)) {
            prototypes.add(new RoutineWrapper(call, routine2, !anyMatched));
        }
        ExpressionList[] expressionListArray = prototypes.toArray(new ExpressionList[prototypes.size()]);
        if (expressionListArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/functions/SqlFunctionsUtil", "getOverloads"));
        }
        return expressionListArray;
    }

    @NotNull
    public static ExpressionList[] getInsertVariants(@NotNull SqlDmlInstruction instruction, @NotNull SqlExpressionList expr) {
        if (instruction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "com/intellij/sql/dialects/functions/SqlFunctionsUtil", "getInsertVariants"));
        }
        if (expr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expr", "com/intellij/sql/dialects/functions/SqlFunctionsUtil", "getInsertVariants"));
        }
        ArrayList lists = ContainerUtil.newArrayList();
        SqlTableType targetType = instruction.getTargetType();
        lists.add(new ArrayList());
        for (int i2 = 0; i2 < targetType.getColumnCount(); ++i2) {
            String columnType = null;
            boolean skip = false;
            if (StringUtil.isNotEmpty((String)targetType.getColumnType(i2).getDisplayName())) {
                PsiElement resolve;
                PsiElement columnElement = targetType.getColumnElement(i2);
                PsiElement psiElement = resolve = columnElement instanceof SqlReferenceExpression ? ((SqlReferenceExpression)columnElement).resolve() : null;
                if (resolve instanceof DasColumn) {
                    columnType = ((DasColumn)resolve).getDataType().getSpecification();
                } else if (columnElement instanceof DasColumn) {
                    columnType = ((DasColumn)columnElement).getDataType().getSpecification();
                    skip = DasUtil.isAutoVal((DasColumn)((DasColumn)columnElement));
                } else {
                    columnType = targetType.getColumnType(i2).getDisplayName();
                }
            }
            if (skip) {
                lists.add(ContainerUtil.newArrayList((Iterable)((Iterable)lists.get(lists.size() - 1))));
            }
            Pair pair = Pair.create((Object)targetType.getColumnName(i2), columnType);
            for (int j = 0; j < lists.size(); ++j) {
                if (j == lists.size() - 1 && skip) continue;
                ((List)lists.get(j)).add(pair);
            }
        }
        ArrayList res = ContainerUtil.newArrayListWithCapacity((int)lists.size());
        for (List list : lists) {
            res.add(new ColumnListWrapper(list, expr));
        }
        ExpressionList[] expressionListArray = res.toArray(new ExpressionList[res.size()]);
        if (expressionListArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/functions/SqlFunctionsUtil", "getInsertVariants"));
        }
        return expressionListArray;
    }

    @NotNull
    public static ExpressionList[] getCreateTable(@NotNull SqlCreateStatement createStatement, @NotNull SqlExpressionList expr) {
        ExpressionList[] expressionListArray;
        if (createStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "createStatement", "com/intellij/sql/dialects/functions/SqlFunctionsUtil", "getCreateTable"));
        }
        if (expr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expr", "com/intellij/sql/dialects/functions/SqlFunctionsUtil", "getCreateTable"));
        }
        ArrayList pairs = ContainerUtil.newArrayList();
        for (DasColumn column : DasUtil.getColumns((DasObject)createStatement)) {
            String type = column.getDataType().getSpecification();
            pairs.add(Pair.create((Object)column.getName(), (Object)(StringUtil.isNotEmpty((String)type) ? type : null)));
        }
        if (pairs.isEmpty()) {
            expressionListArray = new ExpressionList[]{};
        } else {
            ExpressionList[] expressionListArray2 = new ExpressionList[1];
            expressionListArray = expressionListArray2;
            expressionListArray2[0] = new ColumnListWrapper(pairs, expr);
        }
        if (expressionListArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/functions/SqlFunctionsUtil", "getCreateTable"));
        }
        return expressionListArray;
    }

    public static class ColumnListWrapper
    implements ExpressionList {
        private final List<Pair<String, String>> myColumns;
        private final SqlExpressionList myList;

        public ColumnListWrapper(@NotNull List<Pair<String, String>> columns, @NotNull SqlExpressionList list) {
            if (columns == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/sql/dialects/functions/SqlFunctionsUtil$ColumnListWrapper", "<init>"));
            }
            if (list == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/sql/dialects/functions/SqlFunctionsUtil$ColumnListWrapper", "<init>"));
            }
            this.myColumns = columns;
            this.myList = list;
        }

        @Override
        public boolean isMatched() {
            return true;
        }

        @Override
        public boolean isValid() {
            return this.myList.isValid();
        }

        @Override
        public boolean buildText(@NotNull StringBuilder sb, int paramIdx, int[] paramRange) {
            if (sb == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sb", "com/intellij/sql/dialects/functions/SqlFunctionsUtil$ColumnListWrapper", "buildText"));
            }
            for (int i2 = 0; i2 < this.myColumns.size(); ++i2) {
                if (i2 > 0) {
                    sb.append(", ");
                }
                if (i2 == paramIdx) {
                    paramRange[0] = sb.length();
                }
                Pair<String, String> pair = this.myColumns.get(i2);
                sb.append((String)pair.first);
                if (StringUtil.isNotEmpty((String)((String)pair.second))) {
                    sb.append(":").append((String)pair.second);
                }
                if (i2 != paramIdx) continue;
                paramRange[1] = sb.length();
            }
            if (sb.length() == 0) {
                sb.append(CodeInsightBundle.message((String)"parameter.info.no.parameters", (Object[])new Object[0]));
            }
            return true;
        }

        @Override
        public boolean processArgumentTypes(@NotNull PairProcessor<PsiElement, String> processor) {
            if (processor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/sql/dialects/functions/SqlFunctionsUtil$ColumnListWrapper", "processArgumentTypes"));
            }
            List expressions = this.myList.getExpressionList();
            Iterator psiIt = expressions.iterator();
            Iterator<Pair<String, String>> typeIt = this.myColumns.iterator();
            while (typeIt.hasNext() && psiIt.hasNext()) {
                SqlExpression psi = (SqlExpression)psiIt.next();
                Pair<String, String> type = typeIt.next();
                if (processor.process((Object)psi, type.second)) continue;
                return false;
            }
            return true;
        }
    }

    public static class RoutineWrapper
    implements ExpressionList {
        private final SqlFunctionCallExpression myCallExpression;
        private final DasRoutine myRoutine;
        private final boolean myMatched;

        public RoutineWrapper(@NotNull SqlFunctionCallExpression callExpression, @NotNull DasRoutine routine2, boolean matched) {
            if (callExpression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "com/intellij/sql/dialects/functions/SqlFunctionsUtil$RoutineWrapper", "<init>"));
            }
            if (routine2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "routine", "com/intellij/sql/dialects/functions/SqlFunctionsUtil$RoutineWrapper", "<init>"));
            }
            this.myCallExpression = callExpression;
            this.myRoutine = routine2;
            this.myMatched = matched;
        }

        @Override
        public boolean isMatched() {
            return this.myMatched;
        }

        @Override
        public boolean isValid() {
            return this.myCallExpression.isValid();
        }

        @Override
        public boolean buildText(@NotNull StringBuilder sb, int paramIdx, int[] paramRange) {
            if (sb == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sb", "com/intellij/sql/dialects/functions/SqlFunctionsUtil$RoutineWrapper", "buildText"));
            }
            ASTNode[] astNodes = SqlFunctionsUtil.getArgNodes(this.myCallExpression.getParameterList());
            int selectedIndex = paramIdx == -1 ? (astNodes.length == 0 ? 0 : astNodes.length - 1) : paramIdx;
            DasArgument returnArg = this.myRoutine.getReturnArgument();
            PsiFile file = this.myCallExpression.getContainingFile();
            GenericDialect dialect = file instanceof SqlFile ? ((SqlFile)file).getSqlLanguage().getDatabaseDialect() : GenericDialect.INSTANCE;
            DdlBuilder ddlBuilder = new DdlBuilder(sb).applyCodeStyle(this.myCallExpression.getProject()).withDialect(dialect);
            int i2 = 0;
            JBIterable parameters = DasUtil.getParameters((DasRoutine)this.myRoutine);
            for (DasArgument o : parameters) {
                if (o.getArgumentDirection() == DasArgument.Direction.OUT) continue;
                if (i2 > 0) {
                    sb.append(", ");
                }
                if (i2 == selectedIndex) {
                    paramRange[0] = sb.length();
                }
                ddlBuilder.identifier((String)ObjectUtils.notNull((Object)o.getName(), (Object)"")).symbol(":").keyword(o.getDataType().getSpecification());
                if (i2 == selectedIndex) {
                    paramRange[1] = sb.length();
                }
                ++i2;
            }
            if (returnArg != null) {
                sb.append(":");
                SqlCompletionUtil.addParametersPresentableText(ddlBuilder, Collections.singleton(returnArg), true, false);
            }
            return true;
        }

        @Override
        public boolean processArgumentTypes(@NotNull PairProcessor<PsiElement, String> processor) {
            if (processor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/sql/dialects/functions/SqlFunctionsUtil$RoutineWrapper", "processArgumentTypes"));
            }
            SqlExpressionList list = this.myCallExpression.getParameterList();
            List expressions = list == null ? Collections.emptyList() : list.getExpressionList();
            Iterator psiIt = expressions.iterator();
            Iterator parIt = DasUtil.getParameters((DasRoutine)this.myRoutine).iterator();
            while (parIt.hasNext() && psiIt.hasNext()) {
                SqlExpression psi = (SqlExpression)psiIt.next();
                DasArgument par = (DasArgument)parIt.next();
                if (processor.process((Object)psi, (Object)par.getDataType().typeName)) continue;
                return false;
            }
            return true;
        }
    }

    public static class BuiltinPrototypeWrapper
    implements ExpressionList {
        private final SqlFunctionCallExpression myCallExpression;
        private final SqlFunctionDefinition.Prototype myPrototype;
        private final boolean myMatched;

        public BuiltinPrototypeWrapper(@NotNull SqlFunctionCallExpression callExpression, @NotNull SqlFunctionDefinition.Prototype prototype, boolean matched) {
            if (callExpression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "com/intellij/sql/dialects/functions/SqlFunctionsUtil$BuiltinPrototypeWrapper", "<init>"));
            }
            if (prototype == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prototype", "com/intellij/sql/dialects/functions/SqlFunctionsUtil$BuiltinPrototypeWrapper", "<init>"));
            }
            this.myCallExpression = callExpression;
            this.myPrototype = prototype;
            this.myMatched = matched;
        }

        @Override
        public boolean isValid() {
            return this.myCallExpression.isValid();
        }

        @Override
        public boolean isMatched() {
            return this.myMatched;
        }

        @Override
        public boolean buildText(@NotNull StringBuilder sb, final int paramIdx, int[] paramRange) {
            if (sb == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sb", "com/intellij/sql/dialects/functions/SqlFunctionsUtil$BuiltinPrototypeWrapper", "buildText"));
            }
            HashMap map = ContainerUtil.newHashMap();
            final Ref selectedParam = Ref.create((Object)ArrayUtil.getFirstElement((Object[])this.myPrototype.getParams()));
            SqlFunctionsUtil.mapArguments(this.myPrototype, this.myCallExpression.getParameterList(), new PairProcessor<PsiElement, SqlFunctionDefinition.Parameter>(){
                int i = 0;

                public boolean process(PsiElement element, SqlFunctionDefinition.Parameter parameter) {
                    selectedParam.set((Object)parameter);
                    return this.i++ != paramIdx;
                }
            });
            this.myPrototype.toString(sb, (PairConsumer<SqlFunctionDefinition.Parameter, Boolean>)((PairConsumer)(parameter, start) -> {
                if (sb == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sb", "com/intellij/sql/dialects/functions/SqlFunctionsUtil$BuiltinPrototypeWrapper", "lambda$buildText$0"));
                }
                if (parameter == selectedParam.get() && selectedParam.get() != SqlFunctionDefinition.COMMA) {
                    paramRange[start.booleanValue() ? 0 : 1] = sb.length();
                }
            }));
            sb.append(":").append(this.myPrototype.getReturnType());
            return !map.isEmpty() || this.myPrototype.getParams().length == 0;
        }

        @Override
        public boolean processArgumentTypes(@NotNull PairProcessor<PsiElement, String> processor) {
            if (processor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/sql/dialects/functions/SqlFunctionsUtil$BuiltinPrototypeWrapper", "processArgumentTypes"));
            }
            return SqlFunctionsUtil.mapArguments(this.myPrototype, this.myCallExpression.getParameterList(), (PairProcessor<PsiElement, SqlFunctionDefinition.Parameter>)((PairProcessor)(psi, param) -> {
                if (processor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/sql/dialects/functions/SqlFunctionsUtil$BuiltinPrototypeWrapper", "lambda$processArgumentTypes$1"));
                }
                SqlFunctionDefinition.SimpleParameter sparam = (SqlFunctionDefinition.SimpleParameter)ObjectUtils.tryCast((Object)param, SqlFunctionDefinition.SimpleParameter.class);
                if (sparam != null) {
                    return processor.process(psi, (Object)sparam.getType().getDisplayName());
                }
                return true;
            }));
        }
    }

    public static interface ExpressionList {
        public boolean isMatched();

        public boolean isValid();

        public boolean buildText(@NotNull StringBuilder var1, int var2, int[] var3);

        public boolean processArgumentTypes(@NotNull PairProcessor<PsiElement, String> var1);
    }
}

