/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.generic;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoFilter;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.codeInsight.highlighting.HighlightErrorFilter;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.sql.dialects.generic.GenericDialect;
import com.intellij.sql.psi.SqlFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenericDialectErrorFilter
extends HighlightErrorFilter
implements HighlightInfoFilter {
    public boolean shouldHighlightErrorElement(@NotNull PsiErrorElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/dialects/generic/GenericDialectErrorFilter", "shouldHighlightErrorElement"));
        }
        if (!(element.getContainingFile() instanceof SqlFile)) {
            return true;
        }
        return DbSqlUtil.getSqlDialect((PsiElement)element) != GenericDialect.INSTANCE;
    }

    public boolean accept(@NotNull HighlightInfo highlightInfo, @Nullable PsiFile file) {
        if (highlightInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlightInfo", "com/intellij/sql/dialects/generic/GenericDialectErrorFilter", "accept"));
        }
        if (UpdateHighlightersUtil.isFileLevelOrGutterAnnotation((HighlightInfo)highlightInfo)) {
            return true;
        }
        if (!(file instanceof SqlFile) || DbSqlUtil.getSqlDialect((PsiElement)file) != GenericDialect.INSTANCE) {
            return true;
        }
        return highlightInfo.getSeverity().compareTo(HighlightSeverity.WARNING) < 0;
    }
}

