/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.sqlite;

import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.psi.DbDataSource;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.ReservedEntity;
import com.intellij.sql.dialects.SqlDialectImplUtil;
import com.intellij.sql.dialects.SqlImportUtil;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.TreePattern;
import com.intellij.sql.dialects.TreePatternNode;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.dialects.sqlite.SqliteReservedKeywords;
import com.intellij.sql.dialects.sqlite.SqliteTokens;
import com.intellij.sql.dialects.sqlite.SqliteTypes;
import com.intellij.sql.editor.SqlCloseBlockProcessorImpl;
import com.intellij.sql.editor.SqlEnterHandlerImpl;
import com.intellij.sql.editor.SubstitutionDescriptorImpl;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlKeywordTokenType;
import com.intellij.sql.psi.impl.SqlScopeProcessor;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.sql.util.SqlTokenRegistry;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqliteDialect
extends SqlLanguageDialectEx {
    public static final SqliteDialect INSTANCE = new SqliteDialect();

    public SqliteDialect() {
        super("SQLite");
    }

    @Override
    @NotNull
    public DatabaseDialectEx getDatabaseDialect() {
        com.intellij.database.dialects.SqliteDialect sqliteDialect = com.intellij.database.dialects.SqliteDialect.INSTANCE;
        if (sqliteDialect == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/sqlite/SqliteDialect", "getDatabaseDialect"));
        }
        return sqliteDialect;
    }

    public boolean isReservedKeyword(IElementType tokenType) {
        return tokenType instanceof SqlKeywordTokenType && LazyData.ourReservedTokens.fun((Object)tokenType.toString()) != null;
    }

    @Override
    @NotNull
    public Map<String, SqlFunctionDefinition> getSupportedFunctions() {
        Map<String, SqlFunctionDefinition> map = LazyData.ourFunctionMap;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/sqlite/SqliteDialect", "getSupportedFunctions"));
        }
        return map;
    }

    public boolean isOperatorSupported(IElementType tokenType) {
        return LazyData.ourSupportedOperators.contains(tokenType);
    }

    @NotNull
    public Set<String> getKeywords() {
        Set set = SqlTokenRegistry.getTokens(SqliteTokens.class);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/sqlite/SqliteDialect", "getKeywords"));
        }
        return set;
    }

    @NotNull
    public Set<String> getSystemVariables() {
        Set<String> set = LazyData.ourSystemVars;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/sqlite/SqliteDialect", "getSystemVariables"));
        }
        return set;
    }

    @Override
    public boolean processReservedEntitiesWithType(@Nullable String name, @NotNull PsiElement element, boolean resolve, @NotNull SqlScopeProcessor processor) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/dialects/sqlite/SqliteDialect", "processReservedEntitiesWithType"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/sql/dialects/sqlite/SqliteDialect", "processReservedEntitiesWithType"));
        }
        if (SqlImplUtil.equalsInsensetiveOrTrue(name, LazyData.RE_SQLITE_MASTER.name, resolve) && !processor.executeTarget((DasObject)LazyData.RE_SQLITE_MASTER, element, (SqlType)SqlTableTypeBase.EMPTY_TABLE, false, ResolveState.initial())) {
            return false;
        }
        if (processor.getExpectedTypes().contains(ObjectKind.COLUMN)) {
            if (!SqliteDialect.processReservedEntitiesWithTypeSimple((DasObject)LazyData.RE_OID, (SqlType)SqlType.INTEGER, name, element, resolve, processor, true, false)) {
                return false;
            }
            if (!SqliteDialect.processReservedEntitiesWithTypeSimple((DasObject)LazyData.RE_ROWID, (SqlType)SqlType.INTEGER, name, element, resolve, processor, true, false)) {
                return false;
            }
            if (!SqliteDialect.processReservedEntitiesWithTypeSimple((DasObject)LazyData.RE_ROWID2, (SqlType)SqlType.INTEGER, name, element, resolve, processor, true, false)) {
                return false;
            }
        }
        if (processor.getExpectedTypes().contains(SqlDbElementType.ANY) && element instanceof SqlReferenceExpression) {
            for (DasObject function : LazyData.COLLATE_FUNCTIONS.values()) {
                if (SqliteDialect.processReservedEntitiesWithTypeSimple(function, (SqlType)SqlType.REFERENCE, name, element, resolve, processor, false, false)) continue;
                return false;
            }
        }
        return super.processReservedEntitiesWithType(name, element, resolve, processor);
    }

    @Override
    @Nullable
    public TreePattern getBaseImports(@Nullable DbDataSource dataSource) {
        SqlImportUtil.PatternItemsFactory f = new SqlImportUtil.PatternItemsFactory(this);
        return new TreePattern(f.createDataSources(dataSource, f.createNode(Arrays.asList(ObjectName.plain((String)"main"), ObjectName.plain((String)"temp")), ObjectKind.SCHEMA, new TreePatternNode.Group[0])));
    }

    @Override
    @Nullable
    public EnterHandlerDelegate getEnterHandler() {
        return LazyData.ENTER_HANDLER;
    }

    private static class LazyData {
        static final Map<String, SqlFunctionDefinition> ourFunctionMap = Collections.unmodifiableMap(SqlFunctionsUtil.loadFunctionDefinition(INSTANCE));
        static final Set<String> ourSystemVars = Collections.unmodifiableSet(SqlDialectImplUtil.loadSystemVars(INSTANCE));
        static final NullableFunction<String, IElementType> ourReservedTokens = SqlTokenRegistry.getTokenProvider(SqliteReservedKeywords.class);
        static final Set<IElementType> ourSupportedOperators = ContainerUtil.newTroveSet((Object[])new IElementType[]{SqlTokens.SQL_OP_PLUS, SqlTokens.SQL_OP_MINUS, SqlTokens.SQL_OP_MUL, SqlTokens.SQL_OP_DIV, SqlTokens.SQL_OP_NEQ, SqlTokens.SQL_OP_LE, SqlTokens.SQL_OP_LT, SqlTokens.SQL_OP_GE, SqlTokens.SQL_OP_EQ, SqlTokens.SQL_OP_GT, SqlTokens.SQL_OP_CONCAT, SqlTokens.SQL_AND, SqlTokens.SQL_NOT, SqlTokens.SQL_OR, SqlTokens.SQL_IS, SqlTokens.SQL_LIKE, SqlTokens.SQL_COLLATE, SqlTokens.SQL_IN, SqlTokens.SQL_OP_INVERT, SqlTokens.SQL_OP_BITWISE_AND, SqlTokens.SQL_OP_BITWISE_OR, SqlTokens.SQL_OP_LEFT_SHIFT, SqlTokens.SQL_OP_RIGHT_SHIFT, SqlTokens.SQL_OP_MODULO, SqlTokens.SQL_OP_NEQ2, SqliteTypes.SQLITE_MATCH, SqliteTypes.SQLITE_REGEXP, SqliteTypes.SQLITE_GLOB, SqlTokens.SQL_OP_EQEQ, SqliteTypes.SQLITE_ISNULL, SqliteTypes.SQLITE_NOTNULL});
        static final Map<String, DasObject> COLLATE_FUNCTIONS = SqlDialectImplUtil.buildEntities(ObjectKind.ROUTINE, "nocase", "rtrim", "binary");
        static final ReservedEntity RE_SQLITE_MASTER = new ReservedEntity("sqlite_master", ObjectKind.TABLE);
        static final ReservedEntity RE_OID = new ReservedEntity("OID", ObjectKind.COLUMN);
        static final ReservedEntity RE_ROWID = new ReservedEntity("ROWID", ObjectKind.COLUMN);
        static final ReservedEntity RE_ROWID2 = new ReservedEntity("_ROWID_", ObjectKind.COLUMN);
        private static final EnterHandlerDelegate ENTER_HANDLER = new SqlEnterHandlerImpl(new SqlCloseBlockProcessorImpl(new SubstitutionDescriptorImpl(new IElementType[]{SqlTokens.SQL_BEGIN, SqlCompositeElementTypes.SQL_CREATE_TRIGGER_STATEMENT}, "", "end;", 1, SubstitutionDescriptorImpl.TailCheck.tail(new IElementType[]{SqlTokens.SQL_END, SqlTokens.SQL_SEMICOLON}).mask(true, false))));

        private LazyData() {
        }
    }
}

