/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.intentions;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.injection.SqlTypeBasedInjectionSupport;
import com.intellij.sql.injection.SqlTypeBasedInjector;
import com.intellij.sql.intentions.SqlIntentionActionBase;
import com.intellij.sql.psi.SqlElement;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.intellij.plugins.intelliLang.inject.InjectLanguageAction;
import org.intellij.plugins.intelliLang.inject.InjectorUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class SqlInjectByTypeIntention
extends SqlIntentionActionBase {
    private static Set<String> getTypes(@NotNull Project project, @NotNull PsiElement element) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/sql/intentions/SqlInjectByTypeIntention", "getTypes"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/intentions/SqlInjectByTypeIntention", "getTypes"));
        }
        if (!(element instanceof SqlElement)) {
            return Collections.emptySet();
        }
        PsiLanguageInjectionHost host = (PsiLanguageInjectionHost)PsiTreeUtil.getParentOfType((PsiElement)element, PsiLanguageInjectionHost.class, (boolean)false);
        if (host == null) {
            return Collections.emptySet();
        }
        List files = InjectedLanguageManager.getInstance((Project)project).getInjectedPsiFiles((PsiElement)host);
        if (!ContainerUtil.isEmpty((Collection)files)) {
            return Collections.emptySet();
        }
        return SqlTypeBasedInjector.getTypesFor(host);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/sql/intentions/SqlInjectByTypeIntention", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/intentions/SqlInjectByTypeIntention", "isAvailable"));
        }
        return !ContainerUtil.isEmpty(SqlInjectByTypeIntention.getTypes(project, element));
    }

    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/intentions/SqlInjectByTypeIntention", "getText"));
        }
        return string;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/sql/intentions/SqlInjectByTypeIntention", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/intentions/SqlInjectByTypeIntention", "invoke"));
        }
        Set<String> types = SqlInjectByTypeIntention.getTypes(project, element);
        if (ContainerUtil.isEmpty(types)) {
            return;
        }
        SqlTypeBasedInjectionSupport support = (SqlTypeBasedInjectionSupport)((Object)ObjectUtils.tryCast((Object)InjectorUtils.findInjectionSupport((String)"sql"), SqlTypeBasedInjectionSupport.class));
        if (support == null) {
            return;
        }
        InjectLanguageAction.doChooseLanguageToInject((Editor)editor, injectable -> {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/intentions/SqlInjectByTypeIntention", "lambda$invoke$0"));
            }
            if (injectable.getLanguage() == null) {
                return false;
            }
            return support.configureInjectionForTypes(element.getProject(), injectable.getLanguage(), types);
        });
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        if ("Inject by Type" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/intentions/SqlInjectByTypeIntention", "getFamilyName"));
        }
        return "Inject by Type";
    }
}

