/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.sql.psi.SqlResolveResult;
import com.intellij.sql.psi.impl.SqlFileImpl;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlResolveResultImpl
extends PsiElementResolveResult
implements SqlResolveResult {
    private final PsiElement myQualifier;
    private static final Condition<Pair<PsiElement, PsiElement>> IS_FAKE = pair -> {
        SqlFileImpl.FakeDefinition fake = (SqlFileImpl.FakeDefinition)((Object)((Object)ObjectUtils.tryCast((Object)pair.second, SqlFileImpl.FakeDefinition.class)));
        return fake != null && fake.delegates().isEmpty();
    };
    private static final Condition<Pair<PsiElement, PsiElement>> IS_NOT_FAKE = Conditions.not(IS_FAKE);

    public SqlResolveResultImpl(@Nullable PsiElement qualifier, @NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/psi/impl/SqlResolveResultImpl", "<init>"));
        }
        super(element);
        this.myQualifier = qualifier;
    }

    @Nullable
    public PsiElement getQualifier() {
        return this.myQualifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SqlResolveResultImpl result = (SqlResolveResultImpl)((Object)o);
        return !(this.myQualifier != null ? !this.myQualifier.equals(result.myQualifier) : result.myQualifier != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.myQualifier != null ? this.myQualifier.hashCode() : 0);
        return result;
    }

    public static SqlResolveResult[] createSingleSqlResults(@Nullable PsiElement qualifier, @NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/psi/impl/SqlResolveResultImpl", "createSingleSqlResults"));
        }
        return new SqlResolveResult[]{new SqlResolveResultImpl(qualifier, element)};
    }

    public static SqlResolveResult[] createSqlResults(@NotNull Collection<Pair<PsiElement, PsiElement>> qualified) {
        if (qualified == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualified", "com/intellij/sql/psi/impl/SqlResolveResultImpl", "createSqlResults"));
        }
        SqlResolveResult[] res = new SqlResolveResult[qualified.size()];
        int i2 = 0;
        JBIterable reordered = JBIterable.from(qualified);
        reordered = reordered.filter(IS_NOT_FAKE).append((Iterable)reordered.filter(IS_FAKE));
        for (Pair pair : reordered) {
            res[i2++] = new SqlResolveResultImpl((PsiElement)pair.first, (PsiElement)pair.second);
        }
        return res;
    }
}

