/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.script;

import com.intellij.extapi.psi.ASTWrapperPsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTTokenNode;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.TreeBackedLighterAST;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.IdentityCharTable;
import com.intellij.psi.impl.source.tree.PsiWhiteSpaceImpl;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.ILazyParseableElementType;
import com.intellij.sql.script.ReadOnlyASTNode;
import com.intellij.util.CharTable;
import com.intellij.util.Function;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TraverserBasedASTNode<N>
extends ReadOnlyASTNode {
    protected final N myNode;
    protected final SyntaxTraverser<N> myTraverser;
    private final AtomicReference<Meta> myMeta;

    public static <N> FileASTNode createFileNode(@NotNull SyntaxTraverser<N> traverser, @NotNull N node, @NotNull Getter<PsiFile> fileGetter) {
        if (traverser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "traverser", "com/intellij/sql/script/TraverserBasedASTNode", "createFileNode"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/sql/script/TraverserBasedASTNode", "createFileNode"));
        }
        if (fileGetter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileGetter", "com/intellij/sql/script/TraverserBasedASTNode", "createFileNode"));
        }
        return new FileNode<N>(traverser, node, fileGetter);
    }

    public TraverserBasedASTNode(TraverserBasedASTNode<?> parent, int index, @NotNull SyntaxTraverser<N> traverser, @NotNull N node) {
        if (traverser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "traverser", "com/intellij/sql/script/TraverserBasedASTNode", "<init>"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/sql/script/TraverserBasedASTNode", "<init>"));
        }
        super(parent, index);
        this.myMeta = new AtomicReference();
        this.myTraverser = traverser;
        this.myNode = node;
        this.myMeta.set(new Meta(parent, null, null));
    }

    @NotNull
    public IElementType getElementType() {
        IElementType iElementType = this.myTraverser.api.typeOf(this.myNode);
        if (iElementType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/script/TraverserBasedASTNode", "getElementType"));
        }
        return iElementType;
    }

    @NotNull
    public CharSequence getChars() {
        CharSequence charSequence = this.myTraverser.api.textOf(this.myNode);
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/script/TraverserBasedASTNode", "getChars"));
        }
        return charSequence;
    }

    public TextRange getTextRange() {
        return this.myTraverser.api.rangeOf(this.myNode);
    }

    @Override
    public List<ASTNode> getChildList() {
        List<ASTNode> kids = this.myMeta.get().kids;
        if (kids != null) {
            return kids;
        }
        this.myMeta.set(this.myMeta.get().withKids(this.childrenImpl()));
        return this.myMeta.get().kids;
    }

    public List<ASTNode> childrenImpl() {
        List children = this.myTraverser.children(this.myNode).transform(this.CHILD_TRANSFORM(this.myTraverser, 0)).toList();
        if (!children.isEmpty() || this.getTreeParent() == null) {
            return children;
        }
        IElementType type = this.myTraverser.api.typeOf(this.myNode);
        if (!(type instanceof ILazyParseableElementType)) {
            return children;
        }
        PsiBuilder builder = ((ILazyParseableElementType)type).parseLight((ASTNode)this);
        SyntaxTraverser s = SyntaxTraverser.lightTraverser((PsiBuilder)builder);
        int shift = this.myTraverser.api.rangeOf(this.myNode).getStartOffset();
        return s.api.children(s.getRoot()).transform(this.CHILD_TRANSFORM(s, shift)).toList();
    }

    @NotNull
    protected <NN> TraverserBasedASTNode<NN> createChildNode(int index, NN input, SyntaxTraverser<NN> s, int shift) {
        TraverserBasedASTNode<NN> traverserBasedASTNode = shift == 0 ? new TraverserBasedASTNode<NN>(this, index, s, input) : new ShiftedNode<NN>(this, index, shift, s, input);
        if (traverserBasedASTNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/script/TraverserBasedASTNode", "createChildNode"));
        }
        return traverserBasedASTNode;
    }

    public PsiElement getPsi() {
        PsiElement psi = this.myMeta.get().psi;
        if (psi != null) {
            return psi;
        }
        this.myMeta.set(this.myMeta.get().withPsi(this.getPsiImpl()));
        return this.myMeta.get().psi;
    }

    public PsiElement getPsiImpl() {
        IElementType type = this.getElementType();
        ParserDefinition pd = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(type.getLanguage());
        if (pd != null && pd.getWhitespaceTokens().contains(type) || pd == null && type == TokenType.WHITE_SPACE) {
            return new PsiWhiteSpaceImpl(this.getChars());
        }
        if (pd != null && pd.getCommentTokens().contains(type)) {
            return new ASTWrapperPsiComment(this);
        }
        if (pd == null || this.myNode instanceof LighterASTTokenNode) {
            return new ASTWrapperPsiElement((ASTNode)this);
        }
        return pd.createElement((ASTNode)this);
    }

    @NotNull
    private <NN> Function<NN, ASTNode> CHILD_TRANSFORM(final SyntaxTraverser<NN> s, final int shift) {
        Function function = new Function<NN, ASTNode>(){
            int index = 0;

            public ASTNode fun(@Nullable NN input) {
                return TraverserBasedASTNode.this.createChildNode(this.index++, input, s, shift);
            }
        };
        if (function == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/script/TraverserBasedASTNode", "CHILD_TRANSFORM"));
        }
        return function;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TraverserBasedASTNode)) {
            return false;
        }
        return Comparing.equal(this.myNode, ((TraverserBasedASTNode)((Object)obj)).myNode);
    }

    public int hashCode() {
        return this.myNode.hashCode();
    }

    private static class ASTWrapperPsiComment
    extends ASTWrapperPsiElement
    implements PsiComment {
        public ASTWrapperPsiComment(@NotNull ASTNode node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/sql/script/TraverserBasedASTNode$ASTWrapperPsiComment", "<init>"));
            }
            super(node);
        }

        public IElementType getTokenType() {
            return this.getNode().getElementType();
        }
    }

    private static class Meta {
        final ASTNode parent;
        final PsiElement psi;
        final List<ASTNode> kids;

        Meta(ASTNode parent, PsiElement psi, List<ASTNode> kids) {
            this.parent = parent;
            this.psi = psi;
            this.kids = kids;
        }

        Meta withKids(@NotNull List<ASTNode> kids) {
            if (kids == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kids", "com/intellij/sql/script/TraverserBasedASTNode$Meta", "withKids"));
            }
            return new Meta(this.parent, this.psi, kids);
        }

        Meta withPsi(@NotNull PsiElement psi) {
            if (psi == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "com/intellij/sql/script/TraverserBasedASTNode$Meta", "withPsi"));
            }
            return new Meta(this.parent, psi, this.kids);
        }
    }

    private static class ShiftedNode<N>
    extends TraverserBasedASTNode<N> {
        private final int myShift;

        ShiftedNode(TraverserBasedASTNode<?> parent, int index, int shift, @NotNull SyntaxTraverser<N> traverser, @NotNull N node) {
            if (traverser == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "traverser", "com/intellij/sql/script/TraverserBasedASTNode$ShiftedNode", "<init>"));
            }
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/sql/script/TraverserBasedASTNode$ShiftedNode", "<init>"));
            }
            super(parent, index, traverser, node);
            this.myShift = shift;
        }

        @Override
        public TextRange getTextRange() {
            return super.getTextRange().shiftRight(this.myShift);
        }

        @Override
        @NotNull
        protected <NN> TraverserBasedASTNode<NN> createChildNode(int index, NN input, SyntaxTraverser<NN> s, int shift) {
            ShiftedNode<NN> shiftedNode = new ShiftedNode<NN>(this, index, this.myShift + shift, s, input);
            if (shiftedNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/script/TraverserBasedASTNode$ShiftedNode", "createChildNode"));
            }
            return shiftedNode;
        }
    }

    private static class FileNode<N>
    extends TraverserBasedASTNode<N>
    implements FileASTNode {
        private final Getter<PsiFile> myFileGetter;

        public FileNode(SyntaxTraverser<N> traverser, N node, Getter<PsiFile> fileGetter) {
            super(null, -1, traverser, node);
            this.myFileGetter = fileGetter;
        }

        @Override
        public PsiElement getPsi() {
            return (PsiElement)this.myFileGetter.get();
        }

        @NotNull
        public CharTable getCharTable() {
            IdentityCharTable identityCharTable = IdentityCharTable.INSTANCE;
            if (identityCharTable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/script/TraverserBasedASTNode$FileNode", "getCharTable"));
            }
            return identityCharTable;
        }

        public boolean isParsed() {
            return true;
        }

        @NotNull
        public LighterAST getLighterAST() {
            TreeBackedLighterAST treeBackedLighterAST = new TreeBackedLighterAST((FileASTNode)this);
            if (treeBackedLighterAST == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/script/TraverserBasedASTNode$FileNode", "getLighterAST"));
            }
            return treeBackedLighterAST;
        }
    }
}

