/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.appengine.facet.impl;

import com.intellij.appengine.facet.AppEngineFacet;
import com.intellij.appengine.facet.AppEngineWebIntegration;
import com.intellij.appengine.sdk.AppEngineSdk;
import com.intellij.appengine.server.instance.AppEngineServerModel;
import com.intellij.appengine.server.integration.AppEngineServerData;
import com.intellij.appengine.server.integration.AppEngineServerIntegration;
import com.intellij.appengine.server.run.AppEngineServerConfigurationType;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetType;
import com.intellij.framework.addSupport.FrameworkSupportInModuleProvider;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportModel;
import com.intellij.javaee.JavaeePersistenceDescriptorsConstants;
import com.intellij.javaee.appServerIntegrations.AppServerIntegration;
import com.intellij.javaee.appServerIntegrations.ApplicationServer;
import com.intellij.javaee.appServerIntegrations.ApplicationServerPersistentData;
import com.intellij.javaee.artifact.JavaeeArtifactUtil;
import com.intellij.javaee.facet.JavaeeFrameworkSupportInfoCollector;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.javaee.run.configuration.J2EEConfigurationFactory;
import com.intellij.javaee.serverInstances.ApplicationServersManager;
import com.intellij.javaee.web.artifact.WebArtifactUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.jpa.facet.JpaFacet;
import com.intellij.jpa.facet.JpaFacetType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.impl.run.BuildArtifactsBeforeRunTaskProvider;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.descriptors.ConfigFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AppEngineUltimateWebIntegration
extends AppEngineWebIntegration {
    @Override
    @NotNull
    public ArtifactType getAppEngineWebArtifactType() {
        ArtifactType artifactType = WebArtifactUtil.getInstance().getExplodedWarArtifactType();
        if (artifactType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/appengine/facet/impl/AppEngineUltimateWebIntegration", "getAppEngineWebArtifactType"));
        }
        return artifactType;
    }

    @Override
    @Nullable
    public ArtifactType getAppEngineApplicationArtifactType() {
        return JavaeeArtifactUtil.getInstance().getExplodedEarArtifactType();
    }

    @Override
    public VirtualFile suggestParentDirectoryForAppEngineWebXml(@NotNull Module module, @NotNull ModifiableRootModel rootModel) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/appengine/facet/impl/AppEngineUltimateWebIntegration", "suggestParentDirectoryForAppEngineWebXml"));
        }
        if (rootModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootModel", "com/intellij/appengine/facet/impl/AppEngineUltimateWebIntegration", "suggestParentDirectoryForAppEngineWebXml"));
        }
        WebFacet webFacet = (WebFacet)ContainerUtil.getFirstItem((Collection)WebFacet.getInstances((Module)module));
        if (webFacet == null) {
            return null;
        }
        ConfigFile configFile = webFacet.getWebXmlDescriptor();
        if (configFile == null) {
            return null;
        }
        VirtualFile webXml = configFile.getVirtualFile();
        if (webXml == null) {
            return null;
        }
        return webXml.getParent();
    }

    @Override
    public void setupJpaSupport(@NotNull Module module, @NotNull VirtualFile persistenceXml) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/appengine/facet/impl/AppEngineUltimateWebIntegration", "setupJpaSupport"));
        }
        if (persistenceXml == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "persistenceXml", "com/intellij/appengine/facet/impl/AppEngineUltimateWebIntegration", "setupJpaSupport"));
        }
        JpaFacet facet = (JpaFacet)FacetManager.getInstance((Module)module).getFacetByType(JpaFacet.ID);
        if (facet == null) {
            JpaFacet jpaFacet = (JpaFacet)FacetManager.getInstance((Module)module).addFacet((FacetType)JpaFacetType.getInstance(), JpaFacetType.getInstance().getDefaultFacetName(), null);
            jpaFacet.getDescriptorsContainer().getConfiguration().replaceConfigFile(JavaeePersistenceDescriptorsConstants.PERSISTENCE_XML_META_DATA, persistenceXml.getUrl());
        }
    }

    @Override
    public void setupRunConfiguration(@NotNull AppEngineSdk sdk, Artifact artifact, @NotNull Project project) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/intellij/appengine/facet/impl/AppEngineUltimateWebIntegration", "setupRunConfiguration"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/appengine/facet/impl/AppEngineUltimateWebIntegration", "setupRunConfiguration"));
        }
        ApplicationServer appServer = AppEngineUltimateWebIntegration.getOrCreateAppServer(sdk);
        if (appServer != null) {
            AppEngineServerConfigurationType configurationType = AppEngineServerConfigurationType.getInstance();
            List list = RunManager.getInstance((Project)project).getConfigurationSettingsList((ConfigurationType)configurationType);
            if (list.isEmpty()) {
                RunnerAndConfigurationSettings settings = J2EEConfigurationFactory.getInstance().addAppServerConfiguration(project, configurationType.getLocalFactory(), appServer);
                if (artifact != null) {
                    CommonModel configuration = (CommonModel)settings.getConfiguration();
                    ((AppEngineServerModel)configuration.getServerModel()).setArtifact(artifact);
                    BuildArtifactsBeforeRunTaskProvider.setBuildArtifactBeforeRun((Project)project, (RunConfiguration)configuration, (Artifact)artifact);
                }
            }
        }
    }

    @Override
    public void addDevServerToModuleDependencies(@NotNull ModifiableRootModel rootModel, @NotNull AppEngineSdk sdk) {
        if (rootModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootModel", "com/intellij/appengine/facet/impl/AppEngineUltimateWebIntegration", "addDevServerToModuleDependencies"));
        }
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/intellij/appengine/facet/impl/AppEngineUltimateWebIntegration", "addDevServerToModuleDependencies"));
        }
        ApplicationServer appServer = AppEngineUltimateWebIntegration.getOrCreateAppServer(sdk);
        if (appServer != null) {
            rootModel.addLibraryEntry(appServer.getLibrary()).setScope(DependencyScope.PROVIDED);
        }
    }

    @Override
    public void addLibraryToArtifact(@NotNull Library library, @NotNull Artifact artifact, @NotNull Project project) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/appengine/facet/impl/AppEngineUltimateWebIntegration", "addLibraryToArtifact"));
        }
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/intellij/appengine/facet/impl/AppEngineUltimateWebIntegration", "addLibraryToArtifact"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/appengine/facet/impl/AppEngineUltimateWebIntegration", "addLibraryToArtifact"));
        }
        WebArtifactUtil.getInstance().addLibrary(library, artifact, project);
    }

    @Override
    public void setupDevServer(@NotNull AppEngineSdk sdk) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/intellij/appengine/facet/impl/AppEngineUltimateWebIntegration", "setupDevServer"));
        }
        AppEngineUltimateWebIntegration.getOrCreateAppServer(sdk);
    }

    private static ApplicationServer getOrCreateAppServer(AppEngineSdk sdk) {
        if (!sdk.isValid()) {
            return null;
        }
        ApplicationServersManager serversManager = ApplicationServersManager.getInstance();
        AppEngineServerIntegration integration = AppEngineServerIntegration.getInstance();
        List servers = serversManager.getApplicationServers(new AppServerIntegration[]{integration});
        File sdkHomeFile = new File(sdk.getSdkHomePath());
        for (ApplicationServer server : servers) {
            String path = ((AppEngineServerData)server.getPersistentData()).getSdkPath();
            if (!FileUtil.filesEqual((File)sdkHomeFile, (File)new File(path))) continue;
            return server;
        }
        return ApplicationServersManager.getInstance().createServer((AppServerIntegration)integration, (ApplicationServerPersistentData)new AppEngineServerData(sdk.getSdkHomePath()));
    }

    @Override
    public List<? extends AppEngineSdk> getSdkForConfiguredDevServers() {
        List servers = ApplicationServersManager.getInstance().getApplicationServers(new AppServerIntegration[]{AppEngineServerIntegration.getInstance()});
        ArrayList<AppEngineSdk> sdkList = new ArrayList<AppEngineSdk>();
        for (ApplicationServer server : servers) {
            AppEngineSdk sdk = ((AppEngineServerData)server.getPersistentData()).getSdk();
            if (!sdk.isValid()) continue;
            sdkList.add(sdk);
        }
        return sdkList;
    }

    @Override
    public void registerFrameworkInModel(FrameworkSupportModel model, AppEngineFacet appEngineFacet) {
        JavaeeFrameworkSupportInfoCollector.getOrCreateCollector((FrameworkSupportModel)model).setFacet(AppEngineFacet.ID, (Facet)appEngineFacet);
    }

    @Override
    @NotNull
    public List<FrameworkSupportInModuleProvider.FrameworkDependency> getAppEngineFrameworkDependencies() {
        List<FrameworkSupportInModuleProvider.FrameworkDependency> list = Arrays.asList(FrameworkSupportInModuleProvider.FrameworkDependency.required((String)"web"), FrameworkSupportInModuleProvider.FrameworkDependency.optional((String)"facet:jpa"));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/appengine/facet/impl/AppEngineUltimateWebIntegration", "getAppEngineFrameworkDependencies"));
        }
        return list;
    }
}

