/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.appengine.inspections;

import com.intellij.appengine.facet.AppEngineFacet;
import com.intellij.appengine.inspections.AppEngineForbiddenCodeHandler;
import com.intellij.appengine.sdk.AppEngineSdk;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.BaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.util.ClassUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class AppEngineForbiddenCodeInspection
extends BaseJavaLocalInspectionTool {
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, final @NotNull InspectionManager manager, final boolean isOnTheFly) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/appengine/inspections/AppEngineForbiddenCodeInspection", "checkFile"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/appengine/inspections/AppEngineForbiddenCodeInspection", "checkFile"));
        }
        Project project = manager.getProject();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        AppEngineFacet appEngineFacet = AppEngineFacet.getAppEngineFacetByModule(module);
        if (appEngineFacet == null) {
            return null;
        }
        final AppEngineSdk appEngineSdk = appEngineFacet.getSdk();
        if (!appEngineSdk.isValid()) {
            return null;
        }
        final ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        final ArrayList problems = new ArrayList();
        file.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitDocComment(PsiDocComment comment) {
            }

            public void visitMethod(PsiMethod method) {
                PsiModifierList modifierList = method.getModifierList();
                if (modifierList.hasModifierProperty("native") && !AppEngineForbiddenCodeInspection.isNativeMethodAllowed(method)) {
                    problems.add(manager.createProblemDescriptor((PsiElement)modifierList, "Native methods aren't allowed in App Engine application", isOnTheFly, LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR_OR_WARNING));
                }
                super.visitMethod(method);
            }

            public void visitNewExpression(PsiNewExpression expression) {
                String qualifiedName;
                PsiElement resolved;
                PsiJavaCodeReferenceElement classReference = expression.getClassReference();
                if (classReference != null && (resolved = classReference.resolve()) instanceof PsiClass && (qualifiedName = ((PsiClass)resolved).getQualifiedName()) != null && appEngineSdk.isMethodInBlacklist(qualifiedName, "new")) {
                    String message = "App Engine application should not create new instances of '" + qualifiedName + "' class";
                    problems.add(manager.createProblemDescriptor((PsiElement)classReference, message, isOnTheFly, LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR_OR_WARNING));
                }
                super.visitNewExpression(expression);
            }

            public void visitMethodCallExpression(PsiMethodCallExpression expression) {
                PsiMethod method;
                PsiClass psiClass;
                PsiReferenceExpression methodExpression = expression.getMethodExpression();
                PsiElement element = methodExpression.resolve();
                if (element instanceof PsiMethod && (psiClass = (method = (PsiMethod)element).getContainingClass()) != null) {
                    String qualifiedName = psiClass.getQualifiedName();
                    String methodName = method.getName();
                    if (qualifiedName != null && appEngineSdk.isMethodInBlacklist(qualifiedName, methodName)) {
                        String message = "AppEngine application should not call '" + StringUtil.getShortName((String)qualifiedName) + "." + methodName + "' method";
                        problems.add(manager.createProblemDescriptor((PsiElement)methodExpression, message, isOnTheFly, LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR_OR_WARNING));
                    }
                }
                super.visitMethodCallExpression(expression);
            }

            public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                VirtualFile virtualFile;
                PsiFile psiFile;
                PsiElement resolved = reference.resolve();
                if (resolved instanceof PsiClass && (psiFile = resolved.getContainingFile()) != null && (virtualFile = psiFile.getVirtualFile()) != null && !fileIndex.isInSource(virtualFile)) {
                    List list = fileIndex.getOrderEntriesForFile(virtualFile);
                    for (OrderEntry entry : list) {
                        String className;
                        if (!(entry instanceof JdkOrderEntry) || (className = ClassUtil.getJVMClassName((PsiClass)((PsiClass)resolved))) == null || appEngineSdk.isClassInWhiteList(className)) continue;
                        problems.add(manager.createProblemDescriptor((PsiElement)reference, "Class '" + className + "' is not included in App Engine JRE White List", isOnTheFly, LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR_OR_WARNING));
                    }
                }
                super.visitReferenceElement(reference);
            }
        });
        return problems.toArray(new ProblemDescriptor[problems.size()]);
    }

    private static boolean isNativeMethodAllowed(PsiMethod method) {
        for (AppEngineForbiddenCodeHandler handler : (AppEngineForbiddenCodeHandler[])AppEngineForbiddenCodeHandler.EP_NAME.getExtensions()) {
            if (!handler.isNativeMethodAllowed(method)) continue;
            return true;
        }
        return false;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/appengine/inspections/AppEngineForbiddenCodeInspection", "getDefaultLevel"));
        }
        return highlightDisplayLevel;
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        if ("Google App Engine" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/appengine/inspections/AppEngineForbiddenCodeInspection", "getGroupDisplayName"));
        }
        return "Google App Engine";
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Forbidden code in App Engine applications" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/appengine/inspections/AppEngineForbiddenCodeInspection", "getDisplayName"));
        }
        return "Forbidden code in App Engine applications";
    }

    @NotNull
    public String getShortName() {
        if ("AppEngineForbiddenCode" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/appengine/inspections/AppEngineForbiddenCodeInspection", "getShortName"));
        }
        return "AppEngineForbiddenCode";
    }
}

