/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.appengine.server.integration;

import com.intellij.appengine.sdk.AppEngineSdk;
import com.intellij.appengine.sdk.AppEngineSdkManager;
import com.intellij.javaee.appServerIntegrations.ApplicationServerPersistentData;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class AppEngineServerData
implements ApplicationServerPersistentData {
    private String mySdkPath;

    public AppEngineServerData(@NotNull String sdkPath) {
        if (sdkPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkPath", "com/intellij/appengine/server/integration/AppEngineServerData", "<init>"));
        }
        this.mySdkPath = sdkPath;
    }

    @NotNull
    public String getSdkPath() {
        String string = this.mySdkPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/appengine/server/integration/AppEngineServerData", "getSdkPath"));
        }
        return string;
    }

    @NotNull
    public AppEngineSdk getSdk() {
        AppEngineSdk appEngineSdk = AppEngineSdkManager.getInstance().findSdk(this.mySdkPath);
        if (appEngineSdk == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/appengine/server/integration/AppEngineServerData", "getSdk"));
        }
        return appEngineSdk;
    }

    public void setSdkPath(@NotNull String sdkPath) {
        if (sdkPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkPath", "com/intellij/appengine/server/integration/AppEngineServerData", "setSdkPath"));
        }
        this.mySdkPath = sdkPath;
    }

    public void readExternal(Element element) throws InvalidDataException {
        this.mySdkPath = StringUtil.notNullize((String)element.getChildTextTrim("sdk-path"));
    }

    public void writeExternal(Element element) throws WriteExternalException {
        element.addContent(new Element("sdk-path").addContent(this.mySdkPath));
    }
}

