/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.composite;

import com.intellij.jsf.composite.CompositeComponentDescriptor;
import com.intellij.jsf.composite.CompositeUtil;
import com.intellij.jsf.utils.JsfCommonUtils;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.impl.schema.XmlNSDescriptorImpl;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompositeNamespaceDescriptor
extends XmlNSDescriptorImpl {
    private final String myNamespace;
    private final String myResourcesPath;
    private static final Key<CachedValue<Map<String, Set<XmlFile>>>> COMPOSITE_NAMESPACE_FILES_CACHE = Key.create((String)"COMPOSITE_NAMESPACE_FILES_CACHE");

    public CompositeNamespaceDescriptor(@NotNull String namespace, @NotNull String resourcePath) {
        if (namespace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/intellij/jsf/composite/CompositeNamespaceDescriptor", "<init>"));
        }
        if (resourcePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourcePath", "com/intellij/jsf/composite/CompositeNamespaceDescriptor", "<init>"));
        }
        this.myNamespace = namespace;
        this.myResourcesPath = resourcePath;
    }

    public String getResourcesPath() {
        return this.myResourcesPath;
    }

    public void init(PsiElement element) {
        super.init(element);
    }

    public XmlElementDescriptor getElementDescriptor(@NotNull XmlTag tag) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/jsf/composite/CompositeNamespaceDescriptor", "getElementDescriptor"));
        }
        if (!this.myNamespace.equals(tag.getNamespace())) {
            return null;
        }
        return this.getCompositeComponentDescriptor(tag);
    }

    @Nullable
    private XmlElementDescriptor getCompositeComponentDescriptor(@NotNull XmlTag tag) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/jsf/composite/CompositeNamespaceDescriptor", "getCompositeComponentDescriptor"));
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)tag);
        if (module == null) {
            return null;
        }
        for (XmlFile file : CompositeNamespaceDescriptor.getCompositeComponentsFiles(module, this.myResourcesPath)) {
            if (!tag.getLocalName().equals(FileUtil.getNameWithoutExtension((String)file.getName()))) continue;
            return new CompositeComponentDescriptor(file, tag.getNamespacePrefix());
        }
        return null;
    }

    public XmlElementDescriptor getElementDescriptor(String localName, String namespace) {
        return super.getElementDescriptor(localName, namespace);
    }

    @NotNull
    public XmlElementDescriptor[] getRootElementsDescriptors(@Nullable XmlDocument doc) {
        if (doc == null) {
            if (XmlElementDescriptor.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/composite/CompositeNamespaceDescriptor", "getRootElementsDescriptors"));
            }
            return XmlElementDescriptor.EMPTY_ARRAY;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)doc);
        XmlTag rootTag = doc.getRootTag();
        if (rootTag != null) {
            String prefix = rootTag.getPrefixByNamespace(this.myNamespace);
            if (module != null && prefix != null) {
                HashSet<CompositeComponentDescriptor> descriptors = new HashSet<CompositeComponentDescriptor>();
                for (XmlFile file : CompositeNamespaceDescriptor.getCompositeComponentsFiles(module, this.myResourcesPath)) {
                    descriptors.add(new CompositeComponentDescriptor(file, prefix));
                }
                XmlElementDescriptor[] xmlElementDescriptorArray = descriptors.toArray(new XmlElementDescriptor[descriptors.size()]);
                if (xmlElementDescriptorArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/composite/CompositeNamespaceDescriptor", "getRootElementsDescriptors"));
                }
                return xmlElementDescriptorArray;
            }
        }
        if (XmlElementDescriptor.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/composite/CompositeNamespaceDescriptor", "getRootElementsDescriptors"));
        }
        return XmlElementDescriptor.EMPTY_ARRAY;
    }

    @NotNull
    public static Set<XmlFile> getCompositeComponentsFiles(final @NotNull Module module, @NotNull String resourcesPath) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/jsf/composite/CompositeNamespaceDescriptor", "getCompositeComponentsFiles"));
        }
        if (resourcesPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourcesPath", "com/intellij/jsf/composite/CompositeNamespaceDescriptor", "getCompositeComponentsFiles"));
        }
        Map cached = (Map)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/jsf/composite/CompositeNamespaceDescriptor", "lambda$getCompositeComponentsFiles$0"));
            }
            ConcurrentFactoryMap<String, Set<XmlFile>> map = new ConcurrentFactoryMap<String, Set<XmlFile>>(){

                @Nullable
                protected Set<XmlFile> create(String key) {
                    return CompositeNamespaceDescriptor.collectCompositeComponentsFiles(module, key);
                }
            };
            return CachedValueProvider.Result.create((Object)map, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
        Set<XmlFile> files = (Set<XmlFile>)cached.get(resourcesPath);
        Set<XmlFile> set = files != null ? files : Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/composite/CompositeNamespaceDescriptor", "getCompositeComponentsFiles"));
        }
        return set;
    }

    @NotNull
    private static Set<XmlFile> collectCompositeComponentsFiles(@NotNull Module module, @NotNull String resourcesPath) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/jsf/composite/CompositeNamespaceDescriptor", "collectCompositeComponentsFiles"));
        }
        if (resourcesPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourcesPath", "com/intellij/jsf/composite/CompositeNamespaceDescriptor", "collectCompositeComponentsFiles"));
        }
        HashSet<XmlFile> files = new HashSet<XmlFile>();
        for (PsiDirectory directory : JsfCommonUtils.collectDirectories(module, resourcesPath)) {
            for (PsiFile file : directory.getFiles()) {
                if (!(file instanceof XmlFile) || !CompositeUtil.hasCompositeNsDefinedIn((XmlFile)file)) continue;
                files.add((XmlFile)file);
            }
        }
        HashSet<XmlFile> hashSet = files;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/composite/CompositeNamespaceDescriptor", "collectCompositeComponentsFiles"));
        }
        return hashSet;
    }
}

