/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dsm.model.classes;

import com.intellij.dsm.model.classes.And;
import com.intellij.dsm.model.classes.ClassNode;
import com.intellij.dsm.model.classes.TopToBottomTreeStructure;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.Pair;
import com.intellij.util.ArrayUtil;
import com.intellij.util.BooleanFunction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.gga.graph.maps.DataGraph;

class ModuleSplitter
implements TopToBottomTreeStructure.TreeSplitter<ClassNode> {
    ModuleSplitter() {
    }

    @Override
    public List<Pair<BooleanFunction<ClassNode>, TopToBottomTreeStructure.NodeData>> split(DataGraph<ClassNode, Integer> dataGraph, BooleanFunction<ClassNode> memberFunction, TopToBottomTreeStructure.NodeData parentData) {
        ArrayList<Pair<BooleanFunction<ClassNode>, TopToBottomTreeStructure.NodeData>> result = new ArrayList<Pair<BooleanFunction<ClassNode>, TopToBottomTreeStructure.NodeData>>();
        if (parentData instanceof MyNodeData) {
            result.add(new Pair(memberFunction, null));
            return result;
        }
        HashSet<ClassNode> globalClasses = new HashSet<ClassNode>();
        HashSet<String> moduleNamesSet = new HashSet<String>();
        for (int i = 0; i < dataGraph.V(); ++i) {
            ClassNode classNode2 = dataGraph.getNode(i);
            if (!memberFunction.fun((Object)classNode2)) continue;
            if (classNode2.module != null) {
                moduleNamesSet.add(classNode2.module.getName());
                continue;
            }
            globalClasses.add(classNode2);
        }
        Object[] moduleNames = ArrayUtil.toStringArray(moduleNamesSet);
        Arrays.sort(moduleNames);
        for (Object moduleName : moduleNames) {
            result.add((Pair<BooleanFunction<ClassNode>, TopToBottomTreeStructure.NodeData>)new Pair(new And<ClassNode>(memberFunction, arg_0 -> ModuleSplitter.lambda$split$0((String)moduleName, arg_0)), (Object)new MyNodeData((String)moduleName)));
        }
        if (!globalClasses.isEmpty()) {
            result.add((Pair<BooleanFunction<ClassNode>, TopToBottomTreeStructure.NodeData>)new Pair(classNode -> globalClasses.contains(classNode), null));
        }
        return result;
    }

    private static /* synthetic */ boolean lambda$split$0(String moduleName, ClassNode classNode) {
        return classNode.getModuleName().equals(moduleName);
    }

    private static class MyNodeData
    extends TopToBottomTreeStructure.NodeData {
        public MyNodeData(String moduleName) {
            super(moduleName, moduleName, AllIcons.Nodes.Module);
        }
    }
}

