/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dsm.ui;

import com.intellij.dsm.model.DsmTreeStructure;
import com.intellij.dsm.ui.Cache;
import com.intellij.dsm.ui.DsmTableImpl;
import com.intellij.dsm.ui.NodeVisitor;
import java.util.ArrayList;
import java.util.List;

class MaxWidthVisitor<N>
implements NodeVisitor<N> {
    int myMaxWidth = 0;
    public List<DsmTreeStructure.TreeNode<N>> myRows = new ArrayList<DsmTreeStructure.TreeNode<N>>();
    private final DsmTableImpl myDsmTable;
    private final Cache myCache;

    public MaxWidthVisitor(DsmTableImpl dsmTable, Cache cache) {
        this.myDsmTable = dsmTable;
        this.myCache = cache;
    }

    @Override
    public void visitLeaf(DsmTreeStructure.TreeNode<N> node, int x, int y, int height, boolean isFirst, boolean isLast) {
        this.processNode(node, x);
    }

    @Override
    public void visitExpanded(DsmTreeStructure.TreeNode node, int x, int y, int height, boolean isLast) {
        this.myMaxWidth = Math.max(this.myMaxWidth, x + this.myDsmTable.myBoxSize);
    }

    @Override
    public void visitCollapsed(DsmTreeStructure.TreeNode<N> node, int x, int y, int height, boolean isFirst, boolean last) {
        this.processNode(node, x);
    }

    private void processNode(DsmTreeStructure.TreeNode<N> node, int x) {
        this.myRows.add(node);
        int w = this.myCache.isSuperSmall ? this.myDsmTable.myBoxSize * 10 : this.myDsmTable.getFontMetrics(this.myDsmTable.getFont()).stringWidth(node.getShortName()) + this.myDsmTable.myBoxSize * 3;
        this.myMaxWidth = Math.max(this.myMaxWidth, x + w);
    }
}

