/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.impl;

import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.io.LimitedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.SQLException;

public class FileBlob
implements Blob,
Serializable {
    private final File myFile;

    public FileBlob(File file) {
        this.myFile = file;
    }

    public long length() throws SQLException {
        return this.myFile.length();
    }

    public byte[] getBytes(long pos, int length) throws SQLException {
        try {
            return FileUtilRt.loadBytes((InputStream)this.getBinaryStream(pos - 1L, length));
        }
        catch (IOException e) {
            throw new SQLException(e.toString());
        }
    }

    public FileInputStream getBinaryStream() throws SQLException {
        try {
            return new FileInputStream(this.myFile);
        }
        catch (FileNotFoundException e) {
            throw new SQLException(e.toString());
        }
    }

    public long position(byte[] pattern, long start) throws SQLException {
        throw new UnsupportedOperationException("not implemented");
    }

    public long position(Blob pattern, long start) throws SQLException {
        throw new UnsupportedOperationException("not implemented");
    }

    public int setBytes(long pos, byte[] bytes) throws SQLException {
        throw new UnsupportedOperationException("not implemented");
    }

    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        throw new UnsupportedOperationException("not implemented");
    }

    public OutputStream setBinaryStream(long pos) throws SQLException {
        throw new UnsupportedOperationException("not implemented");
    }

    public void truncate(long len) throws SQLException {
        throw new UnsupportedOperationException("not implemented");
    }

    public void free() throws SQLException {
    }

    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        FileInputStream stream = this.getBinaryStream();
        if (pos > 1L) {
            try {
                stream.getChannel().position(pos - 1L);
            }
            catch (IOException e) {
                throw new SQLException(e.toString());
            }
        } else if (length == this.length()) {
            return stream;
        }
        return new LimitedInputStream((InputStream)stream, (int)length);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileBlob fileBlob = (FileBlob)o;
        return this.myFile.equals(fileBlob.myFile);
    }

    public int hashCode() {
        return this.myFile.hashCode();
    }
}

