/*
 * Copyright 2000-2013 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.spring.facet;

import com.intellij.facet.ui.FacetBasedFrameworkSupportProvider;
import com.intellij.framework.library.DownloadableLibraryType;
import com.intellij.framework.library.LibraryBasedFrameworkType;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class SpringLibraryFrameworkType extends LibraryBasedFrameworkType {
  protected SpringLibraryFrameworkType(final @NonNls @NotNull String id, @NotNull Class<? extends DownloadableLibraryType> libraryTypeClass) {
    super(id, libraryTypeClass);
  }

  @Override
  public final String getUnderlyingFrameworkTypeId() {
    return FacetBasedFrameworkSupportProvider.getProviderId(SpringFacet.FACET_TYPE_ID);
  }
}
