/*
 * Copyright 2000-2014 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.spring.model.jam;

import com.intellij.jam.JamElement;
import com.intellij.jam.JamPomTarget;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.pom.references.PomService;
import com.intellij.psi.PsiElement;
import com.intellij.xml.util.PsiElementPointer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/**
* @author Ivan Chirkov
*/
public class JamStringAttributeElementPsiElementPointer implements PsiElementPointer {
  @Nullable
  private final JamStringAttributeElement<?> myAttributeElement;
  @NotNull
  private final JamElement myElement;

  public JamStringAttributeElementPsiElementPointer(@Nullable JamStringAttributeElement<?> attributeElement,
                                                    @NotNull JamElement element) {
    myAttributeElement = attributeElement;
    myElement = element;
  }

  @Nullable
  @Override
  public PsiElement getPsiElement() {
    if (myAttributeElement == null || myAttributeElement.getPsiElement() == null) {
      return null;
    }
    JamPomTarget target = new JamPomTarget(myElement, myAttributeElement);
    return target.isValid() ? PomService.convertToPsi(target) : null;
  }
}
