/*
 * Copyright 2000-2016 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.spring.model.jam;

import com.intellij.jam.JamElement;
import com.intellij.jam.JamNumberAttributeElement;
import com.intellij.jam.annotations.JamPsiConnector;
import com.intellij.jam.reflect.*;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.spring.constants.SpringAnnotationsConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/**
 * {@value SpringAnnotationsConstants#ORDER}
 *
 * @since 2017.1
 */
public abstract class SpringOrder implements JamElement {

  private static final JamNumberAttributeMeta.Single<Integer> VALUE_ATTR_META =
    JamAttributeMeta.singleInteger("value");

  private static final JamAnnotationMeta ANNO_META =
    new JamAnnotationMeta(SpringAnnotationsConstants.ORDER).
      addAttribute(VALUE_ATTR_META);

  private static final JamMemberArchetype<PsiModifierListOwner, SpringOrder> ARCHETYPE =
    new JamMemberArchetype<PsiModifierListOwner, SpringOrder>()
      .addAnnotation(ANNO_META);

  public static final JamClassMeta<SpringOrder> CLASS_META =
    new JamClassMeta<>(ARCHETYPE, SpringOrder.class);
  public static final JamFieldMeta<SpringOrder> FIELD_META =
    new JamFieldMeta<>(ARCHETYPE, SpringOrder.class);
  public static final JamMethodMeta<SpringOrder> METHOD_META =
    new JamMethodMeta<>(ARCHETYPE, SpringOrder.class);

  @NotNull
  @JamPsiConnector
  public abstract PsiModifierListOwner getPsiElement();

  @Nullable
  public Integer getValue() {
    final JamNumberAttributeElement<Integer> jam = VALUE_ATTR_META.getJam(ANNO_META.getAnnotationRef(getPsiElement()));
    return jam.getPsiElement() != null ? jam.getValue() : Integer.MAX_VALUE;
  }
}
