/*
 * Copyright 2000-2016 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.spring.model.jam.testContexts;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiClass;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.model.jam.utils.JamAnnotationTypeUtil;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Collection;
import java.util.List;

/**
 * @since 2017.1
 */
public abstract class SpringTestingImplicitContextsProvider {
  public static final ExtensionPointName<SpringTestingImplicitContextsProvider> EP_NAME =
    ExtensionPointName.create("com.intellij.spring.testingImplicitContextsProvider");

  @NotNull
  public abstract Collection<CommonSpringModel> getModels(@Nullable Module module,
                                                          @NotNull ContextConfiguration configuration);

  protected static boolean isAnnotated(@NotNull ContextConfiguration configuration,
                                     @Nullable Module module,
                                     @NotNull String annotation) {
    if (module == null) return false;

    List<String> annotations = ContainerUtil
      .mapNotNull(JamAnnotationTypeUtil.getInstance(module).getAnnotationTypesWithChildrenIncludingTests(annotation),
                  PsiClass::getQualifiedName);

    return AnnotationUtil.isAnnotated(configuration.getPsiElement(), annotations);
  }
}
