/*
 * Copyright 2000-2013 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.intellij.spring.model.values;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.model.xml.beans.SpringEntry;
import com.intellij.util.xml.GenericDomValue;
import org.jetbrains.annotations.NotNull;

import java.util.Collections;
import java.util.List;

/**
 * @author Dmitry Avdeev
 */
public class EntryKeyConverter extends PropertyValueConverter {

  @NotNull
  public List<PsiType> getValueTypes(final GenericDomValue domValue) {
    SpringEntry entry = (SpringEntry)domValue.getParent();
    assert entry != null;
    final PsiClass psiClass = entry.getRequiredKeyClass();
    if (psiClass == null) {
      return Collections.emptyList();
    }

    final PsiClassType psiClassType = PsiTypesUtil.getClassType(psiClass);
    return Collections.<PsiType>singletonList(psiClassType);
  }
}
