/*
 * Copyright 2000-2013 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.spring.model.values;

import com.intellij.psi.PsiType;
import com.intellij.spring.model.utils.PsiTypeUtil;
import com.intellij.util.xml.GenericDomValue;
import org.jetbrains.annotations.NotNull;

import java.util.Collections;
import java.util.List;

public class PropsValueConverter extends PropertyValueConverter {
  @NotNull
  public List<PsiType> getValueTypes(final GenericDomValue domValue) {
    final PsiType type = PsiTypeUtil.getInstance(domValue.getManager().getProject()).findType(String.class);
    return type == null ? Collections.<PsiType>emptyList() : Collections.singletonList(type);
  }
}
