/*
 * Copyright 2000-2015 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.spring.profiles;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleServiceManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Set;

/**
 * @since 14.1
 */
public abstract class SpringProfilesFactory {

  public static SpringProfilesFactory getInstance(final Module module) {
    return ModuleServiceManager.getService(module, SpringProfilesFactory.class);
  }

  @NotNull
  public abstract SpringProfile getOrCreateProfile(String profileName, @NotNull PsiElement element);

  @Nullable
  public abstract SpringProfile findProfile(String profileName);

  @NotNull
  public abstract Set<SpringProfile> getProfiles();

  public abstract PsiReference[] getProfilesReferences(@NotNull PsiElement element, @Nullable String value, boolean isDefinition);
}
