let crypto = require('crypto');

type HashType = any;

export class HolderContainer {
    value : {[p: string]: CompileInfoHolder} = {}

    reset() {
        this.value = {};
    }
};

/**
 * Emulating incremental compilation.
 * If file content wasn't changes we don't need recompile the file
 */
export class CompileInfoHolder {

    private _lastCompilerResult: {
        [fileName: string]: HashType
    } = {}

    private ts_impl:any;

    constructor(ts_impl:any) {
        this.ts_impl = ts_impl;
    }

    checkUpdateAndAddToCache(file: ts.SourceFile): boolean {
        if (file) {
            let fileName = this.ts_impl.normalizePath(file.fileName);
            let newHash = calcHash(file.text);
            let oldHash = this._lastCompilerResult[fileName];
            if (oldHash != null && oldHash == newHash) {
                return false;
            }

            this._lastCompilerResult[fileName] = newHash;
            return true;
        }

        return false;
    }

    resetForFile(fileName: string) {
        if (this._lastCompilerResult[fileName]) {
            this._lastCompilerResult[fileName] = null;
        }
    }

    reset() {
        this._lastCompilerResult = {};
    }
}

function calcHash(content: string): HashType {
    return crypto.createHash('md5').update(content).digest("hex");
}