import {HolderContainer} from "./compile-info-holder";
import {initCommandNames, IDETypeScriptSession} from "./util";
import {getSessionOld} from "./ts-session-old";
import {getSessionNew} from "./ts-session-new";


export function getSession(ts_impl: any /*must be typeof ts */,
                           logger: ts.server.Logger,
                           commonDefaultOptions: ts.CompilerOptions,
                           mainFile: string,
                           projectEmittedWithAllFiles: HolderContainer,
                           sessionClass: typeof IDETypeScriptSession): ts.server.Session {

    let TypeScriptProjectService: typeof ts.server.ProjectService = ts_impl.server.ProjectService;
    let TypeScriptCommandNames: typeof ts.server.CommandNames = ts_impl.server.CommandNames;
    initCommandNames(TypeScriptCommandNames);
    let host: ts.server.ServerHost = ts_impl.sys;

    let wasFirstMessage = false;

    let version = ts_impl.version;

    let isTS1X = version.indexOf("1.") == 0;
    let isTS2X = version.indexOf("2.") == 0;
    let isTS20 = isTS2X && version.indexOf("2.0") == 0;

    let session: ts.server.Session;
    if (isTS1X || isTS20 && isOld20()) {
        session = getSessionOld(sessionClass,
            TypeScriptProjectService,
            TypeScriptCommandNames,
            logger,
            host,
            ts_impl,
            commonDefaultOptions,
            mainFile,
            projectEmittedWithAllFiles);
    } else {
        session = getSessionNew(sessionClass,
            TypeScriptProjectService,
            TypeScriptCommandNames,
            logger,
            host,
            ts_impl,
            commonDefaultOptions,
            mainFile,
            projectEmittedWithAllFiles);
    }

    return session;


    function isOld20(): boolean {
        for (let i = 0; i < 6; i++) {
            let expectedVersion = "2.0." + i;
            if (expectedVersion == version ||
                version.indexOf(expectedVersion + ".") == 0) {
                return true;
            }
        }
        return false;
    }

}

