package com.intellij.psi.css;

import com.intellij.psi.PsiElement;
import com.intellij.psi.css.descriptor.CssValueOwnerDescriptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface CssPropertyDescriptor extends CssValueOwnerDescriptor, CssMediaGroupAwareDescriptor {
  @SuppressWarnings({"unchecked"})
  boolean isValidValue(@NotNull PsiElement element);

  boolean isShorthandValue();

  @NotNull
  String[] expand(@NotNull CssDeclaration declaration);

  @Nullable
  PsiElement[] getShorthandPsiValue(@NotNull CssDeclaration decl, @NotNull String propertyName);

  boolean is4ValueProperty();

  CssPropertyValue getReferencedPropertyValue(@NotNull String name);

  @NotNull
  CssPropertyInfo[] getInfos();

  boolean isInherited();
  
  @Nullable
  String getInitialValue();
  
  @Nullable
  String getAppliesToValue();

  @Nullable
  String getPercentageValue();

  @NotNull
  String getPropertyName();

  Object[] getAllVariants();

  @Nullable
  String[] getRefNames();

  @NotNull
  Object[] getVariants(@NotNull PsiElement contextElement);

  /**
   * @deprecated use this#isInherited
   */
  boolean getInherited();

  @NotNull
  String toCanonicalName(@NotNull String propertyName);

  CssPropertyValue getValue();

  @NotNull
  PsiElement[] getDeclarations(PsiElement context);

  boolean allowsIntegerWithoutSuffix();
}
