package com.intellij.psi.css;

import com.intellij.icons.AllIcons;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import javax.swing.*;

public final class CssSelectorSuffixType {
  public static final CssSelectorSuffixType UNKNOWN = new CssSelectorSuffixType("Unknown", null);
  public static final CssSelectorSuffixType ID = new CssSelectorSuffixType("Id", AllIcons.Xml.Html_id);
  public static final CssSelectorSuffixType CLASS = new CssSelectorSuffixType("Class", AllIcons.Xml.Css_class);

  private final String myName;
  private final Icon myIcon;

  public CssSelectorSuffixType(@NotNull String name, @Nullable Icon icon) {
    myName = name;
    myIcon = icon;
  }
  
  @Nullable
  public Icon getIcon() {
    return myIcon;
  }

  @Override
  public String toString() {
    return "CssSuffixSelectorType{" + myName + "\"}";
  }
}
