/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.jboss.editor.reference;

import com.intellij.javaee.model.xml.JavaeeDomModelElement;
import com.intellij.javaee.model.xml.JndiEnvironmentRefsGroup;
import com.intellij.javaee.model.xml.ResourceEnvRef;
import com.intellij.javaee.oss.editor.JavaeeSectionInfo;
import com.intellij.javaee.oss.editor.JavaeeSectionInfoEditable;
import com.intellij.javaee.oss.jboss.JBossBundle;
import com.intellij.javaee.oss.jboss.editor.reference.JBossReferenceSection;
import com.intellij.javaee.oss.jboss.editor.reference.JBossReferenceUtil;
import com.intellij.javaee.oss.jboss.model.JBossReferenceHolder;
import com.intellij.javaee.oss.jboss.model.JBossResourceEnvRef;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

class JBossResourceEnvRefSection
extends JBossReferenceSection<ResourceEnvRef> {
    private final JndiEnvironmentRefsGroup group;
    private final JBossReferenceHolder holder;

    JBossResourceEnvRefSection(JndiEnvironmentRefsGroup group, JBossReferenceHolder holder) {
        this.group = group;
        this.holder = holder;
    }

    public List<ResourceEnvRef> getValues() {
        return this.group == null ? Collections.emptyList() : this.group.getResourceEnvRefs();
    }

    @Override
    JavaeeSectionInfo<ResourceEnvRef> createFirstColumn() {
        return new JavaeeSectionInfo<ResourceEnvRef>(JBossBundle.getText("JBossReferenceEditor.resource.environment", new Object[0])){

            public String valueOf(ResourceEnvRef source) {
                return (String)source.getResourceEnvRefName().getValue();
            }
        };
    }

    @Override
    JavaeeSectionInfo<ResourceEnvRef> createSecondColumn() {
        return new JavaeeSectionInfoEditable<ResourceEnvRef>(JBossBundle.getText("JBossReferenceEditor.jndi.name", new Object[0]), (JavaeeDomModelElement)this.holder){

            @Nullable
            public String valueOf(ResourceEnvRef source) {
                JBossResourceEnvRef target = JBossReferenceUtil.findResourceEnvRef(JBossResourceEnvRefSection.this.holder, source);
                return target == null ? null : (String)target.getJndiName().getValue();
            }

            protected void write(ResourceEnvRef item, String value) {
                JBossResourceEnvRef target = JBossReferenceUtil.findResourceEnvRef(JBossResourceEnvRefSection.this.holder, item);
                if (!StringUtil.isEmpty((String)value)) {
                    if (target == null) {
                        target = JBossResourceEnvRefSection.this.holder.addResourceEnvRef();
                        target.getResourceEnvRefName().setValue((Object)item);
                    }
                    target.getJndiName().setValue((Object)value);
                } else if (target != null) {
                    target.undefine();
                }
            }
        };
    }
}

