/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.jboss.version;

import com.intellij.javaee.oss.JavaeeBundle;
import com.intellij.javaee.oss.jboss.version.JBossVersionHandler;
import com.intellij.javaee.oss.server.JavaeeServerVersionDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;

public abstract class JBossVersionHandlerBase
implements JBossVersionHandler {
    private static final Logger LOG = Logger.getInstance((String)("#" + JBossVersionHandlerBase.class.getName()));
    private final String myHome;
    private JavaeeServerVersionDescriptor myVersionDescriptor;

    public JBossVersionHandlerBase(String home) {
        this.myHome = home;
    }

    @Override
    public void detect() throws IOException {
        this.myVersionDescriptor = this.doDetect();
    }

    @Override
    public JavaeeServerVersionDescriptor getVersionDescriptor() {
        return this.myVersionDescriptor;
    }

    protected final String getHome() {
        return this.myHome;
    }

    protected final File findFileUnderHome(@NonNls String relativePath) throws IOException {
        File result = new File(this.getHome(), FileUtil.toSystemDependentName((String)relativePath));
        if (!result.exists()) {
            throw new FileNotFoundException(JavaeeBundle.getText((String)"Error.fileNotFound", (Object[])new Object[]{relativePath}));
        }
        return result;
    }

    @Override
    public File findLibrary(String dir, String jarPrefix) throws IOException {
        File asJarDir = this.findFileUnderHome(dir);
        if (!asJarDir.isDirectory()) {
            throw new IOException("Directory is expected: " + asJarDir.getPath());
        }
        File[] asJars = asJarDir.listFiles((jarDir, name) -> name.startsWith(jarPrefix) && name.endsWith(".jar"));
        int length = asJars.length;
        if (length == 0) {
            throw new IOException("Exactly one AS JAR is expected, while found none");
        }
        if (length > 1) {
            StringBuilder message = new StringBuilder().append("There were ").append(length).append(" jars found:");
            for (File jar : asJars) {
                message.append("\n").append(jar.getAbsoluteFile());
            }
            LOG.debug(message.toString());
        }
        return asJars[0];
    }

    protected abstract JavaeeServerVersionDescriptor doDetect() throws IOException;
}

