/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger;

import com.google.gson.JsonParseException;
import com.intellij.diagnostic.AttachmentFactory;
import com.intellij.diagnostic.LogMessageEx;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.console.BaseConsoleExecuteActionHandler;
import com.intellij.execution.console.GutterContentProvider;
import com.intellij.execution.console.LanguageConsoleBuilder;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.icons.AllIcons;
import com.intellij.javascript.debugger.ChromeExceptionBreakpointHandler;
import com.intellij.javascript.debugger.ConsolePrinter;
import com.intellij.javascript.debugger.DebuggableFileFinder;
import com.intellij.javascript.debugger.DebuggableFileFinderImpl;
import com.intellij.javascript.debugger.FilePathRegExpCreator;
import com.intellij.javascript.debugger.FileResolverByContentKt;
import com.intellij.javascript.debugger.FunctionStepIntoVariant;
import com.intellij.javascript.debugger.GlobalEvaluator;
import com.intellij.javascript.debugger.JSDebugTabLayouter;
import com.intellij.javascript.debugger.JSDebuggerEditorsProvider;
import com.intellij.javascript.debugger.JavaScriptConsolePsiFile;
import com.intellij.javascript.debugger.JavaScriptDebugProcessKt;
import com.intellij.javascript.debugger.JavaScriptDebuggerConsoleExecuteActionHandler;
import com.intellij.javascript.debugger.JavaScriptDebuggerViewSupport;
import com.intellij.javascript.debugger.JavaScriptLineBreakpointManager;
import com.intellij.javascript.debugger.JavaScriptLineBreakpointManagerKt;
import com.intellij.javascript.debugger.JavaScriptSmartStepIntoHandler;
import com.intellij.javascript.debugger.JavaScriptSmartStepIntoHandlerKt;
import com.intellij.javascript.debugger.JavaScriptSuspendContext;
import com.intellij.javascript.debugger.JsFileUtil;
import com.intellij.javascript.debugger.PsiVisitorKt;
import com.intellij.javascript.debugger.RemoteDebuggingFileFinder;
import com.intellij.javascript.debugger.SyntheticSuspendBreakpointInfo;
import com.intellij.javascript.debugger.V8ValueMarkerProvider;
import com.intellij.javascript.debugger.actions.ToggleExceptionBreakpointAction;
import com.intellij.javascript.debugger.breakpoints.JavaScriptBreakpointType;
import com.intellij.javascript.debugger.execution.RemoteUrlMappingBean;
import com.intellij.javascript.debugger.scripts.ScriptsKt;
import com.intellij.javascript.debugger.scripts.SourceTabManager;
import com.intellij.javascript.debugger.settings.JavaScriptDebuggerSettings;
import com.intellij.javascript.debugger.sourcemap.PreloadedSourceMapList;
import com.intellij.javascript.debugger.sourcemap.SourceMapCollector;
import com.intellij.javascript.debugger.sourcemap.SourceMapHelperKt;
import com.intellij.javascript.debugger.sourcemap.SourceMapLoaderKt;
import com.intellij.lang.javascript.JavaScriptFileType;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.impl.http.HttpVirtualFile;
import com.intellij.openapi.vfs.impl.http.RemoteFileInfo;
import com.intellij.openapi.vfs.impl.http.RemoteFileState;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.LocalFileUrl;
import com.intellij.util.PairFunction;
import com.intellij.util.SmartList;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.OrderedSet;
import com.intellij.util.io.AsarFileSystem;
import com.intellij.util.io.FileItem;
import com.intellij.util.io.URLUtil;
import com.intellij.xdebugger.DefaultDebugProcessHandler;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointHandler;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.intellij.xdebugger.stepping.XSmartStepIntoHandler;
import com.intellij.xdebugger.ui.XDebugTabLayouter;
import com.jetbrains.javascript.debugger.JavaScriptDebugAware;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.Breakpoint;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.ContextDependentAsyncResultConsumer;
import org.jetbrains.debugger.DebugEventListener;
import org.jetbrains.debugger.DebugProcessImpl;
import org.jetbrains.debugger.DebuggerViewSupport;
import org.jetbrains.debugger.ExecutionStackView;
import org.jetbrains.debugger.LineBreakpointHandler;
import org.jetbrains.debugger.LineBreakpointManager;
import org.jetbrains.debugger.Location;
import org.jetbrains.debugger.ProcessHandlerWrapper;
import org.jetbrains.debugger.RejectErrorReporter;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.ScriptManager;
import org.jetbrains.debugger.ScriptManagerKt;
import org.jetbrains.debugger.SourceInfo;
import org.jetbrains.debugger.StepAction;
import org.jetbrains.debugger.SuspendContext;
import org.jetbrains.debugger.SuspendContextView;
import org.jetbrains.debugger.SuspendState;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.connection.VmConnection;
import org.jetbrains.debugger.sourcemap.MappingEntry;
import org.jetbrains.debugger.sourcemap.SourceMap;
import org.jetbrains.debugger.sourcemap.SourceMapDecoderKt;
import org.jetbrains.debugger.sourcemap.SourceResolver;
import org.jetbrains.debugger.sourcemap.SourceResolverKt;
import org.jetbrains.io.LocalFileFinder;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u00ac\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000*\f\b\u0000\u0010\u0001*\u0006\u0012\u0002\b\u00030\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\u00020\u0004:\u0004\u00da\u0001\u00db\u0001B)\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00028\u0000\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\u000e\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020%J\u0010\u0010I\u001a\u00020G2\u0006\u0010J\u001a\u00020KH\u0014J2\u0010L\u001a\u00020G2\n\u0010M\u001a\u0006\u0012\u0002\b\u00030N2\b\u0010O\u001a\u0004\u0018\u00010%2\u0006\u0010P\u001a\u00020Q2\n\u0010R\u001a\u0006\u0012\u0002\b\u00030SH\u0002J\u0010\u0010T\u001a\u00020\u00182\u0006\u0010U\u001a\u00020VH\u0002J\u0010\u0010W\u001a\u00020G2\u0006\u0010X\u001a\u00020YH\u0014J\u0006\u0010Z\u001a\u00020GJ\u0017\u0010[\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030]0\\H\u0004\u00a2\u0006\u0002\u0010^J\b\u0010_\u001a\u00020`H\u0016J\b\u0010a\u001a\u00020\u0014H\u0014J\b\u0010b\u001a\u00020YH\u0002J>\u0010c\u001a\u00020d2\b\u0010e\u001a\u0004\u0018\u00010%2\b\u0010f\u001a\u0004\u0018\u00010%2\u0006\u0010g\u001a\u00020h2\u0006\u0010i\u001a\u00020j2\u0006\u0010k\u001a\u00020j2\b\u0010l\u001a\u0004\u0018\u00010@H\u0002JH\u0010m\u001a\u00020n2\f\u0010o\u001a\b\u0012\u0004\u0012\u00020%0p2\u000e\u0010q\u001a\n\u0012\u0004\u0012\u00020%\u0018\u00010p2\u0006\u0010r\u001a\u00020@2\u0006\u0010s\u001a\u00020\u00182\b\u0010U\u001a\u0004\u0018\u00010V2\u0006\u0010t\u001a\u00020\u0018H\u0014J*\u0010u\u001a\u00020Q2\n\u0010v\u001a\u0006\u0012\u0002\b\u00030S2\b\u0010U\u001a\u0004\u0018\u00010V2\n\b\u0002\u0010w\u001a\u0004\u0018\u00010dH\u0014J\u0006\u0010x\u001a\u00020+J&\u0010y\u001a\u0004\u0018\u00010z2\b\u0010{\u001a\u0004\u0018\u00010@2\b\u0010|\u001a\u0004\u0018\u00010}2\u0006\u0010U\u001a\u00020VH\u0004J6\u0010y\u001a\u0004\u0018\u00010z2\u0006\u0010|\u001a\u00020}2\u0006\u0010r\u001a\u00020@2\u0006\u0010s\u001a\u00020\u00182\n\b\u0002\u0010U\u001a\u0004\u0018\u00010V2\b\b\u0002\u0010t\u001a\u00020\u0018J\u0006\u0010~\u001a\u00020GJ\t\u0010\u007f\u001a\u00030\u0080\u0001H\u0014J\u0012\u0010\u0081\u0001\u001a\u00020G2\u0007\u0010\u0082\u0001\u001a\u00020\u0018H\u0014J\u001e\u0010\u0083\u0001\u001a\u0004\u0018\u00010h2\u0006\u0010l\u001a\u00020@2\t\b\u0002\u0010\u0084\u0001\u001a\u00020\u0018H\u0007J\u0011\u0010\u0085\u0001\u001a\u0004\u0018\u00010h2\u0006\u0010l\u001a\u00020@J\u0013\u0010\u0086\u0001\u001a\u0004\u0018\u00010h2\u0006\u0010U\u001a\u00020VH\u0002J'\u0010\u0087\u0001\u001a\u0005\u0018\u00010\u0088\u00012\u0007\u0010\u0089\u0001\u001a\u00020z2\u0007\u0010\u008a\u0001\u001a\u00020j2\u0007\u0010\u008b\u0001\u001a\u00020jH\u0002J%\u0010\u008c\u0001\u001a\u0004\u0018\u00010z2\u0006\u0010J\u001a\u00020K2\u0006\u0010U\u001a\u00020V2\b\u0010{\u001a\u0004\u0018\u00010%H\u0014J\u001d\u0010\u008d\u0001\u001a\u00020G2\u0014\u0010\u008e\u0001\u001a\u000f\u0012\u0004\u0012\u00020V\u0012\u0004\u0012\u00020\u00180\u008f\u0001J\u001a\u0010\u0090\u0001\u001a\u0004\u0018\u0001032\u0007\u0010\u0091\u0001\u001a\u00020%H\u0000\u00a2\u0006\u0003\b\u0092\u0001J\u001a\u0010\u0093\u0001\u001a\n\u0018\u00010@\u00a2\u0006\u0003\b\u0094\u00012\u0007\u0010\u0095\u0001\u001a\u00020%H\u0014J$\u0010\u0096\u0001\u001a\u0004\u0018\u00010%2\r\u0010M\u001a\t\u0012\u0002\b\u0003\u0018\u00010\u0097\u00012\b\u0010\u0098\u0001\u001a\u00030\u0099\u0001H\u0016J\u000b\u0010\u009a\u0001\u001a\u0004\u0018\u00010@H\u0016J\f\u0010\u009b\u0001\u001a\u0005\u0018\u00010\u009c\u0001H\u0016J\u0007\u0010\u009d\u0001\u001a\u00020'J\f\u0010\u009e\u0001\u001a\u0005\u0018\u00010\u009f\u0001H\u0004J#\u0010\u00a0\u0001\u001a\t\u0012\u0005\u0012\u00030\u0099\u00010p2\u0006\u0010J\u001a\u00020K2\u000b\u0010M\u001a\u0007\u0012\u0002\b\u00030\u0097\u0001J-\u0010\u00a1\u0001\u001a\u0004\u0018\u00010d2\b\u0010f\u001a\u0004\u0018\u00010%2\u0006\u0010U\u001a\u00020V2\u0007\u0010\u008a\u0001\u001a\u00020j2\u0007\u0010\u008b\u0001\u001a\u00020jJB\u0010\u00a1\u0001\u001a\u0004\u0018\u00010d2\u0006\u0010J\u001a\u00020K2\t\u0010\u00a2\u0001\u001a\u0004\u0018\u00010%2\u0007\u0010\u00a3\u0001\u001a\u00020%2\t\u0010\u00a4\u0001\u001a\u0004\u0018\u00010%2\u0007\u0010\u008a\u0001\u001a\u00020j2\u0007\u0010\u008b\u0001\u001a\u00020jJ \u0010\u00a5\u0001\u001a\u0005\u0018\u00010\u00a6\u00012\n\u0010v\u001a\u0006\u0012\u0002\b\u00030S2\u0006\u0010U\u001a\u00020VH\u0014J\u0018\u0010\u00a7\u0001\u001a\u00020G2\u0007\u0010\u00a8\u0001\u001a\u00028\u0000H\u0014\u00a2\u0006\u0003\u0010\u00a9\u0001J\u001d\u0010\u00aa\u0001\u001a\u00020\u00182\n\u0010M\u001a\u0006\u0012\u0002\b\u00030N2\u0006\u0010U\u001a\u00020VH\u0004J \u0010\u00ab\u0001\u001a\u00020\u00182\b\u0010U\u001a\u0004\u0018\u00010V2\u000b\b\u0002\u0010\u00ac\u0001\u001a\u0004\u0018\u00010dH\u0016J\u001e\u0010\u00ad\u0001\u001a\u00020\u00182\b\u0010U\u001a\u0004\u0018\u00010V2\t\u0010\u00ae\u0001\u001a\u0004\u0018\u00010hH\u0002J\t\u0010\u00af\u0001\u001a\u00020\u0018H\u0014J\u0012\u0010\u00b0\u0001\u001a\u00030\u00b1\u00012\u0006\u0010g\u001a\u00020hH\u0002J\t\u0010\u00b2\u0001\u001a\u00020\u0018H\u0014J)\u0010\u00b3\u0001\u001a\u00020\u00182\u0006\u0010J\u001a\u00020K2\n\u0010\u00b4\u0001\u001a\u0005\u0018\u00010\u00b5\u00012\n\u0010\u00b6\u0001\u001a\u0005\u0018\u00010\u00b5\u0001H\u0002J2\u0010\u00b7\u0001\u001a\u00020\u00182\u0006\u0010U\u001a\u00020V2\u0007\u0010\u00b8\u0001\u001a\u00020h2\u0007\u0010\u00b9\u0001\u001a\u00020h2\u0007\u0010\u00ba\u0001\u001a\u00020jH\u0000\u00a2\u0006\u0003\b\u00bb\u0001J\u0011\u0010\u00bc\u0001\u001a\u00020\u00182\u0006\u0010U\u001a\u00020VH\u0002J\u0010\u0010\u00bd\u0001\u001a\u00020%2\u0007\u0010\u00be\u0001\u001a\u00020%J\u0012\u0010\u00bf\u0001\u001a\u00020%2\u0007\u0010\u00be\u0001\u001a\u00020%H\u0014J)\u0010\u00c0\u0001\u001a\u00020G2\n\u0010R\u001a\u0006\u0012\u0002\b\u00030S2\n\u0010M\u001a\u0006\u0012\u0002\b\u00030N2\u0006\u0010P\u001a\u00020QH\u0002J)\u0010\u00c0\u0001\u001a\u00020G2\n\u0010R\u001a\u0006\u0012\u0002\b\u00030S2\n\u0010M\u001a\u0006\u0012\u0002\b\u00030N2\u0006\u0010U\u001a\u00020VH\u0002J)\u0010\u00c1\u0001\u001a\u00020G2\n\u0010M\u001a\u0006\u0012\u0002\b\u00030N2\u0006\u0010P\u001a\u00020Q2\n\u0010R\u001a\u0006\u0012\u0002\b\u00030SH\u0002JK\u0010\u00c2\u0001\u001a\u0005\u0018\u00010\u00a6\u00012\n\u0010v\u001a\u0006\u0012\u0002\b\u00030S2\u0006\u0010U\u001a\u00020V2)\b\u0002\u0010\u00c3\u0001\u001a\"\u0012\u0015\u0012\u00130V\u00a2\u0006\u000e\b\u00c4\u0001\u0012\t\b\u00be\u0001\u0012\u0004\b\b(U\u0012\u0004\u0012\u00020G\u0018\u00010\u008f\u0001H\u0004J%\u0010\u00c5\u0001\u001a\u00020\u00182\u0006\u0010J\u001a\u00020K2\n\u0010v\u001a\u0006\u0012\u0002\b\u00030S2\u0006\u0010U\u001a\u00020VH\u0002J'\u0010\u00c6\u0001\u001a\u00020G2\b\u0010\u00c7\u0001\u001a\u00030\u00c8\u00012\b\u0010\u00c9\u0001\u001a\u00030\u00c8\u00012\b\u0010\u00ca\u0001\u001a\u00030\u00c8\u0001H\u0016J\u001e\u0010\u00cb\u0001\u001a\u00020G2\b\u0010\u00cc\u0001\u001a\u00030\u00cd\u00012\t\u0010v\u001a\u0005\u0018\u00010\u00ce\u0001H\u0016J\u0010\u0010\u00cf\u0001\u001a\u00020G2\u0007\u0010\u00d0\u0001\u001a\u00020+JH\u0010\u00d1\u0001\u001a\u00020G2\u0006\u0010J\u001a\u00020K2\u0007\u0010\u00d2\u0001\u001a\u00020z2\b\u0010U\u001a\u0004\u0018\u00010V2\u000b\b\u0002\u0010\u00a3\u0001\u001a\u0004\u0018\u00010@2\u0017\b\u0002\u0010\u00d3\u0001\u001a\u0010\u0012\t\u0012\u0007\u0012\u0002\b\u00030\u00d5\u0001\u0018\u00010\u00d4\u0001J\u000e\u0010\u00d6\u0001\u001a\u0007\u0012\u0002\b\u00030\u00d5\u0001H\u0016J\u0017\u0010\u00d7\u0001\u001a\u00020G2\u000e\u0010\u00d8\u0001\u001a\t\u0012\u0005\u0012\u00030\u00d9\u00010pJ\r\u0010\u0083\u0001\u001a\u0004\u0018\u00010h*\u00020VR\u0014\u0010\r\u001a\u00020\u000eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0018\u0010\u0011\u001a\f0\u0012R\b\u0012\u0004\u0012\u00028\u00000\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\u0004\u0018\u00010 8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0014\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010&\u001a\u0004\u0018\u00010'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010(\u001a\u00020\u0018X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u001aR\u0014\u0010)\u001a\u00020\u0018X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\u001aR\u0010\u0010*\u001a\u0004\u0018\u00010+X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010,\u001a\u00020-X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R5\u00100\u001a#\u0012\f\u0012\n 2*\u0004\u0018\u00010%0%\u0012\f\u0012\n 2*\u0004\u0018\u0001030301\u00a2\u0006\u0002\b4X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00106R\u0011\u00107\u001a\u000208\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010:R\u0014\u0010;\u001a\u00020<X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u0010>R5\u0010?\u001a#\u0012\f\u0012\n 2*\u0004\u0018\u00010@0@\u0012\f\u0012\n 2*\u0004\u0018\u00010\u00180\u001801\u00a2\u0006\u0002\b4X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bA\u00106R\u0016\u0010B\u001a\u0004\u0018\u00010CX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bD\u0010E\u00a8\u0006\u00dc\u0001"}, d2={"Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "C", "Lorg/jetbrains/debugger/connection/VmConnection;", "Lorg/jetbrains/debugger/DebugProcessImpl;", "Lcom/intellij/openapi/Disposable;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "finder", "Lcom/intellij/javascript/debugger/DebuggableFileFinder;", "connection", "executionResult", "Lcom/intellij/execution/ExecutionResult;", "(Lcom/intellij/xdebugger/XDebugSession;Lcom/intellij/javascript/debugger/DebuggableFileFinder;Lorg/jetbrains/debugger/connection/VmConnection;Lcom/intellij/execution/ExecutionResult;)V", "consolePrinter", "Lcom/intellij/javascript/debugger/ConsolePrinter;", "getConsolePrinter", "()Lcom/intellij/javascript/debugger/ConsolePrinter;", "debugEventListener", "Lcom/intellij/javascript/debugger/JavaScriptDebugProcess$MyDebugEventListener;", "debuggerViewSupport", "Lcom/intellij/javascript/debugger/JavaScriptDebuggerViewSupport;", "getDebuggerViewSupport", "()Lcom/intellij/javascript/debugger/JavaScriptDebuggerViewSupport;", "elementsInspectorEnabled", "", "getElementsInspectorEnabled", "()Z", "setElementsInspectorEnabled", "(Z)V", "exceptionBreakpointHandler", "Lcom/intellij/javascript/debugger/ChromeExceptionBreakpointHandler;", "expectedFunction", "Lcom/intellij/javascript/debugger/FunctionStepIntoVariant;", "getFinder", "()Lcom/intellij/javascript/debugger/DebuggableFileFinder;", "firstLineBreakpointPatterns", "Lcom/intellij/util/SmartList;", "", "globalEvaluator", "Lcom/intellij/javascript/debugger/GlobalEvaluator;", "isFilesOnlyInLocalFileSystem", "isV8Inspector", "layouter", "Lcom/intellij/xdebugger/ui/XDebugTabLayouter;", "lineBreakpointManager", "Lcom/intellij/javascript/debugger/JavaScriptLineBreakpointManager;", "getLineBreakpointManager", "()Lcom/intellij/javascript/debugger/JavaScriptLineBreakpointManager;", "pathToAsarFs", "Ljava/util/concurrent/ConcurrentMap;", "kotlin.jvm.PlatformType", "Lcom/intellij/util/io/AsarFileSystem;", "Lorg/jetbrains/annotations/NotNull;", "getPathToAsarFs$JavaScriptDebugger", "()Ljava/util/concurrent/ConcurrentMap;", "preloadedSourceMaps", "Lcom/intellij/javascript/debugger/sourcemap/PreloadedSourceMapList;", "getPreloadedSourceMaps", "()Lcom/intellij/javascript/debugger/sourcemap/PreloadedSourceMapList;", "sourceTabManager", "Lcom/intellij/javascript/debugger/scripts/SourceTabManager;", "getSourceTabManager$JavaScriptDebugger", "()Lcom/intellij/javascript/debugger/scripts/SourceTabManager;", "urlToIsLibraryFile", "Lcom/intellij/util/Url;", "getUrlToIsLibraryFile", "valueMarkerProvider", "Lcom/intellij/javascript/debugger/V8ValueMarkerProvider;", "getValueMarkerProvider", "()Lcom/intellij/javascript/debugger/V8ValueMarkerProvider;", "addFirstLineBreakpointPattern", "", "pattern", "beforeInitBreakpoints", "vm", "Lorg/jetbrains/debugger/Vm;", "breakpointReached", "breakpoint", "Lcom/intellij/xdebugger/breakpoints/XBreakpoint;", "evaluatedLogExpression", "xSuspendContext", "Lcom/intellij/javascript/debugger/JavaScriptSuspendContext;", "suspendContext", "Lorg/jetbrains/debugger/SuspendContext;", "checkLibraryStepCondition", "script", "Lorg/jetbrains/debugger/Script;", "configureConsoleFilers", "console", "Lcom/intellij/execution/ui/ConsoleView;", "consoleCleared", "createBreakpointHandlers", "", "Lcom/intellij/xdebugger/breakpoints/XBreakpointHandler;", "()[Lcom/intellij/xdebugger/breakpoints/XBreakpointHandler;", "createConsole", "Lcom/intellij/execution/ui/ExecutionConsole;", "createDebuggerViewSupport", "createLanguageConsoleView", "createSourceInfo", "Lorg/jetbrains/debugger/SourceInfo;", "sourceFunctionName", "rawFunctionName", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "sourceLine", "", "sourceColumn", "url", "createSourceMapSourceResolver", "Lorg/jetbrains/debugger/sourcemap/SourceResolver;", "sourceUrls", "", "sourceContents", "baseUrl", "baseUrlIsFile", "resolveFileBySourceUrl", "createSuspendContext", "context", "topFrameSourceInfo", "createTabLayouter", "decodeSourceMap", "Lorg/jetbrains/debugger/sourcemap/SourceMap;", "sourceMapUrl", "sourceMapData", "", "dispose", "doGetProcessHandler", "Lcom/intellij/execution/process/ProcessHandler;", "doInitBreakpoints", "setBreakpoints", "findFile", "findByName", "findFileOrAny", "findFileOrCreateVm", "findMapping", "Lorg/jetbrains/debugger/sourcemap/MappingEntry;", "sourceMap", "line", "column", "findSourceMapBeforeAdd", "forEachScript", "scriptProcessor", "Lkotlin/Function1;", "getAsarFs", "path", "getAsarFs$JavaScriptDebugger", "getBreakpointFileUrl", "Lorg/jetbrains/annotations/Nullable;", "ideaUrl", "getBreakpointLanguageHint", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpoint;", "location", "Lorg/jetbrains/debugger/Location;", "getCurrentLocationUrl", "getEvaluator", "Lcom/intellij/xdebugger/evaluation/XDebuggerEvaluator;", "getGlobalEvaluator", "getGutterContentProvider", "Lcom/intellij/execution/console/GutterContentProvider;", "getLocationsForBreakpoint", "getSourceInfo", "scriptId", "scriptUrl", "functionName", "getSyntheticSuspend", "Lcom/intellij/javascript/debugger/SyntheticSuspendBreakpointInfo;", "initChildConnection", "childConnection", "(Lorg/jetbrains/debugger/connection/VmConnection;)V", "isActualBreakFile", "isLibraryFile", "sourceInfo", "isLibraryFileUsingIndex", "sourceFile", "isLineRelationshipComputable", "isMeteorClientScript", "Lcom/intellij/javascript/debugger/JavaScriptDebugProcess$IsMeteorScriptAnswer;", "isRemoveAllBreakpointsOnStop", "isSameSourceLine", "location1", "Lorg/jetbrains/debugger/CallFrame;", "location2", "isScriptFileEquals", "fileForScript", "expectedFile", "expectedLine", "isScriptFileEquals$JavaScriptDebugger", "isSteppingAllowed", "normalizeMemberName", "name", "normalizeMemberNameIfNotProcessedByDebugAware", "processBreakpoint", "processBreakpointLogExpressionAndSuspend", "processBreakpointsHit", "findSourceMap", "Lkotlin/ParameterName;", "processStepIntoFunction", "registerAdditionalActions", "leftToolbar", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "topToolbar", "settings", "runToPosition", "position", "Lcom/intellij/xdebugger/XSourcePosition;", "Lcom/intellij/xdebugger/frame/XSuspendContext;", "setLayouter", "value", "sourceMapFound", "map", "setPromises", "", "Lorg/jetbrains/concurrency/Promise;", "stopAsync", "updateRemoteUrlMappings", "mappings", "Lcom/intellij/javascript/debugger/execution/RemoteUrlMappingBean;", "IsMeteorScriptAnswer", "MyDebugEventListener", "JavaScriptDebugger"})
public abstract class JavaScriptDebugProcess<C extends VmConnection<?>>
extends DebugProcessImpl<C>
implements Disposable {
    @NotNull
    private final SourceTabManager sourceTabManager;
    private volatile FunctionStepIntoVariant expectedFunction;
    private final ChromeExceptionBreakpointHandler exceptionBreakpointHandler;
    @Nullable
    private final V8ValueMarkerProvider valueMarkerProvider;
    @NotNull
    private final JavaScriptLineBreakpointManager lineBreakpointManager;
    private GlobalEvaluator globalEvaluator;
    @NotNull
    private final ConsolePrinter consolePrinter;
    @NotNull
    private final JavaScriptDebuggerViewSupport debuggerViewSupport;
    private boolean elementsInspectorEnabled;
    private XDebugTabLayouter layouter;
    @NotNull
    private final ConcurrentMap<Url, Boolean> urlToIsLibraryFile;
    @NotNull
    private final PreloadedSourceMapList preloadedSourceMaps;
    private final boolean isFilesOnlyInLocalFileSystem = false;
    private final boolean isV8Inspector = false;
    @NotNull
    private final ConcurrentMap<String, AsarFileSystem> pathToAsarFs;
    private final MyDebugEventListener debugEventListener;
    private final SmartList<String> firstLineBreakpointPatterns;
    @NotNull
    private final DebuggableFileFinder finder;

    @NotNull
    public final SourceTabManager getSourceTabManager$JavaScriptDebugger() {
        return this.sourceTabManager;
    }

    @Nullable
    public V8ValueMarkerProvider getValueMarkerProvider() {
        return this.valueMarkerProvider;
    }

    @NotNull
    protected final JavaScriptLineBreakpointManager getLineBreakpointManager() {
        return this.lineBreakpointManager;
    }

    @NotNull
    protected final ConsolePrinter getConsolePrinter() {
        return this.consolePrinter;
    }

    @NotNull
    public final JavaScriptDebuggerViewSupport getDebuggerViewSupport() {
        return this.debuggerViewSupport;
    }

    public final boolean getElementsInspectorEnabled() {
        return this.elementsInspectorEnabled;
    }

    public final void setElementsInspectorEnabled(boolean bl) {
        this.elementsInspectorEnabled = bl;
    }

    @NotNull
    protected final ConcurrentMap<Url, Boolean> getUrlToIsLibraryFile() {
        return this.urlToIsLibraryFile;
    }

    public final void setLayouter(@NotNull XDebugTabLayouter value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.layouter = value;
    }

    @NotNull
    public final PreloadedSourceMapList getPreloadedSourceMaps() {
        return this.preloadedSourceMaps;
    }

    public boolean isFilesOnlyInLocalFileSystem() {
        return this.isFilesOnlyInLocalFileSystem;
    }

    public boolean isV8Inspector() {
        return this.isV8Inspector;
    }

    @NotNull
    public final ConcurrentMap<String, AsarFileSystem> getPathToAsarFs$JavaScriptDebugger() {
        return this.pathToAsarFs;
    }

    public final void addFirstLineBreakpointPattern(@NotNull String pattern) {
        Intrinsics.checkParameterIsNotNull((Object)pattern, (String)"pattern");
        this.firstLineBreakpointPatterns.add((Object)pattern);
    }

    @NotNull
    protected JavaScriptDebuggerViewSupport createDebuggerViewSupport() {
        return new JavaScriptDebuggerViewSupport(this);
    }

    protected boolean isLineRelationshipComputable() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final XBreakpointHandler<?>[] createBreakpointHandlers() {
        XBreakpointHandler[] xBreakpointHandlerArray;
        void additionalHandlers;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        JavaScriptDebugAware[] javaScriptDebugAwareArray = (JavaScriptDebugAware[])JavaScriptDebugAware.EP_NAME.getExtensions();
        for (int i = 0; i < javaScriptDebugAwareArray.length; ++i) {
            Class clazz;
            JavaScriptDebugAware debugAware = javaScriptDebugAwareArray[i];
            if (debugAware.getBreakpointTypeClass() == null) continue;
            Class it = clazz;
            if ((OrderedSet)additionalHandlers.element == null) {
                additionalHandlers.element = new OrderedSet();
            }
            OrderedSet orderedSet = (OrderedSet)additionalHandlers.element;
            if (orderedSet == null) {
                Intrinsics.throwNpe();
            }
            orderedSet.add((Object)it);
        }
        LineBreakpointHandler lineBreakpointHandler = new LineBreakpointHandler(JavaScriptBreakpointType.class, (LineBreakpointManager)this.lineBreakpointManager);
        if ((OrderedSet)additionalHandlers.element == null) {
            XBreakpointHandler[] elements$iv;
            xBreakpointHandlerArray = elements$iv = new XBreakpointHandler[]{(XBreakpointHandler)lineBreakpointHandler, this.exceptionBreakpointHandler};
        } else {
            OrderedSet orderedSet = (OrderedSet)additionalHandlers.element;
            if (orderedSet == null) {
                Intrinsics.throwNpe();
            }
            int size$iv = 2 + orderedSet.size();
            XBreakpointHandler[] result$iv = new XBreakpointHandler[size$iv];
            int n = 0;
            int n2 = size$iv - 1;
            if (n <= n2) {
                void i$iv;
                do {
                    XBreakpointHandler xBreakpointHandler;
                    XBreakpointHandler xBreakpointHandler2;
                    void it;
                    void $i$a$1$let = ++i$iv;
                    void var11_12 = i$iv;
                    XBreakpointHandler[] xBreakpointHandlerArray2 = result$iv;
                    switch (it) {
                        case 0: {
                            xBreakpointHandler2 = (XBreakpointHandler)lineBreakpointHandler;
                            break;
                        }
                        case 1: {
                            xBreakpointHandler2 = this.exceptionBreakpointHandler;
                            break;
                        }
                        default: {
                            OrderedSet orderedSet2 = (OrderedSet)additionalHandlers.element;
                            if (orderedSet2 == null) {
                                Intrinsics.throwNpe();
                            }
                            Object object = orderedSet2.get((int)(it - 2));
                            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"additionalHandlers!![it - 2]");
                            xBreakpointHandler2 = (XBreakpointHandler)new LineBreakpointHandler((Class)object, (LineBreakpointManager)this.lineBreakpointManager);
                        }
                    }
                    xBreakpointHandlerArray2[var11_12] = xBreakpointHandler = xBreakpointHandler2;
                } while (i$iv != n2);
            }
            xBreakpointHandlerArray = result$iv;
        }
        return xBreakpointHandlerArray;
    }

    protected void doInitBreakpoints(boolean setBreakpoints) {
        block10: {
            if (this.finder instanceof RemoteDebuggingFileFinder && !((RemoteDebuggingFileFinder)this.finder).getMappings$JavaScriptDebugger().isEmpty()) {
                new SourceMapCollector(this).collect(((RemoteDebuggingFileFinder)this.finder).getMappings$JavaScriptDebugger());
            } else if (this.isFilesOnlyInLocalFileSystem() && Registry.is((String)"js.debugger.use.preload.v8.inspector.ts", (boolean)false)) {
                Logger $receiver$iv = JavaScriptDebugProcessKt.getLOG();
                try {
                    Object object;
                    Object object2 = TypeScriptConfigService.Provider.get((Project)this.getSession().getProject());
                    if (object2 == null || (object2 = object2.getConfigFiles()) == null) break block10;
                    Object it = object = object2;
                    SourceMapCollector mapCollector = new SourceMapCollector(this);
                    Iterator iterator = it.iterator();
                    while (iterator.hasNext()) {
                        TypeScriptConfig config = (TypeScriptConfig)iterator.next();
                        Logger $receiver$iv2 = JavaScriptDebugProcessKt.getLOG();
                        try {
                            Path outDir;
                            String string;
                            if (!config.isSourceMap() && !config.isInlineSourceMap()) continue;
                            if (config.getOutDirectory() == null) continue;
                            String it2 = string;
                            Path path = outDir = Paths.get(it2, new String[0]);
                            Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"outDir");
                            SourceMapCollector.resolveSourcemaps$default(mapCollector, path, (Url)new LocalFileUrl(((Object)outDir).toString()), ((Object)outDir.getParent().toAbsolutePath()).toString(), config.isInlineSourceMap(), config.isSourceMap(), 0, 32, null);
                        }
                        catch (ProcessCanceledException e$iv) {
                        }
                        catch (Throwable e$iv) {
                            $receiver$iv2.error(e$iv);
                        }
                    }
                }
                catch (ProcessCanceledException e$iv) {
                }
                catch (Throwable e$iv) {
                    $receiver$iv.error(e$iv);
                }
            }
        }
        super.doInitBreakpoints(setBreakpoints);
    }

    public final void forEachScript(@NotNull Function1<? super Script, Boolean> scriptProcessor) {
        block0: {
            Intrinsics.checkParameterIsNotNull(scriptProcessor, (String)"scriptProcessor");
            Vm vm = this.getActiveOrMainVm();
            if (vm == null || (vm = vm.getScriptManager()) == null) break block0;
            vm.forEachScript(scriptProcessor);
        }
    }

    @NotNull
    protected ProcessHandler doGetProcessHandler() {
        ProcessHandler processHandler = super.doGetProcessHandler();
        ProcessHandler it = processHandler;
        ProcessHandler processHandler2 = it;
        if (!(processHandler2 instanceof DefaultDebugProcessHandler)) {
            processHandler2 = null;
        }
        DefaultDebugProcessHandler defaultDebugProcessHandler = (DefaultDebugProcessHandler)processHandler2;
        return defaultDebugProcessHandler != null ? (ProcessHandler)defaultDebugProcessHandler : (ProcessHandler)new ProcessHandlerWrapper((XDebugProcess)this, it);
    }

    protected boolean isRemoveAllBreakpointsOnStop() {
        return this.getRealProcessHandler() == null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Promise<?> stopAsync() {
        Promise promise;
        if (Disposer.isDisposed((Disposable)this)) {
            return Promises.nullPromise();
        }
        ConsoleView consoleView = this.getSession().getConsoleView();
        if (consoleView instanceof LanguageConsoleView) {
            try {
                AppUIUtil.invokeOnEdt((Runnable)new Runnable(consoleView){
                    final /* synthetic */ ConsoleView $consoleView;

                    public final void run() {
                        ((LanguageConsoleView)this.$consoleView).setConsoleEditorEnabled(false);
                    }
                    {
                        this.$consoleView = consoleView;
                    }
                });
            }
            catch (Exception e) {
                JavaScriptDebugProcessKt.getLOG().error((Throwable)e);
            }
        }
        Vm vm = this.getMainVm();
        if (this.isRemoveAllBreakpointsOnStop() && vm != null) {
            void $receiver$iv;
            Promise promise2 = this.lineBreakpointManager.removeAllBreakpoints(vm);
            Promise promise3 = $receiver$iv.then(new Function<Promise<? extends Object>, SUB_RESULT>(this){
                final /* synthetic */ JavaScriptDebugProcess this$0;
                {
                    this.this$0 = javaScriptDebugProcess;
                }

                public final Promise<? extends Object> fun(Object it) {
                    return this.this$0.getConnection().detachAndClose();
                }
            });
            promise = promise3;
            Intrinsics.checkExpressionValueIsNotNull((Object)promise3, (String)"(this as Promise<Any?>).then({ handler() })");
        } else {
            promise = this.getConnection().detachAndClose();
        }
        Promise promise4 = promise;
        Disposer.dispose((Disposable)this);
        return promise4;
    }

    @JvmOverloads
    @Nullable
    public final VirtualFile findFile(@NotNull Url url, boolean findByName2) {
        VirtualFile virtualFile;
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        VirtualFile result = (VirtualFile)this.getUrlToFileCache().get(url);
        if (result != null) {
            if (result.isValid()) {
                return result;
            }
            this.getUrlToFileCache().remove(url, result);
        }
        if ((virtualFile = FileResolverByContentKt.findFileIfAsar(this, url)) == null) {
            Project project = this.getSession().getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"session.project");
            virtualFile = result = this.finder.findFile(url, project, findByName2);
        }
        if (result != null) {
            this.getUrlToFileCache().putIfAbsent(url, result);
        }
        return result;
    }

    @JvmOverloads
    @Nullable
    public static /* bridge */ /* synthetic */ VirtualFile findFile$default(JavaScriptDebugProcess javaScriptDebugProcess, Url url, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: findFile");
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        return javaScriptDebugProcess.findFile(url, bl);
    }

    @JvmOverloads
    @Nullable
    public final VirtualFile findFile(@NotNull Url url) {
        return JavaScriptDebugProcess.findFile$default(this, url, false, 2, null);
    }

    private final boolean processStepIntoFunction(Vm vm, SuspendContext<?> context, Script script) {
        block1: {
            FunctionStepIntoVariant functionStepIntoVariant;
            FunctionStepIntoVariant functionStepIntoVariant2 = this.expectedFunction;
            if (functionStepIntoVariant2 == null) break block1;
            FunctionStepIntoVariant it = functionStepIntoVariant = functionStepIntoVariant2;
            CallFrame topFrame = context.getTopFrame();
            if (topFrame == null || !JavaScriptSmartStepIntoHandlerKt.compareFunctions(this, it, topFrame, script)) {
                this.continueVm(vm, this.getRepeatStepInto().compareAndSet(false, true) ? StepAction.OUT : StepAction.IN);
                return false;
            }
            this.expectedFunction = null;
        }
        return true;
    }

    @Nullable
    protected SyntheticSuspendBreakpointInfo getSyntheticSuspend(@NotNull SuspendContext<?> context, @NotNull Script script) {
        Intrinsics.checkParameterIsNotNull(context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)script, (String)"script");
        return JavaScriptDebugProcess.processBreakpointsHit$default(this, context, script, null, 4, null);
    }

    public final void sourceMapFound(@NotNull Vm vm, @NotNull SourceMap map, @Nullable Script script, @Nullable Url scriptUrl, @Nullable List<Promise<?>> setPromises) {
        SuspendContext context;
        List<JavaScriptLineBreakpointManager.VmBreakpointLocation> breakpoints;
        boolean reAddToSourceTabManager;
        Intrinsics.checkParameterIsNotNull((Object)vm, (String)"vm");
        Intrinsics.checkParameterIsNotNull((Object)map, (String)"map");
        boolean bl = reAddToSourceTabManager = script != null && script.getSourceMap() == null;
        if (reAddToSourceTabManager) {
            Script script2 = script;
            if (script2 == null) {
                Intrinsics.throwNpe();
            }
            script2.setSourceMap(map);
        }
        if ((breakpoints = this.lineBreakpointManager.sourceMapFound(vm, map, script, scriptUrl)).isEmpty()) {
            return;
        }
        SuspendContext suspendContext = context = vm.getSuspendContextManager().getContext();
        CallFrame frame = suspendContext != null ? suspendContext.getTopFrame() : null;
        XBreakpoint currentBreakpoint = null;
        Ref promiseRef = setPromises == null ? null : new Ref();
        block0: for (JavaScriptLineBreakpointManager.VmBreakpointLocation vmBreakpointLocation : breakpoints) {
            Ref ref;
            XLineBreakpoint<?> breakpoint = vmBreakpointLocation.component1();
            List<Location> locations = vmBreakpointLocation.component2();
            if (currentBreakpoint == null && frame != null) {
                for (Location location : locations) {
                    Script contextScript;
                    if (frame.getLine() != location.getLine() || frame.getColumn() != location.getColumn()) continue;
                    SuspendContext suspendContext2 = context;
                    if (suspendContext2 == null) {
                        Intrinsics.throwNpe();
                    }
                    if ((contextScript = suspendContext2.getScript()) == null || !this.isActualBreakFile((XBreakpoint)breakpoint, contextScript)) continue;
                    currentBreakpoint = (XBreakpoint)breakpoint;
                    continue block0;
                }
            }
            LineBreakpointManager.doRemoveBreakpoint$default((LineBreakpointManager)this.lineBreakpointManager, (Vm)vm, breakpoint, (boolean)false, (int)4, null);
            this.lineBreakpointManager.setBreakpoint(vm, breakpoint, locations, promiseRef);
            Ref ref2 = promiseRef;
            if (ref2 == null || (ref2 = (Promise)ref2.get()) == null) continue;
            Ref it = ref = ref2;
            List<Promise<?>> list = setPromises;
            if (list == null) {
                Intrinsics.throwNpe();
            }
            list.add((Promise<?>)it);
        }
        if (currentBreakpoint != null) {
            SuspendContext suspendContext3 = context;
            if (suspendContext3 == null) {
                Intrinsics.throwNpe();
            }
            Script script3 = context.getScript();
            if (script3 == null) {
                Intrinsics.throwNpe();
            }
            this.processBreakpoint(suspendContext3, currentBreakpoint, script3);
        }
        if (reAddToSourceTabManager) {
            Script script4 = script;
            if (script4 == null) {
                Intrinsics.throwNpe();
            }
            this.sourceTabManager.removeScript(script4);
            this.sourceTabManager.addScript(script);
        }
    }

    public static /* bridge */ /* synthetic */ void sourceMapFound$default(JavaScriptDebugProcess javaScriptDebugProcess, Vm vm, SourceMap sourceMap, Script script, Url url, List list, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: sourceMapFound");
        }
        if ((n & 8) != 0) {
            url = null;
        }
        if ((n & 0x10) != 0) {
            list = null;
        }
        javaScriptDebugProcess.sourceMapFound(vm, sourceMap, script, url, list);
    }

    private final void processBreakpoint(SuspendContext<?> suspendContext, XBreakpoint<?> breakpoint, Script script) {
        this.processBreakpoint(suspendContext, breakpoint, JavaScriptDebugProcess.createSuspendContext$default(this, suspendContext, script, null, 4, null));
    }

    private final void processBreakpoint(SuspendContext<?> suspendContext, XBreakpoint<?> breakpoint, JavaScriptSuspendContext xSuspendContext) {
        String condition;
        XExpression xExpression = breakpoint.getConditionExpression();
        String string = condition = xExpression != null ? xExpression.getExpression() : null;
        if (!this.getProcessBreakpointConditionsAtIdeSide() || condition == null) {
            this.processBreakpointLogExpressionAndSuspend(breakpoint, xSuspendContext, suspendContext);
        } else {
            Promise $receiver$iv;
            Promise promise = xSuspendContext.evaluateExpression(condition);
            $receiver$iv = $receiver$iv.done((Consumer)new ContextDependentAsyncResultConsumer<String>(suspendContext, suspendContext, this, suspendContext, breakpoint, xSuspendContext){
                final /* synthetic */ SuspendContext $context;
                final /* synthetic */ JavaScriptDebugProcess this$0;
                final /* synthetic */ SuspendContext $suspendContext$inlined;
                final /* synthetic */ XBreakpoint $breakpoint$inlined;
                final /* synthetic */ JavaScriptSuspendContext $xSuspendContext$inlined;
                {
                    this.$context = $captured_local_variable$1;
                    this.this$0 = javaScriptDebugProcess;
                    this.$suspendContext$inlined = suspendContext;
                    this.$breakpoint$inlined = xBreakpoint;
                    this.$xSuspendContext$inlined = javaScriptSuspendContext;
                    super($super_call_param$2);
                }

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 */
                protected void consume(Object result, Vm vm) {
                    String it = (String)result;
                    if (Intrinsics.areEqual((Object)it, (Object)"false")) {
                        this.this$0.resume(this.$suspendContext$inlined.getVm());
                    } else {
                        JavaScriptDebugProcess.access$processBreakpointLogExpressionAndSuspend(this.this$0, this.$breakpoint$inlined, this.$xSuspendContext$inlined, this.$suspendContext$inlined);
                    }
                }
            });
            $receiver$iv.rejected((Consumer)new ContextDependentAsyncResultConsumer<Throwable>(suspendContext, suspendContext, this, breakpoint, xSuspendContext, suspendContext){
                final /* synthetic */ SuspendContext $context;
                final /* synthetic */ JavaScriptDebugProcess this$0;
                final /* synthetic */ XBreakpoint $breakpoint$inlined;
                final /* synthetic */ JavaScriptSuspendContext $xSuspendContext$inlined;
                final /* synthetic */ SuspendContext $suspendContext$inlined;
                {
                    this.$context = $captured_local_variable$1;
                    this.this$0 = javaScriptDebugProcess;
                    this.$breakpoint$inlined = xBreakpoint;
                    this.$xSuspendContext$inlined = javaScriptSuspendContext;
                    this.$suspendContext$inlined = suspendContext;
                    super($super_call_param$2);
                }

                protected void consume(Throwable result, Vm vm) {
                    Throwable it = result;
                    JavaScriptDebugProcess.access$processBreakpointLogExpressionAndSuspend(this.this$0, this.$breakpoint$inlined, this.$xSuspendContext$inlined, this.$suspendContext$inlined);
                }
            });
        }
    }

    private final void processBreakpointLogExpressionAndSuspend(XBreakpoint<?> breakpoint, JavaScriptSuspendContext xSuspendContext, SuspendContext<?> suspendContext) {
        String logExpression;
        XExpression xExpression = breakpoint.getLogExpressionObject();
        String string = logExpression = xExpression != null ? xExpression.getExpression() : null;
        if (logExpression == null) {
            this.breakpointReached(breakpoint, null, xSuspendContext, suspendContext);
        } else {
            Promise $receiver$iv;
            Promise promise = xSuspendContext.evaluateExpression(logExpression);
            $receiver$iv = $receiver$iv.done((Consumer)new ContextDependentAsyncResultConsumer<String>(suspendContext, suspendContext, this, breakpoint, xSuspendContext, suspendContext){
                final /* synthetic */ SuspendContext $context;
                final /* synthetic */ JavaScriptDebugProcess this$0;
                final /* synthetic */ XBreakpoint $breakpoint$inlined;
                final /* synthetic */ JavaScriptSuspendContext $xSuspendContext$inlined;
                final /* synthetic */ SuspendContext $suspendContext$inlined;
                {
                    this.$context = $captured_local_variable$1;
                    this.this$0 = javaScriptDebugProcess;
                    this.$breakpoint$inlined = xBreakpoint;
                    this.$xSuspendContext$inlined = javaScriptSuspendContext;
                    this.$suspendContext$inlined = suspendContext;
                    super($super_call_param$2);
                }

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 */
                protected void consume(Object result, Vm vm) {
                    String it = (String)result;
                    JavaScriptDebugProcess.access$breakpointReached(this.this$0, this.$breakpoint$inlined, it, this.$xSuspendContext$inlined, this.$suspendContext$inlined);
                }
            });
            $receiver$iv.rejected((Consumer)new ContextDependentAsyncResultConsumer<Throwable>(suspendContext, suspendContext, this, breakpoint, logExpression, xSuspendContext, suspendContext){
                final /* synthetic */ SuspendContext $context;
                final /* synthetic */ JavaScriptDebugProcess this$0;
                final /* synthetic */ XBreakpoint $breakpoint$inlined;
                final /* synthetic */ String $logExpression$inlined;
                final /* synthetic */ JavaScriptSuspendContext $xSuspendContext$inlined;
                final /* synthetic */ SuspendContext $suspendContext$inlined;
                {
                    this.$context = $captured_local_variable$1;
                    this.this$0 = javaScriptDebugProcess;
                    this.$breakpoint$inlined = xBreakpoint;
                    this.$logExpression$inlined = string;
                    this.$xSuspendContext$inlined = javaScriptSuspendContext;
                    this.$suspendContext$inlined = suspendContext;
                    super($super_call_param$2);
                }

                protected void consume(Throwable result, Vm vm) {
                    Throwable it = result;
                    JavaScriptDebugProcess.access$breakpointReached(this.this$0, this.$breakpoint$inlined, "Failed to evaluate expression: " + this.$logExpression$inlined, this.$xSuspendContext$inlined, this.$suspendContext$inlined);
                }
            });
        }
    }

    private final void breakpointReached(XBreakpoint<?> breakpoint, String evaluatedLogExpression, JavaScriptSuspendContext xSuspendContext, SuspendContext<?> suspendContext) {
        if (this.getSession().breakpointReached(breakpoint, evaluatedLogExpression, (XSuspendContext)xSuspendContext)) {
            this.setOverlay(suspendContext);
        } else {
            this.resume(suspendContext.getVm());
        }
    }

    @Nullable
    public Url getCurrentLocationUrl() {
        return null;
    }

    public final void updateRemoteUrlMappings(@NotNull List<? extends RemoteUrlMappingBean> mappings) {
        Intrinsics.checkParameterIsNotNull(mappings, (String)"mappings");
        DebuggableFileFinder finder = this.finder;
        if (finder instanceof RemoteDebuggingFileFinder && ((RemoteDebuggingFileFinder)finder).updateRemoteUrlMapping(mappings)) {
            this.getUrlToFileCache().clear();
            Vm vm = this.getActiveOrMainVm();
            if (vm == null) {
                Intrinsics.throwNpe();
            }
            this.lineBreakpointManager.updateAllBreakpoints(vm);
        }
    }

    public void runToPosition(@NotNull XSourcePosition position, @Nullable XSuspendContext context) {
        Intrinsics.checkParameterIsNotNull((Object)position, (String)"position");
        XSuspendContext xSuspendContext = context;
        if ((xSuspendContext == null || (xSuspendContext = this.getVm(xSuspendContext)) == null) && (xSuspendContext = this.getActiveOrMainVm()) == null) {
            Intrinsics.throwNpe();
        }
        this.lineBreakpointManager.runToLocation(position, (Vm)xSuspendContext);
    }

    public final void dispose() {
    }

    @NotNull
    public final XDebugTabLayouter createTabLayouter() {
        XDebugTabLayouter xDebugTabLayouter = this.layouter;
        if (xDebugTabLayouter == null) {
            xDebugTabLayouter = new JSDebugTabLayouter(this);
        }
        return xDebugTabLayouter;
    }

    public void registerAdditionalActions(@NotNull DefaultActionGroup leftToolbar, @NotNull DefaultActionGroup topToolbar, @NotNull DefaultActionGroup settings) {
        block0: {
            Object object;
            Intrinsics.checkParameterIsNotNull((Object)leftToolbar, (String)"leftToolbar");
            Intrinsics.checkParameterIsNotNull((Object)topToolbar, (String)"topToolbar");
            Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
            leftToolbar.add((AnAction)new ToggleExceptionBreakpointAction());
            Object object2 = this.getExecutionResult();
            if (object2 == null || (object2 = object2.getActions()) == null || (object2 = ArraysKt.asList((Object[])object2)) == null) break block0;
            Object it = object = object2;
            leftToolbar.addAll((Collection)it);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Location> getLocationsForBreakpoint(@NotNull Vm vm, @NotNull XLineBreakpoint<?> breakpoint) {
        SourceInfo lambdaPosition;
        Intrinsics.checkParameterIsNotNull((Object)vm, (String)"vm");
        Intrinsics.checkParameterIsNotNull(breakpoint, (String)"breakpoint");
        XSourcePosition position = breakpoint.getSourcePosition();
        if (position == null) {
            JavaScriptDebugProcessKt.getLOG().warn("Unable to set breakpoint with null position: " + breakpoint.getFileUrl());
            return CollectionsKt.emptyList();
        }
        VirtualFile file = position.getFile();
        if (this.isFilesOnlyInLocalFileSystem() && !file.isInLocalFileSystem()) {
            return CollectionsKt.emptyList();
        }
        VirtualFile virtualFile = file;
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"file");
        List<Url> urls = this.finder.getRemoteUrls(virtualFile);
        Project project = this.getSession().getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"session.project");
        SourceInfo sourceInfo = lambdaPosition = PsiVisitorKt.getLambdaPosition(breakpoint, project);
        int column = sourceInfo != null ? sourceInfo.getColumn() : -1;
        VirtualFile virtualFile2 = position.getFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"position.file");
        List locations = SourceMapHelperKt.getRawLocations$default(this, urls, virtualFile2, position.getLine(), null, null, null, column, 112, null);
        if (locations.isEmpty()) {
            List list;
            this.lineBreakpointManager.sourceMapNotFound(breakpoint, vm);
            if (!this.isFilesOnlyInLocalFileSystem() && this.finder instanceof RemoteDebuggingFileFinder) {
                DebuggableFileFinder debuggableFileFinder = ((RemoteDebuggingFileFinder)this.finder).getParent$JavaScriptDebugger();
                if (!(debuggableFileFinder instanceof DebuggableFileFinderImpl)) {
                    debuggableFileFinder = null;
                }
                DebuggableFileFinderImpl debuggableFileFinderImpl = (DebuggableFileFinderImpl)debuggableFileFinder;
                String string = debuggableFileFinderImpl != null ? debuggableFileFinderImpl.getAuthority$JavaScriptDebugger() : null;
                CharSequence charSequence = string;
                if (!(charSequence == null || charSequence.length() == 0)) {
                    String string2 = string;
                    if (string2 == null) {
                        Intrinsics.throwNpe();
                    }
                    if (!JsFileUtil.isOnBuiltInWebServerByAuthority(string2)) {
                        VirtualFile virtualFile3 = file;
                        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile3, (String)"file");
                        Object isMeteorScript = this.isMeteorClientScript(virtualFile3);
                        if (Intrinsics.areEqual(isMeteorScript, (Object)((Object)IsMeteorScriptAnswer.NOT_A_METEOR_SCRIPT)) ^ true) {
                            if (Intrinsics.areEqual(isMeteorScript, (Object)((Object)IsMeteorScriptAnswer.MAYBE_METEOR_CLIENT_SCRIPT))) {
                                this.lineBreakpointManager.setMeteorAnyClientScriptBreakpointIfNeed(vm, "https?://" + string + "/app/.+" + "\\" + ".js" + JavaScriptLineBreakpointManagerKt.PATTERN_PARAMETERS_POSTFIX);
                            }
                            return CollectionsKt.emptyList();
                        }
                    }
                }
            }
            if (this.isV8Inspector() && this instanceof FilePathRegExpCreator) {
                for (Url url : urls) {
                    if (!StringsKt.endsWith$default((String)url.getPath(), (String)".js", (boolean)false, (int)2, null)) {
                        FileUtilRt.getNameWithoutExtension((String)url.getPath());
                    }
                    JavaScriptLineBreakpointManager.setAnyFirstLineBreakpoint$default(this.lineBreakpointManager, vm, ((FilePathRegExpCreator)((Object)this)).createFilePathRegExp(url, true), null, 4, null);
                }
            }
            VirtualFile virtualFile4 = file;
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile4, (String)"file");
            if (this.finder.isOnlySourceMappedBreakpoints(virtualFile4)) {
                list = CollectionsKt.emptyList();
            } else {
                Iterable iterable = urls;
                Collection destination$iv = (Collection)new SmartList();
                for (Object item$iv : iterable) {
                    void it;
                    Url url = (Url)item$iv;
                    Collection collection = destination$iv;
                    Location location = new Location((Url)it, position.getLine(), column);
                    collection.add(location);
                }
                list = (List)destination$iv;
            }
            return list;
        }
        if (locations.size() == 1 && lambdaPosition == null) {
            return CollectionsKt.listOf((Object)((Location)CollectionsKt.first((List)locations)).withoutColumn());
        }
        return locations;
    }

    private final IsMeteorScriptAnswer isMeteorClientScript(VirtualFile file) {
        VirtualFile projectBaseDir = this.getSession().getProject().getBaseDir();
        VirtualFile virtualFile = file.getParent();
        if (virtualFile == null) {
            return IsMeteorScriptAnswer.NOT_A_METEOR_SCRIPT;
        }
        VirtualFile parent = virtualFile;
        do {
            if (parent.findChild(".meteor") != null) {
                if (StringUtil.equals((CharSequence)parent.getNameSequence(), (CharSequence)"server")) {
                    return IsMeteorScriptAnswer.METEOR_SERVER_SCRIPT;
                }
                return IsMeteorScriptAnswer.MAYBE_METEOR_CLIENT_SCRIPT;
            }
            if (parent.getParent() != null) continue;
            return IsMeteorScriptAnswer.NOT_A_METEOR_SCRIPT;
        } while (!Intrinsics.areEqual((Object)parent, (Object)projectBaseDir));
        return IsMeteorScriptAnswer.NOT_A_METEOR_SCRIPT;
    }

    @Nullable
    protected Url getBreakpointFileUrl(@NotNull String ideaUrl) {
        Intrinsics.checkParameterIsNotNull((Object)ideaUrl, (String)"ideaUrl");
        return Urls.parseFromIdea((CharSequence)ideaUrl);
    }

    @Nullable
    public final VirtualFile findFile(@NotNull Script $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return this.findFile($receiver.getUrl(), $receiver.getSourceMap() == null);
    }

    private final MappingEntry findMapping(SourceMap sourceMap, int line, int column) {
        int normalizedColumn = column == -1 ? 0 : column;
        MappingEntry mappingEntry = sourceMap.getGeneratedMappings().get(line, normalizedColumn);
        if (mappingEntry == null) {
            mappingEntry = sourceMap.getGeneratedMappings().get(line - 1, normalizedColumn);
        }
        return mappingEntry;
    }

    @Nullable
    public final SourceInfo getSourceInfo(@Nullable String rawFunctionName, @NotNull Script script, int line, int column) {
        VirtualFile virtualFile;
        Url url;
        int sourceUrl;
        MappingEntry mapping;
        Intrinsics.checkParameterIsNotNull((Object)script, (String)"script");
        SourceMap sourceMap = script.getSourceMap();
        if (sourceMap == null) {
            SourceInfo sourceInfo;
            VirtualFile virtualFile2 = this.findFileOrCreateVm(script);
            if (virtualFile2 != null) {
                VirtualFile virtualFile3;
                VirtualFile it = virtualFile3 = virtualFile2;
                boolean addScriptOffset = this.isFilesOnlyInLocalFileSystem();
                int sourceLine = line + (addScriptOffset ? script.getLine() : 0);
                int sourceColumn = column + (addScriptOffset ? script.getColumn() : 0);
                sourceInfo = this.createSourceInfo(null, rawFunctionName, it, sourceLine, sourceColumn, script.getUrl());
            } else {
                sourceInfo = null;
            }
            return sourceInfo;
        }
        SourceMap sourceMap2 = sourceMap;
        MappingEntry mappingEntry = mapping = this.findMapping(sourceMap2, line, column);
        int n = sourceUrl = mappingEntry != null ? mappingEntry.getSource() : -1;
        if (sourceUrl == -1) {
            SourceInfo sourceInfo;
            VirtualFile virtualFile4 = this.findFileOrCreateVm(script);
            if (virtualFile4 != null) {
                VirtualFile addScriptOffset;
                VirtualFile it = addScriptOffset = virtualFile4;
                sourceInfo = this.createSourceInfo(null, rawFunctionName, it, line, column, script.getUrl());
            } else {
                sourceInfo = null;
            }
            return sourceInfo;
        }
        SourceResolver sourceResolver = sourceMap2.getSourceResolver();
        MappingEntry mappingEntry2 = mapping;
        if (mappingEntry2 == null) {
            Intrinsics.throwNpe();
        }
        Url url2 = url = sourceResolver.getSource(mappingEntry2);
        if (url2 != null) {
            Url $i$a$1$let;
            Url it = $i$a$1$let = url2;
            virtualFile = JavaScriptDebugProcess.findFile$default(this, it, false, 2, null);
        } else {
            virtualFile = null;
        }
        VirtualFile file = virtualFile;
        Url effectiveSourceUrl = url;
        if (file == null) {
            Url localFileUrl = sourceMap2.getSourceResolver().getUrlIfLocalFile(mapping);
            if (localFileUrl != null) {
                file = LocalFileFinder.findFile((String)localFileUrl.getPath());
                effectiveSourceUrl = localFileUrl;
            } else {
                String rawSource;
                String string = rawSource = sourceMap2.getSourceResolver().getRawSource(mapping);
                if (Intrinsics.areEqual((Object)(string != null ? StringsKt.firstOrNull((CharSequence)string) : null), (Object)Character.valueOf('.'))) {
                    VirtualFile virtualFile5;
                    VirtualFile virtualFile6 = this.findFile(script);
                    if (virtualFile6 != null && (virtualFile6 = virtualFile6.getParent()) != null) {
                        String string2 = rawSource;
                        if (string2 == null) {
                            Intrinsics.throwNpe();
                        }
                        virtualFile5 = virtualFile6.findFileByRelativePath(string2);
                    } else {
                        virtualFile5 = null;
                    }
                    file = virtualFile5;
                    effectiveSourceUrl = null;
                } else if (url != null) {
                    file = VirtualFileManager.getInstance().findFileByUrl(url.toExternalForm());
                }
            }
            if (file == null) {
                String sourceContent = sourceMap2.getSourceResolver().getSourceContent(mapping);
                if (sourceContent == null) {
                    SourceInfo sourceInfo;
                    JavaScriptDebugProcessKt.getLOG().warn("Cannot find source file " + url + ", script " + script.getUrl());
                    VirtualFile virtualFile7 = ScriptsKt.findRemoteFile(script, script.getUrl());
                    if (virtualFile7 != null) {
                        VirtualFile virtualFile8;
                        VirtualFile it = virtualFile8 = virtualFile7;
                        sourceInfo = this.createSourceInfo(null, rawFunctionName, it, line, column, script.getUrl());
                    } else {
                        sourceInfo = null;
                    }
                    return sourceInfo;
                }
                effectiveSourceUrl = url;
                Url url3 = url;
                if (url3 == null) {
                    Intrinsics.throwNpe();
                }
                file = ScriptsKt.createVmFile(url3, (UserDataHolder)script, sourceContent, mapping.getSource());
            }
        }
        return this.createSourceInfo(mapping.getName(), rawFunctionName, file, mapping.getSourceLine(), mapping.getSourceColumn(), effectiveSourceUrl);
    }

    private final VirtualFile findFileOrCreateVm(Script script) {
        VirtualFile virtualFile = this.findFile(script);
        if (virtualFile == null) {
            virtualFile = ScriptsKt.findRemoteFile(script, script.getUrl());
        }
        return virtualFile;
    }

    private final SourceInfo createSourceInfo(String sourceFunctionName, String rawFunctionName, VirtualFile file, int sourceLine, int sourceColumn, Url url) {
        SourceInfo sourceInfo;
        if (file instanceof HttpVirtualFile) {
            RemoteFileInfo remoteFileInfo = ((HttpVirtualFile)file).getFileInfo();
            if (Intrinsics.areEqual((Object)(remoteFileInfo != null ? remoteFileInfo.getState() : null), (Object)RemoteFileState.ERROR_OCCURRED)) {
                file.refresh(true, false);
            }
        }
        SourceInfo sourceInfo2 = sourceInfo;
        SourceInfo sourceInfo3 = sourceInfo;
        VirtualFile virtualFile = file;
        int n = sourceLine;
        int n2 = sourceColumn;
        int n3 = 0;
        String string = sourceFunctionName;
        if (string == null) {
            String string2 = rawFunctionName;
            if (string2 != null) {
                String string3 = string2;
                int n4 = n3;
                int n5 = n2;
                int n6 = n;
                VirtualFile virtualFile2 = virtualFile;
                SourceInfo sourceInfo4 = sourceInfo2;
                SourceInfo sourceInfo5 = sourceInfo3;
                String it = string3;
                String string4 = this.normalizeMemberName(it);
                sourceInfo3 = sourceInfo5;
                sourceInfo2 = sourceInfo4;
                virtualFile = virtualFile2;
                n = n6;
                n2 = n5;
                n3 = n4;
                string = string4;
            } else {
                string = null;
            }
        }
        sourceInfo2(virtualFile, n, n2, n3, string, url, 8, null);
        return sourceInfo3;
    }

    @NotNull
    public final String normalizeMemberName(@NotNull String name) {
        String string;
        String string2;
        block2: {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Object[] $receiver$iv = JavaScriptDebugAware.EP_NAME.getExtensions();
            for (int i = 0; i < $receiver$iv.length; ++i) {
                Object file$iv = $receiver$iv[i];
                JavaScriptDebugAware it = (JavaScriptDebugAware)file$iv;
                String result$iv = it.normalizeMemberName(name);
                if (result$iv == null) continue;
                string2 = result$iv;
                break block2;
            }
            string2 = string = null;
        }
        if (string2 == null) {
            string = Intrinsics.areEqual((Object)"(anonymous function)", (Object)name) ? "" : this.normalizeMemberNameIfNotProcessedByDebugAware(name);
        }
        return string;
    }

    @NotNull
    protected String normalizeMemberNameIfNotProcessedByDebugAware(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return name;
    }

    @Nullable
    public final VirtualFile findFileOrAny(@NotNull Url url) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        VirtualFile virtualFile = JavaScriptDebugProcess.findFile$default(this, url, false, 2, null);
        if (virtualFile == null) {
            virtualFile = VirtualFileManager.getInstance().findFileByUrl(url.toExternalForm());
        }
        return virtualFile;
    }

    protected void initChildConnection(@NotNull C childConnection) {
        Intrinsics.checkParameterIsNotNull(childConnection, (String)"childConnection");
        super.initChildConnection(childConnection);
        childConnection.addDebugListener((DebugEventListener)this.debugEventListener);
    }

    @NotNull
    protected JavaScriptSuspendContext createSuspendContext(@NotNull SuspendContext<?> context, @Nullable Script script, @Nullable SourceInfo topFrameSourceInfo) {
        String string;
        Intrinsics.checkParameterIsNotNull(context, (String)"context");
        if (Intrinsics.areEqual((Object)context.getVm(), (Object)this.getMainVm())) {
            string = "";
        } else {
            string = context.getVm().getName();
            if (string == null) {
                Intrinsics.throwNpe();
            }
        }
        String displayName = string;
        return new JavaScriptSuspendContext(this, new ExecutionStackView(context, (DebuggerViewSupport)this.debuggerViewSupport, script, topFrameSourceInfo, displayName));
    }

    @NotNull
    public static /* bridge */ /* synthetic */ JavaScriptSuspendContext createSuspendContext$default(JavaScriptDebugProcess javaScriptDebugProcess, SuspendContext suspendContext, Script script, SourceInfo sourceInfo, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createSuspendContext");
        }
        if ((n & 4) != 0) {
            sourceInfo = null;
        }
        return javaScriptDebugProcess.createSuspendContext(suspendContext, script, sourceInfo);
    }

    @Nullable
    protected SourceMap findSourceMapBeforeAdd(@NotNull Vm vm, @NotNull Script script, @Nullable String sourceMapUrl) {
        SourceMap sourceMap;
        block11: {
            block10: {
                Intrinsics.checkParameterIsNotNull((Object)vm, (String)"vm");
                Intrinsics.checkParameterIsNotNull((Object)script, (String)"script");
                CharSequence charSequence = sourceMapUrl;
                if (charSequence == null || charSequence.length() == 0) break block10;
                String string = sourceMapUrl;
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                if (!StringsKt.startsWith$default((String)string, (String)"blob:", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)sourceMapUrl, (String)"javascript:", (boolean)false, (int)2, null)) break block11;
            }
            return null;
        }
        SourceMap newSourceMap = null;
        if (URLUtil.isDataUri((String)sourceMapUrl)) {
            sourceMap = this.preloadedSourceMaps.getByScript(script.getUrl());
            if (sourceMap == null) {
                newSourceMap = sourceMap = this.decodeSourceMap(null, SourceMapLoaderKt.loadFromDataUri(sourceMapUrl, script.getUrl(), this.getSession()), script);
            }
        } else {
            Url parsedUrl = SourceMapLoaderKt.canonicalizeUrl(sourceMapUrl, script.getUrl());
            sourceMap = this.preloadedSourceMaps.get(parsedUrl);
            if (sourceMap == null) {
                newSourceMap = sourceMap = SourceMapLoaderKt.findSourceMap(parsedUrl, script, this);
            }
        }
        if (sourceMap != null) {
            script.setSourceMap(sourceMap);
        }
        return newSourceMap;
    }

    private final boolean isSameSourceLine(Vm vm, CallFrame location1, CallFrame location2) {
        if (location1 == null || location2 == null) {
            return false;
        }
        ScriptManager scriptManager = vm.getScriptManager();
        Script script = scriptManager.getScript(location1);
        if (script == null) {
            return false;
        }
        Script script1 = script;
        Script script2 = scriptManager.getScript(location2);
        if (script2 == null) {
            return false;
        }
        Script script22 = script2;
        if (script1 != script22) {
            VirtualFile virtualFile = this.findFile(script1);
            if (virtualFile == null) {
                return false;
            }
            VirtualFile file1 = virtualFile;
            VirtualFile virtualFile2 = this.findFile(script22);
            if (virtualFile2 == null) {
                return false;
            }
            VirtualFile file2 = virtualFile2;
            if (!Intrinsics.areEqual((Object)file1, (Object)file2) && !Intrinsics.areEqual((Object)file1.getCanonicalFile(), (Object)file2.getCanonicalFile())) {
                return false;
            }
        }
        int line1 = location1.getLine();
        int line2 = location2.getLine();
        SourceMap sourceMap = script1.getSourceMap();
        if (sourceMap == null) {
            return line1 == line2;
        }
        SourceMap sourceMap2 = sourceMap;
        return sourceMap2.getSourceLineByRawLocation(line1, location1.getColumn()) == sourceMap2.getSourceLineByRawLocation(line2, location2.getColumn());
    }

    private final boolean isSteppingAllowed(Script script) {
        List<FileNameMatcher> steppingFilters;
        Url url = script.getUrl();
        if (Intrinsics.areEqual((Object)ScriptManagerKt.VM_SCHEME, (Object)url.getScheme()) ^ true && !(steppingFilters = JavaScriptDebuggerSettings.getInstance().getComputedSteppingFilters()).isEmpty()) {
            String urlAsString = url.trimParameters().toDecodedForm();
            for (FileNameMatcher fileNameMatcher : steppingFilters) {
                if (!fileNameMatcher.accept(urlAsString)) continue;
                return false;
            }
        }
        return this.getDisableDoNotStepIntoLibraries() || this.checkLibraryStepCondition(script);
    }

    private final boolean checkLibraryStepCondition(Script script) {
        return !JavaScriptDebuggerSettings.getInstance().isDoNotStepIntoLibraryCode() || !JavaScriptDebugProcess.isLibraryFile$default(this, script, null, 2, null);
    }

    protected final boolean isActualBreakFile(@NotNull XBreakpoint<?> breakpoint, @NotNull Script script) {
        Intrinsics.checkParameterIsNotNull(breakpoint, (String)"breakpoint");
        Intrinsics.checkParameterIsNotNull((Object)script, (String)"script");
        XSourcePosition xSourcePosition = breakpoint.getSourcePosition();
        if (xSourcePosition == null) {
            return true;
        }
        XSourcePosition breakpointPosition = xSourcePosition;
        VirtualFile ideBreakpointFile = breakpointPosition.getFile();
        if (ideBreakpointFile.isInLocalFileSystem()) {
            int n;
            SourceMap sourceMap = script.getSourceMap();
            if (sourceMap != null) {
                VirtualFile virtualFile = ideBreakpointFile;
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"ideBreakpointFile");
                n = sourceMap.findSourceIndex(virtualFile, this.isFilesOnlyInLocalFileSystem());
            } else {
                n = -1;
            }
            if (n >= 0) {
                return true;
            }
        }
        VirtualFile virtualFile = this.findFile(script);
        if (virtualFile != null) {
            VirtualFile virtualFile2;
            VirtualFile it = virtualFile2 = virtualFile;
            VirtualFile virtualFile3 = ideBreakpointFile;
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile3, (String)"ideBreakpointFile");
            return this.isScriptFileEquals$JavaScriptDebugger(script, it, virtualFile3, breakpointPosition.getLine());
        }
        if (ideBreakpointFile.isInLocalFileSystem()) {
            SourceMap sourceMap = script.getSourceMap();
            if (sourceMap != null) {
                SourceMap sourceMap2;
                SourceMap it = sourceMap2 = sourceMap;
                Url[] urlArray = it.getSources();
                for (int i = 0; i < urlArray.length; ++i) {
                    Url source = urlArray[i];
                    if (!source.isInLocalFileSystem()) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public final boolean isScriptFileEquals$JavaScriptDebugger(@NotNull Script script, @NotNull VirtualFile fileForScript, @NotNull VirtualFile expectedFile, int expectedLine) {
        Intrinsics.checkParameterIsNotNull((Object)script, (String)"script");
        Intrinsics.checkParameterIsNotNull((Object)fileForScript, (String)"fileForScript");
        Intrinsics.checkParameterIsNotNull((Object)expectedFile, (String)"expectedFile");
        if (Intrinsics.areEqual((Object)fileForScript, (Object)expectedFile)) {
            return true;
        }
        Url scriptUrl = script.getUrl();
        if (Intrinsics.areEqual((Object)fileForScript, (Object)expectedFile.getCanonicalFile()) || Intrinsics.areEqual((Object)expectedFile, (Object)fileForScript.getCanonicalFile())) {
            this.getUrlToFileCache().put(scriptUrl, expectedFile);
            return true;
        }
        List<Url> expectedIdeUrls = this.finder.getRemoteUrls(expectedFile);
        if (Urls.equalsIgnoreParameters((Url)scriptUrl, (Collection)expectedIdeUrls, (boolean)SystemInfoRt.isFileSystemCaseSensitive)) {
            return true;
        }
        for (Location rawLocation : SourceMapHelperKt.getRawLocations$default(this, expectedIdeUrls, expectedFile, expectedLine, null, null, null, 0, 240, null)) {
            if (!Urls.equals((Url)rawLocation.getUrl(), (Url)scriptUrl, (boolean)SystemInfoRt.isFileSystemCaseSensitive, (boolean)true)) continue;
            return true;
        }
        return false;
    }

    public boolean isLibraryFile(@Nullable Script script, @Nullable SourceInfo sourceInfo) {
        SourceInfo url;
        if (script != null && Intrinsics.areEqual((Object)script.getType(), (Object)Script.Type.NATIVE)) {
            return true;
        }
        SourceInfo sourceInfo2 = sourceInfo;
        if (sourceInfo2 == null || (sourceInfo2 = sourceInfo2.getUrl()) == null) {
            Script script2 = script;
            if (script2 == null) {
                Intrinsics.throwNpe();
            }
            sourceInfo2 = url = script2.getUrl();
        }
        if (url.isInLocalFileSystem()) {
            if (SourceMapLoaderKt.isInternalNodeJsScript((Url)url) || StringsKt.contains$default((CharSequence)url.getPath(), (CharSequence)"/node_modules/", (boolean)false, (int)2, null)) {
                return true;
            }
            if (StringsKt.contains$default((CharSequence)url.getPath(), (CharSequence)SourceMapLoaderKt.ASAR, (boolean)false, (int)2, null)) {
                return false;
            }
        } else if (JavaScriptDebugProcessKt.isWebpackLibraryFile((Url)url)) {
            return true;
        }
        Boolean bl = (Boolean)this.urlToIsLibraryFile.get(url);
        if (bl != null) {
            Boolean bl2 = bl;
            boolean it = bl2;
            return it;
        }
        SourceInfo sourceInfo3 = sourceInfo;
        boolean result = this.isLibraryFileUsingIndex(script, (VirtualFile)(sourceInfo3 != null ? sourceInfo3.getFile() : null));
        this.urlToIsLibraryFile.put((Url)url, result);
        return result;
    }

    public static /* bridge */ /* synthetic */ boolean isLibraryFile$default(JavaScriptDebugProcess javaScriptDebugProcess, Script script, SourceInfo sourceInfo, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: isLibraryFile");
        }
        if ((n & 2) != 0) {
            sourceInfo = null;
        }
        return javaScriptDebugProcess.isLibraryFile(script, sourceInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean isLibraryFileUsingIndex(Script script, VirtualFile sourceFile) {
        VirtualFile virtualFile = sourceFile != null || script == null ? sourceFile : this.findFile(script);
        if (virtualFile == null) {
            return false;
        }
        VirtualFile file = virtualFile;
        if (file instanceof LightVirtualFile) {
            return false;
        }
        AccessToken token = ReadAction.start();
        try {
            ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)this.getSession().getProject()).getFileIndex();
            boolean bl = fileIndex.isInLibrarySource(file) || fileIndex.isInLibraryClasses(file) || !fileIndex.isInContent(file) && (script == null || script.getSourceMap() == null);
            return bl;
        }
        catch (IndexNotReadyException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            token.finish();
        }
    }

    @Nullable
    protected final SourceMap decodeSourceMap(@Nullable Url sourceMapUrl, @Nullable CharSequence sourceMapData, @NotNull Script script) {
        Url url;
        Intrinsics.checkParameterIsNotNull((Object)script, (String)"script");
        CharSequence loadedSourceMapData = sourceMapData;
        if (sourceMapData == null) {
            VirtualFile virtualFile;
            if (sourceMapUrl == null) {
                return null;
            }
            if (sourceMapUrl.isInLocalFileSystem()) {
                virtualFile = LocalFileFinder.findFile((String)sourceMapUrl.getPath());
            } else {
                VirtualFile virtualFile2;
                VirtualFile virtualFile3 = this.findFile(script);
                if (virtualFile3 != null) {
                    VirtualFile virtualFile4;
                    VirtualFile it = virtualFile4 = virtualFile3;
                    virtualFile2 = it.getParent().findChild(it.getName() + ".map");
                } else {
                    virtualFile2 = virtualFile = null;
                }
            }
            if (virtualFile == null) {
                JavaScriptDebugProcessKt.getLOG().info("Cannot find source map " + sourceMapUrl);
                return null;
            }
            try {
                loadedSourceMapData = SourceMapLoaderKt.loadFile(virtualFile);
            }
            catch (IOException e) {
                JavaScriptDebugProcessKt.getLOG().error((Throwable)e);
                return null;
            }
        }
        CharSequence charSequence = loadedSourceMapData;
        if (charSequence == null) {
            Intrinsics.throwNpe();
        }
        if ((url = sourceMapUrl) == null) {
            url = script.getUrl();
        }
        return JavaScriptDebugProcess.decodeSourceMap$default(this, charSequence, url, true, script, false, 16, null);
    }

    @Nullable
    public final SourceMap decodeSourceMap(@NotNull CharSequence sourceMapData, @NotNull Url baseUrl, boolean baseUrlIsFile, @Nullable Script script, boolean resolveFileBySourceUrl) {
        Intrinsics.checkParameterIsNotNull((Object)sourceMapData, (String)"sourceMapData");
        Intrinsics.checkParameterIsNotNull((Object)baseUrl, (String)"baseUrl");
        try {
            return SourceMapDecoderKt.decodeSourceMap((CharSequence)sourceMapData, (Function2)((Function2)new Function2<List<? extends String>, List<? extends String>, SourceResolver>(this, baseUrl, baseUrlIsFile, script, resolveFileBySourceUrl){
                final /* synthetic */ JavaScriptDebugProcess this$0;
                final /* synthetic */ Url $baseUrl;
                final /* synthetic */ boolean $baseUrlIsFile;
                final /* synthetic */ Script $script;
                final /* synthetic */ boolean $resolveFileBySourceUrl;

                @NotNull
                public final SourceResolver invoke(@NotNull List<String> sourceUrls, @Nullable List<String> sourceContents) {
                    Intrinsics.checkParameterIsNotNull(sourceUrls, (String)"sourceUrls");
                    return this.this$0.createSourceMapSourceResolver(sourceUrls, sourceContents, this.$baseUrl, this.$baseUrlIsFile, this.$script, this.$resolveFileBySourceUrl);
                }
                {
                    this.this$0 = javaScriptDebugProcess;
                    this.$baseUrl = url;
                    this.$baseUrlIsFile = bl;
                    this.$script = script;
                    this.$resolveFileBySourceUrl = bl2;
                    super(2);
                }
            }));
        }
        catch (JsonParseException e) {
            JavaScriptDebugProcessKt.getLOG().warn("Cannot decode sourcemap " + baseUrl, (Throwable)e);
        }
        catch (Throwable e) {
            JavaScriptDebugProcessKt.getLOG().error((Object)LogMessageEx.createEvent((String)("Cannot decode sourcemap " + baseUrl), (String)ExceptionUtil.getThrowableText((Throwable)e), (Attachment[])new Attachment[]{AttachmentFactory.createAttachment((VirtualFile)((VirtualFile)new LightVirtualFile(((Object)sourceMapData).toString())))}));
        }
        return null;
    }

    @Nullable
    public static /* bridge */ /* synthetic */ SourceMap decodeSourceMap$default(JavaScriptDebugProcess javaScriptDebugProcess, CharSequence charSequence, Url url, boolean bl, Script script, boolean bl2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: decodeSourceMap");
        }
        if ((n & 8) != 0) {
            script = null;
        }
        if ((n & 0x10) != 0) {
            bl2 = script != null;
        }
        return javaScriptDebugProcess.decodeSourceMap(charSequence, url, bl, script, bl2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected SourceResolver createSourceMapSourceResolver(@NotNull List<String> sourceUrls, @Nullable List<String> sourceContents, @NotNull Url baseUrl, boolean baseUrlIsFile, @Nullable Script script, boolean resolveFileBySourceUrl) {
        Url[] urlArray;
        void size$iv;
        SourceResolver sourceResolver;
        Intrinsics.checkParameterIsNotNull(sourceUrls, (String)"sourceUrls");
        Intrinsics.checkParameterIsNotNull((Object)baseUrl, (String)"baseUrl");
        int n = sourceUrls.size();
        List<String> list = sourceUrls;
        SourceResolver sourceResolver2 = sourceResolver;
        SourceResolver sourceResolver3 = sourceResolver;
        Url[] result$iv = new Url[size$iv];
        boolean bl = false;
        void var10_13 = size$iv - true;
        if (bl <= var10_13) {
            void i$iv;
            do {
                Url url;
                Url url2;
                void it;
                void var11_14 = ++i$iv;
                void var20_18 = i$iv;
                urlArray = result$iv;
                Url url3 = SourceResolverKt.canonicalizeUrl((String)sourceUrls.get((int)it), (Url)baseUrl, (boolean)this.isFilesOnlyInLocalFileSystem(), (boolean)baseUrlIsFile);
                if (resolveFileBySourceUrl) {
                    boolean isBrowserify = StringsKt.endsWith$default((String)baseUrl.getPath(), (String)".browserify", (boolean)false, (int)2, null);
                    Project project = this.getSession().getProject();
                    Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"session.project");
                    List<String> list2 = sourceContents;
                    url2 = FileResolverByContentKt.resolveFileBySourceUrl(project, url3, list2 != null ? (String)CollectionsKt.getOrNull(list2, (int)it) : null, isBrowserify);
                    if (url2 == null) {
                        url2 = url3;
                    }
                } else {
                    url2 = url3;
                }
                urlArray[var20_18] = url = url2;
            } while (i$iv != var10_13);
        }
        urlArray = result$iv;
        sourceResolver2(list, urlArray, sourceContents);
        return sourceResolver3;
    }

    protected void configureConsoleFilers(@NotNull ConsoleView console2) {
        Intrinsics.checkParameterIsNotNull((Object)console2, (String)"console");
    }

    @NotNull
    public ExecutionConsole createConsole() {
        ExecutionResult executionResult = this.getExecutionResult();
        if (executionResult == null || (executionResult = executionResult.getExecutionConsole()) == null) {
            executionResult = (ExecutionConsole)this.createLanguageConsoleView();
        }
        return executionResult;
    }

    private final ConsoleView createLanguageConsoleView() {
        ProcessHandler processHandler = this.getRealProcessHandler();
        JavaScriptDebuggerConsoleExecuteActionHandler consoleExecuteActionHandler = new JavaScriptDebuggerConsoleExecuteActionHandler(this);
        LanguageConsoleView console2 = new LanguageConsoleBuilder().executionEnabled((Condition)new Condition<LanguageConsoleView>(this){
            final /* synthetic */ JavaScriptDebugProcess this$0;

            public final boolean value(LanguageConsoleView it) {
                return this.this$0.checkCanPerformCommands();
            }
            {
                this.this$0 = javaScriptDebugProcess;
            }
        }).initActions((BaseConsoleExecuteActionHandler)consoleExecuteActionHandler, "js-debugger-repl").gutterContentProvider(this.getGutterContentProvider()).psiFileFactory((PairFunction)new PairFunction<VirtualFile, Project, PsiFile>(consoleExecuteActionHandler){
            final /* synthetic */ JavaScriptDebuggerConsoleExecuteActionHandler $consoleExecuteActionHandler;

            @NotNull
            public final JavaScriptConsolePsiFile fun(VirtualFile file, Project project) {
                return new JavaScriptConsolePsiFile(project, file, this.$consoleExecuteActionHandler);
            }
            {
                this.$consoleExecuteActionHandler = javaScriptDebuggerConsoleExecuteActionHandler;
            }
        }).processInputStateKey(processHandler == null ? null : "js.debugger.console.stdin").build(this.getSession().getProject(), JavaScriptFileType.INSTANCE.getLanguage());
        if (processHandler != null) {
            LanguageConsoleView languageConsoleView = console2;
            Intrinsics.checkExpressionValueIsNotNull((Object)languageConsoleView, (String)"console");
            this.configureConsoleFilers((ConsoleView)languageConsoleView);
            console2.attachToProcess(processHandler);
        }
        LanguageConsoleView languageConsoleView = console2;
        Intrinsics.checkExpressionValueIsNotNull((Object)languageConsoleView, (String)"console");
        return (ConsoleView)languageConsoleView;
    }

    @Nullable
    protected final GutterContentProvider getGutterContentProvider() {
        return (GutterContentProvider)this.consolePrinter;
    }

    @Nullable
    public final SourceInfo getSourceInfo(@NotNull Vm vm, @Nullable String scriptId, @NotNull String scriptUrl, @Nullable String functionName, int line, int column) {
        SourceInfo sourceInfo;
        Script script;
        Script script2;
        Intrinsics.checkParameterIsNotNull((Object)vm, (String)"vm");
        Intrinsics.checkParameterIsNotNull((Object)scriptUrl, (String)"scriptUrl");
        ScriptManager scriptManager = vm.getScriptManager();
        CharSequence charSequence = scriptId;
        if (charSequence == null || charSequence.length() == 0) {
            script2 = null;
        } else {
            String string = scriptId;
            if (string == null) {
                Intrinsics.throwNpe();
            }
            script2 = script = scriptManager.findScriptById(string);
        }
        if (script == null) {
            script = scriptManager.findScriptByUrl(scriptUrl);
        }
        Script script3 = script;
        if (script3 != null) {
            CharSequence it = charSequence = script3;
            sourceInfo = this.getSourceInfo(functionName, (Script)it, line, column);
        } else {
            sourceInfo = null;
        }
        return sourceInfo;
    }

    @Nullable
    public XDebuggerEvaluator getEvaluator() {
        XDebuggerEvaluator evaluator = super.getEvaluator();
        return evaluator == null && this.checkCanPerformCommands() ? (XDebuggerEvaluator)this.getGlobalEvaluator() : evaluator;
    }

    @NotNull
    public final GlobalEvaluator getGlobalEvaluator() {
        if (this.globalEvaluator == null) {
            this.globalEvaluator = new GlobalEvaluator((DebuggerViewSupport)this.debuggerViewSupport, this.getConnection());
        }
        GlobalEvaluator globalEvaluator = this.globalEvaluator;
        if (globalEvaluator == null) {
            Intrinsics.throwNpe();
        }
        return globalEvaluator;
    }

    public final void consoleCleared() {
        GlobalEvaluator evaluator = this.globalEvaluator;
        if (evaluator != null) {
            evaluator.getValues().clear();
        }
    }

    @Nullable
    public String getBreakpointLanguageHint(@Nullable XLineBreakpoint<?> breakpoint, @NotNull Location location) {
        Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
        return null;
    }

    @Nullable
    protected final SyntheticSuspendBreakpointInfo processBreakpointsHit(@NotNull SuspendContext<?> context, @NotNull Script script, @Nullable Function1<? super Script, Unit> findSourceMap) {
        Intrinsics.checkParameterIsNotNull(context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)script, (String)"script");
        List breakpointsHit = context.getBreakpointsHit();
        for (Breakpoint breakpoint : breakpointsHit) {
            if (this.lineBreakpointManager.isAnyFirstLineBreakpoint(breakpoint)) {
                if (script.getSourceMap() != null || findSourceMap == null) continue;
                findSourceMap.invoke((Object)script);
                continue;
            }
            if (this.lineBreakpointManager.isRunToCursorBreakpoint(breakpoint)) {
                return null;
            }
            for (XLineBreakpoint<?> lineBreakpoint : this.lineBreakpointManager.findBreakpoints(breakpoint)) {
                if (!this.isActualBreakFile((XBreakpoint)lineBreakpoint, script)) continue;
                return new SyntheticSuspendBreakpointInfo(lineBreakpoint);
            }
        }
        if (breakpointsHit.isEmpty() && !context.getHasUnresolvedBreakpointsHit() || this.getLastStep() != null) {
            return null;
        }
        this.resume(context.getVm());
        return SyntheticSuspendBreakpointInfo.SKIP;
    }

    @Nullable
    public static /* bridge */ /* synthetic */ SyntheticSuspendBreakpointInfo processBreakpointsHit$default(JavaScriptDebugProcess javaScriptDebugProcess, SuspendContext suspendContext, Script script, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: processBreakpointsHit");
        }
        if ((n & 4) != 0) {
            function1 = null;
        }
        return javaScriptDebugProcess.processBreakpointsHit(suspendContext, script, (Function1<Script, Unit>)function1);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final AsarFileSystem getAsarFs$JavaScriptDebugger(@NotNull String path) {
        void fs;
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = (AsarFileSystem)this.pathToAsarFs.get(path);
        if ((AsarFileSystem)fs.element == null) {
            Object object;
            Path path2 = SourceMapLoaderKt.regularFile(path);
            if (path2 == null) {
                return null;
            }
            Path path3 = path2;
            void var12_4 = fs;
            Path it = path3;
            AsarFileSystem asarFileSystem = new AsarFileSystem(it);
            var12_4.element = asarFileSystem;
            String packageJson = "package.json";
            FileItem fileItem = ((AsarFileSystem)fs.element).getFile(packageJson);
            if (fileItem != null) {
                object = fileItem;
                FileItem fileItem2 = object;
                GlobalSearchScope scope = ProjectScope.getContentScope((Project)this.getSession().getProject());
                Collection files = (Collection)ApplicationManager.getApplication().runReadAction(new Computable<T>(scope, this, packageJson, (Ref.ObjectRef)fs){
                    final /* synthetic */ GlobalSearchScope $scope$inlined;
                    final /* synthetic */ JavaScriptDebugProcess this$0;
                    final /* synthetic */ String $packageJson$inlined;
                    final /* synthetic */ Ref.ObjectRef $fs$inlined;
                    {
                        this.$scope$inlined = globalSearchScope;
                        this.this$0 = javaScriptDebugProcess;
                        this.$packageJson$inlined = string;
                        this.$fs$inlined = objectRef;
                    }

                    public final T compute() {
                        return (T)FilenameIndex.getVirtualFilesByName((Project)this.this$0.getSession().getProject(), (String)this.$packageJson$inlined, (GlobalSearchScope)this.$scope$inlined);
                    }
                });
                Collection collection = files;
                if (!collection.isEmpty()) {
                    Collection collection2 = files;
                    Intrinsics.checkExpressionValueIsNotNull((Object)collection2, (String)"files");
                    AsarFileSystem asarFileSystem2 = (AsarFileSystem)fs.element;
                    if (asarFileSystem2 == null) {
                        Intrinsics.throwNpe();
                    }
                    VirtualFile virtualFile = FileResolverByContentKt.selectMostSimilarFile$default(collection2, asarFileSystem2.loadBytes(fileItem2), null, 4, null);
                    if (virtualFile != null) {
                        Collection it2 = collection = virtualFile;
                        AsarFileSystem asarFileSystem3 = (AsarFileSystem)fs.element;
                        if (asarFileSystem3 == null) {
                            Intrinsics.throwNpe();
                        }
                        asarFileSystem3.setVfsRoot(it2.getParent());
                    }
                }
            }
            AsarFileSystem asarFileSystem4 = this.pathToAsarFs.putIfAbsent(path, (AsarFileSystem)fs.element);
            if (asarFileSystem4 != null) {
                Object it3 = object = asarFileSystem4;
                return it3;
            }
        }
        return (AsarFileSystem)fs.element;
    }

    protected void beforeInitBreakpoints(@NotNull Vm vm) {
        Intrinsics.checkParameterIsNotNull((Object)vm, (String)"vm");
        if (Registry.is((String)JavaScriptDebugProcessKt.getUSE_ANY_BREAKPOINT_REGISTRY_OPTION(), (boolean)true)) {
            Iterator iterator = this.firstLineBreakpointPatterns.iterator();
            while (iterator.hasNext()) {
                String p;
                String string = p = (String)iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"p");
                JavaScriptLineBreakpointManager.setAnyFirstLineBreakpoint$default(this.lineBreakpointManager, vm, string, null, 4, null);
            }
        }
        super.beforeInitBreakpoints(vm);
    }

    @NotNull
    public final DebuggableFileFinder getFinder() {
        return this.finder;
    }

    /*
     * WARNING - void declaration
     */
    public JavaScriptDebugProcess(final @NotNull XDebugSession session, @NotNull DebuggableFileFinder finder, @NotNull C connection, @Nullable ExecutionResult executionResult) {
        void $receiver$iv;
        Exception e$iv;
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        Intrinsics.checkParameterIsNotNull((Object)finder, (String)"finder");
        Intrinsics.checkParameterIsNotNull(connection, (String)"connection");
        super(session, connection, (XDebuggerEditorsProvider)new JSDebuggerEditorsProvider(), (XSmartStepIntoHandler)new JavaScriptSmartStepIntoHandler(session){

            public void startStepInto(@NotNull FunctionStepIntoVariant variant, @Nullable XSuspendContext context) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)variant), (String)"variant");
                XDebugProcess xDebugProcess = this.getMySession().getDebugProcess();
                if (xDebugProcess == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.javascript.debugger.JavaScriptDebugProcess<*>");
                }
                JavaScriptDebugProcess debugProcess = (JavaScriptDebugProcess)xDebugProcess;
                debugProcess.expectedFunction = variant;
                XSuspendContext xSuspendContext = context;
                if (xSuspendContext == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.debugger.SuspendContextView");
                }
                debugProcess.continueVm(((SuspendContextView)xSuspendContext).getActiveExecutionStack().getSuspendContext().getVm(), StepAction.IN);
            }
        }, executionResult);
        this.finder = finder;
        this.sourceTabManager = new SourceTabManager(this);
        this.exceptionBreakpointHandler = new ChromeExceptionBreakpointHandler(this);
        this.lineBreakpointManager = new JavaScriptLineBreakpointManager(this);
        this.urlToIsLibraryFile = ContainerUtil.newConcurrentMap();
        this.preloadedSourceMaps = new PreloadedSourceMapList();
        this.pathToAsarFs = ContainerUtil.newConcurrentMap();
        this.debugEventListener = new MyDebugEventListener();
        this.firstLineBreakpointPatterns = new SmartList();
        Logger logger = JavaScriptDebugProcessKt.getLOG();
        Object var6_6 = null;
        boolean bl = true;
        Object var8_8 = null;
        if (bl & true) {
            e$iv = null;
        }
        if ($receiver$iv.isDebugEnabled()) {
            void var10_9 = $receiver$iv;
            String string = "FileFinder: " + this.finder;
            var10_9.debug(string, (Throwable)e$iv);
        }
        this.consolePrinter = new ConsolePrinter(this, this.isLineRelationshipComputable());
        connection.addDebugListener((DebugEventListener)this.debugEventListener);
        session.setPauseActionSupported(true);
        this.debuggerViewSupport = this.createDebuggerViewSupport();
    }

    public /* synthetic */ JavaScriptDebugProcess(XDebugSession xDebugSession, DebuggableFileFinder debuggableFileFinder, VmConnection vmConnection, ExecutionResult executionResult, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            executionResult = null;
        }
        this(xDebugSession, debuggableFileFinder, vmConnection, executionResult);
    }

    public static final /* synthetic */ void access$processBreakpoint(JavaScriptDebugProcess $this, @NotNull SuspendContext suspendContext, @NotNull XBreakpoint breakpoint, @NotNull Script script) {
        $this.processBreakpoint(suspendContext, breakpoint, script);
    }

    public static final /* synthetic */ boolean access$getDisableDoNotStepIntoLibraries$p(JavaScriptDebugProcess $this) {
        return $this.getDisableDoNotStepIntoLibraries();
    }

    @Nullable
    public static final /* synthetic */ MappingEntry access$findMapping(JavaScriptDebugProcess $this, @NotNull SourceMap sourceMap, int line, int column) {
        return $this.findMapping(sourceMap, line, column);
    }

    public static final /* synthetic */ void access$processBreakpointLogExpressionAndSuspend(JavaScriptDebugProcess $this, @NotNull XBreakpoint breakpoint, @NotNull JavaScriptSuspendContext xSuspendContext, @NotNull SuspendContext suspendContext) {
        $this.processBreakpointLogExpressionAndSuspend(breakpoint, xSuspendContext, suspendContext);
    }

    public static final /* synthetic */ void access$breakpointReached(JavaScriptDebugProcess $this, @NotNull XBreakpoint breakpoint, @Nullable String evaluatedLogExpression, @NotNull JavaScriptSuspendContext xSuspendContext, @NotNull SuspendContext suspendContext) {
        $this.breakpointReached(breakpoint, evaluatedLogExpression, xSuspendContext, suspendContext);
    }

    @Nullable
    public static final /* synthetic */ FunctionStepIntoVariant access$getExpectedFunction$p(JavaScriptDebugProcess $this) {
        return $this.expectedFunction;
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/javascript/debugger/JavaScriptDebugProcess$IsMeteorScriptAnswer;", "", "(Ljava/lang/String;I)V", "NOT_A_METEOR_SCRIPT", "MAYBE_METEOR_CLIENT_SCRIPT", "METEOR_SERVER_SCRIPT", "JavaScriptDebugger"})
    private static final class IsMeteorScriptAnswer
    extends Enum<IsMeteorScriptAnswer> {
        public static final /* enum */ IsMeteorScriptAnswer NOT_A_METEOR_SCRIPT;
        public static final /* enum */ IsMeteorScriptAnswer MAYBE_METEOR_CLIENT_SCRIPT;
        public static final /* enum */ IsMeteorScriptAnswer METEOR_SERVER_SCRIPT;
        private static final /* synthetic */ IsMeteorScriptAnswer[] $VALUES;

        static {
            IsMeteorScriptAnswer[] isMeteorScriptAnswerArray = new IsMeteorScriptAnswer[3];
            IsMeteorScriptAnswer[] isMeteorScriptAnswerArray2 = isMeteorScriptAnswerArray;
            isMeteorScriptAnswerArray[0] = NOT_A_METEOR_SCRIPT = new IsMeteorScriptAnswer();
            isMeteorScriptAnswerArray[1] = MAYBE_METEOR_CLIENT_SCRIPT = new IsMeteorScriptAnswer();
            isMeteorScriptAnswerArray[2] = METEOR_SERVER_SCRIPT = new IsMeteorScriptAnswer();
            $VALUES = isMeteorScriptAnswerArray;
        }

        public static IsMeteorScriptAnswer[] values() {
            return (IsMeteorScriptAnswer[])$VALUES.clone();
        }

        public static IsMeteorScriptAnswer valueOf(String string) {
            return Enum.valueOf(IsMeteorScriptAnswer.class, string);
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0004H\u0016J\"\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0006H\u0016J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\u000f\u001a\u00020\u0004H\u0016J\u0018\u0010\u0010\u001a\u00020\u00042\u000e\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u0012H\u0016\u00a8\u0006\u0014"}, d2={"Lcom/intellij/javascript/debugger/JavaScriptDebugProcess$MyDebugEventListener;", "Lorg/jetbrains/debugger/DebugEventListener;", "(Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;)V", "errorOccurred", "", "errorMessage", "", "resumed", "scriptAdded", "vm", "Lorg/jetbrains/debugger/Vm;", "script", "Lorg/jetbrains/debugger/Script;", "sourceMapUrl", "scriptRemoved", "scriptsCleared", "suspended", "context", "Lorg/jetbrains/debugger/SuspendContext;", "Lorg/jetbrains/debugger/CallFrame;", "JavaScriptDebugger"})
    private final class MyDebugEventListener
    implements DebugEventListener {
        public void errorOccurred(@NotNull String errorMessage) {
            Intrinsics.checkParameterIsNotNull((Object)errorMessage, (String)"errorMessage");
            JavaScriptDebugProcess.this.getSession().reportError(errorMessage);
        }

        public void scriptsCleared() {
            JavaScriptDebugProcess.this.getSourceTabManager$JavaScriptDebugger().clear();
        }

        public void scriptAdded(@NotNull Vm vm, @NotNull Script script, @Nullable String sourceMapUrl) {
            Intrinsics.checkParameterIsNotNull((Object)vm, (String)"vm");
            Intrinsics.checkParameterIsNotNull((Object)script, (String)"script");
            SourceMap sourceMap = JavaScriptDebugProcess.this.findSourceMapBeforeAdd(vm, script, sourceMapUrl);
            if (sourceMap != null) {
                SourceMap sourceMap2;
                SourceMap it = sourceMap2 = sourceMap;
                JavaScriptDebugProcess.sourceMapFound$default(JavaScriptDebugProcess.this, vm, it, script, null, null, 24, null);
            }
            JavaScriptDebugProcess.this.getSourceTabManager$JavaScriptDebugger().addScript(script);
        }

        public void scriptRemoved(@NotNull Script script) {
            Intrinsics.checkParameterIsNotNull((Object)script, (String)"script");
            JavaScriptDebugProcess.this.getSourceTabManager$JavaScriptDebugger().removeScript(script);
        }

        /*
         * WARNING - void declaration
         */
        public void suspended(@NotNull SuspendContext<? extends CallFrame> context) {
            Object isInTranspiledCode$;
            XLineBreakpoint<?> breakpoint;
            Intrinsics.checkParameterIsNotNull(context, (String)"context");
            Vm vm = context.getVm();
            boolean activeThread = Intrinsics.areEqual((Object)vm.getSuspendContextManager().getContext(), context);
            Script script = context.getScript();
            if (script == null) {
                JavaScriptDebugProcess.this.setOverlay(context);
                JavaScriptSuspendContext suspendContext = JavaScriptDebugProcess.createSuspendContext$default(JavaScriptDebugProcess.this, context, null, null, 4, null);
                if (activeThread) {
                    JavaScriptDebugProcess.this.getSession().positionReached((XSuspendContext)suspendContext);
                }
                return;
            }
            if (Intrinsics.areEqual((Object)context.getState(), (Object)SuspendState.EXCEPTION)) {
                void $receiver$iv;
                if (!JavaScriptDebugProcess.this.checkLibraryStepCondition(script)) {
                    JavaScriptDebugProcess.this.resume(vm);
                    return;
                }
                Promise<XBreakpoint<?>> suspendContext = JavaScriptDebugProcess.this.exceptionBreakpointHandler.findBreakpoint(context.getExceptionData());
                Promise promise = $receiver$iv.done((Consumer)new ContextDependentAsyncResultConsumer<XBreakpoint<? extends XBreakpointProperties<Object>>>(context, context, this, vm, context, script){
                    final /* synthetic */ SuspendContext $context;
                    final /* synthetic */ MyDebugEventListener this$0;
                    final /* synthetic */ Vm $vm$inlined;
                    final /* synthetic */ SuspendContext $context$inlined;
                    final /* synthetic */ Script $script$inlined;
                    {
                        this.$context = $captured_local_variable$1;
                        this.this$0 = myDebugEventListener;
                        this.$vm$inlined = vm;
                        this.$context$inlined = suspendContext;
                        this.$script$inlined = script;
                        super($super_call_param$2);
                    }

                    /*
                     * Ignored method signature, as it can't be verified against descriptor
                     */
                    protected void consume(Object result, Vm vm) {
                        XBreakpoint it = (XBreakpoint)result;
                        if (it == null) {
                            this.this$0.JavaScriptDebugProcess.this.resume(this.$vm$inlined);
                        } else {
                            JavaScriptDebugProcess.access$processBreakpoint(this.this$0.JavaScriptDebugProcess.this, this.$context$inlined, it, this.$script$inlined);
                        }
                    }
                });
                XDebugSession xDebugSession = JavaScriptDebugProcess.this.getSession();
                Intrinsics.checkExpressionValueIsNotNull((Object)xDebugSession, (String)"session");
                promise.rejected((Consumer)new RejectErrorReporter(xDebugSession, null, 2, null));
                return;
            }
            if (activeThread && !JavaScriptDebugProcess.this.processStepIntoFunction(vm, context, script)) {
                return;
            }
            SyntheticSuspendBreakpointInfo syntheticBreakpointInfo = JavaScriptDebugProcess.this.getSyntheticSuspend(context, script);
            if (syntheticBreakpointInfo != null && syntheticBreakpointInfo.isSkipped()) {
                return;
            }
            SyntheticSuspendBreakpointInfo syntheticSuspendBreakpointInfo = syntheticBreakpointInfo;
            Object object = breakpoint = syntheticSuspendBreakpointInfo != null ? syntheticSuspendBreakpointInfo.getBreakpoint() : null;
            if (breakpoint != null && activeThread) {
                JavaScriptDebugProcess.this.setLastStep(null);
                JavaScriptDebugProcess.this.setLastCallFrame(null);
            }
            StepAction lastStep = JavaScriptDebugProcess.this.getLastStep();
            CallFrame topFrame = context.getTopFrame();
            if (lastStep != null) {
                if (Intrinsics.areEqual((Object)script.getType(), (Object)Script.Type.NATIVE) && Registry.is((String)"js.debugger.skip.native.scripts", (boolean)true)) {
                    JavaScriptDebugProcessKt.getLOG().info("Skip break because native script " + script.getUrl());
                    JavaScriptDebugProcess.this.resume(vm);
                    return;
                }
                if (!JavaScriptDebugProcess.this.isForceStep() && !JavaScriptDebugProcess.this.isSteppingAllowed(script)) {
                    JavaScriptDebugProcessKt.getLOG().info("Continue (" + lastStep + "), stepping is not allowed in to " + script.getUrl().toDecodedForm());
                    JavaScriptDebugProcess.this.continueVm(vm, lastStep);
                    return;
                }
                if (JavaScriptDebugProcess.this.getLastCallFrame() != null) {
                    if (JavaScriptDebugProcess.this.isForceStep() && Intrinsics.areEqual((Object)lastStep, (Object)StepAction.OUT) ^ true && JavaScriptDebuggerSettings.getInstance().isDoNotStepIntoLibraryCode()) {
                        JavaScriptDebugProcess.this.setDisableDoNotStepIntoLibraries(JavaScriptDebugProcess.isLibraryFile$default(JavaScriptDebugProcess.this, script, null, 2, null));
                    }
                    if (Intrinsics.areEqual((Object)lastStep, (Object)StepAction.IN) || Intrinsics.areEqual((Object)lastStep, (Object)StepAction.OVER)) {
                        isInTranspiledCode$ = new Function0<Boolean>(this, script, topFrame){
                            final /* synthetic */ MyDebugEventListener this$0;
                            final /* synthetic */ Script $script;
                            final /* synthetic */ CallFrame $topFrame;

                            public final boolean invoke() {
                                SourceMap sourceMap = this.$script.getSourceMap();
                                if (sourceMap == null || this.$topFrame == null) {
                                    return false;
                                }
                                MappingEntry mappingEntry = JavaScriptDebugProcess.access$findMapping(this.this$0.JavaScriptDebugProcess.this, sourceMap, this.$topFrame.getLine(), this.$topFrame.getColumn());
                                return (mappingEntry != null ? mappingEntry.getSource() : -1) == -1;
                            }
                            {
                                this.this$0 = myDebugEventListener;
                                this.$script = script;
                                this.$topFrame = callFrame;
                                super(0);
                            }
                        };
                        if (!JavaScriptDebugProcess.this.isForceStep() && isInTranspiledCode$.invoke()) {
                            void $receiver$iv;
                            Exception e$iv;
                            Logger logger = JavaScriptDebugProcessKt.getLOG();
                            Object var11_14 = null;
                            boolean bl = true;
                            Object var13_18 = null;
                            if (bl & true) {
                                e$iv = null;
                            }
                            if ($receiver$iv.isDebugEnabled()) {
                                void var15_20 = $receiver$iv;
                                String string = "Continue (" + lastStep + "), because transpiled code is not mapped (script: " + script + ", top frame: " + topFrame + ")";
                                var15_20.debug(string, (Throwable)e$iv);
                            }
                            JavaScriptDebugProcess.this.continueVm(vm, lastStep);
                            return;
                        }
                        if (Registry.is((String)"js.debugger.step.over.skip.same.line", (boolean)true) && JavaScriptDebugProcess.this.isSameSourceLine(vm, JavaScriptDebugProcess.this.getLastCallFrame(), topFrame)) {
                            JavaScriptDebugProcess.this.setLastCallFrame(topFrame);
                            JavaScriptDebugProcess.this.continueVm(vm, lastStep);
                            return;
                        }
                        JavaScriptDebugProcess.this.setLastCallFrame(null);
                        JavaScriptDebugProcess.this.setForceStep(false);
                    } else if (!JavaScriptDebugProcess.this.isVmStepOutCorrect() && Intrinsics.areEqual((Object)lastStep, (Object)StepAction.OUT)) {
                        CallFrame callFrame = JavaScriptDebugProcess.this.getLastCallFrame();
                        if (callFrame == null) {
                            Intrinsics.throwNpe();
                        }
                        CallFrame callFrame2 = topFrame;
                        if (Intrinsics.areEqual((Object)callFrame.getFunctionName(), (Object)(callFrame2 != null ? callFrame2.getFunctionName() : null))) {
                            JavaScriptDebugProcess.this.setLastCallFrame(topFrame);
                            JavaScriptDebugProcess.this.continueVm(vm, lastStep);
                            return;
                        }
                    }
                }
            } else if (breakpoint != null && JavaScriptDebuggerSettings.getInstance().isDoNotStepIntoLibraryCode()) {
                JavaScriptDebugProcess.this.setDisableDoNotStepIntoLibraries(JavaScriptDebugProcess.isLibraryFile$default(JavaScriptDebugProcess.this, script, null, 2, null));
            }
            if (breakpoint == null) {
                JavaScriptDebugProcess.this.setOverlay(context);
                JavaScriptDebugProcess.this.getLineBreakpointManager().clearRunToLocationBreakpoints(vm);
                JavaScriptDebugProcess.this.getSession().positionReached((XSuspendContext)JavaScriptDebugProcess.createSuspendContext$default(JavaScriptDebugProcess.this, context, script, null, 4, null));
            } else {
                void topFrameSourceInfo;
                VirtualFile scriptFile;
                JavaScriptDebugProcess.this.getSession().updateBreakpointPresentation(breakpoint, AllIcons.Debugger.Db_verified_breakpoint, null);
                isInTranspiledCode$ = new Ref.ObjectRef();
                ((Ref.ObjectRef)isInTranspiledCode$).element = null;
                SourceMap sourceMap = script.getSourceMap();
                if (sourceMap != null && !ArraysKt.contains((Object[])sourceMap.getSources(), (Object)script.getUrl()) && (scriptFile = JavaScriptDebugProcess.this.findFile(script)) != null) {
                    XSourcePosition xSourcePosition = breakpoint.getSourcePosition();
                    if (Intrinsics.areEqual((Object)scriptFile, (Object)(xSourcePosition != null ? xSourcePosition.getFile() : null))) {
                        CallFrame callFrame = topFrame;
                        if (callFrame != null) {
                            CallFrame callFrame3;
                            CallFrame it = callFrame3 = callFrame;
                            topFrameSourceInfo.element = JavaScriptDebugProcess.this.createSourceInfo(null, it.getFunctionName(), scriptFile, it.getLine(), it.getColumn(), script.getUrl());
                        }
                    }
                }
                JavaScriptDebugProcess.this.processBreakpoint(context, (XBreakpoint)breakpoint, JavaScriptDebugProcess.this.createSuspendContext(context, script, (SourceInfo)topFrameSourceInfo.element));
                Object var9_11 = null;
            }
        }

        public void resumed() {
            JavaScriptDebugProcessKt.getLOG().debug("Session resumed");
            JavaScriptDebugProcess.this.getSession().resume();
        }
    }
}

