/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger;

import com.intellij.javascript.debugger.JSDebuggerBundle;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.JsFileUtil;
import com.intellij.javascript.debugger.RemoteDebuggingFileFinder;
import com.intellij.javascript.debugger.execution.JavaScriptDebugConfiguration;
import com.intellij.javascript.debugger.execution.RemoteUrlMappingBean;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Url;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.debugger.connection.VmConnection;

public class RemoteUrlMappingHelper {
    public static void showSetRemoteUrlDialog(@NotNull JavaScriptDebugProcess<? extends VmConnection> debugProcess, @NotNull VirtualFile file) {
        if (debugProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugProcess", "com/intellij/javascript/debugger/RemoteUrlMappingHelper", "showSetRemoteUrlDialog"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/javascript/debugger/RemoteUrlMappingHelper", "showSetRemoteUrlDialog"));
        }
        Url hostUrl = debugProcess.getCurrentLocationUrl();
        String url = Messages.showInputDialog((Project)debugProcess.getSession().getProject(), (String)JSDebuggerBundle.message("label.text.input.remote.url.for.0", file.getName()), (String)JSDebuggerBundle.message("dialog.title.remote.url", new Object[0]), null, (String)(hostUrl == null ? null : hostUrl.trimParameters().toDecodedForm()), null);
        if (url != null) {
            RemoteUrlMappingHelper.addUrlMapping(debugProcess, file, url);
        }
    }

    private static void addUrlMapping(@NotNull JavaScriptDebugProcess<? extends VmConnection> debugProcess, VirtualFile file, String url) {
        if (debugProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugProcess", "com/intellij/javascript/debugger/RemoteUrlMappingHelper", "addUrlMapping"));
        }
        if (debugProcess.getFinder() instanceof RemoteDebuggingFileFinder) {
            JavaScriptDebugConfiguration configuration = (JavaScriptDebugConfiguration)debugProcess.getSession().getRunProfile();
            assert (configuration != null);
            List<RemoteUrlMappingBean> mappings = configuration.getMappings();
            String filePath = file.getPath();
            Iterator<RemoteUrlMappingBean> iterator = mappings.iterator();
            while (iterator.hasNext()) {
                RemoteUrlMappingBean mapping = iterator.next();
                if (!filePath.equals(mapping.localFilePath)) continue;
                iterator.remove();
            }
            mappings.add(new RemoteUrlMappingBean(filePath, url));
            debugProcess.updateRemoteUrlMappings(mappings);
        }
    }

    public static void showSetLocalPathDialog(@NotNull JavaScriptDebugProcess<? extends VmConnection> debugProcess, @NotNull Url url, boolean allowFiles) {
        if (debugProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugProcess", "com/intellij/javascript/debugger/RemoteUrlMappingHelper", "showSetLocalPathDialog"));
        }
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/javascript/debugger/RemoteUrlMappingHelper", "showSetLocalPathDialog"));
        }
        final Project project = debugProcess.getSession().getProject();
        FileChooserDescriptor descriptor = new FileChooserDescriptor(allowFiles, true, false, false, false, false){

            public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
                if (!super.isFileVisible(file, showHiddenFiles) || !file.isDirectory() && !JsFileUtil.isHtmlOrJavaScript(file)) {
                    return false;
                }
                return !ProjectRootManager.getInstance((Project)project).getFileIndex().isExcluded(file);
            }
        };
        descriptor.setTitle("Choose Local Path");
        descriptor.setDescription("Specify local path for '" + url + "'");
        descriptor.setRoots(ProjectRootManager.getInstance((Project)project).getContentRoots());
        FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Project)project, null, (VirtualFile)debugProcess.findFile(url), file -> {
            if (debugProcess == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugProcess", "com/intellij/javascript/debugger/RemoteUrlMappingHelper", "lambda$showSetLocalPathDialog$0"));
            }
            if (url == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/javascript/debugger/RemoteUrlMappingHelper", "lambda$showSetLocalPathDialog$0"));
            }
            RemoteUrlMappingHelper.addUrlMapping(debugProcess, file, url.trimParameters().toDecodedForm());
        });
    }
}

