/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.scripts;

import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.scripts.DirectoryInfo;
import com.intellij.javascript.debugger.scripts.LazyDirectoryInfo;
import com.intellij.openapi.Disposable;
import com.intellij.util.Alarm;
import com.intellij.util.PlatformIcons;
import com.intellij.util.SingleAlarm;
import com.intellij.util.Url;
import com.intellij.util.UrlImpl;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.ScriptManagerBaseKt;
import org.jetbrains.debugger.ScriptManagerKt;
import org.jetbrains.debugger.sourcemap.SourceMap;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\tJ\u000e\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018J\u0006\u0010\u0019\u001a\u00020\u0014J\u0018\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u000e\u0010 \u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018J\u0018\u0010!\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R:\u0010\u0007\u001a.\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t \n*\u0015\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t0\f\u00a2\u0006\u0002\b\u000b0\b\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/javascript/debugger/scripts/SourceTabManager;", "", "debugProcess", "Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "(Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;)V", "getDebugProcess", "()Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "listeners", "", "Ljava/lang/Runnable;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "", "root", "Lcom/intellij/javascript/debugger/scripts/DirectoryInfo;", "getRoot", "()Lcom/intellij/javascript/debugger/scripts/DirectoryInfo;", "updateScriptsAlarm", "Lcom/intellij/util/SingleAlarm;", "addListener", "", "listener", "addScript", "script", "Lorg/jetbrains/debugger/Script;", "clear", "doAddScript", "url", "Lcom/intellij/util/Url;", "doRemoveScript", "isEvaluatedOneLineScript", "", "removeScript", "suggestRootNode", "JavaScriptDebugger"})
public final class SourceTabManager {
    @NotNull
    private final DirectoryInfo root;
    private final List<Runnable> listeners;
    private final SingleAlarm updateScriptsAlarm;
    @NotNull
    private final JavaScriptDebugProcess<?> debugProcess;

    @NotNull
    public final DirectoryInfo getRoot() {
        return this.root;
    }

    public final void addScript(@NotNull Script script) {
        Intrinsics.checkParameterIsNotNull((Object)script, (String)"script");
        if (this.isEvaluatedOneLineScript(script)) {
            return;
        }
        if (script.getSourceMap() == null) {
            this.doAddScript(script, script.getUrl());
        } else {
            SourceMap sourceMap = script.getSourceMap();
            if (sourceMap == null) {
                Intrinsics.throwNpe();
            }
            Url[] urlArray = sourceMap.getSources();
            for (int i = 0; i < urlArray.length; ++i) {
                Url source = urlArray[i];
                this.doAddScript(script, source);
            }
        }
        this.updateScriptsAlarm.cancelAndRequest();
    }

    private final boolean isEvaluatedOneLineScript(Script script) {
        return script.getSourceMap() == null && Intrinsics.areEqual((Object)ScriptManagerKt.VM_SCHEME, (Object)script.getUrl().getScheme()) && script.getLine() - script.getEndLine() < 2;
    }

    private final void doAddScript(Script script, Url url) {
        this.suggestRootNode(script, url).addChild(script, url);
    }

    private final DirectoryInfo suggestRootNode(Script script, Url url) {
        DirectoryInfo child;
        Object object;
        String rootName;
        Icon icon = PlatformIcons.FOLDER_ICON;
        int weight = 5;
        if (script.isWorker()) {
            rootName = "Workers";
        } else if (url.getScheme() == null && !url.isInLocalFileSystem()) {
            rootName = "(no domain)";
        } else if (Intrinsics.areEqual((Object)ScriptManagerKt.VM_SCHEME, (Object)url.getScheme())) {
            rootName = "(evaluated)";
            --weight;
        } else if (Intrinsics.areEqual((Object)"webpack", (Object)url.getScheme()) ^ true && ScriptManagerBaseKt.isSpecial((Url)url)) {
            rootName = "Libraries";
            icon = PlatformIcons.LIBRARY_ICON;
            ++weight;
        } else {
            return this.root;
        }
        if (!((object = this.root.getChildNameToInfo().get((Object)rootName)) instanceof DirectoryInfo)) {
            object = null;
        }
        if ((child = (DirectoryInfo)object) == null) {
            Url url2 = (Url)new UrlImpl(rootName);
            Icon icon2 = icon;
            Intrinsics.checkExpressionValueIsNotNull((Object)icon2, (String)"icon");
            child = new LazyDirectoryInfo(rootName, url2, icon2, this.debugProcess, weight);
            this.root.getChildNameToInfo().put((Object)rootName, (Object)child);
        }
        return child;
    }

    public final void removeScript(@NotNull Script script) {
        Intrinsics.checkParameterIsNotNull((Object)script, (String)"script");
        if (this.isEvaluatedOneLineScript(script)) {
            return;
        }
        SourceMap sourceMap = script.getSourceMap();
        if (sourceMap != null) {
            SourceMap sourceMap2;
            SourceMap it = sourceMap2 = sourceMap;
            Url[] urlArray = it.getSources();
            for (int i = 0; i < urlArray.length; ++i) {
                Url source = urlArray[i];
                this.doRemoveScript(script, source);
            }
        }
        this.doRemoveScript(script, script.getUrl());
        this.updateScriptsAlarm.cancelAndRequest();
    }

    private final void doRemoveScript(Script script, Url url) {
        DirectoryInfo directory = this.suggestRootNode(script, url);
        directory.removeChild(url);
        if (directory != this.root && !directory.hasChildren()) {
            this.root.getChildNameToInfo().remove((Object)directory.getName());
        }
    }

    public final void addListener(@NotNull Runnable listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.listeners.add(listener);
    }

    public final void clear() {
        this.root.getChildNameToInfo().clear();
        this.updateScriptsAlarm.cancelAndRequest();
    }

    @NotNull
    public final JavaScriptDebugProcess<?> getDebugProcess() {
        return this.debugProcess;
    }

    public SourceTabManager(@NotNull JavaScriptDebugProcess<?> debugProcess) {
        Intrinsics.checkParameterIsNotNull(debugProcess, (String)"debugProcess");
        this.debugProcess = debugProcess;
        this.root = new DirectoryInfo("<root>", (Url)new UrlImpl(""), null, 4, null);
        this.listeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.updateScriptsAlarm = new SingleAlarm(new Runnable(){

            @Override
            public final void run() {
                for (Runnable listener : listeners) {
                    listener.run();
                }
            }
        }, 500, Alarm.ThreadToUse.SWING_THREAD, (Disposable)this.debugProcess);
    }
}

