/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.sourcemap;

import com.google.common.collect.BiMap;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.JavaScriptDebugProcessKt;
import com.intellij.javascript.debugger.sourcemap.PreloadedSourceMapList;
import com.intellij.javascript.debugger.sourcemap.SourceMapLoaderKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.containers.UtilKt;
import com.intellij.util.io.PathKt;
import com.intellij.util.io.URLUtil;
import java.io.Closeable;
import java.io.File;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.sourcemap.SourceMap;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nJ\u0018\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J@\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u000b2\b\b\u0002\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u0017\u001a\u00020\u00162\b\b\u0002\u0010\u0018\u001a\u00020\u0019R\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/javascript/debugger/sourcemap/SourceMapCollector;", "", "debugProcess", "Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "(Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;)V", "list", "Lcom/intellij/javascript/debugger/sourcemap/PreloadedSourceMapList;", "collect", "", "mappings", "Lcom/google/common/collect/BiMap;", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "processScript", "baseUrl", "Lcom/intellij/util/Url;", "file", "Ljava/nio/file/Path;", "resolveSourcemaps", "dir", "root", "checkJs", "", "checkMap", "level", "", "JavaScriptDebugger"})
public final class SourceMapCollector {
    private PreloadedSourceMapList list;
    private final JavaScriptDebugProcess<?> debugProcess;

    public final void collect(@NotNull BiMap<String, VirtualFile> mappings) {
        Intrinsics.checkParameterIsNotNull(mappings, (String)"mappings");
        for (VirtualFile file : (Set)mappings.values()) {
            Url url;
            Path ioDir = Paths.get(file.getPath(), new String[0]);
            if (!PathKt.isDirectory((Path)ioDir)) continue;
            Object object = mappings.inverse().get((Object)file);
            if (object == null) {
                Intrinsics.throwNpe();
            }
            if (Urls.parseFromIdea((CharSequence)((CharSequence)object)) == null) continue;
            Url it = url;
            Path path = ioDir;
            Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"ioDir");
            Url url2 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)url2, (String)"it");
            SourceMapCollector.resolveSourcemaps$default(this, path, url2, null, false, false, 0, 60, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void resolveSourcemaps(@NotNull Path dir, @NotNull Url baseUrl, @Nullable String root, boolean checkJs, boolean checkMap, int level) {
        Object children2;
        Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
        Intrinsics.checkParameterIsNotNull((Object)baseUrl, (String)"baseUrl");
        if (dir.isAbsolute() && dir.getParent() == null) {
            JavaScriptDebugProcessKt.getLOG().warn("Source maps are searched in FS root: " + ((Object)dir).toString());
            return;
        }
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        Path path = dir;
        Function1 filter$iv = (Function1)new Function1<Path, Boolean>(checkJs, checkMap){
            final /* synthetic */ boolean $checkJs;
            final /* synthetic */ boolean $checkMap;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean invoke(@NotNull Path it) {
                String string;
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                if (PathKt.isHidden((Path)it)) {
                    return false;
                }
                BasicFileAttributes basicFileAttributes = PathKt.basicAttributesIfExists((Path)it);
                if (basicFileAttributes == null) return false;
                BasicFileAttributes attributes = basicFileAttributes;
                if (attributes.isDirectory()) {
                    if (Intrinsics.areEqual((Object)((Object)it.getFileName()).toString(), (Object)"node_modules") ^ true) return true;
                }
                if (!attributes.isRegularFile()) return false;
                String $receiver = string = ((Object)it.getFileName()).toString();
                if (this.$checkJs) {
                    if (StringsKt.endsWith$default((String)$receiver, (String)".js", (boolean)false, (int)2, null)) return true;
                }
                if (!this.$checkMap) return false;
                if (!StringsKt.endsWith$default((String)$receiver, (String)".map", (boolean)false, (int)2, null)) return false;
                return true;
            }
            {
                this.$checkJs = bl;
                this.$checkMap = bl2;
                super(1);
            }
        };
        try {
            void $receiver$iv;
            Closeable closeable = Files.newDirectoryStream((Path)$receiver$iv, (DirectoryStream.Filter)new PathKt.sam.Filter.i.855e4f15(filter$iv));
            boolean bl = false;
            try {
                Iterator iterator;
                String string;
                DirectoryStream it = (DirectoryStream)closeable;
                Iterator iterator2 = it.iterator();
                if (!iterator2.hasNext()) {
                    return;
                }
                String dirPath = ((Object)dir.toAbsolutePath()).toString();
                String string2 = root;
                if (string2 != null) {
                    String string3;
                    String it2 = string3 = string2;
                    string = Intrinsics.stringPlus((String)FileUtilRt.getRelativePath((String)root, (String)dirPath, (char)File.separatorChar), (Object)Character.valueOf(File.separatorChar));
                } else {
                    string = null;
                }
                String dirRelativePathWithSeparator = string;
                Url baseLocalFsUrl = Urls.newLocalFileUrl((String)dirPath);
                children2.element = (List)new SmartList();
                Iterator iterator3 = iterator = iterator2;
                while (iterator3.hasNext()) {
                    Path file = (Path)iterator3.next();
                    if (PathKt.isDirectory((Path)file)) {
                        if (level > 4) {
                            JavaScriptDebugProcessKt.getLOG().warn("Sourcemaps are not collected in " + file + ": deep > 4");
                            continue;
                        }
                        Path path2 = file;
                        Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"file");
                        Url url = baseUrl.resolve(((Object)file.getFileName()).toString());
                        Intrinsics.checkExpressionValueIsNotNull((Object)url, (String)"baseUrl.resolve(file.fileName.toString())");
                        this.resolveSourcemaps(path2, url, root, checkJs, checkMap, level + 1);
                        continue;
                    }
                    String fileName = ((Object)file.getFileName()).toString();
                    if (checkJs && !StringsKt.endsWith$default((String)fileName, (String)".map", (boolean)false, (int)2, null)) {
                        List list = (List)children2.element;
                        if (list == null) {
                            Intrinsics.throwNpe();
                        }
                        Path path3 = file;
                        Intrinsics.checkExpressionValueIsNotNull((Object)path3, (String)"file");
                        list.add(path3);
                        continue;
                    }
                    Logger $receiver$iv2 = JavaScriptDebugProcessKt.getLOG();
                    try {
                        SourceMap map;
                        CharSequence charSequence = PathKt.readChars((Path)file);
                        Url url = baseLocalFsUrl;
                        Intrinsics.checkExpressionValueIsNotNull((Object)url, (String)"baseLocalFsUrl");
                        if (JavaScriptDebugProcess.decodeSourceMap$default(this.debugProcess, charSequence, url, false, null, false, 24, null) == null) {
                            continue;
                        }
                        String string4 = map.getOutFile();
                        if (string4 == null) {
                            String string5 = fileName;
                            int n = 0;
                            int n2 = fileName.length() - ".map".length();
                            String string6 = string5;
                            if (string6 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                            }
                            String string7 = string6.substring(n, n2);
                            string4 = string7;
                            Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        }
                        String scriptFileName = string4;
                        Url scriptUrl = baseUrl.resolve(scriptFileName);
                        Url url2 = baseUrl.resolve(fileName);
                        Intrinsics.checkExpressionValueIsNotNull((Object)url2, (String)"baseUrl.resolve(fileName)");
                        Url url3 = scriptUrl;
                        Intrinsics.checkExpressionValueIsNotNull((Object)url3, (String)"scriptUrl");
                        if (!this.list.add(url2, map, url3)) {
                            JavaScriptDebugProcessKt.getLOG().warn("map for " + scriptUrl + " is already preloaded");
                            continue;
                        }
                        if (dirRelativePathWithSeparator == null) continue;
                        this.list.getScriptUrlToRelativePath().put((Object)scriptUrl, (Object)(dirRelativePathWithSeparator + scriptFileName));
                    }
                    catch (ProcessCanceledException e$iv) {
                    }
                    catch (Throwable e$iv) {
                        $receiver$iv2.error(e$iv);
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Exception exception) {
                bl = true;
                try {
                    Closeable closeable2 = closeable;
                    if (closeable2 != null) {
                        closeable2.close();
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                throw (Throwable)exception;
            }
            finally {
                if (!bl) {
                    Closeable closeable3 = closeable;
                    if (closeable3 != null) {
                        closeable3.close();
                    }
                }
            }
        }
        catch (NoSuchFileException noSuchFileException) {
        }
        if (!UtilKt.isNullOrEmpty((Collection)((List)children2.element))) {
            List list = (List)children2.element;
            if (list == null) {
                Intrinsics.throwNpe();
            }
            for (Path file : list) {
                Logger $receiver$iv = JavaScriptDebugProcessKt.getLOG();
                try {
                    this.processScript(baseUrl, file);
                }
                catch (ProcessCanceledException e$iv) {
                }
                catch (Throwable e$iv) {
                    $receiver$iv.error(e$iv);
                }
            }
        }
        children2 = null;
    }

    public static /* bridge */ /* synthetic */ void resolveSourcemaps$default(SourceMapCollector sourceMapCollector, Path path, Url url, String string, boolean bl, boolean bl2, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            string = null;
        }
        if ((n2 & 8) != 0) {
            bl = true;
        }
        if ((n2 & 0x10) != 0) {
            bl2 = true;
        }
        if ((n2 & 0x20) != 0) {
            n = 0;
        }
        sourceMapCollector.resolveSourcemaps(path, url, string, bl, bl2, n);
    }

    private final void processScript(Url baseUrl, Path file) {
        block2: {
            Url scriptUrl;
            String sourceMapUrl = SourceMapLoaderKt.getSourceMapUrl(file);
            if (sourceMapUrl == null || !URLUtil.isDataUri((String)sourceMapUrl)) break block2;
            Url url = scriptUrl = baseUrl.resolve(((Object)file.getFileName()).toString());
            Intrinsics.checkExpressionValueIsNotNull((Object)url, (String)"scriptUrl");
            CharSequence charSequence = SourceMapLoaderKt.loadFromDataUri(sourceMapUrl, url, this.debugProcess.getSession());
            if (charSequence == null) {
                return;
            }
            CharSequence data = charSequence;
            SourceMap sourceMap = JavaScriptDebugProcess.decodeSourceMap$default(this.debugProcess, data, baseUrl, false, null, false, 16, null);
            if (sourceMap != null) {
                SourceMap sourceMap2;
                SourceMap it = sourceMap2 = sourceMap;
                Url url2 = scriptUrl;
                Intrinsics.checkExpressionValueIsNotNull((Object)url2, (String)"scriptUrl");
                Url url3 = scriptUrl;
                Intrinsics.checkExpressionValueIsNotNull((Object)url3, (String)"scriptUrl");
                this.list.add(url2, it, url3);
            }
        }
    }

    public SourceMapCollector(@NotNull JavaScriptDebugProcess<?> debugProcess) {
        Intrinsics.checkParameterIsNotNull(debugProcess, (String)"debugProcess");
        this.debugProcess = debugProcess;
        this.list = this.debugProcess.getPreloadedSourceMaps();
    }
}

